/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.Headers;
import io.netty.handler.codec.TextHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.HttpUtil;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.netty.util.internal.PlatformDependent;
import java.util.Map;

public final class InboundHttp2ToHttpPriorityAdapter
extends InboundHttp2ToHttpAdapter {
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_METHOD = new AsciiString((CharSequence)HttpUtil.OUT_OF_MESSAGE_SEQUENCE_METHOD.toString());
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_PATH = new AsciiString((CharSequence)"");
    private static final AsciiString OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE = new AsciiString((CharSequence)HttpUtil.OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE.toString());
    private final IntObjectMap<HttpHeaders> outOfMessageFlowHeaders = new IntObjectHashMap();

    InboundHttp2ToHttpPriorityAdapter(Builder builder) {
        super(builder);
    }

    @Override
    protected void removeMessage(int streamId) {
        super.removeMessage(streamId);
        this.outOfMessageFlowHeaders.remove(streamId);
    }

    private static HttpHeaders getActiveHeaders(FullHttpMessage msg) {
        return msg.content().isReadable() ? msg.trailingHeaders() : msg.headers();
    }

    private void importOutOfMessageFlowHeaders(int streamId, HttpHeaders headers) {
        HttpHeaders outOfMessageFlowHeader = (HttpHeaders)this.outOfMessageFlowHeaders.get(streamId);
        if (outOfMessageFlowHeader == null) {
            this.outOfMessageFlowHeaders.put(streamId, (Object)headers);
        } else {
            outOfMessageFlowHeader.setAll(headers);
        }
    }

    private void exportOutOfMessageFlowHeaders(int streamId, HttpHeaders headers) {
        HttpHeaders outOfMessageFlowHeader = (HttpHeaders)this.outOfMessageFlowHeaders.get(streamId);
        if (outOfMessageFlowHeader != null) {
            headers.setAll(outOfMessageFlowHeader);
        }
    }

    private static void removePriorityRelatedHeaders(HttpHeaders headers) {
        headers.remove((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text());
        headers.remove((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_WEIGHT.text());
    }

    private void initializePseudoHeaders(Http2Headers headers) {
        if (this.connection.isServer()) {
            headers.method(OUT_OF_MESSAGE_SEQUENCE_METHOD).path(OUT_OF_MESSAGE_SEQUENCE_PATH);
        } else {
            headers.status(OUT_OF_MESSAGE_SEQUENCE_RETURN_CODE);
        }
    }

    private static void addHttpHeadersToHttp2Headers(HttpHeaders httpHeaders, final Http2Headers http2Headers) {
        try {
            httpHeaders.forEachEntry((Headers.EntryVisitor)new TextHeaders.EntryVisitor(){

                public boolean visit(Map.Entry<CharSequence, CharSequence> entry) throws Exception {
                    http2Headers.add(AsciiString.of((CharSequence)entry.getKey()), AsciiString.of((CharSequence)entry.getValue()));
                    return true;
                }
            });
        }
        catch (Exception ex) {
            PlatformDependent.throwException((Throwable)ex);
        }
    }

    @Override
    protected void fireChannelRead(ChannelHandlerContext ctx, FullHttpMessage msg, int streamId) {
        this.exportOutOfMessageFlowHeaders(streamId, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg));
        super.fireChannelRead(ctx, msg, streamId);
    }

    @Override
    protected FullHttpMessage processHeadersBegin(ChannelHandlerContext ctx, int streamId, Http2Headers headers, boolean endOfStream, boolean allowAppend, boolean appendToTrailer) throws Http2Exception {
        FullHttpMessage msg = super.processHeadersBegin(ctx, streamId, headers, endOfStream, allowAppend, appendToTrailer);
        if (msg != null) {
            this.exportOutOfMessageFlowHeaders(streamId, InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg));
        }
        return msg;
    }

    @Override
    public void priorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
        Http2Stream parent = stream.parent();
        FullHttpMessage msg = (FullHttpMessage)this.messageMap.get(stream.id());
        if (msg == null) {
            if (parent != null && !parent.equals(this.connection.connectionStream())) {
                DefaultHttpHeaders headers = new DefaultHttpHeaders();
                headers.setInt((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), parent.id());
                this.importOutOfMessageFlowHeaders(stream.id(), (HttpHeaders)headers);
            }
        } else if (parent == null) {
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(msg.headers());
            InboundHttp2ToHttpPriorityAdapter.removePriorityRelatedHeaders(msg.trailingHeaders());
        } else if (!parent.equals(this.connection.connectionStream())) {
            HttpHeaders headers = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg);
            headers.setInt((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_DEPENDENCY_ID.text(), parent.id());
        }
    }

    @Override
    public void onWeightChanged(Http2Stream stream, short oldWeight) {
        HttpHeaders headers;
        FullHttpMessage msg = (FullHttpMessage)this.messageMap.get(stream.id());
        if (msg == null) {
            headers = new DefaultHttpHeaders();
            this.importOutOfMessageFlowHeaders(stream.id(), headers);
        } else {
            headers = InboundHttp2ToHttpPriorityAdapter.getActiveHeaders(msg);
        }
        headers.setShort((CharSequence)HttpUtil.ExtensionHeaderNames.STREAM_WEIGHT.text(), stream.weight());
    }

    @Override
    public void onPriorityRead(ChannelHandlerContext ctx, int streamId, int streamDependency, short weight, boolean exclusive) throws Http2Exception {
        FullHttpMessage msg = (FullHttpMessage)this.messageMap.get(streamId);
        if (msg == null) {
            HttpHeaders httpHeaders = (HttpHeaders)this.outOfMessageFlowHeaders.remove(streamId);
            if (httpHeaders == null) {
                throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Priority Frame recieved for unknown stream id %d", streamId);
            }
            DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
            this.initializePseudoHeaders(http2Headers);
            InboundHttp2ToHttpPriorityAdapter.addHttpHeadersToHttp2Headers(httpHeaders, http2Headers);
            msg = this.newMessage(streamId, http2Headers, this.validateHttpHeaders);
            this.fireChannelRead(ctx, msg, streamId);
        }
    }

    public static final class Builder
    extends InboundHttp2ToHttpAdapter.Builder {
        public Builder(Http2Connection connection) {
            super(connection);
        }

        @Override
        public InboundHttp2ToHttpPriorityAdapter build() {
            InboundHttp2ToHttpPriorityAdapter instance = new InboundHttp2ToHttpPriorityAdapter(this);
            instance.connection.addListener(instance);
            return instance;
        }
    }
}

