/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamRemovalPolicy;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class DefaultHttp2StreamRemovalPolicy
extends ChannelHandlerAdapter
implements Http2StreamRemovalPolicy,
Runnable {
    private static final long GARBAGE_COLLECTION_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final Queue<Garbage> garbage = new ArrayDeque<Garbage>();
    private ScheduledFuture<?> timerFuture;
    private Http2StreamRemovalPolicy.Action action;

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.timerFuture = ctx.channel().eventLoop().scheduleWithFixedDelay((Runnable)this, GARBAGE_COLLECTION_INTERVAL, GARBAGE_COLLECTION_INTERVAL, TimeUnit.NANOSECONDS);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.timerFuture != null) {
            this.timerFuture.cancel(false);
            this.timerFuture = null;
        }
    }

    @Override
    public void setAction(Http2StreamRemovalPolicy.Action action) {
        this.action = action;
    }

    @Override
    public void markForRemoval(Http2Stream stream) {
        this.garbage.add(new Garbage(stream));
    }

    @Override
    public void run() {
        Garbage next;
        if (this.garbage.isEmpty() || this.action == null) {
            return;
        }
        long time = System.nanoTime();
        while ((next = this.garbage.peek()) != null && time - next.removalTime > GARBAGE_COLLECTION_INTERVAL) {
            this.garbage.remove();
            this.action.removeStream(next.stream);
        }
    }

    private static final class Garbage {
        private final long removalTime = System.nanoTime();
        private final Http2Stream stream;

        Garbage(Http2Stream stream) {
            this.stream = stream;
        }
    }
}

