/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionUtil;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketExtensionUtilTest {
    @Test
    public void testIsWebsocketUpgrade() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        Assert.assertFalse((boolean)WebSocketExtensionUtil.isWebsocketUpgrade((HttpHeaders)headers));
        headers.add((CharSequence)HttpHeaderNames.UPGRADE, (Object)HttpHeaderValues.WEBSOCKET);
        Assert.assertFalse((boolean)WebSocketExtensionUtil.isWebsocketUpgrade((HttpHeaders)headers));
        headers.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)"Keep-Alive, Upgrade");
        Assert.assertTrue((boolean)WebSocketExtensionUtil.isWebsocketUpgrade((HttpHeaders)headers));
    }

    @Test
    public void computeMergeExtensionsHeaderValueWhenNoUserDefinedHeader() {
        List extras = WebSocketExtensionUtil.extractExtensions((String)"permessage-deflate; client_max_window_bits,permessage-deflate; client_no_context_takeover; client_max_window_bits,deflate-frame,x-webkit-deflate-frame");
        String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue(null, (List)extras);
        Assert.assertEquals((Object)"permessage-deflate;client_max_window_bits,permessage-deflate;client_no_context_takeover;client_max_window_bits,deflate-frame,x-webkit-deflate-frame", (Object)newHeaderValue);
    }

    @Test
    public void computeMergeExtensionsHeaderValueWhenNoConflictingUserDefinedHeader() {
        List extras = WebSocketExtensionUtil.extractExtensions((String)"permessage-deflate; client_max_window_bits,permessage-deflate; client_no_context_takeover; client_max_window_bits,deflate-frame,x-webkit-deflate-frame");
        String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue((String)"foo, bar", (List)extras);
        Assert.assertEquals((Object)"permessage-deflate;client_max_window_bits,permessage-deflate;client_no_context_takeover;client_max_window_bits,deflate-frame,x-webkit-deflate-frame,foo,bar", (Object)newHeaderValue);
    }

    @Test
    public void computeMergeExtensionsHeaderValueWhenConflictingUserDefinedHeader() {
        List extras = WebSocketExtensionUtil.extractExtensions((String)"permessage-deflate; client_max_window_bits,permessage-deflate; client_no_context_takeover; client_max_window_bits,deflate-frame,x-webkit-deflate-frame");
        String newHeaderValue = WebSocketExtensionUtil.computeMergeExtensionsHeaderValue((String)"permessage-deflate; client_max_window_bits", (List)extras);
        Assert.assertEquals((Object)"permessage-deflate;client_max_window_bits,permessage-deflate;client_no_context_takeover;client_max_window_bits,deflate-frame,x-webkit-deflate-frame", (Object)newHeaderValue);
    }
}

