/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketFrameAggregatorTest {
    private static final byte[] content1 = "Content1".getBytes(CharsetUtil.UTF_8);
    private static final byte[] content2 = "Content2".getBytes(CharsetUtil.UTF_8);
    private static final byte[] content3 = "Content3".getBytes(CharsetUtil.UTF_8);
    private static final byte[] aggregatedContent = new byte[content1.length + content2.length + content3.length];

    @Test
    public void testAggregationBinary() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketFrameAggregator(Integer.MAX_VALUE)});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
        channel.writeInbound(new Object[]{new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new PongWebSocketFrame(Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])content3))});
        Assert.assertTrue((boolean)channel.finish());
        BinaryWebSocketFrame frame = (BinaryWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame.isFinalFragment());
        Assert.assertEquals((long)1L, (long)frame.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame.content()));
        PingWebSocketFrame frame2 = (PingWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame2.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame2.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame2.content()));
        PongWebSocketFrame frame3 = (PongWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame3.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame3.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame3.content()));
        BinaryWebSocketFrame frame4 = (BinaryWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame4.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame4.rsv());
        Assert.assertArrayEquals((byte[])aggregatedContent, (byte[])WebSocketFrameAggregatorTest.toBytes(frame4.content()));
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testAggregationText() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketFrameAggregator(Integer.MAX_VALUE)});
        channel.writeInbound(new Object[]{new TextWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new TextWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
        channel.writeInbound(new Object[]{new PingWebSocketFrame(Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new PongWebSocketFrame(Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])content3))});
        Assert.assertTrue((boolean)channel.finish());
        TextWebSocketFrame frame = (TextWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame.isFinalFragment());
        Assert.assertEquals((long)1L, (long)frame.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame.content()));
        PingWebSocketFrame frame2 = (PingWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame2.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame2.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame2.content()));
        PongWebSocketFrame frame3 = (PongWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame3.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame3.rsv());
        Assert.assertArrayEquals((byte[])content1, (byte[])WebSocketFrameAggregatorTest.toBytes(frame3.content()));
        TextWebSocketFrame frame4 = (TextWebSocketFrame)channel.readInbound();
        Assert.assertTrue((boolean)frame4.isFinalFragment());
        Assert.assertEquals((long)0L, (long)frame4.rsv());
        Assert.assertArrayEquals((byte[])aggregatedContent, (byte[])WebSocketFrameAggregatorTest.toBytes(frame4.content()));
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void textFrameTooBig() throws Exception {
        Object msg;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocketFrameAggregator(8)});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content1))});
        try {
            channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])content2))});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(true, 1, Unpooled.wrappedBuffer((byte[])content1))});
        channel.writeInbound(new Object[]{new BinaryWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content1))});
        try {
            channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(false, 0, Unpooled.wrappedBuffer((byte[])content2))});
        channel.writeInbound(new Object[]{new ContinuationWebSocketFrame(true, 0, Unpooled.wrappedBuffer((byte[])content2))});
        while ((msg = channel.readInbound()) != null) {
            ReferenceCountUtil.release((Object)msg);
        }
        channel.finish();
    }

    private static byte[] toBytes(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        buf.release();
        return bytes;
    }

    static {
        System.arraycopy(content1, 0, aggregatedContent, 0, content1.length);
        System.arraycopy(content2, 0, aggregatedContent, content1.length, content2.length);
        System.arraycopy(content3, 0, aggregatedContent, content1.length + content2.length, content3.length);
    }
}

