/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class DiskFileUploadTest {
    @Test
    public void testSpecificCustomBaseDir() throws IOException {
        File baseDir = new File("target/DiskFileUploadTest/testSpecificCustomBaseDir");
        baseDir.mkdirs();
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L, baseDir.getAbsolutePath(), false);
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().getAbsolutePath().startsWith(baseDir.getAbsolutePath()));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public final void testDiskFileUploadEquals() {
        DiskFileUpload f2 = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        Assert.assertEquals((Object)f2, (Object)f2);
        f2.delete();
    }

    @Test
    public void testEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testEmptyBufferSetAfterNonEmptyBuffer() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testNonEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)2L, (long)f.getFile().length());
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddContents() throws Exception {
        DiskFileUpload f1 = new DiskFileUpload("file1", "file1", "application/json", null, null, 0L);
        try {
            byte[] jsonBytes = new byte[4096];
            PlatformDependent.threadLocalRandom().nextBytes(jsonBytes);
            f1.addContent(Unpooled.wrappedBuffer((byte[])jsonBytes, (int)0, (int)1024), false);
            f1.addContent(Unpooled.wrappedBuffer((byte[])jsonBytes, (int)1024, (int)(jsonBytes.length - 1024)), true);
            Assert.assertArrayEquals((byte[])jsonBytes, (byte[])f1.get());
            File file = f1.getFile();
            Assert.assertEquals((long)jsonBytes.length, (long)file.length());
            FileInputStream fis = new FileInputStream(file);
            try {
                byte[] buf = new byte[jsonBytes.length];
                int offset = 0;
                int read = 0;
                int len = buf.length;
                while ((read = fis.read(buf, offset, len)) > 0 && (len -= read) > 0 && (offset += read) < buf.length) {
                }
                Assert.assertArrayEquals((byte[])jsonBytes, (byte[])buf);
            }
            finally {
                fis.close();
            }
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromByteBuf() throws Exception {
        DiskFileUpload f1 = new DiskFileUpload("file2", "file2", "application/json", null, null, 0L);
        try {
            String json = "{\"hello\":\"world\"}";
            byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
            f1.setContent(Unpooled.wrappedBuffer((byte[])bytes));
            Assert.assertEquals((Object)json, (Object)f1.getString());
            Assert.assertArrayEquals((byte[])bytes, (byte[])f1.get());
            File file = f1.getFile();
            Assert.assertEquals((long)bytes.length, (long)file.length());
            Assert.assertArrayEquals((byte[])bytes, (byte[])DiskFileUploadTest.doReadFile(file, bytes.length));
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromInputStream() throws Exception {
        String json = "{\"hello\":\"world\",\"foo\":\"bar\"}";
        DiskFileUpload f1 = new DiskFileUpload("file3", "file3", "application/json", null, null, 0L);
        try {
            byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            ByteBufInputStream is = new ByteBufInputStream(buf);
            try {
                f1.setContent((InputStream)is);
                Assert.assertEquals((Object)json, (Object)f1.getString());
                Assert.assertArrayEquals((byte[])bytes, (byte[])f1.get());
                File file = f1.getFile();
                Assert.assertEquals((long)bytes.length, (long)file.length());
                Assert.assertArrayEquals((byte[])bytes, (byte[])DiskFileUploadTest.doReadFile(file, bytes.length));
            }
            finally {
                buf.release();
                is.close();
            }
        }
        finally {
            f1.delete();
        }
    }

    @Test
    public void testAddContentFromByteBuf() throws Exception {
        DiskFileUploadTest.testAddContentFromByteBuf0(false);
    }

    @Test
    public void testAddContentFromCompositeByteBuf() throws Exception {
        DiskFileUploadTest.testAddContentFromByteBuf0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testAddContentFromByteBuf0(boolean composite) throws Exception {
        DiskFileUpload f1 = new DiskFileUpload("file3", "file3", "application/json", null, null, 0L);
        try {
            byte[] bytes = new byte[4096];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            Object buffer = composite ? Unpooled.compositeBuffer().addComponent(true, Unpooled.wrappedBuffer((byte[])bytes, (int)0, (int)(bytes.length / 2))).addComponent(true, Unpooled.wrappedBuffer((byte[])bytes, (int)(bytes.length / 2), (int)(bytes.length / 2))) : Unpooled.wrappedBuffer((byte[])bytes);
            f1.addContent(buffer, true);
            ByteBuf buf = f1.getByteBuf();
            Assert.assertEquals((long)buf.readerIndex(), (long)0L);
            Assert.assertEquals((long)buf.writerIndex(), (long)bytes.length);
            Assert.assertArrayEquals((byte[])bytes, (byte[])ByteBufUtil.getBytes((ByteBuf)buf));
        }
        finally {
            f1.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] doReadFile(File file, int maxRead) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        try {
            byte[] buf = new byte[maxRead];
            int offset = 0;
            int read = 0;
            int len = buf.length;
            while ((read = fis.read(buf, offset, len)) > 0 && (len -= read) > 0 && (offset += read) < buf.length) {
            }
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDelete() throws Exception {
        String json = "{\"foo\":\"bar\"}";
        byte[] bytes = json.getBytes(CharsetUtil.UTF_8);
        File tmpFile = null;
        DiskFileUpload f1 = new DiskFileUpload("file4", "file4", "application/json", null, null, 0L);
        try {
            Assert.assertNull((Object)f1.getFile());
            f1.setContent(Unpooled.wrappedBuffer((byte[])bytes));
            tmpFile = f1.getFile();
            Assert.assertNotNull((Object)tmpFile);
        }
        catch (Throwable throwable) {
            f1.delete();
            Assert.assertNull((Object)f1.getFile());
            Assert.assertNotNull(tmpFile);
            Assert.assertFalse((boolean)tmpFile.exists());
            throw throwable;
        }
        f1.delete();
        Assert.assertNull((Object)f1.getFile());
        Assert.assertNotNull((Object)tmpFile);
        Assert.assertFalse((boolean)tmpFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void setSetContentFromFileExceptionally() throws Exception {
        long maxSize = 4L;
        DiskFileUpload f1 = new DiskFileUpload("file5", "file5", "application/json", null, null, 0L);
        f1.setMaxSize(4L);
        try {
            f1.setContent(Unpooled.wrappedBuffer((byte[])new byte[4]));
            File originalFile = f1.getFile();
            Assert.assertNotNull((Object)originalFile);
            Assert.assertEquals((long)4L, (long)originalFile.length());
            Assert.assertEquals((long)4L, (long)f1.length());
            byte[] bytes = new byte[8];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            try {
                fos.write(bytes);
                fos.flush();
            }
            finally {
                fos.close();
            }
            try {
                f1.setContent(tmpFile);
                Assert.fail((String)"should not reach here!");
            }
            catch (IOException e) {
                Assert.assertNotNull((Object)f1.getFile());
                Assert.assertEquals((Object)originalFile, (Object)f1.getFile());
                Assert.assertEquals((long)4L, (long)f1.length());
            }
        }
        finally {
            f1.delete();
        }
    }
}

