/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.AbstractMemoryHttpData;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;

public class AbstractMemoryHttpDataTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromFile() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        try {
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            byte[] bytes = new byte[4096];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            try {
                fos.write(bytes);
                fos.flush();
            }
            finally {
                fos.close();
            }
            test.setContent(tmpFile);
            ByteBuf buf = test.getByteBuf();
            Assert.assertEquals((long)buf.readerIndex(), (long)0L);
            Assert.assertEquals((long)buf.writerIndex(), (long)bytes.length);
            Assert.assertArrayEquals((byte[])bytes, (byte[])test.get());
            Assert.assertArrayEquals((byte[])bytes, (byte[])ByteBufUtil.getBytes((ByteBuf)buf));
        }
        finally {
            test.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameTo() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        try {
            File tmpFile = PlatformDependent.createTempFile((String)UUID.randomUUID().toString(), (String)".tmp", null);
            tmpFile.deleteOnExit();
            int totalByteCount = 4096;
            byte[] bytes = new byte[4096];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            ByteBuf content = Unpooled.wrappedBuffer((byte[])bytes);
            test.setContent(content);
            boolean succ = test.renameTo(tmpFile);
            Assert.assertTrue((boolean)succ);
            FileInputStream fis = new FileInputStream(tmpFile);
            try {
                byte[] buf = new byte[4096];
                int count = 0;
                int offset = 0;
                int size = 4096;
                while ((count = fis.read(buf, offset, size)) > 0 && (offset += count) < 4096 && (size -= count) > 0) {
                }
                Assert.assertArrayEquals((byte[])bytes, (byte[])buf);
                Assert.assertEquals((long)0L, (long)fis.available());
            }
            finally {
                fis.close();
            }
        }
        finally {
            test.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetContentFromStream() throws Exception {
        TestHttpData test = new TestHttpData("test", CharsetUtil.UTF_8, 0L);
        String contentStr = "foo_test";
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])contentStr.getBytes(CharsetUtil.UTF_8));
        buf.markReaderIndex();
        ByteBufInputStream is = new ByteBufInputStream(buf);
        try {
            test.setContent((InputStream)is);
            Assert.assertFalse((boolean)buf.isReadable());
            Assert.assertEquals((Object)test.getString(CharsetUtil.UTF_8), (Object)contentStr);
            buf.resetReaderIndex();
            Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)buf, (ByteBuf)test.getByteBuf()));
        }
        finally {
            is.close();
        }
        SecureRandom random = new SecureRandom();
        for (int i = 0; i < 20; ++i) {
            int size = random.nextInt(Short.MAX_VALUE);
            byte[] bytes = new byte[size];
            ((Random)random).nextBytes(bytes);
            TestHttpData data = new TestHttpData("name", CharsetUtil.UTF_8, 0L);
            data.setContent(new ByteArrayInputStream(bytes));
            ByteBuf buffer = data.getByteBuf();
            Assert.assertEquals((long)0L, (long)buffer.readerIndex());
            Assert.assertEquals((long)bytes.length, (long)buffer.writerIndex());
            Assert.assertArrayEquals((byte[])bytes, (byte[])Arrays.copyOf(buffer.array(), bytes.length));
            Assert.assertArrayEquals((byte[])bytes, (byte[])data.get());
        }
    }

    private static final class TestHttpData
    extends AbstractMemoryHttpData {
        private TestHttpData(String name, Charset charset, long size) {
            super(name, charset, size);
        }

        public InterfaceHttpData.HttpDataType getHttpDataType() {
            throw TestHttpData.reject();
        }

        public HttpData copy() {
            throw TestHttpData.reject();
        }

        public HttpData duplicate() {
            throw TestHttpData.reject();
        }

        public HttpData retainedDuplicate() {
            throw TestHttpData.reject();
        }

        public HttpData replace(ByteBuf content) {
            return null;
        }

        public int compareTo(InterfaceHttpData o) {
            throw TestHttpData.reject();
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        private static UnsupportedOperationException reject() {
            throw new UnsupportedOperationException("Should never be called.");
        }
    }
}

