/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.cors;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.handler.codec.http.cors.CorsHandler;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsEqual;
import org.junit.Test;

public class CorsHandlerTest {
    @Test
    public void nonCorsRequest() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forAnyOrigin().build(), null);
        MatcherAssert.assertThat((Object)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestWithAnyOrigin() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forAnyOrigin().build(), "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"*"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestWithNullOrigin() {
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigin((String)"http://test.com").allowNullOrigin().allowCredentials().build(), "null");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"null"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Matcher)IsEqual.equalTo((Object)"true")));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestWithOrigin() {
        String origin = "http://localhost:8888";
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build(), "http://localhost:8888");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"http://localhost:8888"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestWithOrigins() {
        String origin1 = "http://localhost:8888";
        String origin2 = "https://localhost:8888";
        String[] origins = new String[]{"http://localhost:8888", "https://localhost:8888"};
        HttpResponse response1 = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])origins).build(), "http://localhost:8888");
        MatcherAssert.assertThat((Object)response1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"http://localhost:8888"));
        MatcherAssert.assertThat((Object)response1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response1), (Matcher)CoreMatchers.is((Object)true));
        HttpResponse response2 = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])origins).build(), "https://localhost:8888");
        MatcherAssert.assertThat((Object)response2.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"https://localhost:8888"));
        MatcherAssert.assertThat((Object)response2.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response2), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestWithNoMatchingOrigin() {
        String origin = "http://localhost:8888";
        HttpResponse response = CorsHandlerTest.simpleRequest(CorsConfigBuilder.forOrigins((String[])new String[]{"https://localhost:8888"}).build(), "http://localhost:8888");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightDeleteRequestWithCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.DELETE}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"http://localhost:8888"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.containsString((String)"GET"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.containsString((String)"DELETE"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightGetRequestWithCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").allowedRequestMethods(new HttpMethod[]{HttpMethod.OPTIONS, HttpMethod.GET, HttpMethod.DELETE}).allowedRequestHeaders(new String[]{"content-type", "xheader1"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)"http://localhost:8888"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.containsString((String)"OPTIONS"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.containsString((String)"GET"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.containsString((String)"content-type"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS), (Matcher)CoreMatchers.containsString((String)"xheader1"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithDefaultHeaders() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.DATE), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithCustomHeader() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", new Object[]{"somevalue"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get(HttpHeadersTestUtils.of("CustomHeader")), (Matcher)IsEqual.equalTo((Object)"somevalue"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithUnauthorizedOrigin() {
        String origin = "http://host";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://host", "xheader1");
        MatcherAssert.assertThat((Object)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithCustomHeaders() {
        String headerName = "CustomHeader";
        String value1 = "value1";
        String value2 = "value2";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", new Object[]{"value1", "value2"}).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        CorsHandlerTest.assertValues(response, "CustomHeader", "value1", "value2");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithCustomHeadersIterable() {
        String headerName = "CustomHeader";
        String value1 = "value1";
        String value2 = "value2";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", Arrays.asList("value1", "value2")).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        CorsHandlerTest.assertValues(response, "CustomHeader", "value1", "value2");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithValueGenerator() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"GenHeader", (Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                return "generatedValue";
            }
        }).build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get(HttpHeadersTestUtils.of("GenHeader")), (Matcher)IsEqual.equalTo((Object)"generatedValue"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestWithNullOrigin() {
        String origin = "null";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"null").allowNullOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "null", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Matcher)IsEqual.equalTo((Object)"null")));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Matcher)IsEqual.equalTo((Object)"true")));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestAllowCredentials() {
        String origin = "null";
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"null").allowCredentials().build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "null", "content-type, xheader1");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Matcher)IsEqual.equalTo((Object)"true")));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void preflightRequestDoNotAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        HttpResponse response = CorsHandlerTest.preflightRequest(config, "http://localhost:8888", "");
        MatcherAssert.assertThat((Object)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestCustomHeaders() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"custom1", "custom2"}).build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)IsEqual.equalTo((Object)"*"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS), (Matcher)CoreMatchers.containsString((String)"custom1"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS), (Matcher)CoreMatchers.containsString((String)"custom2"));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)IsEqual.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestDoNotAllowCredentials() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().contains((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void anyOriginAndAllowCredentialsShouldEchoRequestOrigin() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().allowCredentials().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)IsEqual.equalTo((Object)"true"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)IsEqual.equalTo((Object)"http://localhost:7777"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.VARY), (Matcher)IsEqual.equalTo((Object)HttpHeaderNames.ORIGIN.toString()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestExposeHeaders() {
        CorsConfig config = CorsConfigBuilder.forAnyOrigin().exposeHeaders(new String[]{"one", "two"}).build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS), (Matcher)CoreMatchers.containsString((String)"one"));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS), (Matcher)CoreMatchers.containsString((String)"two"));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestShortCircuit() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.FORBIDDEN));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH), (Matcher)CoreMatchers.is((Object)"0"));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void simpleRequestNoShortCircuit() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, "http://localhost:7777");
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shortCircuitNonCorsRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"https://localhost").shortCircuit().build();
        HttpResponse response = CorsHandlerTest.simpleRequest(config, null);
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void shortCircuitWithConnectionKeepAliveShouldStayOpen() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.FORBIDDEN));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shortCircuitWithoutConnectionShouldStayOpen() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.FORBIDDEN));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void shortCircuitWithConnectionCloseShouldClose() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8080").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.FORBIDDEN));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void preflightRequestShouldReleaseRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").preflightResponseHeader((CharSequence)"CustomHeader", Arrays.asList("value1", "value2")).build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "content-type, xheader1", null);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)channel.readOutbound()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void preflightRequestWithConnectionKeepAliveShouldStayOpen() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", HttpHeaderValues.KEEP_ALIVE);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void preflightRequestWithoutConnectionShouldStayOpen() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", null);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void preflightRequestWithConnectionCloseShouldClose() throws Exception {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"http://localhost:8888").build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config)});
        FullHttpRequest request = CorsHandlerTest.optionsRequest("http://localhost:8888", "", HttpHeaderValues.CLOSE);
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)HttpUtil.isKeepAlive((HttpMessage)response), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)channel.isOpen(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)response.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)response), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void forbiddenShouldReleaseRequest() {
        CorsConfig config = CorsConfigBuilder.forOrigin((String)"https://localhost").shortCircuit().build();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config), new EchoHandler()});
        FullHttpRequest request = CorsHandlerTest.createHttpRequest(HttpMethod.GET);
        request.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)"http://localhost:8888");
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{request}), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        MatcherAssert.assertThat((Object)ReferenceCountUtil.release((Object)channel.readOutbound()), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void differentConfigsPerOrigin() {
        String host1 = "http://host1:80";
        String host2 = "http://host2";
        CorsConfig rule1 = CorsConfigBuilder.forOrigin((String)host1).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET}).build();
        CorsConfig rule2 = CorsConfigBuilder.forOrigin((String)host2).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST}).allowCredentials().build();
        List<CorsConfig> corsConfigs = Arrays.asList(rule1, rule2);
        HttpResponse preFlightHost1 = CorsHandlerTest.preflightRequest(corsConfigs, host1, "", false);
        MatcherAssert.assertThat((Object)preFlightHost1.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)preFlightHost1.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        HttpResponse preFlightHost2 = CorsHandlerTest.preflightRequest(corsConfigs, host2, "", false);
        CorsHandlerTest.assertValues(preFlightHost2, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "GET", "POST");
        MatcherAssert.assertThat((Object)preFlightHost2.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS), (Matcher)IsEqual.equalTo((Object)"true"));
    }

    @Test
    public void specificConfigPrecedenceOverGeneric() {
        String host1 = "http://host1";
        String host2 = "http://host2";
        CorsConfig forHost1 = CorsConfigBuilder.forOrigin((String)host1).allowedRequestMethods(new HttpMethod[]{HttpMethod.GET}).maxAge(3600L).build();
        CorsConfig allowAll = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.POST, HttpMethod.GET, HttpMethod.OPTIONS}).maxAge(1800L).build();
        List<CorsConfig> rules = Arrays.asList(forHost1, allowAll);
        HttpResponse host1Response = CorsHandlerTest.preflightRequest(rules, host1, "", false);
        MatcherAssert.assertThat((Object)host1Response.headers().get((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS), (Matcher)CoreMatchers.is((Object)"GET"));
        MatcherAssert.assertThat((Object)host1Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE), (Matcher)IsEqual.equalTo((Object)"3600"));
        HttpResponse host2Response = CorsHandlerTest.preflightRequest(rules, host2, "", false);
        CorsHandlerTest.assertValues(host2Response, HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), "POST", "GET", "OPTIONS");
        MatcherAssert.assertThat((Object)host2Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN), (Matcher)IsEqual.equalTo((Object)"*"));
        MatcherAssert.assertThat((Object)host2Response.headers().getAsString((CharSequence)HttpHeaderNames.ACCESS_CONTROL_MAX_AGE), (Matcher)IsEqual.equalTo((Object)"1800"));
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin) {
        return CorsHandlerTest.simpleRequest(config, origin, null);
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin, String requestHeaders) {
        return CorsHandlerTest.simpleRequest(config, origin, requestHeaders, HttpMethod.GET);
    }

    private static HttpResponse simpleRequest(CorsConfig config, String origin, String requestHeaders, HttpMethod method) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(config), new EchoHandler()});
        FullHttpRequest httpRequest = CorsHandlerTest.createHttpRequest(method);
        if (origin != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)origin);
        }
        if (requestHeaders != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS, (Object)requestHeaders);
        }
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{httpRequest}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
        return response;
    }

    private static HttpResponse preflightRequest(CorsConfig config, String origin, String requestHeaders) {
        return CorsHandlerTest.preflightRequest(Collections.singletonList(config), origin, requestHeaders, config.isShortCircuit());
    }

    private static HttpResponse preflightRequest(List<CorsConfig> configs, String origin, String requestHeaders, boolean isSHortCircuit) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new CorsHandler(configs, isSHortCircuit)});
        MatcherAssert.assertThat((Object)channel.writeInbound(new Object[]{CorsHandlerTest.optionsRequest(origin, requestHeaders, null)}), (Matcher)CoreMatchers.is((Object)false));
        HttpResponse response = (HttpResponse)channel.readOutbound();
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
        return response;
    }

    private static FullHttpRequest optionsRequest(String origin, String requestHeaders, AsciiString connection) {
        FullHttpRequest httpRequest = CorsHandlerTest.createHttpRequest(HttpMethod.OPTIONS);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ORIGIN, (Object)origin);
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_METHOD, (Object)httpRequest.method().toString());
        httpRequest.headers().set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_REQUEST_HEADERS, (Object)requestHeaders);
        if (connection != null) {
            httpRequest.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)connection);
        }
        return httpRequest;
    }

    private static FullHttpRequest createHttpRequest(HttpMethod method) {
        return new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, method, "/info");
    }

    private static void assertValues(HttpResponse response, String headerName, String ... values) {
        String header = response.headers().get(HttpHeadersTestUtils.of(headerName));
        for (String value : values) {
            MatcherAssert.assertThat((Object)header, (Matcher)CoreMatchers.containsString((String)value));
        }
    }

    private static class EchoHandler
    extends SimpleChannelInboundHandler<Object> {
        private EchoHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, true, true));
        }
    }
}

