/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class HttpHeadersTest {
    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assert.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assert.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assert.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"1", values.get(0));
        Assert.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testEqualsIgnoreCase() {
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullHeaderValueValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(true);
        headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullHeaderValueNotValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddSelf() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        headers.add((HttpHeaders)headers);
    }

    @Test
    public void testSetSelfIsNoOp() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        headers.add("name", (Object)"value");
        headers.set((HttpHeaders)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
    }
}

