/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import io.netty.handler.codec.http.websocketx.WebSocket13FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import io.netty.handler.codec.http.websocketx.WebSocketRequestBuilder;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandshakeHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WebSocketServerProtocolHandlerTest {
    private final Queue<FullHttpResponse> responses = new ArrayDeque<FullHttpResponse>();

    @Before
    public void setUp() {
        this.responses.clear();
    }

    @Test
    public void testHttpUpgradeRequest() {
        EmbeddedChannel ch = this.createChannel((ChannelHandler)new MockOutboundHandler());
        ChannelHandlerContext handshakerCtx = ch.pipeline().context(WebSocketServerProtocolHandshakeHandler.class);
        WebSocketServerProtocolHandlerTest.writeUpgradeRequest(ch);
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
        Assert.assertNotNull((Object)WebSocketServerProtocolHandler.getHandshaker((Channel)handshakerCtx.channel()));
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testWebSocketServerProtocolHandshakeHandlerReplacedBeforeHandshake() {
        EmbeddedChannel ch = this.createChannel((ChannelHandler)new MockOutboundHandler());
        ChannelHandlerContext handshakerCtx = ch.pipeline().context(WebSocketServerProtocolHandshakeHandler.class);
        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
                    Assert.assertNull((Object)ctx.pipeline().context(WebSocketServerProtocolHandshakeHandler.class));
                }
            }
        }});
        WebSocketServerProtocolHandlerTest.writeUpgradeRequest(ch);
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
        Assert.assertNotNull((Object)WebSocketServerProtocolHandler.getHandshaker((Channel)handshakerCtx.channel()));
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testHttpUpgradeRequestInvalidUpgradeHeader() {
        EmbeddedChannel ch = this.createChannel();
        FullHttpRequest httpRequestWithEntity = new WebSocketRequestBuilder().httpVersion(HttpVersion.HTTP_1_1).method(HttpMethod.GET).uri("/test").connection("Upgrade").version00().upgrade("BogusSocket").build();
        ch.writeInbound(new Object[]{httpRequestWithEntity});
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)response.status());
        Assert.assertEquals((Object)"not a WebSocket handshake request: missing upgrade", (Object)WebSocketServerProtocolHandlerTest.getResponseMessage(response));
        response.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testHttpUpgradeRequestMissingWSKeyHeader() {
        EmbeddedChannel ch = this.createChannel();
        FullHttpRequest httpRequest = new WebSocketRequestBuilder().httpVersion(HttpVersion.HTTP_1_1).method(HttpMethod.GET).uri("/test").key(null).connection("Upgrade").upgrade((CharSequence)HttpHeaderValues.WEBSOCKET).version13().build();
        ch.writeInbound(new Object[]{httpRequest});
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)response.status());
        Assert.assertEquals((Object)"not a WebSocket request: missing key", (Object)WebSocketServerProtocolHandlerTest.getResponseMessage(response));
        response.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testCreateUTF8Validator() {
        WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").withUTF8Validator(true).build();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerProtocolHandler(config), new HttpRequestDecoder(), new HttpResponseEncoder(), new MockOutboundHandler()});
        WebSocketServerProtocolHandlerTest.writeUpgradeRequest(ch);
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
        Assert.assertNotNull((Object)ch.pipeline().get(Utf8FrameValidator.class));
    }

    @Test
    public void testDoNotCreateUTF8Validator() {
        WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").withUTF8Validator(false).build();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerProtocolHandler(config), new HttpRequestDecoder(), new HttpResponseEncoder(), new MockOutboundHandler()});
        WebSocketServerProtocolHandlerTest.writeUpgradeRequest(ch);
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
        Assert.assertNull((Object)ch.pipeline().get(Utf8FrameValidator.class));
    }

    @Test
    public void testHandleTextFrame() {
        CustomTextFrameHandler customTextFrameHandler = new CustomTextFrameHandler();
        EmbeddedChannel ch = this.createChannel((ChannelHandler)customTextFrameHandler);
        WebSocketServerProtocolHandlerTest.writeUpgradeRequest(ch);
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
        if (ch.pipeline().context(HttpRequestDecoder.class) != null) {
            ch.pipeline().remove(HttpRequestDecoder.class);
        }
        ch.writeInbound(new Object[]{new TextWebSocketFrame("payload")});
        Assert.assertEquals((Object)"processed: payload", (Object)customTextFrameHandler.getContent());
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testCheckValidWebSocketPath() {
        FullHttpRequest httpRequest = new WebSocketRequestBuilder().httpVersion(HttpVersion.HTTP_1_1).method(HttpMethod.GET).uri("/test").key((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY).connection("Upgrade").upgrade((CharSequence)HttpHeaderValues.WEBSOCKET).version13().build();
        WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").checkStartsWith(true).build();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerProtocolHandler(config), new HttpRequestDecoder(), new HttpResponseEncoder(), new MockOutboundHandler()});
        ch.writeInbound(new Object[]{httpRequest});
        FullHttpResponse response = this.responses.remove();
        Assert.assertEquals((Object)HttpResponseStatus.SWITCHING_PROTOCOLS, (Object)response.status());
        response.release();
    }

    @Test
    public void testCheckInvalidWebSocketPath() {
        FullHttpRequest httpRequest = new WebSocketRequestBuilder().httpVersion(HttpVersion.HTTP_1_1).method(HttpMethod.GET).uri("/testabc").key((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY).connection("Upgrade").upgrade((CharSequence)HttpHeaderValues.WEBSOCKET).version13().build();
        WebSocketServerProtocolConfig config = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").checkStartsWith(true).build();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerProtocolHandler(config), new HttpRequestDecoder(), new HttpResponseEncoder(), new MockOutboundHandler()});
        ch.writeInbound(new Object[]{httpRequest});
        ChannelHandlerContext handshakerCtx = ch.pipeline().context(WebSocketServerProtocolHandshakeHandler.class);
        Assert.assertNull((Object)WebSocketServerProtocolHandler.getHandshaker((Channel)handshakerCtx.channel()));
    }

    @Test
    public void testExplicitCloseFrameSentWhenServerChannelClosed() throws Exception {
        WebSocketCloseStatus closeStatus = WebSocketCloseStatus.ENDPOINT_UNAVAILABLE;
        EmbeddedChannel client = this.createClient(new ChannelHandler[0]);
        EmbeddedChannel server = this.createServer(new ChannelHandler[0]);
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        Assert.assertTrue((boolean)server.writeOutbound(new Object[]{new CloseWebSocketFrame(closeStatus)}));
        server.close();
        Assert.assertTrue((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        Assert.assertFalse((boolean)server.isOpen());
        CloseWebSocketFrame closeMessage = (CloseWebSocketFrame)client.readInbound();
        Assert.assertEquals((long)closeMessage.statusCode(), (long)closeStatus.code());
        closeMessage.release();
        client.close();
        Assert.assertTrue((boolean)ReferenceCountUtil.release((Object)client.readOutbound()));
        Assert.assertFalse((boolean)client.finishAndReleaseAll());
        Assert.assertFalse((boolean)server.finishAndReleaseAll());
    }

    @Test
    public void testCloseFrameSentWhenServerChannelClosedSilently() throws Exception {
        EmbeddedChannel client = this.createClient(new ChannelHandler[0]);
        EmbeddedChannel server = this.createServer(new ChannelHandler[0]);
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        server.close();
        Assert.assertTrue((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        Assert.assertFalse((boolean)server.isOpen());
        CloseWebSocketFrame closeMessage = (CloseWebSocketFrame)client.readInbound();
        Assert.assertEquals((long)closeMessage.statusCode(), (long)WebSocketCloseStatus.NORMAL_CLOSURE.code());
        closeMessage.release();
        client.close();
        Assert.assertTrue((boolean)ReferenceCountUtil.release((Object)client.readOutbound()));
        Assert.assertFalse((boolean)client.finishAndReleaseAll());
        Assert.assertFalse((boolean)server.finishAndReleaseAll());
    }

    @Test
    public void testExplicitCloseFrameSentWhenClientChannelClosed() throws Exception {
        WebSocketCloseStatus closeStatus = WebSocketCloseStatus.INVALID_PAYLOAD_DATA;
        EmbeddedChannel client = this.createClient(new ChannelHandler[0]);
        EmbeddedChannel server = this.createServer(new ChannelHandler[0]);
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        Assert.assertTrue((boolean)client.writeOutbound(new Object[]{new CloseWebSocketFrame(closeStatus)}));
        client.close();
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.isOpen());
        Assert.assertFalse((boolean)server.isOpen());
        CloseWebSocketFrame closeMessage = this.decode((ByteBuf)server.readOutbound(), CloseWebSocketFrame.class);
        Assert.assertEquals((long)closeMessage.statusCode(), (long)closeStatus.code());
        closeMessage.release();
        Assert.assertFalse((boolean)client.finishAndReleaseAll());
        Assert.assertFalse((boolean)server.finishAndReleaseAll());
    }

    @Test
    public void testCloseFrameSentWhenClientChannelClosedSilently() throws Exception {
        EmbeddedChannel client = this.createClient(new ChannelHandler[0]);
        EmbeddedChannel server = this.createServer(new ChannelHandler[0]);
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.writeInbound(new Object[]{server.readOutbound()}));
        client.close();
        Assert.assertFalse((boolean)server.writeInbound(new Object[]{client.readOutbound()}));
        Assert.assertFalse((boolean)client.isOpen());
        Assert.assertFalse((boolean)server.isOpen());
        CloseWebSocketFrame closeMessage = this.decode((ByteBuf)server.readOutbound(), CloseWebSocketFrame.class);
        Assert.assertEquals((Object)closeMessage, (Object)new CloseWebSocketFrame(WebSocketCloseStatus.NORMAL_CLOSURE));
        closeMessage.release();
        Assert.assertFalse((boolean)client.finishAndReleaseAll());
        Assert.assertFalse((boolean)server.finishAndReleaseAll());
    }

    private EmbeddedChannel createClient(ChannelHandler ... handlers) throws Exception {
        WebSocketClientProtocolConfig clientConfig = WebSocketClientProtocolConfig.newBuilder().webSocketUri("http://test/test").dropPongFrames(false).handleCloseFrames(false).build();
        EmbeddedChannel ch = new EmbeddedChannel(false, false, new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), new WebSocketClientProtocolHandler(clientConfig)});
        ch.pipeline().addLast(handlers);
        ch.register();
        return ch;
    }

    private EmbeddedChannel createServer(ChannelHandler ... handlers) throws Exception {
        WebSocketServerProtocolConfig serverConfig = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").dropPongFrames(false).build();
        EmbeddedChannel ch = new EmbeddedChannel(false, false, new ChannelHandler[]{new HttpServerCodec(), new HttpObjectAggregator(8192), new WebSocketServerProtocolHandler(serverConfig)});
        ch.pipeline().addLast(handlers);
        ch.register();
        return ch;
    }

    private <T> T decode(ByteBuf input, Class<T> clazz) {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new WebSocket13FrameDecoder(true, false, 65536, true)});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{input}));
        Object decoded = ch.readInbound();
        Assert.assertNotNull((Object)decoded);
        Assert.assertFalse((boolean)ch.finish());
        return clazz.cast(decoded);
    }

    private EmbeddedChannel createChannel() {
        return this.createChannel(null);
    }

    private EmbeddedChannel createChannel(ChannelHandler handler) {
        WebSocketServerProtocolConfig serverConfig = WebSocketServerProtocolConfig.newBuilder().websocketPath("/test").sendCloseFrame(null).build();
        return new EmbeddedChannel(new ChannelHandler[]{new WebSocketServerProtocolHandler(serverConfig), new HttpRequestDecoder(), new HttpResponseEncoder(), new MockOutboundHandler(), handler});
    }

    private static void writeUpgradeRequest(EmbeddedChannel ch) {
        ch.writeInbound(new Object[]{WebSocketRequestBuilder.successful()});
    }

    private static String getResponseMessage(FullHttpResponse response) {
        return response.content().toString(CharsetUtil.UTF_8);
    }

    private static class CustomTextFrameHandler
    extends ChannelInboundHandlerAdapter {
        private String content;

        private CustomTextFrameHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            Assert.assertNull((Object)this.content);
            this.content = "processed: " + ((TextWebSocketFrame)msg).text();
            ReferenceCountUtil.release((Object)msg);
        }

        String getContent() {
            return this.content;
        }
    }

    private class MockOutboundHandler
    extends ChannelOutboundHandlerAdapter {
        private MockOutboundHandler() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            WebSocketServerProtocolHandlerTest.this.responses.add((FullHttpResponse)msg);
            promise.setSuccess();
        }

        public void flush(ChannelHandlerContext ctx) {
        }
    }
}

