/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakeException;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketHandshakeExceptionTest {
    @Test
    public void testClientExceptionWithoutResponse() {
        WebSocketClientHandshakeException clientException = new WebSocketClientHandshakeException("client message");
        Assert.assertNull((Object)clientException.response());
        Assert.assertEquals((Object)"client message", (Object)clientException.getMessage());
    }

    @Test
    public void testClientExceptionWithResponse() {
        DefaultHttpResponse httpResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
        httpResponse.headers().set("x-header", (Object)"x-value");
        WebSocketClientHandshakeException clientException = new WebSocketClientHandshakeException("client message", (HttpResponse)httpResponse);
        Assert.assertNotNull((Object)clientException.response());
        Assert.assertEquals((Object)"client message", (Object)clientException.getMessage());
        Assert.assertEquals((Object)HttpResponseStatus.BAD_REQUEST, (Object)clientException.response().status());
        Assert.assertEquals((Object)httpResponse.headers(), (Object)clientException.response().headers());
    }

    @Test
    public void testServerExceptionWithoutRequest() {
        WebSocketServerHandshakeException serverException = new WebSocketServerHandshakeException("server message");
        Assert.assertNull((Object)serverException.request());
        Assert.assertEquals((Object)"server message", (Object)serverException.getMessage());
    }

    @Test
    public void testClientExceptionWithRequest() {
        DefaultHttpRequest httpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "ws://localhost:9999/ws");
        httpRequest.headers().set("x-header", (Object)"x-value");
        WebSocketServerHandshakeException serverException = new WebSocketServerHandshakeException("server message", (HttpRequest)httpRequest);
        Assert.assertNotNull((Object)serverException.request());
        Assert.assertEquals((Object)"server message", (Object)serverException.getMessage());
        Assert.assertEquals((Object)HttpMethod.GET, (Object)serverException.request().method());
        Assert.assertEquals((Object)httpRequest.headers(), (Object)serverException.request().headers());
        Assert.assertEquals((Object)httpRequest.uri(), (Object)serverException.request().uri());
    }
}

