/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.spdy.DefaultSpdyDataFrame;
import io.netty.handler.codec.spdy.DefaultSpdyHeadersFrame;
import io.netty.handler.codec.spdy.DefaultSpdyPingFrame;
import io.netty.handler.codec.spdy.DefaultSpdyRstStreamFrame;
import io.netty.handler.codec.spdy.DefaultSpdySettingsFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynReplyFrame;
import io.netty.handler.codec.spdy.DefaultSpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.handler.codec.spdy.SpdyGoAwayFrame;
import io.netty.handler.codec.spdy.SpdyHeaders;
import io.netty.handler.codec.spdy.SpdyHeadersFrame;
import io.netty.handler.codec.spdy.SpdyPingFrame;
import io.netty.handler.codec.spdy.SpdyRstStreamFrame;
import io.netty.handler.codec.spdy.SpdySessionHandler;
import io.netty.handler.codec.spdy.SpdySettingsFrame;
import io.netty.handler.codec.spdy.SpdyStreamStatus;
import io.netty.handler.codec.spdy.SpdySynReplyFrame;
import io.netty.handler.codec.spdy.SpdySynStreamFrame;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public class SpdySessionHandlerTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SpdySessionHandlerTest.class);
    private static final int closeSignal = 0xFFFFFF;
    private static final SpdySettingsFrame closeMessage = new DefaultSpdySettingsFrame();

    private static void assertDataFrame(Object msg, int streamId, boolean last) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdyDataFrame));
        SpdyDataFrame spdyDataFrame = (SpdyDataFrame)msg;
        Assert.assertEquals((long)streamId, (long)spdyDataFrame.streamId());
        Assert.assertEquals((Object)last, (Object)spdyDataFrame.isLast());
    }

    private static void assertSynReply(Object msg, int streamId, boolean last, SpdyHeaders headers) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdySynReplyFrame));
        SpdySessionHandlerTest.assertHeaders(msg, streamId, last, headers);
    }

    private static void assertRstStream(Object msg, int streamId, SpdyStreamStatus status) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdyRstStreamFrame));
        SpdyRstStreamFrame spdyRstStreamFrame = (SpdyRstStreamFrame)msg;
        Assert.assertEquals((long)streamId, (long)spdyRstStreamFrame.streamId());
        Assert.assertEquals((Object)status, (Object)spdyRstStreamFrame.status());
    }

    private static void assertPing(Object msg, int id) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdyPingFrame));
        SpdyPingFrame spdyPingFrame = (SpdyPingFrame)msg;
        Assert.assertEquals((long)id, (long)spdyPingFrame.id());
    }

    private static void assertGoAway(Object msg, int lastGoodStreamId) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdyGoAwayFrame));
        SpdyGoAwayFrame spdyGoAwayFrame = (SpdyGoAwayFrame)msg;
        Assert.assertEquals((long)lastGoodStreamId, (long)spdyGoAwayFrame.lastGoodStreamId());
    }

    private static void assertHeaders(Object msg, int streamId, boolean last, SpdyHeaders headers) {
        Assert.assertNotNull((Object)msg);
        Assert.assertTrue((boolean)(msg instanceof SpdyHeadersFrame));
        SpdyHeadersFrame spdyHeadersFrame = (SpdyHeadersFrame)msg;
        Assert.assertEquals((long)streamId, (long)spdyHeadersFrame.streamId());
        Assert.assertEquals((Object)last, (Object)spdyHeadersFrame.isLast());
        for (CharSequence name : headers.names()) {
            List expectedValues = headers.getAll((Object)name);
            List receivedValues = spdyHeadersFrame.headers().getAll((Object)name);
            Assert.assertTrue((boolean)receivedValues.containsAll(expectedValues));
            receivedValues.removeAll(expectedValues);
            Assert.assertTrue((boolean)receivedValues.isEmpty());
            spdyHeadersFrame.headers().remove((Object)name);
        }
        Assert.assertTrue((boolean)spdyHeadersFrame.headers().isEmpty());
    }

    private static void testSpdySessionHandler(SpdyVersion version, boolean server) {
        EmbeddedChannel sessionHandler = new EmbeddedChannel(new ChannelHandler[]{new SpdySessionHandler(version, server), new EchoHandler(0xFFFFFF, server)});
        while (sessionHandler.readOutbound() != null) {
        }
        int localStreamId = server ? 1 : 2;
        int remoteStreamId = server ? 2 : 1;
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(localStreamId, 0, 0);
        spdySynStreamFrame.headers().set((Object)"compression", (Object)"test");
        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(localStreamId);
        spdyDataFrame.setLast(true);
        sessionHandler.writeInbound(new Object[]{new DefaultSpdyDataFrame(localStreamId)});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId, SpdyStreamStatus.INVALID_STREAM);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{new DefaultSpdyDataFrame(remoteStreamId)});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), remoteStreamId, SpdyStreamStatus.PROTOCOL_ERROR);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{new DefaultSpdySynReplyFrame(remoteStreamId += 2)});
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{new DefaultSpdySynReplyFrame(remoteStreamId)});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), remoteStreamId, SpdyStreamStatus.STREAM_IN_USE);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        remoteStreamId += 2;
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertSynReply(sessionHandler.readOutbound(), localStreamId, false, spdySynStreamFrame.headers());
        Assert.assertNull((Object)sessionHandler.readOutbound());
        DefaultSpdyHeadersFrame spdyHeadersFrame = new DefaultSpdyHeadersFrame(localStreamId);
        spdyHeadersFrame.headers().add((Object)"header", (Object)"test1");
        spdyHeadersFrame.headers().add((Object)"header", (Object)"test2");
        sessionHandler.writeInbound(new Object[]{spdyHeadersFrame});
        SpdySessionHandlerTest.assertHeaders(sessionHandler.readOutbound(), localStreamId, false, spdyHeadersFrame.headers());
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setStreamId(localStreamId += 2);
        spdySynStreamFrame.setLast(true);
        spdySynStreamFrame.setUnidirectional(true);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId, SpdyStreamStatus.REFUSED_STREAM);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        int testStreamId = spdyDataFrame.streamId();
        sessionHandler.writeInbound(new Object[]{spdyDataFrame});
        SpdySessionHandlerTest.assertDataFrame(sessionHandler.readOutbound(), testStreamId, spdyDataFrame.isLast());
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdyHeadersFrame.setStreamId(testStreamId);
        sessionHandler.writeInbound(new Object[]{spdyHeadersFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), testStreamId, SpdyStreamStatus.INVALID_STREAM);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{new DefaultSpdyRstStreamFrame(remoteStreamId, 3)});
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setLast(false);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setUnidirectional(false);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId, SpdyStreamStatus.PROTOCOL_ERROR);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setStreamId((localStreamId += 2) - 1);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId - 1, SpdyStreamStatus.PROTOCOL_ERROR);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setStreamId(localStreamId);
        spdyHeadersFrame.setStreamId(localStreamId);
        spdyHeadersFrame.setInvalid();
        sessionHandler.writeInbound(new Object[]{spdyHeadersFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId, SpdyStreamStatus.PROTOCOL_ERROR);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.finish();
    }

    private static void testSpdySessionHandlerPing(SpdyVersion version, boolean server) {
        EmbeddedChannel sessionHandler = new EmbeddedChannel(new ChannelHandler[]{new SpdySessionHandler(version, server), new EchoHandler(0xFFFFFF, server)});
        while (sessionHandler.readOutbound() != null) {
        }
        int localStreamId = server ? 1 : 2;
        int remoteStreamId = server ? 2 : 1;
        DefaultSpdyPingFrame localPingFrame = new DefaultSpdyPingFrame(localStreamId);
        DefaultSpdyPingFrame remotePingFrame = new DefaultSpdyPingFrame(remoteStreamId);
        sessionHandler.writeInbound(new Object[]{localPingFrame});
        SpdySessionHandlerTest.assertPing(sessionHandler.readOutbound(), localPingFrame.id());
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{remotePingFrame});
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.finish();
    }

    private static void testSpdySessionHandlerGoAway(SpdyVersion version, boolean server) {
        EmbeddedChannel sessionHandler = new EmbeddedChannel(new ChannelHandler[]{new SpdySessionHandler(version, server), new EchoHandler(0xFFFFFF, server)});
        while (sessionHandler.readOutbound() != null) {
        }
        int localStreamId = server ? 1 : 2;
        DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(localStreamId, 0, 0);
        spdySynStreamFrame.headers().set((Object)"compression", (Object)"test");
        DefaultSpdyDataFrame spdyDataFrame = new DefaultSpdyDataFrame(localStreamId);
        spdyDataFrame.setLast(true);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertSynReply(sessionHandler.readOutbound(), localStreamId, false, spdySynStreamFrame.headers());
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{spdyDataFrame});
        SpdySessionHandlerTest.assertDataFrame(sessionHandler.readOutbound(), localStreamId, true);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.writeInbound(new Object[]{closeMessage});
        SpdySessionHandlerTest.assertGoAway(sessionHandler.readOutbound(), localStreamId);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdySynStreamFrame.setStreamId(localStreamId += 2);
        sessionHandler.writeInbound(new Object[]{spdySynStreamFrame});
        SpdySessionHandlerTest.assertRstStream(sessionHandler.readOutbound(), localStreamId, SpdyStreamStatus.REFUSED_STREAM);
        Assert.assertNull((Object)sessionHandler.readOutbound());
        spdyDataFrame.setStreamId(localStreamId);
        sessionHandler.writeInbound(new Object[]{spdyDataFrame});
        Assert.assertNull((Object)sessionHandler.readOutbound());
        sessionHandler.finish();
    }

    @Test
    public void testSpdyClientSessionHandler() {
        logger.info("Running: testSpdyClientSessionHandler v3.1");
        SpdySessionHandlerTest.testSpdySessionHandler(SpdyVersion.SPDY_3_1, false);
    }

    @Test
    public void testSpdyClientSessionHandlerPing() {
        logger.info("Running: testSpdyClientSessionHandlerPing v3.1");
        SpdySessionHandlerTest.testSpdySessionHandlerPing(SpdyVersion.SPDY_3_1, false);
    }

    @Test
    public void testSpdyClientSessionHandlerGoAway() {
        logger.info("Running: testSpdyClientSessionHandlerGoAway v3.1");
        SpdySessionHandlerTest.testSpdySessionHandlerGoAway(SpdyVersion.SPDY_3_1, false);
    }

    @Test
    public void testSpdyServerSessionHandler() {
        logger.info("Running: testSpdyServerSessionHandler v3.1");
        SpdySessionHandlerTest.testSpdySessionHandler(SpdyVersion.SPDY_3_1, true);
    }

    @Test
    public void testSpdyServerSessionHandlerPing() {
        logger.info("Running: testSpdyServerSessionHandlerPing v3.1");
        SpdySessionHandlerTest.testSpdySessionHandlerPing(SpdyVersion.SPDY_3_1, true);
    }

    @Test
    public void testSpdyServerSessionHandlerGoAway() {
        logger.info("Running: testSpdyServerSessionHandlerGoAway v3.1");
        SpdySessionHandlerTest.testSpdySessionHandlerGoAway(SpdyVersion.SPDY_3_1, true);
    }

    static {
        closeMessage.setValue(0xFFFFFF, 0);
    }

    private static class EchoHandler
    extends ChannelInboundHandlerAdapter {
        private final int closeSignal;
        private final boolean server;

        EchoHandler(int closeSignal, boolean server) {
            this.closeSignal = closeSignal;
            this.server = server;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            int streamId = this.server ? 2 : 1;
            DefaultSpdySynStreamFrame spdySynStreamFrame = new DefaultSpdySynStreamFrame(streamId, 0, 0);
            spdySynStreamFrame.setLast(true);
            ctx.writeAndFlush((Object)spdySynStreamFrame);
            spdySynStreamFrame.setStreamId(spdySynStreamFrame.streamId() + 2);
            ctx.writeAndFlush((Object)spdySynStreamFrame);
            spdySynStreamFrame.setStreamId(spdySynStreamFrame.streamId() + 2);
            ctx.writeAndFlush((Object)spdySynStreamFrame);
            spdySynStreamFrame.setStreamId(spdySynStreamFrame.streamId() + 2);
            ctx.writeAndFlush((Object)spdySynStreamFrame);
            DefaultSpdySettingsFrame spdySettingsFrame = new DefaultSpdySettingsFrame();
            spdySettingsFrame.setValue(4, 1);
            ctx.writeAndFlush((Object)spdySettingsFrame);
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            SpdySettingsFrame spdySettingsFrame;
            if (msg instanceof SpdySynStreamFrame) {
                SpdySynStreamFrame spdySynStreamFrame = (SpdySynStreamFrame)msg;
                if (!spdySynStreamFrame.isUnidirectional()) {
                    int streamId = spdySynStreamFrame.streamId();
                    DefaultSpdySynReplyFrame spdySynReplyFrame = new DefaultSpdySynReplyFrame(streamId);
                    spdySynReplyFrame.setLast(spdySynStreamFrame.isLast());
                    for (Map.Entry entry : spdySynStreamFrame.headers()) {
                        spdySynReplyFrame.headers().add(entry.getKey(), entry.getValue());
                    }
                    ctx.writeAndFlush((Object)spdySynReplyFrame);
                }
                return;
            }
            if (msg instanceof SpdySynReplyFrame) {
                return;
            }
            if (msg instanceof SpdyDataFrame || msg instanceof SpdyPingFrame || msg instanceof SpdyHeadersFrame) {
                ctx.writeAndFlush(msg);
                return;
            }
            if (msg instanceof SpdySettingsFrame && (spdySettingsFrame = (SpdySettingsFrame)msg).isSet(this.closeSignal)) {
                ctx.close();
            }
        }
    }
}

