/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DefaultHttpDataFactoryTest {
    private static final HttpRequest req1 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/form");
    private static final HttpRequest req2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/form");
    private DefaultHttpDataFactory factory;

    @BeforeClass
    public static void assertReq1EqualsReq2() {
        Assert.assertEquals((long)req1.hashCode(), (long)req2.hashCode());
        Assert.assertTrue((boolean)req1.equals(req2));
    }

    @Before
    public void setupFactory() {
        this.factory = new DefaultHttpDataFactory();
    }

    @After
    public void cleanupFactory() {
        this.factory.cleanAllHttpData();
    }

    @Test
    public void customBaseDirAndDeleteOnExit() {
        DefaultHttpDataFactory defaultHttpDataFactory = new DefaultHttpDataFactory(true);
        String dir = "target/DefaultHttpDataFactoryTest/customBaseDirAndDeleteOnExit";
        defaultHttpDataFactory.setBaseDir("target/DefaultHttpDataFactoryTest/customBaseDirAndDeleteOnExit");
        defaultHttpDataFactory.setDeleteOnExit(true);
        Attribute attr = defaultHttpDataFactory.createAttribute(req1, "attribute1");
        FileUpload fu = defaultHttpDataFactory.createFileUpload(req1, "attribute1", "f.txt", "text/plain", null, null, 0L);
        Assert.assertEquals((Object)"target/DefaultHttpDataFactoryTest/customBaseDirAndDeleteOnExit", (Object)((DiskAttribute)DiskAttribute.class.cast(attr)).getBaseDirectory());
        Assert.assertEquals((Object)"target/DefaultHttpDataFactoryTest/customBaseDirAndDeleteOnExit", (Object)((DiskFileUpload)DiskFileUpload.class.cast(fu)).getBaseDirectory());
        Assert.assertTrue((boolean)((DiskAttribute)DiskAttribute.class.cast(attr)).deleteOnExit());
        Assert.assertTrue((boolean)((DiskFileUpload)DiskFileUpload.class.cast(fu)).deleteOnExit());
    }

    @Test
    public void cleanRequestHttpDataShouldIdentifiesRequestsByTheirIdentities() throws Exception {
        Attribute attribute1 = this.factory.createAttribute(req1, "attribute1", "value1");
        Attribute attribute2 = this.factory.createAttribute(req2, "attribute2", "value2");
        FileUpload file1 = this.factory.createFileUpload(req1, "file1", "file1.txt", "text/plain", HttpHeaderValues.IDENTITY.toString(), CharsetUtil.UTF_8, 123L);
        FileUpload file2 = this.factory.createFileUpload(req2, "file2", "file2.txt", "text/plain", HttpHeaderValues.IDENTITY.toString(), CharsetUtil.UTF_8, 123L);
        file1.setContent(Unpooled.copiedBuffer((CharSequence)"file1 content", (Charset)CharsetUtil.UTF_8));
        file2.setContent(Unpooled.copiedBuffer((CharSequence)"file2 content", (Charset)CharsetUtil.UTF_8));
        Assert.assertNotNull((Object)attribute1.getByteBuf());
        Assert.assertNotNull((Object)attribute2.getByteBuf());
        Assert.assertNotNull((Object)file1.getByteBuf());
        Assert.assertNotNull((Object)file2.getByteBuf());
        Assert.assertEquals((long)1L, (long)attribute1.refCnt());
        Assert.assertEquals((long)1L, (long)attribute2.refCnt());
        Assert.assertEquals((long)1L, (long)file1.refCnt());
        Assert.assertEquals((long)1L, (long)file2.refCnt());
        this.factory.cleanRequestHttpData(req1);
        Assert.assertNull((Object)attribute1.getByteBuf());
        Assert.assertNull((Object)file1.getByteBuf());
        Assert.assertEquals((long)0L, (long)attribute1.refCnt());
        Assert.assertEquals((long)0L, (long)file1.refCnt());
        Assert.assertNotNull((Object)attribute2.getByteBuf());
        Assert.assertNotNull((Object)file2.getByteBuf());
        Assert.assertEquals((long)1L, (long)attribute2.refCnt());
        Assert.assertEquals((long)1L, (long)file2.refCnt());
    }

    @Test
    public void removeHttpDataFromCleanShouldIdentifiesDataByTheirIdentities() throws Exception {
        Attribute attribute1 = this.factory.createAttribute(req1, "attribute", "value");
        Attribute attribute2 = this.factory.createAttribute(req1, "attribute", "value");
        FileUpload file1 = this.factory.createFileUpload(req1, "file", "file.txt", "text/plain", HttpHeaderValues.IDENTITY.toString(), CharsetUtil.UTF_8, 123L);
        FileUpload file2 = this.factory.createFileUpload(req1, "file", "file.txt", "text/plain", HttpHeaderValues.IDENTITY.toString(), CharsetUtil.UTF_8, 123L);
        file1.setContent(Unpooled.copiedBuffer((CharSequence)"file content", (Charset)CharsetUtil.UTF_8));
        file2.setContent(Unpooled.copiedBuffer((CharSequence)"file content", (Charset)CharsetUtil.UTF_8));
        Assert.assertEquals((long)attribute1.hashCode(), (long)attribute2.hashCode());
        Assert.assertTrue((boolean)attribute1.equals(attribute2));
        Assert.assertEquals((long)file1.hashCode(), (long)file2.hashCode());
        Assert.assertTrue((boolean)file1.equals(file2));
        this.factory.removeHttpDataFromClean(req1, (InterfaceHttpData)attribute2);
        this.factory.removeHttpDataFromClean(req1, (InterfaceHttpData)file2);
        this.factory.cleanRequestHttpData(req1);
        Assert.assertNull((Object)attribute1.getByteBuf());
        Assert.assertNull((Object)file1.getByteBuf());
        Assert.assertEquals((long)0L, (long)attribute1.refCnt());
        Assert.assertEquals((long)0L, (long)file1.refCnt());
        Assert.assertNotNull((Object)attribute2.getByteBuf());
        Assert.assertNotNull((Object)file2.getByteBuf());
        Assert.assertEquals((long)1L, (long)attribute2.refCnt());
        Assert.assertEquals((long)1L, (long)file2.refCnt());
        attribute2.release();
        file2.release();
        Assert.assertEquals((long)0L, (long)attribute2.refCnt());
        Assert.assertEquals((long)0L, (long)file2.refCnt());
    }
}

