/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.PrematureChannelClosureException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseDecoderTest {
    @Test
    public void testMaxHeaderSize1() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4092];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        Assert.assertNull((Object)res.decoderResult().cause());
        Assert.assertTrue((boolean)res.decoderResult().isSuccess());
        Assert.assertNull((Object)ch.readInbound());
        Assert.assertTrue((boolean)ch.finish());
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.instanceOf(LastHttpContent.class));
    }

    @Test
    public void testMaxHeaderSize2() {
        int maxHeaderSize = 8192;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 8192)});
        char[] bytes = new char[4094];
        Arrays.fill(bytes, 'a');
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"A:", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assert.assertNull((Object)ch.readInbound());
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"B: ", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((char[])bytes, (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        Assert.assertTrue((boolean)(res.decoderResult().cause() instanceof TooLongFrameException));
        Assert.assertFalse((boolean)ch.finish());
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseChunked() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            HttpContent content = (HttpContent)ch.readInbound();
            Assert.assertEquals((long)data.length, (long)content.content().readableBytes());
            byte[] decodedData = new byte[data.length];
            content.content().readBytes(decodedData);
            Assert.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assert.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testResponseChunkedExceedMaxChunkSize() {
        int i;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(4096, 8192, 32)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        byte[] data = new byte[64];
        for (i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(data.length) + "\r\n"), (Charset)CharsetUtil.US_ASCII)}));
            Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)}));
            byte[] decodedData = new byte[data.length];
            HttpContent content = (HttpContent)ch.readInbound();
            Assert.assertEquals((long)32L, (long)content.content().readableBytes());
            content.content().readBytes(decodedData, 0, 32);
            content.release();
            content = (HttpContent)ch.readInbound();
            Assert.assertEquals((long)32L, (long)content.content().readableBytes());
            content.content().readBytes(decodedData, 32, 32);
            Assert.assertArrayEquals((byte[])data, (byte[])decodedData);
            content.release();
            Assert.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        Assert.assertFalse((boolean)content.content().isReadable());
        content.release();
        ch.finish();
        Assert.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testClosureWithoutContentLength1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertTrue((boolean)ch.finish());
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testClosureWithoutContentLength2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"12345678"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(LastHttpContent.class))));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        Assert.assertTrue((boolean)ch.finish());
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testPrematureClosureWithChunkedEncoding2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n8\r\n12345678", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING), (Matcher)CoreMatchers.is((Object)"chunked"));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().toString(CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"12345678"));
        MatcherAssert.assertThat((Object)content, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(LastHttpContent.class))));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithEmptyHeaderAndEmptyContent() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent content = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        content.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithoutContentLengthHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)1024));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithHeaderRemoveTrailingSpaces() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nX-Header: h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT       \r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        MatcherAssert.assertThat((Object)res.headers().get(HttpHeadersTestUtils.of("X-Header")), (Matcher)CoreMatchers.is((Object)"h2=h2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[1024])});
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)1024));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResetContentResponseWithTransferEncoding() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 205 Reset Content\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.RESET_CONTENT));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testLastResponseWithTrailingHeader() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        HttpHeaders headers = lastContent.trailingHeaders();
        Assert.assertEquals((long)1L, (long)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("t1=t1v1"));
        Assert.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testLastResponseWithTrailingHeaderFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\nSet-Cookie: t1=t1v1\r\nSet-Cookie: t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testLastResponseWithTrailingHeaderFragmented(data, i);
        }
    }

    private static void testLastResponseWithTrailingHeaderFragmented(byte[] content, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        int headerLength = 47;
        for (int a = 0; a < headerLength; a += amount) {
            amount = fragmentSize;
            if (a + amount > headerLength) {
                amount = headerLength - a;
            }
            boolean headerDone = a + amount == headerLength;
            Assert.assertEquals((Object)headerDone, (Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)a, (int)amount)}));
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])content, (int)headerLength, (int)(content.length - headerLength))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)lastContent.content().isReadable(), (Matcher)CoreMatchers.is((Object)false));
        HttpHeaders headers = lastContent.trailingHeaders();
        Assert.assertEquals((long)1L, (long)headers.names().size());
        List values = headers.getAll(HttpHeadersTestUtils.of("Set-Cookie"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("t1=t1v1"));
        Assert.assertTrue((boolean)values.contains("t2=t2v2; Expires=Wed, 09-Jun-2021 10:18:14 GMT"));
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResponseWithContentLength() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent firstContent = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)firstContent.content().readableBytes(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        Assert.assertEquals((long)5L, (long)lastContent.content().readableBytes());
        Assert.assertEquals((Object)Unpooled.copiedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testResponseWithContentLengthFragmented() {
        byte[] data = "HTTP/1.1 200 OK\r\nContent-Length: 10\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        for (int i = 1; i < data.length; ++i) {
            HttpResponseDecoderTest.testResponseWithContentLengthFragmented(data, i);
        }
    }

    private static void testResponseWithContentLengthFragmented(byte[] header, int fragmentSize) {
        int amount;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        for (int a = 0; a < header.length; a += amount) {
            amount = fragmentSize;
            if (a + amount > header.length) {
                amount = header.length - a;
            }
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])header, (int)a, (int)amount)});
        }
        byte[] data = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
        }
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)0, (int)(data.length / 2))});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data, (int)5, (int)(data.length / 2))});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.OK));
        HttpContent firstContent = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)firstContent.content().readableBytes(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)0, (int)5), (Object)firstContent.content());
        firstContent.release();
        LastHttpContent lastContent = (LastHttpContent)ch.readInbound();
        Assert.assertEquals((long)5L, (long)lastContent.content().readableBytes());
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data, (int)5, (int)5), (Object)lastContent.content());
        lastContent.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testWebSocketResponse() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.SWITCHING_PROTOCOLS));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)16));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWebSocketResponseWithDataFollowing() {
        byte[] data = "HTTP/1.1 101 WebSocket Protocol Handshake\r\nUpgrade: WebSocket\r\nConnection: Upgrade\r\nSec-WebSocket-Origin: http://localhost:8080\r\nSec-WebSocket-Location: ws://localhost/some/path\r\n\r\n1234567812345678".getBytes();
        byte[] otherData = new byte[]{1, 2, 3, 4};
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[][])new byte[][]{data, otherData})});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_1));
        MatcherAssert.assertThat((Object)res.status(), (Matcher)CoreMatchers.is((Object)HttpResponseStatus.SWITCHING_PROTOCOLS));
        HttpContent content = (HttpContent)ch.readInbound();
        MatcherAssert.assertThat((Object)content.content().readableBytes(), (Matcher)CoreMatchers.is((Object)16));
        content.release();
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])otherData);
        ByteBuf buffer = (ByteBuf)ch.readInbound();
        try {
            Assert.assertEquals((Object)expected, (Object)buffer);
        }
        finally {
            expected.release();
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    @Test
    public void testGarbageHeaders() {
        byte[] data = "<html>\r\n<head><title>400 Bad Request</title></head>\r\n<body bgcolor=\"white\">\r\n<center><h1>400 Bad Request</h1></center>\r\n<hr><center>nginx/1.1.19</center>\r\n</body>\r\n</html>\r\n".getBytes();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        HttpResponse res = (HttpResponse)ch.readInbound();
        MatcherAssert.assertThat((Object)res.protocolVersion(), (Matcher)CoreMatchers.sameInstance((Object)HttpVersion.HTTP_1_0));
        MatcherAssert.assertThat((Object)res.status().code(), (Matcher)CoreMatchers.is((Object)999));
        MatcherAssert.assertThat((Object)res.decoderResult().isFailure(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)res.decoderResult().isFinished(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])data)});
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ch.finish();
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testGarbageChunk() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseWithIllegalChunk = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\nNOT_A_CHUNK_LENGTH\r\n";
        channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseWithIllegalChunk, (Charset)CharsetUtil.US_ASCII)});
        MatcherAssert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(HttpResponse.class)));
        LastHttpContent invalidChunk = (LastHttpContent)channel.readInbound();
        MatcherAssert.assertThat((Object)invalidChunk.decoderResult().isFailure(), (Matcher)CoreMatchers.is((Object)true));
        invalidChunk.release();
        MatcherAssert.assertThat((Object)channel.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)channel.finish(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    public void testConnectionClosedBeforeHeadersReceived() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String responseInitialLine = "HTTP/1.1 200 OK\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)responseInitialLine, (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertTrue((boolean)channel.finish());
        HttpMessage message = (HttpMessage)channel.readInbound();
        Assert.assertTrue((boolean)message.decoderResult().isFailure());
        MatcherAssert.assertThat((Object)message.decoderResult().cause(), (Matcher)CoreMatchers.instanceOf(PrematureChannelClosureException.class));
        Assert.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testTrailerWithEmptyLineInSeparateBuffer() {
        HttpResponseDecoder decoder = new HttpResponseDecoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{decoder});
        String headers = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\nTrailer: My-Trailer\r\n";
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])headers.getBytes(CharsetUtil.US_ASCII))}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])"\r\n".getBytes(CharsetUtil.US_ASCII))}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"0\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"My-Trailer: 42\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assert.assertEquals((long)2L, (long)response.headers().size());
        Assert.assertEquals((Object)"chunked", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        Assert.assertEquals((Object)"My-Trailer", (Object)response.headers().get((CharSequence)HttpHeaderNames.TRAILER));
        LastHttpContent lastContent = (LastHttpContent)channel.readInbound();
        Assert.assertEquals((long)1L, (long)lastContent.trailingHeaders().size());
        Assert.assertEquals((Object)"42", (Object)lastContent.trailingHeaders().get("My-Trailer"));
        Assert.assertEquals((long)0L, (long)lastContent.content().readableBytes());
        lastContent.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testWhitespace() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder()});
        String requestStr = "HTTP/1.1 200 OK\r\nTransfer-Encoding : chunked\r\nHost: netty.io\n\r\n";
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)requestStr, (Charset)CharsetUtil.US_ASCII)}));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assert.assertFalse((boolean)response.decoderResult().isFailure());
        Assert.assertEquals((Object)HttpHeaderValues.CHUNKED.toString(), (Object)response.headers().get((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
        Assert.assertEquals((Object)"netty.io", (Object)response.headers().get((CharSequence)HttpHeaderNames.HOST));
        Assert.assertFalse((boolean)channel.finish());
    }
}

