/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.DecoderResultProvider;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class HttpObjectAggregatorTest {
    @Test
    public void testAggregate() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        DefaultLastHttpContent chunk3 = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER);
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        Assert.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assert.assertNotNull((Object)aggregatedMessage);
        Assert.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assert.assertNull((Object)embedder.readInbound());
    }

    private static void checkContentBuffer(FullHttpRequest aggregatedMessage) {
        CompositeByteBuf buffer = (CompositeByteBuf)aggregatedMessage.content();
        Assert.assertEquals((long)2L, (long)buffer.numComponents());
        List buffers = buffer.decompose(0, buffer.capacity());
        Assert.assertEquals((long)2L, (long)buffers.size());
        for (ByteBuf buf : buffers) {
            Assert.assertFalse((boolean)(buf instanceof CompositeByteBuf));
        }
        aggregatedMessage.release();
    }

    @Test
    public void testAggregateWithTrailer() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)true);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        DefaultLastHttpContent trailer = new DefaultLastHttpContent();
        trailer.trailingHeaders().set(HttpHeadersTestUtils.of("X-Trailer"), (Object)true);
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{trailer}));
        Assert.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assert.assertNotNull((Object)aggregatedMessage);
        Assert.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.trailingHeaders().get(HttpHeadersTestUtils.of("X-Trailer")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assert.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testOversizedRequest() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertFalse((boolean)embedder.isOpen());
        try {
            Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk3}));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof ClosedChannelException));
        }
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWithContentLengthAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4, false)});
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nContent-Length: 5\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertTrue((boolean)embedder.isOpen());
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4})}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{5})}));
        Assert.assertNull((Object)embedder.readOutbound());
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nContent-Length: 2\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.instanceOf(LastHttpContent.class));
        ReferenceCountUtil.release((Object)response);
        Assert.assertTrue((boolean)embedder.isOpen());
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])new byte[]{1})}));
        Assert.assertNull((Object)embedder.readOutbound());
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((byte[])new byte[]{2})}));
        Assert.assertNull((Object)embedder.readOutbound());
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        Assert.assertEquals((Object)HttpVersion.HTTP_1_1, (Object)request.protocolVersion());
        Assert.assertEquals((Object)HttpMethod.PUT, (Object)request.method());
        Assert.assertEquals((Object)"/upload", (Object)request.uri());
        Assert.assertEquals((long)2L, (long)HttpUtil.getContentLength((HttpMessage)request));
        byte[] actual = new byte[request.content().readableBytes()];
        request.content().readBytes(actual);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])actual);
        request.release();
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWithoutKeepAlive() {
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.PUT, "http://localhost");
        HttpUtil.setContentLength((HttpMessage)message, (long)5L);
        HttpObjectAggregatorTest.checkOversizedRequest((HttpRequest)message);
    }

    @Test
    public void testOversizedRequestWithContentLength() {
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.setContentLength((HttpMessage)message, (long)5L);
        HttpObjectAggregatorTest.checkOversizedRequest((HttpRequest)message);
    }

    private static void checkOversizedRequest(HttpRequest message) {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        HttpResponse response = (HttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        MatcherAssert.assertThat((Object)response, (Matcher)CoreMatchers.instanceOf(LastHttpContent.class));
        ReferenceCountUtil.release((Object)response);
        if (HttpObjectAggregatorTest.serverShouldCloseConnection(message, response)) {
            Assert.assertFalse((boolean)embedder.isOpen());
            try {
                embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.EMPTY_BUFFER)});
                Assert.fail();
            }
            catch (Exception e) {
                MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.instanceOf(ClosedChannelException.class));
            }
            Assert.assertFalse((boolean)embedder.finish());
        } else {
            Assert.assertTrue((boolean)embedder.isOpen());
            Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[8]))}));
            Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[8]))}));
            DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.PUT, "http://localhost");
            HttpUtil.setContentLength((HttpMessage)message, (long)2L);
            Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
            Assert.assertNull((Object)embedder.readOutbound());
            Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{new DefaultHttpContent(Unpooled.copiedBuffer((byte[])new byte[]{1}))}));
            Assert.assertNull((Object)embedder.readOutbound());
            Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{new DefaultLastHttpContent(Unpooled.copiedBuffer((byte[])new byte[]{2}))}));
            Assert.assertNull((Object)embedder.readOutbound());
            FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
            Assert.assertEquals((Object)message2.protocolVersion(), (Object)request.protocolVersion());
            Assert.assertEquals((Object)message2.method(), (Object)request.method());
            Assert.assertEquals((Object)message2.uri(), (Object)request.uri());
            Assert.assertEquals((long)2L, (long)HttpUtil.getContentLength((HttpMessage)request));
            byte[] actual = new byte[request.content().readableBytes()];
            request.content().readBytes(actual);
            Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])actual);
            request.release();
            Assert.assertFalse((boolean)embedder.finish());
        }
    }

    private static boolean serverShouldCloseConnection(HttpRequest message, HttpResponse response) {
        if (!HttpUtil.isKeepAlive((HttpMessage)response)) {
            return true;
        }
        if (HttpUtil.is100ContinueExpected((HttpMessage)message)) {
            return false;
        }
        return !HttpUtil.isKeepAlive((HttpMessage)message);
    }

    @Test
    public void testOversizedResponse() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(4)});
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        try {
            embedder.writeInbound(new Object[]{chunk2});
            Assert.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)embedder.isOpen());
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstructorUsage() {
        new HttpObjectAggregator(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidMaxCumulationBufferComponents() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(Integer.MAX_VALUE);
        aggr.setMaxCumulationBufferComponents(1);
    }

    @Test(expected=IllegalStateException.class)
    public void testSetMaxCumulationBufferComponentsAfterInit() throws Exception {
        HttpObjectAggregator aggr = new HttpObjectAggregator(Integer.MAX_VALUE);
        ChannelHandlerContext ctx = (ChannelHandlerContext)Mockito.mock(ChannelHandlerContext.class);
        aggr.handlerAdded(ctx);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{ctx});
        aggr.setMaxCumulationBufferComponents(10);
    }

    @Test
    public void testAggregateTransferEncodingChunked() {
        HttpObjectAggregator aggr = new HttpObjectAggregator(0x100000);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{aggr});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        message.headers().set(HttpHeadersTestUtils.of("X-Test"), (Object)true);
        message.headers().set(HttpHeadersTestUtils.of("Transfer-Encoding"), (Object)HttpHeadersTestUtils.of("Chunked"));
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test2", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        Assert.assertTrue((boolean)embedder.finish());
        FullHttpRequest aggregatedMessage = (FullHttpRequest)embedder.readInbound();
        Assert.assertNotNull((Object)aggregatedMessage);
        Assert.assertEquals((long)(chunk1.content().readableBytes() + chunk2.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)aggregatedMessage));
        Assert.assertEquals((Object)Boolean.TRUE.toString(), (Object)aggregatedMessage.headers().get(HttpHeadersTestUtils.of("X-Test")));
        HttpObjectAggregatorTest.checkContentBuffer(aggregatedMessage);
        Assert.assertNull((Object)embedder.readInbound());
    }

    @Test
    public void testBadRequest() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(0x100000)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.0 with extra\r\n", (Charset)CharsetUtil.UTF_8)});
        Object inbound = ch.readInbound();
        MatcherAssert.assertThat((Object)inbound, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpRequest.class)));
        Assert.assertTrue((boolean)((DecoderResultProvider)inbound).decoderResult().isFailure());
        Assert.assertNull((Object)ch.readInbound());
        ch.finish();
    }

    @Test
    public void testBadResponse() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseDecoder(), new HttpObjectAggregator(0x100000)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"HTTP/1.0 BAD_CODE Bad Server\r\n", (Charset)CharsetUtil.UTF_8)});
        Object inbound = ch.readInbound();
        MatcherAssert.assertThat((Object)inbound, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FullHttpResponse.class)));
        Assert.assertTrue((boolean)((DecoderResultProvider)inbound).decoderResult().isFailure());
        Assert.assertNull((Object)ch.readInbound());
        ch.finish();
    }

    @Test
    public void testOversizedRequestWith100Continue() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(8)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.set100ContinueExpected((HttpMessage)message, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)message, (long)16L);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"some", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertTrue((boolean)embedder.isOpen());
        DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        FullHttpRequest fullMsg = (FullHttpRequest)embedder.readInbound();
        Assert.assertNotNull((Object)fullMsg);
        Assert.assertEquals((long)(chunk2.content().readableBytes() + chunk3.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)fullMsg));
        Assert.assertEquals((long)HttpUtil.getContentLength((HttpMessage)fullMsg), (long)fullMsg.content().readableBytes());
        fullMsg.release();
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testUnsupportedExpectHeaderExpectation() {
        HttpObjectAggregatorTest.runUnsupportedExceptHeaderExceptionTest(true);
        HttpObjectAggregatorTest.runUnsupportedExceptHeaderExceptionTest(false);
    }

    private static void runUnsupportedExceptHeaderExceptionTest(boolean close) {
        int maxContentLength = 4;
        HttpObjectAggregator aggregator = close ? new HttpObjectAggregator(4, true) : new HttpObjectAggregator(4);
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), aggregator});
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.1\r\nExpect: chocolate=yummy\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
        Assert.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.EXPECTATION_FAILED, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        response.release();
        if (close) {
            Assert.assertFalse((boolean)embedder.isOpen());
        } else {
            Assert.assertTrue((boolean)embedder.isOpen());
            Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET / HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.US_ASCII)}));
            FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
            MatcherAssert.assertThat((Object)request.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.GET));
            MatcherAssert.assertThat((Object)request.uri(), (Matcher)CoreMatchers.is((Object)"/"));
            MatcherAssert.assertThat((Object)request.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
            request.release();
        }
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testValidRequestWith100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(100)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 0\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.CONTINUE, (Object)response.status());
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        Assert.assertFalse((boolean)request.headers().contains((CharSequence)HttpHeaderNames.EXPECT));
        request.release();
        response.release();
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWith100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assert.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertTrue((boolean)embedder.isOpen());
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"GET /max-upload-size HTTP/1.1\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        FullHttpRequest request = (FullHttpRequest)embedder.readInbound();
        MatcherAssert.assertThat((Object)request.method(), (Matcher)CoreMatchers.is((Object)HttpMethod.GET));
        MatcherAssert.assertThat((Object)request.uri(), (Matcher)CoreMatchers.is((Object)"/max-upload-size"));
        MatcherAssert.assertThat((Object)request.content().readableBytes(), (Matcher)CoreMatchers.is((Object)0));
        request.release();
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testOversizedRequestWith100ContinueAndDecoderCloseConnection() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(4, true)});
        embedder.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"PUT /upload HTTP/1.1\r\nExpect: 100-continue\r\nContent-Length: 100\r\n\r\n", (Charset)CharsetUtil.US_ASCII)});
        Assert.assertNull((Object)embedder.readInbound());
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertFalse((boolean)embedder.isOpen());
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testRequestAfterOversized100ContinueAndDecoder() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(), new HttpObjectAggregator(15)});
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        HttpUtil.set100ContinueExpected((HttpMessage)message, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)message, (long)16L);
        DefaultHttpContent chunk1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"some", (Charset)CharsetUtil.US_ASCII));
        DefaultHttpContent chunk2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"test", (Charset)CharsetUtil.US_ASCII));
        LastHttpContent chunk3 = LastHttpContent.EMPTY_LAST_CONTENT;
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message}));
        FullHttpResponse response = (FullHttpResponse)embedder.readOutbound();
        Assert.assertEquals((Object)HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE, (Object)response.status());
        Assert.assertEquals((Object)"0", (Object)response.headers().get((CharSequence)HttpHeaderNames.CONTENT_LENGTH));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk1}));
        Assert.assertTrue((boolean)embedder.isOpen());
        DefaultHttpRequest message2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "http://localhost");
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{message2}));
        Assert.assertFalse((boolean)embedder.writeInbound(new Object[]{chunk2}));
        Assert.assertTrue((boolean)embedder.writeInbound(new Object[]{chunk3}));
        FullHttpRequest fullMsg = (FullHttpRequest)embedder.readInbound();
        Assert.assertNotNull((Object)fullMsg);
        Assert.assertEquals((long)(chunk2.content().readableBytes() + chunk3.content().readableBytes()), (long)HttpUtil.getContentLength((HttpMessage)fullMsg));
        Assert.assertEquals((long)HttpUtil.getContentLength((HttpMessage)fullMsg), (long)fullMsg.content().readableBytes());
        fullMsg.release();
        Assert.assertFalse((boolean)embedder.finish());
    }

    @Test
    public void testReplaceAggregatedRequest() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
        Exception boom = new Exception("boom");
        DefaultHttpRequest req = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http://localhost");
        req.setDecoderResult(DecoderResult.failure((Throwable)boom));
        Assert.assertTrue((embedder.writeInbound(new Object[]{req}) && embedder.finish() ? 1 : 0) != 0);
        FullHttpRequest aggregatedReq = (FullHttpRequest)embedder.readInbound();
        FullHttpRequest replacedReq = aggregatedReq.replace(Unpooled.EMPTY_BUFFER);
        Assert.assertEquals((Object)replacedReq.decoderResult(), (Object)aggregatedReq.decoderResult());
        aggregatedReq.release();
        replacedReq.release();
    }

    @Test
    public void testReplaceAggregatedResponse() {
        EmbeddedChannel embedder = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(0x100000)});
        Exception boom = new Exception("boom");
        DefaultHttpResponse rep = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        rep.setDecoderResult(DecoderResult.failure((Throwable)boom));
        Assert.assertTrue((embedder.writeInbound(new Object[]{rep}) && embedder.finish() ? 1 : 0) != 0);
        FullHttpResponse aggregatedRep = (FullHttpResponse)embedder.readInbound();
        FullHttpResponse replacedRep = aggregatedRep.replace(Unpooled.EMPTY_BUFFER);
        Assert.assertEquals((Object)replacedRep.decoderResult(), (Object)aggregatedRep.decoderResult());
        aggregatedRep.release();
        replacedRep.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectiveRequestAggregation() {
        HttpObjectAggregator myPostAggregator = new HttpObjectAggregator(0x100000){

            protected boolean isStartMessage(HttpObject msg) throws Exception {
                HttpRequest request;
                HttpMethod method;
                return msg instanceof HttpRequest && (method = (request = (HttpRequest)msg).method()).equals((Object)HttpMethod.POST);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{myPostAggregator});
        try {
            DefaultHttpRequest request1 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/");
            DefaultHttpContent content1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            request1.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{request1, content1, LastHttpContent.EMPTY_LAST_CONTENT}));
            Object msg1 = channel.readInbound();
            try {
                Assert.assertTrue((boolean)(msg1 instanceof FullHttpRequest));
            }
            finally {
                ReferenceCountUtil.release((Object)msg1);
            }
            DefaultHttpRequest request2 = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.PUT, "/");
            DefaultHttpContent content2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            request2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            try {
                Assert.assertTrue((boolean)channel.writeInbound(new Object[]{request2, content2, LastHttpContent.EMPTY_LAST_CONTENT}));
                Assert.assertSame((Object)request2, (Object)channel.readInbound());
                Assert.assertSame((Object)content2, (Object)channel.readInbound());
                Assert.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
            }
            finally {
                ReferenceCountUtil.release((Object)request2);
                ReferenceCountUtil.release((Object)content2);
            }
            Assert.assertFalse((boolean)channel.finish());
        }
        finally {
            channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelectiveResponseAggregation() {
        HttpObjectAggregator myTextAggregator = new HttpObjectAggregator(0x100000){

            protected boolean isStartMessage(HttpObject msg) throws Exception {
                HttpResponse response;
                HttpHeaders headers;
                String contentType;
                return msg instanceof HttpResponse && AsciiString.contentEqualsIgnoreCase((CharSequence)(contentType = (headers = (response = (HttpResponse)msg).headers()).get((CharSequence)HttpHeaderNames.CONTENT_TYPE)), (CharSequence)HttpHeaderValues.TEXT_PLAIN);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{myTextAggregator});
        try {
            DefaultHttpResponse response1 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            DefaultHttpContent content1 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.UTF_8));
            response1.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            Assert.assertTrue((boolean)channel.writeInbound(new Object[]{response1, content1, LastHttpContent.EMPTY_LAST_CONTENT}));
            Object msg1 = channel.readInbound();
            try {
                Assert.assertTrue((boolean)(msg1 instanceof FullHttpResponse));
            }
            finally {
                ReferenceCountUtil.release((Object)msg1);
            }
            DefaultHttpResponse response2 = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            DefaultHttpContent content2 = new DefaultHttpContent(Unpooled.copiedBuffer((CharSequence)"{key: 'value'}", (Charset)CharsetUtil.UTF_8));
            response2.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
            try {
                Assert.assertTrue((boolean)channel.writeInbound(new Object[]{response2, content2, LastHttpContent.EMPTY_LAST_CONTENT}));
                Assert.assertSame((Object)response2, (Object)channel.readInbound());
                Assert.assertSame((Object)content2, (Object)channel.readInbound());
                Assert.assertSame((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)channel.readInbound());
            }
            finally {
                ReferenceCountUtil.release((Object)response2);
                ReferenceCountUtil.release((Object)content2);
            }
            Assert.assertFalse((boolean)channel.finish());
        }
        finally {
            channel.close();
        }
    }
}

