/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions.compression;

import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateDecoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateEncoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import java.util.Collections;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;

public class PerMessageDeflateServerExtensionHandshakerTest {
    @Test
    public void testNormalHandshake() {
        PerMessageDeflateServerExtensionHandshaker handshaker = new PerMessageDeflateServerExtensionHandshaker();
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", Collections.emptyMap()));
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((long)4L, (long)extension.rsv());
        Assert.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assert.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        WebSocketExtensionData data = extension.newReponseData();
        Assert.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().isEmpty());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", null);
        parameters.put("client_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", Collections.emptyMap()));
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((long)4L, (long)extension.rsv());
        Assert.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assert.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        data = extension.newReponseData();
        Assert.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().isEmpty());
        parameters = new HashMap();
        parameters.put("server_max_window_bits", "12");
        parameters.put("server_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assert.assertNull((Object)extension);
    }

    @Test
    public void testCustomHandshake() {
        PerMessageDeflateServerExtensionHandshaker handshaker = new PerMessageDeflateServerExtensionHandshaker(6, true, 10, true, true);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("client_max_window_bits", null);
        parameters.put("server_max_window_bits", "12");
        parameters.put("client_no_context_takeover", null);
        parameters.put("server_no_context_takeover", null);
        WebSocketServerExtension extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((long)4L, (long)extension.rsv());
        Assert.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assert.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        WebSocketExtensionData data = extension.newReponseData();
        Assert.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assert.assertEquals((Object)"10", data.parameters().get("client_max_window_bits"));
        Assert.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        Assert.assertEquals((Object)"12", data.parameters().get("server_max_window_bits"));
        Assert.assertTrue((boolean)data.parameters().containsKey("client_max_window_bits"));
        Assert.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        parameters = new HashMap();
        parameters.put("server_max_window_bits", "12");
        parameters.put("server_no_context_takeover", null);
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assert.assertNotNull((Object)extension);
        Assert.assertEquals((long)4L, (long)extension.rsv());
        Assert.assertTrue((boolean)(extension.newExtensionDecoder() instanceof PerMessageDeflateDecoder));
        Assert.assertTrue((boolean)(extension.newExtensionEncoder() instanceof PerMessageDeflateEncoder));
        data = extension.newReponseData();
        Assert.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assert.assertEquals((long)2L, (long)data.parameters().size());
        Assert.assertTrue((boolean)data.parameters().containsKey("server_max_window_bits"));
        Assert.assertEquals((Object)"12", data.parameters().get("server_max_window_bits"));
        Assert.assertTrue((boolean)data.parameters().containsKey("server_no_context_takeover"));
        parameters = new HashMap();
        extension = handshaker.handshakeExtension(new WebSocketExtensionData("permessage-deflate", parameters));
        Assert.assertNotNull((Object)extension);
        data = extension.newReponseData();
        Assert.assertEquals((Object)"permessage-deflate", (Object)data.name());
        Assert.assertTrue((boolean)data.parameters().isEmpty());
    }
}

