/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker07;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerTest;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketClientHandshaker07Test
extends WebSocketClientHandshakerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostHeaderPreserved() {
        URI uri = URI.create("ws://localhost:9999");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, null, new DefaultHttpHeaders().set((CharSequence)HttpHeaderNames.HOST, (Object)"test.netty.io"), false);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"/", (Object)request.uri());
            Assert.assertEquals((Object)"test.netty.io", (Object)request.headers().get((CharSequence)HttpHeaderNames.HOST));
        }
        finally {
            request.release();
        }
    }

    @Override
    protected WebSocketClientHandshaker newHandshaker(URI uri, String subprotocol, HttpHeaders headers, boolean absoluteUpgradeUrl) {
        return new WebSocketClientHandshaker07(uri, WebSocketVersion.V07, subprotocol, false, headers, 1024, true, false, 10000L, absoluteUpgradeUrl);
    }

    @Override
    protected CharSequence getOriginHeaderName() {
        return HttpHeaderNames.SEC_WEBSOCKET_ORIGIN;
    }

    @Override
    protected CharSequence getProtocolHeaderName() {
        return HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL;
    }

    @Override
    protected CharSequence[] getHandshakeRequiredHeaderNames() {
        return new CharSequence[]{HttpHeaderNames.UPGRADE, HttpHeaderNames.CONNECTION, HttpHeaderNames.SEC_WEBSOCKET_KEY, HttpHeaderNames.HOST, HttpHeaderNames.SEC_WEBSOCKET_VERSION};
    }
}

