/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpHeaderDateFormat;
import java.text.ParseException;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class HttpHeaderDateFormatTest {
    private static final Date DATE = new Date(784111777000L);

    @Test
    public void testParse() throws ParseException {
        HttpHeaderDateFormat format = HttpHeaderDateFormat.get();
        Date parsedDateWithSingleDigitDay = format.parse("Sun, 6 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)parsedDateWithSingleDigitDay);
        Assert.assertEquals((Object)DATE, (Object)parsedDateWithSingleDigitDay);
        Date parsedDateWithDoubleDigitDay = format.parse("Sun, 06 Nov 1994 08:49:37 GMT");
        Assert.assertNotNull((Object)parsedDateWithDoubleDigitDay);
        Assert.assertEquals((Object)DATE, (Object)parsedDateWithDoubleDigitDay);
        Date parsedDateWithDashSeparatorSingleDigitDay = format.parse("Sunday, 06-Nov-94 08:49:37 GMT");
        Assert.assertNotNull((Object)parsedDateWithDashSeparatorSingleDigitDay);
        Assert.assertEquals((Object)DATE, (Object)parsedDateWithDashSeparatorSingleDigitDay);
        Date parsedDateWithSingleDoubleDigitDay = format.parse("Sunday, 6-Nov-94 08:49:37 GMT");
        Assert.assertNotNull((Object)parsedDateWithSingleDoubleDigitDay);
        Assert.assertEquals((Object)DATE, (Object)parsedDateWithSingleDoubleDigitDay);
        Date parsedDateWithoutGMT = format.parse("Sun Nov 6 08:49:37 1994");
        Assert.assertNotNull((Object)parsedDateWithoutGMT);
        Assert.assertEquals((Object)DATE, (Object)parsedDateWithoutGMT);
    }

    @Test
    public void testFormat() {
        HttpHeaderDateFormat format = HttpHeaderDateFormat.get();
        String formatted = format.format(DATE);
        Assert.assertNotNull((Object)formatted);
        Assert.assertEquals((Object)"Sun, 06 Nov 1994 08:49:37 GMT", (Object)formatted);
    }
}

