/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HttpClientUpgradeHandlerTest {
    @Test
    public void testSuccessfulUpgrade() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assert.assertEquals((long)2L, (long)request.headers().size());
        Assert.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assert.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assert.assertTrue((boolean)request.release());
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{upgradeResponse}));
        Assert.assertFalse((boolean)channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL, (Object)catcher.getUserEvent());
        Assert.assertNull((Object)channel.pipeline().get("upgrade"));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        FullHttpResponse response = (FullHttpResponse)channel.readInbound();
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        Assert.assertTrue((boolean)response.release());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testUpgradeRejected() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assert.assertEquals((long)2L, (long)request.headers().size());
        Assert.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assert.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assert.assertTrue((boolean)request.release());
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED, (Object)catcher.getUserEvent());
        Assert.assertNull((Object)channel.pipeline().get("upgrade"));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        LastHttpContent last = (LastHttpContent)channel.readInbound();
        Assert.assertEquals((Object)LastHttpContent.EMPTY_LAST_CONTENT, (Object)last);
        Assert.assertFalse((boolean)last.release());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testEarlyBailout() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io")}));
        FullHttpRequest request = (FullHttpRequest)channel.readOutbound();
        Assert.assertEquals((long)2L, (long)request.headers().size());
        Assert.assertTrue((boolean)request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)"fancyhttp", false));
        Assert.assertTrue((boolean)request.headers().contains("connection", "upgrade", false));
        Assert.assertTrue((boolean)request.release());
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_ISSUED, (Object)catcher.getUserEvent());
        DefaultHttpResponse upgradeResponse = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS);
        upgradeResponse.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)"fancyhttp");
        Assert.assertTrue((boolean)channel.writeInbound(new Object[]{new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK)}));
        Assert.assertEquals((Object)HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED, (Object)catcher.getUserEvent());
        Assert.assertNull((Object)channel.pipeline().get("upgrade"));
        HttpResponse response = (HttpResponse)channel.readInbound();
        Assert.assertEquals((Object)HttpResponseStatus.OK, (Object)response.status());
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void dontStripConnectionHeaders() {
        FakeSourceCodec sourceCodec = new FakeSourceCodec();
        FakeUpgradeCodec upgradeCodec = new FakeUpgradeCodec();
        HttpClientUpgradeHandler handler = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)sourceCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1024);
        UserEventCatcher catcher = new UserEventCatcher();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{catcher});
        channel.pipeline().addFirst("upgrade", (ChannelHandler)handler);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "netty.io");
        request.headers().add("connection", (Object)"extra");
        request.headers().add("extra", (Object)"value");
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        FullHttpRequest readRequest = (FullHttpRequest)channel.readOutbound();
        List connectionHeaders = readRequest.headers().getAll("connection");
        Assert.assertTrue((boolean)connectionHeaders.contains("extra"));
        Assert.assertTrue((boolean)readRequest.release());
        Assert.assertFalse((boolean)channel.finish());
    }

    private static final class UserEventCatcher
    extends ChannelInboundHandlerAdapter {
        private Object evt;

        private UserEventCatcher() {
        }

        public Object getUserEvent() {
            return this.evt;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            this.evt = evt;
        }
    }

    private static final class FakeUpgradeCodec
    implements HttpClientUpgradeHandler.UpgradeCodec {
        private FakeUpgradeCodec() {
        }

        public CharSequence protocol() {
            return "fancyhttp";
        }

        public Collection<CharSequence> setUpgradeHeaders(ChannelHandlerContext ctx, HttpRequest upgradeRequest) {
            return Collections.emptyList();
        }

        public void upgradeTo(ChannelHandlerContext ctx, FullHttpResponse upgradeResponse) throws Exception {
        }
    }

    private static final class FakeSourceCodec
    implements HttpClientUpgradeHandler.SourceCodec {
        private FakeSourceCodec() {
        }

        public void prepareUpgradeFrom(ChannelHandlerContext ctx) {
        }

        public void upgradeFrom(ChannelHandlerContext ctx) {
        }
    }
}

