/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class DefaultHttpHeadersTest {
    private static final CharSequence HEADER_NAME = "testHeader";

    @Test(expected=IllegalArgumentException.class)
    public void nullHeaderNameNotAllowed() {
        new DefaultHttpHeaders().add(null, (Object)"foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyHeaderNameNotAllowed() {
        new DefaultHttpHeaders().add("", (Object)"foo");
    }

    @Test
    public void keysShouldBeCaseInsensitive() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Name"), (Object)HttpHeadersTestUtils.of("value1"));
        headers.add(HttpHeadersTestUtils.of("name"), (Object)HttpHeadersTestUtils.of("value2"));
        headers.add(HttpHeadersTestUtils.of("NAME"), (Object)HttpHeadersTestUtils.of("value3"));
        Assert.assertEquals((long)3L, (long)headers.size());
        List<String> values = Arrays.asList("value1", "value2", "value3");
        Assert.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("NAME")));
        Assert.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("name")));
        Assert.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("Name")));
        Assert.assertEquals(values, (Object)headers.getAll(HttpHeadersTestUtils.of("nAmE")));
    }

    @Test
    public void keysShouldBeCaseInsensitiveInHeadersEquals() {
        DefaultHttpHeaders headers1 = new DefaultHttpHeaders();
        headers1.add(HttpHeadersTestUtils.of("name1"), Arrays.asList("value1", "value2", "value3"));
        headers1.add(HttpHeadersTestUtils.of("nAmE2"), (Object)HttpHeadersTestUtils.of("value4"));
        DefaultHttpHeaders headers2 = new DefaultHttpHeaders();
        headers2.add(HttpHeadersTestUtils.of("naMe1"), Arrays.asList("value1", "value2", "value3"));
        headers2.add(HttpHeadersTestUtils.of("NAME2"), (Object)HttpHeadersTestUtils.of("value4"));
        Assert.assertEquals((Object)headers1, (Object)headers1);
        Assert.assertEquals((Object)headers2, (Object)headers2);
        Assert.assertEquals((Object)headers1, (Object)headers2);
        Assert.assertEquals((Object)headers2, (Object)headers1);
        Assert.assertEquals((long)headers1.hashCode(), (long)headers2.hashCode());
    }

    @Test
    public void testStringKeyRetrievedAsAsciiString() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        String connection = "keep-alive";
        headers.add(HttpHeadersTestUtils.of("Connection"), (Object)"keep-alive");
        String value = headers.getAsString((CharSequence)HttpHeaderNames.CONNECTION.toString());
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"keep-alive", (Object)value);
        String value2 = headers.getAsString((CharSequence)HttpHeaderNames.CONNECTION);
        Assert.assertNotNull((Object)value2);
        Assert.assertEquals((Object)"keep-alive", (Object)value2);
    }

    @Test
    public void testAsciiStringKeyRetrievedAsString() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        String cacheControl = "no-cache";
        headers.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"no-cache");
        String value = headers.getAsString((CharSequence)HttpHeaderNames.CACHE_CONTROL);
        Assert.assertNotNull((Object)value);
        Assert.assertEquals((Object)"no-cache", (Object)value);
        String value2 = headers.getAsString((CharSequence)HttpHeaderNames.CACHE_CONTROL.toString());
        Assert.assertNotNull((Object)value2);
        Assert.assertEquals((Object)"no-cache", (Object)value2);
    }

    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assert.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assert.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assert.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"1", values.get(0));
        Assert.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testEqualsIgnoreCase() {
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, null), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase(null, (CharSequence)"foo"), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"bar", null), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)AsciiString.contentEqualsIgnoreCase((CharSequence)"FoO", (CharSequence)"fOo"), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullHeaderValueValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(true);
        headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
    }

    @Test(expected=NullPointerException.class)
    public void testSetNullHeaderValueNotValidate() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        headers.set(HttpHeadersTestUtils.of("test"), (Object)null);
    }

    @Test
    public void addCharSequences() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void addObjects() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.add(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setCharSequences() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectObjects() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void setObjectIterable() {
        DefaultHttpHeaders headers = DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders();
        headers.set(HEADER_NAME, HttpHeadersTestUtils.HeaderValue.THREE.asList());
        DefaultHttpHeadersTest.assertDefaultValues(headers, HttpHeadersTestUtils.HeaderValue.THREE);
    }

    @Test
    public void toStringOnEmptyHeaders() {
        Assert.assertEquals((Object)"DefaultHttpHeaders[]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().toString());
    }

    @Test
    public void toStringOnSingleHeader() {
        Assert.assertEquals((Object)"DefaultHttpHeaders[foo: bar]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().add("foo", (Object)"bar").toString());
    }

    @Test
    public void toStringOnMultipleHeaders() {
        Assert.assertEquals((Object)"DefaultHttpHeaders[foo: bar, baz: qix]", (Object)DefaultHttpHeadersTest.newDefaultDefaultHttpHeaders().add("foo", (Object)"bar").add("baz", (Object)"qix").toString());
    }

    @Test
    public void providesHeaderNamesAsArray() throws Exception {
        Set nettyHeaders = new DefaultHttpHeaders().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)10).names();
        Object[] namesArray = nettyHeaders.toArray(new String[0]);
        Assert.assertArrayEquals((Object[])namesArray, (Object[])new String[]{HttpHeaderNames.CONTENT_LENGTH.toString()});
    }

    private static void assertDefaultValues(DefaultHttpHeaders headers, HttpHeadersTestUtils.HeaderValue headerValue) {
        Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)headerValue.asList().get(0), (CharSequence)headers.get(HEADER_NAME)));
        List<CharSequence> expected = headerValue.asList();
        List actual = headers.getAll(HEADER_NAME);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Iterator<CharSequence> eItr = expected.iterator();
        Iterator aItr = actual.iterator();
        while (eItr.hasNext()) {
            Assert.assertTrue((boolean)AsciiString.contentEquals((CharSequence)eItr.next(), (CharSequence)((CharSequence)aItr.next())));
        }
    }

    private static DefaultHttpHeaders newDefaultDefaultHttpHeaders() {
        return new DefaultHttpHeaders(true);
    }
}

