/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerKeepAliveHandler;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.StringUtil;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpServerKeepAliveHandlerTest {
    private static final String REQUEST_KEEP_ALIVE = "REQUEST_KEEP_ALIVE";
    private static final int NOT_SELF_DEFINED_MSG_LENGTH = 0;
    private static final int SET_RESPONSE_LENGTH = 1;
    private static final int SET_MULTIPART = 2;
    private static final int SET_CHUNKED = 4;
    private final boolean isKeepAliveResponseExpected;
    private final HttpVersion httpVersion;
    private final HttpResponseStatus responseStatus;
    private final String sendKeepAlive;
    private final int setSelfDefinedMessageLength;
    private final String setResponseConnection;
    private EmbeddedChannel channel;

    @Parameterized.Parameters
    public static Collection<Object[]> keepAliveProvider() {
        return Arrays.asList({true, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, HttpHeaderValues.KEEP_ALIVE}, {true, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 2, HttpHeaderValues.KEEP_ALIVE}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, null, 1, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, HttpHeaderValues.CLOSE}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 2, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 4, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, 1, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, null, 0, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_1, HttpResponseStatus.OK, null, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.OK, REQUEST_KEEP_ALIVE, 1, null}, {true, HttpVersion.HTTP_1_1, HttpResponseStatus.NO_CONTENT, REQUEST_KEEP_ALIVE, 0, null}, {false, HttpVersion.HTTP_1_0, HttpResponseStatus.NO_CONTENT, null, 0, null});
    }

    public HttpServerKeepAliveHandlerTest(boolean isKeepAliveResponseExpected, HttpVersion httpVersion, HttpResponseStatus responseStatus, String sendKeepAlive, int setSelfDefinedMessageLength, CharSequence setResponseConnection) {
        this.isKeepAliveResponseExpected = isKeepAliveResponseExpected;
        this.httpVersion = httpVersion;
        this.responseStatus = responseStatus;
        this.sendKeepAlive = sendKeepAlive;
        this.setSelfDefinedMessageLength = setSelfDefinedMessageLength;
        this.setResponseConnection = setResponseConnection == null ? null : setResponseConnection.toString();
    }

    @Before
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HttpServerKeepAliveHandler()});
    }

    @Test
    public void test_KeepAlive() throws Exception {
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(this.httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)request, (boolean)REQUEST_KEEP_ALIVE.equals(this.sendKeepAlive));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.responseStatus);
        if (!StringUtil.isNullOrEmpty((String)this.setResponseConnection)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)this.setResponseConnection);
        }
        this.setupMessageLength((HttpResponse)response);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{request}));
        Object requestForwarded = this.channel.readInbound();
        Assert.assertEquals((Object)request, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)response);
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assert.assertEquals((String)"channel.isOpen", (Object)this.isKeepAliveResponseExpected, (Object)this.channel.isOpen());
        Assert.assertEquals((String)"response keep-alive", (Object)this.isKeepAliveResponseExpected, (Object)HttpUtil.isKeepAlive((HttpMessage)writtenResponse));
        ReferenceCountUtil.release((Object)writtenResponse);
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void testConnectionCloseHeaderHandledCorrectly() throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.responseStatus);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        this.setupMessageLength((HttpResponse)response);
        this.channel.writeAndFlush((Object)response);
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assert.assertFalse((boolean)this.channel.isOpen());
        ReferenceCountUtil.release((Object)writtenResponse);
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void testConnectionCloseHeaderHandledCorrectlyForVoidPromise() throws Exception {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.responseStatus);
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        this.setupMessageLength((HttpResponse)response);
        this.channel.writeAndFlush((Object)response, this.channel.voidPromise());
        HttpResponse writtenResponse = (HttpResponse)this.channel.readOutbound();
        Assert.assertFalse((boolean)this.channel.isOpen());
        ReferenceCountUtil.release((Object)writtenResponse);
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    @Test
    public void test_PipelineKeepAlive() {
        DefaultFullHttpRequest firstRequest = new DefaultFullHttpRequest(this.httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)firstRequest, (boolean)true);
        DefaultFullHttpRequest secondRequest = new DefaultFullHttpRequest(this.httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)secondRequest, (boolean)REQUEST_KEEP_ALIVE.equals(this.sendKeepAlive));
        DefaultFullHttpRequest finalRequest = new DefaultFullHttpRequest(this.httpVersion, HttpMethod.GET, "/v1/foo/bar");
        HttpUtil.setKeepAlive((HttpMessage)finalRequest, (boolean)false);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.responseStatus);
        DefaultFullHttpResponse informationalResp = new DefaultFullHttpResponse(this.httpVersion, HttpResponseStatus.PROCESSING);
        HttpUtil.setKeepAlive((HttpMessage)response, (boolean)true);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        HttpUtil.setKeepAlive((HttpMessage)informationalResp, (boolean)true);
        Assert.assertTrue((boolean)this.channel.writeInbound(new Object[]{firstRequest, secondRequest, finalRequest}));
        Object requestForwarded = this.channel.readInbound();
        Assert.assertEquals((Object)firstRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)response.retainedDuplicate());
        HttpResponse firstResponse = (HttpResponse)this.channel.readOutbound();
        Assert.assertTrue((String)"channel.isOpen", (boolean)this.channel.isOpen());
        Assert.assertTrue((String)"response keep-alive", (boolean)HttpUtil.isKeepAlive((HttpMessage)firstResponse));
        ReferenceCountUtil.release((Object)firstResponse);
        requestForwarded = this.channel.readInbound();
        Assert.assertEquals((Object)secondRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        this.channel.writeAndFlush((Object)informationalResp);
        HttpResponse writtenInfoResp = (HttpResponse)this.channel.readOutbound();
        Assert.assertTrue((String)"channel.isOpen", (boolean)this.channel.isOpen());
        Assert.assertTrue((String)"response keep-alive", (boolean)HttpUtil.isKeepAlive((HttpMessage)writtenInfoResp));
        ReferenceCountUtil.release((Object)writtenInfoResp);
        if (!StringUtil.isNullOrEmpty((String)this.setResponseConnection)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)this.setResponseConnection);
        } else {
            response.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
        }
        this.setupMessageLength((HttpResponse)response);
        this.channel.writeAndFlush((Object)response.retainedDuplicate());
        HttpResponse secondResponse = (HttpResponse)this.channel.readOutbound();
        Assert.assertEquals((String)"channel.isOpen", (Object)this.isKeepAliveResponseExpected, (Object)this.channel.isOpen());
        Assert.assertEquals((String)"response keep-alive", (Object)this.isKeepAliveResponseExpected, (Object)HttpUtil.isKeepAlive((HttpMessage)secondResponse));
        ReferenceCountUtil.release((Object)secondResponse);
        requestForwarded = this.channel.readInbound();
        Assert.assertEquals((Object)finalRequest, (Object)requestForwarded);
        ReferenceCountUtil.release((Object)requestForwarded);
        if (this.isKeepAliveResponseExpected) {
            this.channel.writeAndFlush((Object)response);
            HttpResponse finalResponse = (HttpResponse)this.channel.readOutbound();
            Assert.assertFalse((String)"channel.isOpen", (boolean)this.channel.isOpen());
            Assert.assertFalse((String)"response keep-alive", (boolean)HttpUtil.isKeepAlive((HttpMessage)finalResponse));
        }
        ReferenceCountUtil.release((Object)response);
        Assert.assertFalse((boolean)this.channel.finishAndReleaseAll());
    }

    private void setupMessageLength(HttpResponse response) {
        switch (this.setSelfDefinedMessageLength) {
            case 0: {
                if (!HttpUtil.isContentLengthSet((HttpMessage)response)) break;
                response.headers().remove((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                break;
            }
            case 1: {
                HttpUtil.setContentLength((HttpMessage)response, (long)0L);
                break;
            }
            case 4: {
                HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
                break;
            }
            case 2: {
                response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.MULTIPART_MIXED.toUpperCase());
                break;
            }
            default: {
                throw new IllegalArgumentException("selfDefinedMessageLength: " + this.setSelfDefinedMessageLength);
            }
        }
    }
}

