/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.FileRegion;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class HttpResponseEncoderTest {
    private static final long INTEGER_OVERFLOW = 0x80000000L;
    private static final FileRegion FILE_REGION = new DummyLongFileRegion();

    @Test
    public void testLargeFileRegionChunked() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{response}));
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)("HTTP/1.1 200 OK\r\n" + HttpHeaderNames.TRANSFER_ENCODING + ": " + HttpHeaderValues.CHUNKED + "\r\n\r\n"), (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{FILE_REGION}));
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)"80000000\r\n", (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        FileRegion region = (FileRegion)channel.readOutbound();
        Assert.assertSame((Object)FILE_REGION, (Object)region);
        region.release();
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)"\r\n", (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)"0\r\n\r\n", (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testEmptyBufferBypass() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        channel.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER});
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        Assert.assertThat((Object)buffer, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)Unpooled.EMPTY_BUFFER)));
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{response}));
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\n\r\n", (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        channel.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER});
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertThat((Object)buffer, (Matcher)Matchers.is((Matcher)Matchers.sameInstance((Object)Unpooled.EMPTY_BUFFER)));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testEmptyContentChunked() throws Exception {
        HttpResponseEncoderTest.testEmptyContent(true);
    }

    @Test
    public void testEmptyContentNotChunked() throws Exception {
        HttpResponseEncoderTest.testEmptyContent(false);
    }

    private static void testEmptyContent(boolean chunked) throws Exception {
        String content = "netty rocks";
        ByteBuf contentBuffer = Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.US_ASCII);
        int length = contentBuffer.readableBytes();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        if (!chunked) {
            HttpUtil.setContentLength((HttpMessage)response, (long)length);
        }
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{response}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpContent(Unpooled.EMPTY_BUFFER)}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultLastHttpContent(contentBuffer)}));
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        if (!chunked) {
            Assert.assertEquals((Object)("HTTP/1.1 200 OK\r\ncontent-length: " + length + "\r\n\r\n"), (Object)buffer.toString(CharsetUtil.US_ASCII));
        } else {
            Assert.assertEquals((Object)"HTTP/1.1 200 OK\r\n\r\n", (Object)buffer.toString(CharsetUtil.US_ASCII));
        }
        buffer.release();
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((long)0L, (long)buffer.readableBytes());
        buffer.release();
        buffer = (ByteBuf)channel.readOutbound();
        Assert.assertEquals((long)length, (long)buffer.readableBytes());
        buffer.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNoContent() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NO_CONTENT, null, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNoContentContentLength() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NO_CONTENT, (CharSequence)HttpHeaderNames.CONTENT_LENGTH, true);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNoContentTransferEncoding() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NO_CONTENT, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING, true);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNotModified() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NOT_MODIFIED, null, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNotModifiedContentLength() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NOT_MODIFIED, (CharSequence)HttpHeaderNames.CONTENT_LENGTH, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusNotModifiedTransferEncoding() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        HttpResponseEncoderTest.assertEmptyResponse(channel, HttpResponseStatus.NOT_MODIFIED, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING, false);
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusInformational() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        for (int code = 100; code < 200; ++code) {
            HttpResponseStatus status = HttpResponseStatus.valueOf((int)code);
            HttpResponseEncoderTest.assertEmptyResponse(channel, status, null, false);
        }
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusInformationalContentLength() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        for (int code = 100; code < 200; ++code) {
            HttpResponseStatus status = HttpResponseStatus.valueOf((int)code);
            HttpResponseEncoderTest.assertEmptyResponse(channel, status, (CharSequence)HttpHeaderNames.CONTENT_LENGTH, code != 101);
        }
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusInformationalTransferEncoding() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        for (int code = 100; code < 200; ++code) {
            HttpResponseStatus status = HttpResponseStatus.valueOf((int)code);
            HttpResponseEncoderTest.assertEmptyResponse(channel, status, (CharSequence)HttpHeaderNames.TRANSFER_ENCODING, code != 101);
        }
        Assert.assertFalse((boolean)channel.finish());
    }

    private static void assertEmptyResponse(EmbeddedChannel channel, HttpResponseStatus status, CharSequence headerName, boolean headerStripped) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        if (HttpHeaderNames.CONTENT_LENGTH.contentEquals(headerName)) {
            response.headers().set(headerName, (Object)"0");
        } else if (HttpHeaderNames.TRANSFER_ENCODING.contentEquals(headerName)) {
            response.headers().set(headerName, (Object)HttpHeaderValues.CHUNKED);
        }
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{response}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        ByteBuf buffer = (ByteBuf)channel.readOutbound();
        StringBuilder responseText = new StringBuilder();
        responseText.append(HttpVersion.HTTP_1_1.toString()).append(' ').append(status.toString()).append("\r\n");
        if (!headerStripped && headerName != null) {
            responseText.append(headerName).append(": ");
            if (HttpHeaderNames.CONTENT_LENGTH.contentEquals(headerName)) {
                responseText.append('0');
            } else {
                responseText.append(HttpHeaderValues.CHUNKED.toString());
            }
            responseText.append("\r\n");
        }
        responseText.append("\r\n");
        Assert.assertEquals((Object)responseText.toString(), (Object)buffer.toString(CharsetUtil.US_ASCII));
        buffer.release();
        buffer = (ByteBuf)channel.readOutbound();
        buffer.release();
    }

    @Test
    public void testEmptyContentsChunked() throws Exception {
        this.testEmptyContents(true, false);
    }

    @Test
    public void testEmptyContentsChunkedWithTrailers() throws Exception {
        this.testEmptyContents(true, true);
    }

    @Test
    public void testEmptyContentsNotChunked() throws Exception {
        this.testEmptyContents(false, false);
    }

    @Test
    public void testEmptyContentNotsChunkedWithTrailers() throws Exception {
        this.testEmptyContents(false, true);
    }

    private void testEmptyContents(boolean chunked, boolean trailers) throws Exception {
        HttpResponseEncoder encoder = new HttpResponseEncoder();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{encoder});
        DefaultHttpResponse request = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        if (chunked) {
            HttpUtil.setTransferEncodingChunked((HttpMessage)request, (boolean)true);
        }
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{request}));
        ByteBuf contentBuffer = Unpooled.buffer();
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpContent(contentBuffer)}));
        ByteBuf lastContentBuffer = Unpooled.buffer();
        DefaultLastHttpContent last = new DefaultLastHttpContent(lastContentBuffer);
        if (trailers) {
            last.trailingHeaders().set("X-Netty-Test", (Object)"true");
        }
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{last}));
        ByteBuf head = (ByteBuf)channel.readOutbound();
        Assert.assertTrue((boolean)head.release());
        ByteBuf content = (ByteBuf)channel.readOutbound();
        content.release();
        ByteBuf lastContent = (ByteBuf)channel.readOutbound();
        lastContent.release();
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testStatusResetContentTransferContentLength() {
        HttpResponseEncoderTest.testStatusResetContentTransferContentLength0((CharSequence)HttpHeaderNames.CONTENT_LENGTH, Unpooled.buffer().writeLong(8L));
    }

    @Test
    public void testStatusResetContentTransferEncoding() {
        HttpResponseEncoderTest.testStatusResetContentTransferContentLength0((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, Unpooled.buffer().writeLong(8L));
    }

    private static void testStatusResetContentTransferContentLength0(CharSequence headerName, ByteBuf content) {
        ByteBuf buffer;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new HttpResponseEncoder()});
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.RESET_CONTENT);
        if (HttpHeaderNames.CONTENT_LENGTH.contentEqualsIgnoreCase(headerName)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{response}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{new DefaultHttpContent(content)}));
        Assert.assertTrue((boolean)channel.writeOutbound(new Object[]{LastHttpContent.EMPTY_LAST_CONTENT}));
        StringBuilder responseText = new StringBuilder();
        responseText.append(HttpVersion.HTTP_1_1.toString()).append(' ').append(HttpResponseStatus.RESET_CONTENT.toString()).append("\r\n");
        responseText.append((CharSequence)HttpHeaderNames.CONTENT_LENGTH).append(": 0\r\n");
        responseText.append("\r\n");
        StringBuilder written = new StringBuilder();
        while ((buffer = (ByteBuf)channel.readOutbound()) != null) {
            written.append(buffer.toString(CharsetUtil.US_ASCII));
            buffer.release();
        }
        Assert.assertEquals((Object)responseText.toString(), (Object)written.toString());
        Assert.assertFalse((boolean)channel.finish());
    }

    private static class DummyLongFileRegion
    implements FileRegion {
        private DummyLongFileRegion() {
        }

        public long position() {
            return 0L;
        }

        public long transfered() {
            return 0L;
        }

        public long transferred() {
            return 0L;
        }

        public long count() {
            return 0x80000000L;
        }

        public long transferTo(WritableByteChannel target, long position) throws IOException {
            throw new UnsupportedOperationException();
        }

        public FileRegion touch(Object hint) {
            return this;
        }

        public FileRegion touch() {
            return this;
        }

        public FileRegion retain() {
            return this;
        }

        public FileRegion retain(int increment) {
            return this;
        }

        public int refCnt() {
            return 1;
        }

        public boolean release() {
            return false;
        }

        public boolean release(int decrement) {
            return false;
        }
    }
}

