/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeadersTestUtils;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class HttpUtilTest {
    @Test
    public void testRemoveTransferEncodingIgnoreCase() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"Chunked");
        Assert.assertFalse((boolean)message.headers().isEmpty());
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)false);
        Assert.assertTrue((boolean)message.headers().isEmpty());
    }

    @Test
    public void testGetOperations() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders();
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("1"));
        headers.add(HttpHeadersTestUtils.of("Foo"), (Object)HttpHeadersTestUtils.of("2"));
        Assert.assertEquals((Object)"1", (Object)headers.get(HttpHeadersTestUtils.of("Foo")));
        List values = headers.getAll(HttpHeadersTestUtils.of("Foo"));
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)"1", values.get(0));
        Assert.assertEquals((Object)"2", values.get(1));
    }

    @Test
    public void testGetCharsetAsRawCharSequence() {
        String QUOTES_CHARSET_CONTENT_TYPE = "text/html; charset=\"utf8\"";
        String SIMPLE_CONTENT_TYPE = "text/html";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)QUOTES_CHARSET_CONTENT_TYPE);
        Assert.assertEquals((Object)"\"utf8\"", (Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assert.assertEquals((Object)"\"utf8\"", (Object)HttpUtil.getCharsetAsSequence((CharSequence)QUOTES_CHARSET_CONTENT_TYPE));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assert.assertNull((Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assert.assertNull((Object)HttpUtil.getCharsetAsSequence((CharSequence)SIMPLE_CONTENT_TYPE));
    }

    @Test
    public void testGetCharset() {
        String NORMAL_CONTENT_TYPE = "text/html; charset=utf-8";
        String UPPER_CASE_NORMAL_CONTENT_TYPE = "TEXT/HTML; CHARSET=UTF-8";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)NORMAL_CONTENT_TYPE);
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)NORMAL_CONTENT_TYPE));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)UPPER_CASE_NORMAL_CONTENT_TYPE);
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)UPPER_CASE_NORMAL_CONTENT_TYPE));
    }

    @Test
    public void testGetCharsetIfNotLastParameter() {
        String NORMAL_CONTENT_TYPE_WITH_PARAMETERS = "application/soap-xml; charset=utf-8; action=\"http://www.soap-service.by/foo/add\"";
        DefaultHttpRequest message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "http://localhost:7788/foo");
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)NORMAL_CONTENT_TYPE_WITH_PARAMETERS);
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)NORMAL_CONTENT_TYPE_WITH_PARAMETERS));
        Assert.assertEquals((Object)"utf-8", (Object)HttpUtil.getCharsetAsSequence((HttpMessage)message));
        Assert.assertEquals((Object)"utf-8", (Object)HttpUtil.getCharsetAsSequence((CharSequence)NORMAL_CONTENT_TYPE_WITH_PARAMETERS));
    }

    @Test
    public void testGetCharset_defaultValue() {
        String SIMPLE_CONTENT_TYPE = "text/html";
        String CONTENT_TYPE_WITH_INCORRECT_CHARSET = "text/html; charset=UTFFF";
        String CONTENT_TYPE_WITH_ILLEGAL_CHARSET_NAME = "text/html; charset=!illegal!";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html", (Charset)StandardCharsets.UTF_8));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTFFF");
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=UTFFF"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=UTFFF");
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=UTFFF", (Charset)StandardCharsets.UTF_8));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=!illegal!");
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((HttpMessage)message));
        Assert.assertEquals((Object)CharsetUtil.ISO_8859_1, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=!illegal!"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=!illegal!");
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((HttpMessage)message, (Charset)StandardCharsets.UTF_8));
        Assert.assertEquals((Object)CharsetUtil.UTF_8, (Object)HttpUtil.getCharset((CharSequence)"text/html; charset=!illegal!", (Charset)StandardCharsets.UTF_8));
    }

    @Test
    public void testGetMimeType() {
        String SIMPLE_CONTENT_TYPE = "text/html";
        String NORMAL_CONTENT_TYPE = "text/html; charset=utf-8";
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        Assert.assertNull((Object)HttpUtil.getMimeType((HttpMessage)message));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"");
        Assert.assertNull((Object)HttpUtil.getMimeType((HttpMessage)message));
        Assert.assertNull((Object)HttpUtil.getMimeType((CharSequence)""));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html");
        Assert.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((HttpMessage)message));
        Assert.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((CharSequence)"text/html"));
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
        Assert.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((HttpMessage)message));
        Assert.assertEquals((Object)"text/html", (Object)HttpUtil.getMimeType((CharSequence)"text/html; charset=utf-8"));
    }

    @Test
    public void testGetContentLengthThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContentLengthIntDefaultValueThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message, (int)1);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testGetContentLengthLongDefaultValueThrowsNumberFormatException() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"bar");
        try {
            HttpUtil.getContentLength((HttpMessage)message, (long)1L);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testDoubleChunkedHeader() {
        DefaultHttpResponse message = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)"chunked");
        HttpUtil.setTransferEncodingChunked((HttpMessage)message, (boolean)true);
        List<String> expected = Collections.singletonList("chunked");
        Assert.assertEquals(expected, (Object)message.headers().getAll((CharSequence)HttpHeaderNames.TRANSFER_ENCODING));
    }

    private static List<String> allPossibleCasesOfContinue() {
        ArrayList<String> cases = new ArrayList<String>();
        String c = "continue";
        int i = 0;
        while ((double)i < Math.pow(2.0, "continue".length())) {
            StringBuilder sb = new StringBuilder("continue".length());
            int k = 0;
            for (int j = i; j > 0; j >>= 1) {
                if ((j & 1) == 1) {
                    sb.append(Character.toUpperCase("continue".charAt(k++)));
                    continue;
                }
                sb.append("continue".charAt(k++));
            }
            while (k < "continue".length()) {
                sb.append("continue".charAt(k));
                ++k;
            }
            cases.add(sb.toString());
            ++i;
        }
        return cases;
    }

    @Test
    public void testIs100Continue() {
        for (String continueCase : HttpUtilTest.allPossibleCasesOfContinue()) {
            HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, "100-" + continueCase, true);
        }
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, null, false);
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_1, "chocolate=yummy", false);
        HttpUtilTest.run100ContinueTest(HttpVersion.HTTP_1_0, "100-continue", false);
        DefaultFullHttpResponse message = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)"100-continue");
        HttpUtilTest.run100ContinueTest((HttpMessage)message, false);
    }

    private static void run100ContinueTest(HttpVersion version, String expectations, boolean expect) {
        DefaultFullHttpRequest message = new DefaultFullHttpRequest(version, HttpMethod.GET, "/");
        if (expectations != null) {
            message.headers().set((CharSequence)HttpHeaderNames.EXPECT, (Object)expectations);
        }
        HttpUtilTest.run100ContinueTest((HttpMessage)message, expect);
    }

    private static void run100ContinueTest(HttpMessage message, boolean expected) {
        Assert.assertEquals((Object)expected, (Object)HttpUtil.is100ContinueExpected((HttpMessage)message));
        ReferenceCountUtil.release((Object)message);
    }

    @Test
    public void testContainsUnsupportedExpectation() {
        for (String continueCase : HttpUtilTest.allPossibleCasesOfContinue()) {
            HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, "100-" + continueCase, false);
        }
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, null, false);
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_1, "chocolate=yummy", true);
        HttpUtilTest.runUnsupportedExpectationTest(HttpVersion.HTTP_1_0, "100-continue", false);
        DefaultFullHttpResponse message = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        message.headers().set("Expect", (Object)"100-continue");
        HttpUtilTest.runUnsupportedExpectationTest((HttpMessage)message, false);
    }

    private static void runUnsupportedExpectationTest(HttpVersion version, String expectations, boolean expect) {
        DefaultFullHttpRequest message = new DefaultFullHttpRequest(version, HttpMethod.GET, "/");
        if (expectations != null) {
            message.headers().set("Expect", (Object)expectations);
        }
        HttpUtilTest.runUnsupportedExpectationTest((HttpMessage)message, expect);
    }

    private static void runUnsupportedExpectationTest(HttpMessage message, boolean expected) {
        Assert.assertEquals((Object)expected, (Object)HttpUtil.isUnsupportedExpectation((HttpMessage)message));
        ReferenceCountUtil.release((Object)message);
    }

    @Test
    public void testFormatHostnameForHttpFromResolvedAddressWithHostname() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("localhost"), 8080);
        Assert.assertEquals((Object)"localhost", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testFormatHostnameForHttpFromUnesolvedAddressWithHostname() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("localhost", 80);
        Assert.assertEquals((Object)"localhost", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv6() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("::1"), 8080);
        Assert.assertEquals((Object)"[::1]", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv6Unresolved() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("::1", 8080);
        Assert.assertEquals((Object)"[::1]", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv4() throws Exception {
        InetSocketAddress socketAddress = new InetSocketAddress(InetAddress.getByName("10.0.0.1"), 8080);
        Assert.assertEquals((Object)"10.0.0.1", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testIpv4Unresolved() {
        InetSocketAddress socketAddress = InetSocketAddress.createUnresolved("10.0.0.1", 8080);
        Assert.assertEquals((Object)"10.0.0.1", (Object)HttpUtil.formatHostnameForHttp((InetSocketAddress)socketAddress));
    }

    @Test
    public void testKeepAliveIfConnectionHeaderAbsent() {
        DefaultHttpRequest http11Message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http:localhost/http_1_1");
        Assert.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        DefaultHttpRequest http10Message = new DefaultHttpRequest(HttpVersion.HTTP_1_0, HttpMethod.GET, "http:localhost/http_1_0");
        Assert.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http10Message));
    }

    @Test
    public void testKeepAliveIfConnectionHeaderMultipleValues() {
        DefaultHttpRequest http11Message = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "http:localhost/http_1_1");
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", " + HttpHeaderValues.CLOSE));
        Assert.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", Close"));
        Assert.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.CLOSE + ", " + HttpHeaderValues.UPGRADE));
        Assert.assertFalse((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
        http11Message.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)(HttpHeaderValues.UPGRADE + ", " + HttpHeaderValues.KEEP_ALIVE));
        Assert.assertTrue((boolean)HttpUtil.isKeepAlive((HttpMessage)http11Message));
    }
}

