/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.rtsp;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.rtsp.RtspEncoder;
import io.netty.handler.codec.rtsp.RtspHeaderNames;
import io.netty.handler.codec.rtsp.RtspMethods;
import io.netty.handler.codec.rtsp.RtspResponseStatuses;
import io.netty.handler.codec.rtsp.RtspVersions;
import io.netty.util.CharsetUtil;
import org.junit.Assert;
import org.junit.Test;

public class RtspEncoderTest {
    @Test
    public void testSendSetupRequest() {
        String expected = "SETUP rtsp://172.10.20.30:554/d3abaaa7-65f2-42b4-8d6b-379f492fcf0f RTSP/1.0\r\ntransport: MP2T/DVBC/UDP;unicast;client=01234567;source=172.10.20.30;destination=1.1.1.1;client_port=6922\r\ncseq: 1\r\n\r\n";
        DefaultHttpRequest request = new DefaultHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.SETUP, "rtsp://172.10.20.30:554/d3abaaa7-65f2-42b4-8d6b-379f492fcf0f");
        request.headers().add((CharSequence)RtspHeaderNames.TRANSPORT, (Object)"MP2T/DVBC/UDP;unicast;client=01234567;source=172.10.20.30;destination=1.1.1.1;client_port=6922");
        request.headers().add((CharSequence)RtspHeaderNames.CSEQ, (Object)"1");
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new RtspEncoder()});
        ch.writeOutbound(new Object[]{request});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        String actual = buf.toString(CharsetUtil.UTF_8);
        buf.release();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSendGetParameterRequest() {
        String expected = "GET_PARAMETER rtsp://172.10.20.30:554 RTSP/1.0\r\nsession: 2547019973447939919\r\ncseq: 3\r\ncontent-length: 31\r\ncontent-type: text/parameters\r\n\r\nstream_state\r\nposition\r\nscale\r\n";
        byte[] content = "stream_state\r\nposition\r\nscale\r\n".getBytes(CharsetUtil.UTF_8);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(RtspVersions.RTSP_1_0, RtspMethods.GET_PARAMETER, "rtsp://172.10.20.30:554");
        request.headers().add((CharSequence)RtspHeaderNames.SESSION, (Object)"2547019973447939919");
        request.headers().add((CharSequence)RtspHeaderNames.CSEQ, (Object)"3");
        request.headers().add((CharSequence)RtspHeaderNames.CONTENT_LENGTH, (Object)("" + content.length));
        request.headers().add((CharSequence)RtspHeaderNames.CONTENT_TYPE, (Object)"text/parameters");
        request.content().writeBytes(content);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new RtspEncoder()});
        ch.writeOutbound(new Object[]{request});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        String actual = buf.toString(CharsetUtil.UTF_8);
        buf.release();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSend200OkResponseWithoutBody() {
        String expected = "RTSP/1.0 200 OK\r\nserver: Testserver\r\ncseq: 1\r\nsession: 2547019973447939919\r\n\r\n";
        DefaultHttpResponse response = new DefaultHttpResponse(RtspVersions.RTSP_1_0, RtspResponseStatuses.OK);
        response.headers().add((CharSequence)RtspHeaderNames.SERVER, (Object)"Testserver");
        response.headers().add((CharSequence)RtspHeaderNames.CSEQ, (Object)"1");
        response.headers().add((CharSequence)RtspHeaderNames.SESSION, (Object)"2547019973447939919");
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new RtspEncoder()});
        ch.writeOutbound(new Object[]{response});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        String actual = buf.toString(CharsetUtil.UTF_8);
        buf.release();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testSend200OkResponseWithBody() {
        String expected = "RTSP/1.0 200 OK\r\nserver: Testserver\r\nsession: 2547019973447939919\r\ncontent-type: text/parameters\r\ncontent-length: 50\r\ncseq: 3\r\n\r\nposition: 24\r\nstream_state: playing\r\nscale: 1.00\r\n";
        byte[] content = "position: 24\r\nstream_state: playing\r\nscale: 1.00\r\n".getBytes(CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(RtspVersions.RTSP_1_0, RtspResponseStatuses.OK);
        response.headers().add((CharSequence)RtspHeaderNames.SERVER, (Object)"Testserver");
        response.headers().add((CharSequence)RtspHeaderNames.SESSION, (Object)"2547019973447939919");
        response.headers().add((CharSequence)RtspHeaderNames.CONTENT_TYPE, (Object)"text/parameters");
        response.headers().add((CharSequence)RtspHeaderNames.CONTENT_LENGTH, (Object)("" + content.length));
        response.headers().add((CharSequence)RtspHeaderNames.CSEQ, (Object)"3");
        response.content().writeBytes(content);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new RtspEncoder()});
        ch.writeOutbound(new Object[]{response});
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        String actual = buf.toString(CharsetUtil.UTF_8);
        buf.release();
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

