/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.EmptyArrays;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketUtilTest {
    private static final int NUM_ITERATIONS = 1000;

    private static void assertRandomWithinBoundaries(int min, int max) {
        int r = WebSocketUtil.randomNumber((int)min, (int)max);
        Assert.assertTrue((min <= r && r <= max ? 1 : 0) != 0);
    }

    @Test
    public void testRandomNumberGenerator() {
        int iteration = 0;
        while (++iteration < 1000) {
            WebSocketUtilTest.assertRandomWithinBoundaries(0, 1);
            WebSocketUtilTest.assertRandomWithinBoundaries(0, 1);
            WebSocketUtilTest.assertRandomWithinBoundaries(-1, 1);
            WebSocketUtilTest.assertRandomWithinBoundaries(-1, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBase64() {
        String base64 = WebSocketUtil.base64((byte[])EmptyArrays.EMPTY_BYTES);
        Assert.assertNotNull((Object)base64);
        Assert.assertTrue((boolean)base64.isEmpty());
        base64 = WebSocketUtil.base64((byte[])"foo".getBytes(CharsetUtil.UTF_8));
        Assert.assertEquals((Object)base64, (Object)"Zm9v");
        base64 = WebSocketUtil.base64((byte[])"bar".getBytes(CharsetUtil.UTF_8));
        ByteBuf src = Unpooled.wrappedBuffer((byte[])base64.getBytes(CharsetUtil.UTF_8));
        try {
            ByteBuf dst = Base64.decode((ByteBuf)src);
            try {
                Assert.assertEquals((Object)new String(ByteBufUtil.getBytes((ByteBuf)dst), CharsetUtil.UTF_8), (Object)"bar");
            }
            finally {
                dst.release();
            }
        }
        finally {
            src.release();
        }
    }
}

