/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpResponseDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketUtil;
import io.netty.util.CharsetUtil;
import java.net.URI;
import org.junit.Assert;
import org.junit.Test;

public abstract class WebSocketClientHandshakerTest {
    protected abstract WebSocketClientHandshaker newHandshaker(URI var1, String var2, HttpHeaders var3, boolean var4);

    protected WebSocketClientHandshaker newHandshaker(URI uri) {
        return this.newHandshaker(uri, null, null, false);
    }

    protected abstract CharSequence getOriginHeaderName();

    protected abstract CharSequence getProtocolHeaderName();

    protected abstract CharSequence[] getHandshakeRequiredHeaderNames();

    @Test
    public void hostHeaderWs() {
        for (String scheme : new String[]{"ws://", "http://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "Netty.io"}) {
                String enter = scheme + host;
                this.testHostHeader(enter, host);
                this.testHostHeader(enter + '/', host);
                this.testHostHeader(enter + ":80", host);
                this.testHostHeader(enter + ":443", host + ":443");
                this.testHostHeader(enter + ":9999", host + ":9999");
                this.testHostHeader(enter + "/path", host);
                this.testHostHeader(enter + ":80/path", host);
                this.testHostHeader(enter + ":443/path", host + ":443");
                this.testHostHeader(enter + ":9999/path", host + ":9999");
            }
        }
    }

    @Test
    public void hostHeaderWss() {
        for (String scheme : new String[]{"wss://", "https://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "Netty.io"}) {
                String enter = scheme + host;
                this.testHostHeader(enter, host);
                this.testHostHeader(enter + '/', host);
                this.testHostHeader(enter + ":80", host + ":80");
                this.testHostHeader(enter + ":443", host);
                this.testHostHeader(enter + ":9999", host + ":9999");
                this.testHostHeader(enter + "/path", host);
                this.testHostHeader(enter + ":80/path", host + ":80");
                this.testHostHeader(enter + ":443/path", host);
                this.testHostHeader(enter + ":9999/path", host + ":9999");
            }
        }
    }

    @Test
    public void hostHeaderWithoutScheme() {
        this.testHostHeader("//localhost/", "localhost");
        this.testHostHeader("//localhost/path", "localhost");
        this.testHostHeader("//localhost:80/", "localhost:80");
        this.testHostHeader("//localhost:443/", "localhost:443");
        this.testHostHeader("//localhost:9999/", "localhost:9999");
    }

    @Test
    public void originHeaderWs() {
        for (String scheme : new String[]{"ws://", "http://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "NETTY.IO"}) {
                String enter = scheme + host;
                String expect = "http://" + host.toLowerCase();
                this.testOriginHeader(enter, expect);
                this.testOriginHeader(enter + '/', expect);
                this.testOriginHeader(enter + ":80", expect);
                this.testOriginHeader(enter + ":443", expect + ":443");
                this.testOriginHeader(enter + ":9999", expect + ":9999");
                this.testOriginHeader(enter + "/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":80/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":443/path%20with%20ws", expect + ":443");
                this.testOriginHeader(enter + ":9999/path%20with%20ws", expect + ":9999");
            }
        }
    }

    @Test
    public void originHeaderWss() {
        for (String scheme : new String[]{"wss://", "https://"}) {
            for (String host : new String[]{"localhost", "127.0.0.1", "[::1]", "NETTY.IO"}) {
                String enter = scheme + host;
                String expect = "https://" + host.toLowerCase();
                this.testOriginHeader(enter, expect);
                this.testOriginHeader(enter + '/', expect);
                this.testOriginHeader(enter + ":80", expect + ":80");
                this.testOriginHeader(enter + ":443", expect);
                this.testOriginHeader(enter + ":9999", expect + ":9999");
                this.testOriginHeader(enter + "/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":80/path%20with%20ws", expect + ":80");
                this.testOriginHeader(enter + ":443/path%20with%20ws", expect);
                this.testOriginHeader(enter + ":9999/path%20with%20ws", expect + ":9999");
            }
        }
    }

    @Test
    public void originHeaderWithoutScheme() {
        this.testOriginHeader("//localhost/", "http://localhost");
        this.testOriginHeader("//localhost/path", "http://localhost");
        this.testOriginHeader("//localhost:80/", "http://localhost");
        this.testOriginHeader("//localhost:80/path", "http://localhost");
        this.testOriginHeader("//localhost:443/", "https://localhost");
        this.testOriginHeader("//localhost:443/path", "https://localhost");
        this.testOriginHeader("//localhost:9999/", "http://localhost:9999");
        this.testOriginHeader("//localhost:9999/path", "http://localhost:9999");
        this.testOriginHeader("//LOCALHOST/", "http://localhost");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetOriginFromCustomHeaders() {
        HttpHeaders customHeaders = new DefaultHttpHeaders().set(this.getOriginHeaderName(), (Object)"http://example.com");
        WebSocketClientHandshaker handshaker = this.newHandshaker(URI.create("ws://server.example.com/chat"), null, customHeaders, false);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"http://example.com", (Object)request.headers().get(this.getOriginHeaderName()));
        }
        finally {
            request.release();
        }
    }

    private void testHostHeader(String uri, String expected) {
        this.testHeaderDefaultHttp(uri, (CharSequence)HttpHeaderNames.HOST, expected);
    }

    private void testOriginHeader(String uri, String expected) {
        this.testHeaderDefaultHttp(uri, this.getOriginHeaderName(), expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testHeaderDefaultHttp(String uri, CharSequence header, String expectedValue) {
        WebSocketClientHandshaker handshaker = this.newHandshaker(URI.create(uri));
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)expectedValue, (Object)request.headers().get(header));
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrl() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"/path%20with%20ws", (Object)request.getUri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithQuery() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"/path%20with%20ws?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithoutPath() {
        URI uri = URI.create("ws://localhost:9999");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"/", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUpgradeUrlWithoutPathWithQuery() {
        URI uri = URI.create("ws://localhost:9999?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"/?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbsoluteUpgradeUrlWithQuery() {
        URI uri = URI.create("ws://localhost:9999/path%20with%20ws?a=b%20c");
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, null, null, true);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        try {
            Assert.assertEquals((Object)"ws://localhost:9999/path%20with%20ws?a=b%20c", (Object)request.uri());
        }
        finally {
            request.release();
        }
    }

    @Test(timeout=3000L)
    public void testHttpResponseAndFrameInSameBuffer() {
        this.testHttpResponseAndFrameInSameBuffer(false);
    }

    @Test(timeout=3000L)
    public void testHttpResponseAndFrameInSameBufferCodec() {
        this.testHttpResponseAndFrameInSameBuffer(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHttpResponseAndFrameInSameBuffer(boolean codec) {
        ByteBuf buf;
        ByteBuf frameBytes;
        String url = "ws://localhost:9999/ws";
        final WebSocketClientHandshaker shaker = this.newHandshaker(URI.create(url));
        final WebSocketClientHandshaker handshaker = new WebSocketClientHandshaker(shaker.uri(), shaker.version(), null, (HttpHeaders)EmptyHttpHeaders.INSTANCE, Integer.MAX_VALUE, -1L){

            protected FullHttpRequest newHandshakeRequest() {
                return shaker.newHandshakeRequest();
            }

            protected void verify(FullHttpResponse response) {
            }

            protected WebSocketFrameDecoder newWebsocketDecoder() {
                return shaker.newWebsocketDecoder();
            }

            protected WebSocketFrameEncoder newWebSocketEncoder() {
                return shaker.newWebSocketEncoder();
            }
        };
        byte[] data = WebSocketUtil.randomBytes((int)24);
        WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(url, null, false);
        FullHttpRequest request = shaker.newHandshakeRequest();
        WebSocketServerHandshaker socketServerHandshaker = factory.newHandshaker((HttpRequest)request);
        request.release();
        EmbeddedChannel websocketChannel = new EmbeddedChannel(new ChannelHandler[]{socketServerHandshaker.newWebSocketEncoder(), socketServerHandshaker.newWebsocketDecoder()});
        Assert.assertTrue((boolean)websocketChannel.writeOutbound(new Object[]{new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])data))}));
        byte[] bytes = "HTTP/1.1 101 Switching Protocols\r\nContent-Length: 0\r\n\r\n".getBytes(CharsetUtil.US_ASCII);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer();
        compositeByteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])bytes));
        while ((frameBytes = (ByteBuf)websocketChannel.readOutbound()) != null) {
            compositeByteBuf.addComponent(true, frameBytes);
        }
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE), new SimpleChannelInboundHandler<FullHttpResponse>(){

            protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                handshaker.finishHandshake(ctx.channel(), msg);
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }});
        if (codec) {
            ch.pipeline().addFirst(new ChannelHandler[]{new HttpClientCodec()});
        } else {
            ch.pipeline().addFirst(new ChannelHandler[]{new HttpRequestEncoder(), new HttpResponseDecoder()});
        }
        shaker.handshake((Channel)ch).syncUninterruptibly();
        while ((buf = (ByteBuf)ch.readOutbound()) != null) {
            buf.release();
        }
        Assert.assertTrue((boolean)ch.writeInbound(new Object[]{compositeByteBuf}));
        Assert.assertTrue((boolean)ch.finish());
        BinaryWebSocketFrame frame = (BinaryWebSocketFrame)ch.readInbound();
        ByteBuf expect = Unpooled.wrappedBuffer((byte[])data);
        try {
            Assert.assertEquals((Object)expect, (Object)frame.content());
            Assert.assertTrue((boolean)frame.isFinalFragment());
            Assert.assertEquals((long)0L, (long)frame.rsv());
        }
        finally {
            expect.release();
            frame.release();
        }
    }

    @Test
    public void testDuplicateWebsocketHandshakeHeaders() {
        URI uri = URI.create("ws://localhost:9999/foo");
        DefaultHttpHeaders inputHeaders = new DefaultHttpHeaders();
        String bogusSubProtocol = "bogusSubProtocol";
        String bogusHeaderValue = "bogusHeaderValue";
        for (CharSequence header : this.getHandshakeRequiredHeaderNames()) {
            if (HttpHeaderNames.HOST.equals((Object)header)) continue;
            inputHeaders.add(header, (Object)bogusHeaderValue);
        }
        inputHeaders.add(this.getProtocolHeaderName(), (Object)bogusSubProtocol);
        String realSubProtocol = "realSubProtocol";
        WebSocketClientHandshaker handshaker = this.newHandshaker(uri, realSubProtocol, (HttpHeaders)inputHeaders, false);
        FullHttpRequest request = handshaker.newHandshakeRequest();
        HttpHeaders outputHeaders = request.headers();
        for (CharSequence header : this.getHandshakeRequiredHeaderNames()) {
            Assert.assertEquals((long)1L, (long)outputHeaders.getAll(header).size());
            Assert.assertNotEquals((Object)bogusHeaderValue, (Object)outputHeaders.get(header));
        }
        Assert.assertEquals((long)1L, (long)outputHeaders.getAll(this.getProtocolHeaderName()).size());
        Assert.assertEquals((Object)realSubProtocol, (Object)outputHeaders.get(this.getProtocolHeaderName()));
        request.release();
    }
}

