/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.multipart;

import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class DiskFileUploadTest {
    @Test
    public final void testDiskFileUploadEquals() {
        DiskFileUpload f2 = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        Assert.assertEquals((Object)f2, (Object)f2);
        f2.delete();
    }

    @Test
    public void testEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testEmptyBufferSetAfterNonEmptyBuffer() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)0L, (long)f.getFile().length());
        f.delete();
    }

    @Test
    public void testNonEmptyBufferSetMultipleTimes() throws IOException {
        DiskFileUpload f = new DiskFileUpload("d1", "d1", "application/json", null, null, 100L);
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)4L, (long)f.getFile().length());
        f.setContent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assert.assertTrue((boolean)f.getFile().exists());
        Assert.assertEquals((long)2L, (long)f.getFile().length());
        f.delete();
    }
}

