/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx.extensions;

import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilter;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketExtensionFilterTest {
    @Test
    public void testNeverSkip() {
        WebSocketExtensionFilter neverSkip = WebSocketExtensionFilter.NEVER_SKIP;
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)binaryFrame));
        Assert.assertTrue((boolean)binaryFrame.release());
        TextWebSocketFrame textFrame = new TextWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)textFrame));
        Assert.assertTrue((boolean)textFrame.release());
        PingWebSocketFrame pingFrame = new PingWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)pingFrame));
        Assert.assertTrue((boolean)pingFrame.release());
        PongWebSocketFrame pongFrame = new PongWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)pongFrame));
        Assert.assertTrue((boolean)pongFrame.release());
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)closeFrame));
        Assert.assertTrue((boolean)closeFrame.release());
        ContinuationWebSocketFrame continuationFrame = new ContinuationWebSocketFrame();
        Assert.assertFalse((boolean)neverSkip.mustSkip((WebSocketFrame)continuationFrame));
        Assert.assertTrue((boolean)continuationFrame.release());
    }

    @Test
    public void testAlwaysSkip() {
        WebSocketExtensionFilter neverSkip = WebSocketExtensionFilter.ALWAYS_SKIP;
        BinaryWebSocketFrame binaryFrame = new BinaryWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)binaryFrame));
        Assert.assertTrue((boolean)binaryFrame.release());
        TextWebSocketFrame textFrame = new TextWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)textFrame));
        Assert.assertTrue((boolean)textFrame.release());
        PingWebSocketFrame pingFrame = new PingWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)pingFrame));
        Assert.assertTrue((boolean)pingFrame.release());
        PongWebSocketFrame pongFrame = new PongWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)pongFrame));
        Assert.assertTrue((boolean)pongFrame.release());
        CloseWebSocketFrame closeFrame = new CloseWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)closeFrame));
        Assert.assertTrue((boolean)closeFrame.release());
        ContinuationWebSocketFrame continuationFrame = new ContinuationWebSocketFrame();
        Assert.assertTrue((boolean)neverSkip.mustSkip((WebSocketFrame)continuationFrame));
        Assert.assertTrue((boolean)continuationFrame.release());
    }
}

