/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.Utf8FrameValidator;
import org.junit.Assert;
import org.junit.Test;

public class WebSocketUtf8FrameValidatorTest {
    @Test
    public void testCorruptedFrameExceptionInFinish() {
        this.assertCorruptedFrameExceptionHandling(new byte[]{-50});
    }

    @Test
    public void testCorruptedFrameExceptionInCheck() {
        this.assertCorruptedFrameExceptionHandling(new byte[]{-8, -120, -128, -128, -128});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertCorruptedFrameExceptionHandling(byte[] data) {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new Utf8FrameValidator()});
        try {
            channel.writeInbound(new Object[]{new TextWebSocketFrame(Unpooled.copiedBuffer((byte[])data))});
            Assert.fail();
        }
        catch (CorruptedFrameException corruptedFrameException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)channel.finish());
        ByteBuf buf = (ByteBuf)channel.readOutbound();
        Assert.assertNotNull((Object)buf);
        try {
            Assert.assertFalse((boolean)buf.isReadable());
        }
        finally {
            buf.release();
        }
        Assert.assertNull((Object)channel.readOutbound());
    }
}

