/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http.websocketx;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;

@ChannelHandler.Sharable
public class WebSocket00FrameEncoder
extends MessageToByteEncoder<WebSocketFrame> {
    protected void encode(ChannelHandlerContext ctx, WebSocketFrame msg, ByteBuf out) throws Exception {
        if (msg instanceof TextWebSocketFrame) {
            ByteBuf data = msg.content();
            out.writeByte(0);
            out.writeBytes(data, data.readerIndex(), data.readableBytes());
            out.writeByte(-1);
        } else if (msg instanceof CloseWebSocketFrame) {
            out.writeByte(-1);
            out.writeByte(0);
        } else {
            ByteBuf data = msg.content();
            int dataLen = data.readableBytes();
            out.ensureWritable(dataLen + 5);
            out.writeByte(-128);
            int b1 = dataLen >>> 28 & 0x7F;
            int b2 = dataLen >>> 14 & 0x7F;
            int b3 = dataLen >>> 7 & 0x7F;
            int b4 = dataLen & 0x7F;
            if (b1 == 0) {
                if (b2 == 0) {
                    if (b3 == 0) {
                        out.writeByte(b4);
                    } else {
                        out.writeByte(b3 | 0x80);
                        out.writeByte(b4);
                    }
                } else {
                    out.writeByte(b2 | 0x80);
                    out.writeByte(b3 | 0x80);
                    out.writeByte(b4);
                }
            } else {
                out.writeByte(b1 | 0x80);
                out.writeByte(b2 | 0x80);
                out.writeByte(b3 | 0x80);
                out.writeByte(b4);
            }
            out.writeBytes(data, data.readerIndex(), dataLen);
        }
    }
}

