/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.spdy.SpdyCodecUtil;
import io.netty.handler.codec.spdy.SpdyHeaderBlockDecompressor;
import io.netty.handler.codec.spdy.SpdyProtocolException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class SpdyHeaderBlockZlibDecompressor
extends SpdyHeaderBlockDecompressor {
    private final int version;
    private final byte[] out = new byte[8192];
    private final Inflater decompressor = new Inflater();

    public SpdyHeaderBlockZlibDecompressor(int version) {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("unsupported version: " + version);
        }
        this.version = version;
    }

    @Override
    public void setInput(ByteBuf compressed) {
        byte[] in = new byte[compressed.readableBytes()];
        compressed.readBytes(in);
        this.decompressor.setInput(in);
    }

    @Override
    public void decode(ByteBuf decompressed) throws Exception {
        try {
            int numBytes = this.decompressor.inflate(this.out);
            if (numBytes == 0 && this.decompressor.needsDictionary()) {
                if (this.version < 3) {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY2_DICT);
                } else {
                    this.decompressor.setDictionary(SpdyCodecUtil.SPDY_DICT);
                }
                numBytes = this.decompressor.inflate(this.out);
            }
            decompressed.writeBytes(this.out, 0, numBytes);
        }
        catch (DataFormatException e) {
            throw new SpdyProtocolException("Received invalid header block", e);
        }
    }

    @Override
    public void end() {
        this.decompressor.end();
    }
}

