/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.spdy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.spdy.SpdyDataFrame;
import io.netty.util.internal.StringUtil;

public class DefaultSpdyDataFrame
implements SpdyDataFrame {
    private int streamId;
    private boolean last;
    private boolean compressed;
    private ByteBuf data = Unpooled.EMPTY_BUFFER;

    public DefaultSpdyDataFrame(int streamId) {
        this.setStreamId(streamId);
    }

    @Override
    public int getStreamId() {
        return this.streamId;
    }

    @Override
    public void setStreamId(int streamId) {
        if (streamId <= 0) {
            throw new IllegalArgumentException("Stream-ID must be positive: " + streamId);
        }
        this.streamId = streamId;
    }

    @Override
    public boolean isLast() {
        return this.last;
    }

    @Override
    public void setLast(boolean last) {
        this.last = last;
    }

    @Override
    @Deprecated
    public boolean isCompressed() {
        return this.compressed;
    }

    @Override
    @Deprecated
    public void setCompressed(boolean compressed) {
        this.compressed = compressed;
    }

    @Override
    public ByteBuf getData() {
        return this.data;
    }

    @Override
    public void setData(ByteBuf data) {
        if (data == null) {
            data = Unpooled.EMPTY_BUFFER;
        }
        if (data.readableBytes() > 0xFFFFFF) {
            throw new IllegalArgumentException("data payload cannot exceed 16777215 bytes");
        }
        this.data = data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getSimpleName());
        buf.append("(last: ");
        buf.append(this.isLast());
        buf.append("; compressed: ");
        buf.append(this.isCompressed());
        buf.append(')');
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Stream-ID = ");
        buf.append(this.streamId);
        buf.append(StringUtil.NEWLINE);
        buf.append("--> Size = ");
        buf.append(this.data.readableBytes());
        return buf.toString();
    }
}

