/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.haproxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyConstants;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyMessageEncoder;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.codec.haproxy.HAProxySSLTLV;
import io.netty.handler.codec.haproxy.HAProxyTLV;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;

public class HaProxyMessageEncoderTest {
    private static final int V2_HEADER_BYTES_LENGTH = 16;
    private static final int IPv4_ADDRESS_BYTES_LENGTH = 12;
    private static final int IPv6_ADDRESS_BYTES_LENGTH = 36;

    @Test
    public void testIPV4EncodeProxyV1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((Object)"PROXY TCP4 192.168.0.1 192.168.0.11 56324 443\r\n", (Object)byteBuf.toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPV6EncodeProxyV1() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", "1050:0:0:0:5:600:300c:326b", 56324, 443);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((Object)"PROXY TCP6 2001:0db8:85a3:0000:0000:8a2e:0370:7334 1050:0:0:0:5:600:300c:326b 56324 443\r\n", (Object)byteBuf.toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPv4EncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assert.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assert.assertEquals((long)2L, (long)((commandByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assert.assertEquals((long)1L, (long)((transportByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(transportByte & 0xF));
        int sourceAddrLength = byteBuf.getUnsignedShort(14);
        Assert.assertEquals((long)12L, (long)sourceAddrLength);
        byte[] sourceAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)16, (int)4);
        Assert.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 1}, (byte[])sourceAddr);
        byte[] destAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)20, (int)4);
        Assert.assertArrayEquals((byte[])new byte[]{-64, -88, 0, 11}, (byte[])destAddr);
        int sourcePort = byteBuf.getUnsignedShort(24);
        Assert.assertEquals((long)56324L, (long)sourcePort);
        int destPort = byteBuf.getUnsignedShort(26);
        Assert.assertEquals((long)443L, (long)destPort);
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testIPv6EncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, "2001:0db8:85a3:0000:0000:8a2e:0370:7334", "1050:0:0:0:5:600:300c:326b", 56324, 443);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assert.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assert.assertEquals((long)2L, (long)((commandByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assert.assertEquals((long)2L, (long)((transportByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(transportByte & 0xF));
        int sourceAddrLength = byteBuf.getUnsignedShort(14);
        Assert.assertEquals((long)36L, (long)sourceAddrLength);
        byte[] sourceAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)16, (int)16);
        Assert.assertArrayEquals((byte[])new byte[]{32, 1, 13, -72, -123, -93, 0, 0, 0, 0, -118, 46, 3, 112, 115, 52}, (byte[])sourceAddr);
        byte[] destAddr = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)32, (int)16);
        Assert.assertArrayEquals((byte[])new byte[]{16, 80, 0, 0, 0, 0, 0, 0, 0, 5, 6, 0, 48, 12, 50, 107}, (byte[])destAddr);
        int sourcePort = byteBuf.getUnsignedShort(48);
        Assert.assertEquals((long)56324L, (long)sourcePort);
        int destPort = byteBuf.getUnsignedShort(50);
        Assert.assertEquals((long)443L, (long)destPort);
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testUnixEncodeProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "/var/run/src.sock", "/var/run/dst.sock", 0, 0);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)12);
        Assert.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.getByte(12);
        Assert.assertEquals((long)2L, (long)((commandByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(commandByte & 0xF));
        byte transportByte = byteBuf.getByte(13);
        Assert.assertEquals((long)3L, (long)((transportByte & 0xF0) >> 4));
        Assert.assertEquals((long)1L, (long)(transportByte & 0xF));
        int addrLength = byteBuf.getUnsignedShort(14);
        Assert.assertEquals((long)216L, (long)addrLength);
        int srcAddrEnd = byteBuf.forEachByte(16, 108, ByteProcessor.FIND_NUL);
        Assert.assertEquals((Object)"/var/run/src.sock", (Object)byteBuf.slice(16, srcAddrEnd - 16).toString(CharsetUtil.US_ASCII));
        int dstAddrEnd = byteBuf.forEachByte(124, 108, ByteProcessor.FIND_NUL);
        Assert.assertEquals((Object)"/var/run/dst.sock", (Object)byteBuf.slice(124, dstAddrEnd - 124).toString(CharsetUtil.US_ASCII));
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testTLVEncodeProxy() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        ArrayList<HAProxyTLV> tlvs = new ArrayList<HAProxyTLV>();
        ByteBuf helloWorld = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV alpnTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_ALPN, 1, helloWorld.copy());
        tlvs.add(alpnTlv);
        ByteBuf arbitrary = Unpooled.copiedBuffer((CharSequence)"an arbitrary string", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV authorityTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_AUTHORITY, 1, arbitrary.copy());
        tlvs.add(authorityTlv);
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443, tlvs);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)byteBuf.getUnsignedShort(14), (long)(byteBuf.readableBytes() - 16));
        ByteBuf tlv = byteBuf.skipBytes(28);
        Assert.assertEquals((long)alpnTlv.typeByteValue(), (long)tlv.readByte());
        short bufLength = tlv.readShort();
        Assert.assertEquals((long)helloWorld.array().length, (long)bufLength);
        Assert.assertEquals((Object)helloWorld, (Object)tlv.readBytes((int)bufLength));
        Assert.assertEquals((long)authorityTlv.typeByteValue(), (long)tlv.readByte());
        bufLength = tlv.readShort();
        Assert.assertEquals((long)arbitrary.array().length, (long)bufLength);
        Assert.assertEquals((Object)arbitrary, (Object)tlv.readBytes((int)bufLength));
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testSslTLVEncodeProxy() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        ArrayList<HAProxyTLV> tlvs = new ArrayList<HAProxyTLV>();
        ByteBuf helloWorld = Unpooled.copiedBuffer((CharSequence)"hello world", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV alpnTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_ALPN, 1, helloWorld.copy());
        tlvs.add(alpnTlv);
        ByteBuf arbitrary = Unpooled.copiedBuffer((CharSequence)"an arbitrary string", (Charset)CharsetUtil.US_ASCII);
        HAProxyTLV authorityTlv = new HAProxyTLV(HAProxyTLV.Type.PP2_TYPE_AUTHORITY, 1, arbitrary.copy());
        tlvs.add(authorityTlv);
        ByteBuf sslContent = Unpooled.copiedBuffer((CharSequence)"some ssl content", (Charset)CharsetUtil.US_ASCII);
        HAProxySSLTLV haProxySSLTLV = new HAProxySSLTLV(1, 1, tlvs, sslContent.copy());
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, "192.168.0.1", "192.168.0.11", 56324, 443, Collections.singletonList(haProxySSLTLV));
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((long)byteBuf.getUnsignedShort(14), (long)(byteBuf.readableBytes() - 16));
        ByteBuf tlv = byteBuf.skipBytes(28);
        Assert.assertEquals((long)haProxySSLTLV.typeByteValue(), (long)tlv.readByte());
        int bufLength = tlv.readUnsignedShort();
        Assert.assertEquals((long)bufLength, (long)tlv.readableBytes());
        Assert.assertEquals((long)1L, (long)byteBuf.readByte());
        Assert.assertEquals((long)1L, (long)byteBuf.readInt());
        Assert.assertEquals((long)alpnTlv.typeByteValue(), (long)tlv.readByte());
        bufLength = tlv.readShort();
        Assert.assertEquals((long)helloWorld.array().length, (long)bufLength);
        Assert.assertEquals((Object)helloWorld, (Object)tlv.readBytes(bufLength));
        Assert.assertEquals((long)authorityTlv.typeByteValue(), (long)tlv.readByte());
        bufLength = tlv.readShort();
        Assert.assertEquals((long)arbitrary.array().length, (long)bufLength);
        Assert.assertEquals((Object)arbitrary, (Object)tlv.readBytes(bufLength));
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testEncodeLocalProxyV2() {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{HAProxyMessageEncoder.INSTANCE});
        HAProxyMessage message = new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.LOCAL, HAProxyProxiedProtocol.UNKNOWN, null, null, 0, 0);
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{message}));
        ByteBuf byteBuf = (ByteBuf)ch.readOutbound();
        byte[] headerBytes = new byte[12];
        byteBuf.readBytes(headerBytes);
        Assert.assertArrayEquals((byte[])HAProxyConstants.BINARY_PREFIX, (byte[])headerBytes);
        byte commandByte = byteBuf.readByte();
        Assert.assertEquals((long)2L, (long)((commandByte & 0xF0) >> 4));
        Assert.assertEquals((long)0L, (long)(commandByte & 0xF));
        byte transportByte = byteBuf.readByte();
        Assert.assertEquals((long)0L, (long)transportByte);
        int sourceAddrLength = byteBuf.readUnsignedShort();
        Assert.assertEquals((long)0L, (long)sourceAddrLength);
        Assert.assertFalse((boolean)byteBuf.isReadable());
        byteBuf.release();
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIpV4Address() {
        String invalidIpv4Address = "192.168.0.1234";
        new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP4, invalidIpv4Address, "192.168.0.11", 56324, 443);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidIpV6Address() {
        String invalidIpv6Address = "2001:0db8:85a3:0000:0000:8a2e:0370:73345";
        new HAProxyMessage(HAProxyProtocolVersion.V1, HAProxyCommand.PROXY, HAProxyProxiedProtocol.TCP6, invalidIpv6Address, "1050:0:0:0:5:600:300c:326b", 56324, 443);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUnixAddress() {
        String invalidUnixAddress = new String(new byte[109]);
        new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, invalidUnixAddress, "/var/run/dst.sock", 0, 0);
    }

    @Test(expected=NullPointerException.class)
    public void testNullUnixAddress() {
        new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, null, null, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLongUnixAddress() {
        String longUnixAddress = new String(new char[109]).replace("\u0000", "a");
        new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "source", longUnixAddress, 0, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidUnixPort() {
        new HAProxyMessage(HAProxyProtocolVersion.V2, HAProxyCommand.PROXY, HAProxyProxiedProtocol.UNIX_STREAM, "/var/run/src.sock", "/var/run/dst.sock", 80, 443);
    }
}

