/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.AbstractDnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import org.junit.Assert;
import org.junit.Test;

public class AbstractDnsRecordTest {
    @Test
    public void testValidDomainName() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assert.assertEquals((Object)(name + '.'), (Object)record.name());
    }

    @Test
    public void testValidDomainNameUmlaut() {
        String name = "\u00e4";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assert.assertEquals((Object)"xn--4ca.", (Object)record.name());
    }

    @Test
    public void testValidDomainNameTrailingDot() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa.";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assert.assertEquals((Object)name, (Object)record.name());
    }

    @Test
    public void testValidDomainNameUmlautTrailingDot() {
        String name = "\u00e4.";
        AbstractDnsRecord record = new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
        Assert.assertEquals((Object)"xn--4ca.", (Object)record.name());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidDomainNameLength() {
        String name = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidDomainNameUmlautLength() {
        String name = "\u00e4aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
        new AbstractDnsRecord(name, DnsRecordType.A, 0L){};
    }
}

