/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocatorTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PoolArenaMetric;
import io.netty.buffer.PoolChunk;
import io.netty.buffer.PoolChunkListMetric;
import io.netty.buffer.PoolSubpageMetric;
import io.netty.buffer.PooledByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.PooledDirectByteBuf;
import io.netty.buffer.PooledHeapByteBuf;
import io.netty.buffer.PooledUnsafeDirectByteBuf;
import io.netty.buffer.PooledUnsafeHeapByteBuf;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class PooledByteBufAllocatorTest
extends AbstractByteBufAllocatorTest<PooledByteBufAllocator> {
    @Override
    protected PooledByteBufAllocator newAllocator(boolean preferDirect) {
        return new PooledByteBufAllocator(preferDirect);
    }

    @Override
    protected PooledByteBufAllocator newUnpooledAllocator() {
        return new PooledByteBufAllocator(0, 0, 8192, 1);
    }

    @Override
    protected long expectedUsedMemory(PooledByteBufAllocator allocator, int capacity) {
        return allocator.metric().chunkSize();
    }

    @Override
    protected long expectedUsedMemoryAfterRelease(PooledByteBufAllocator allocator, int capacity) {
        return allocator.metric().chunkSize();
    }

    @Test
    public void testTrim() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        Assert.assertFalse((boolean)allocator.trimCurrentThreadCache());
        ByteBuf directBuffer = allocator.directBuffer();
        Assert.assertTrue((boolean)directBuffer.release());
        Assert.assertTrue((boolean)allocator.trimCurrentThreadCache());
    }

    @Test
    public void testPooledUnsafeHeapBufferAndUnsafeDirectBuffer() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        ByteBuf directBuffer = allocator.directBuffer();
        PooledByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? PooledUnsafeDirectByteBuf.class : PooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        PooledByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? PooledUnsafeHeapByteBuf.class : PooledHeapByteBuf.class);
        heapBuffer.release();
    }

    @Test
    public void testIOBuffersAreDirectWhenUnsafeAvailableOrDirectBuffersPooled() {
        PooledByteBufAllocator allocator = this.newAllocator(true);
        ByteBuf ioBuffer = allocator.ioBuffer();
        Assert.assertTrue((boolean)ioBuffer.isDirect());
        ioBuffer.release();
        PooledByteBufAllocator unpooledAllocator = this.newUnpooledAllocator();
        ioBuffer = unpooledAllocator.ioBuffer();
        if (PlatformDependent.hasUnsafe()) {
            Assert.assertTrue((boolean)ioBuffer.isDirect());
        } else {
            Assert.assertFalse((boolean)ioBuffer.isDirect());
        }
        ioBuffer.release();
    }

    @Test
    public void testWithoutUseCacheForAllThreads() {
        Assert.assertFalse((boolean)(Thread.currentThread() instanceof FastThreadLocalThread));
        PooledByteBufAllocator pool = new PooledByteBufAllocator(false, 1, 1, 8192, 11, 0, 0, 0, false);
        ByteBuf buf = pool.buffer(1);
        buf.release();
    }

    @Test
    public void testArenaMetricsNoCache() {
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 11, 0, 0, 0), 100, 0, 100, 100);
    }

    @Test
    public void testArenaMetricsCache() {
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 11, 1000, 1000, 1000), 100, 1, 1, 0);
    }

    @Test
    public void testArenaMetricsNoCacheAlign() {
        Assume.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 11, 0, 0, 0, true, 64), 100, 0, 100, 100);
    }

    @Test
    public void testArenaMetricsCacheAlign() {
        Assume.assumeTrue((boolean)PooledByteBufAllocator.isDirectMemoryCacheAlignmentSupported());
        PooledByteBufAllocatorTest.testArenaMetrics0(new PooledByteBufAllocator(true, 2, 2, 8192, 11, 1000, 1000, 1000, true, 64), 100, 1, 1, 0);
    }

    private static void testArenaMetrics0(PooledByteBufAllocator allocator, int num, int expectedActive, int expectedAlloc, int expectedDealloc) {
        for (int i = 0; i < num; ++i) {
            Assert.assertTrue((boolean)allocator.directBuffer().release());
            Assert.assertTrue((boolean)allocator.heapBuffer().release());
        }
        PooledByteBufAllocatorTest.assertArenaMetrics(allocator.metric().directArenas(), expectedActive, expectedAlloc, expectedDealloc);
        PooledByteBufAllocatorTest.assertArenaMetrics(allocator.metric().heapArenas(), expectedActive, expectedAlloc, expectedDealloc);
    }

    private static void assertArenaMetrics(List<PoolArenaMetric> arenaMetrics, int expectedActive, int expectedAlloc, int expectedDealloc) {
        int active = 0;
        int alloc = 0;
        int dealloc = 0;
        for (PoolArenaMetric arena : arenaMetrics) {
            active = (int)((long)active + arena.numActiveAllocations());
            alloc = (int)((long)alloc + arena.numAllocations());
            dealloc = (int)((long)dealloc + arena.numDeallocations());
        }
        Assert.assertEquals((long)expectedActive, (long)active);
        Assert.assertEquals((long)expectedAlloc, (long)alloc);
        Assert.assertEquals((long)expectedDealloc, (long)dealloc);
    }

    @Test
    public void testPoolChunkListMetric() {
        for (PoolArenaMetric arenaMetric : PooledByteBufAllocator.DEFAULT.metric().heapArenas()) {
            PooledByteBufAllocatorTest.assertPoolChunkListMetric(arenaMetric);
        }
    }

    private static void assertPoolChunkListMetric(PoolArenaMetric arenaMetric) {
        List lists = arenaMetric.chunkLists();
        Assert.assertEquals((long)6L, (long)lists.size());
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(0), 1, 25);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(1), 1, 50);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(2), 25, 75);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(4), 75, 100);
        PooledByteBufAllocatorTest.assertPoolChunkListMetric((PoolChunkListMetric)lists.get(5), 100, 100);
    }

    private static void assertPoolChunkListMetric(PoolChunkListMetric m, int min, int max) {
        Assert.assertEquals((long)min, (long)m.minUsage());
        Assert.assertEquals((long)max, (long)m.maxUsage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSmallSubpageMetric() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 11, 0, 0, 0);
        ByteBuf buffer = allocator.heapBuffer(500);
        try {
            PoolArenaMetric metric = (PoolArenaMetric)allocator.metric().heapArenas().get(0);
            PoolSubpageMetric subpageMetric = (PoolSubpageMetric)metric.smallSubpages().get(0);
            Assert.assertEquals((long)1L, (long)(subpageMetric.maxNumElements() - subpageMetric.numAvailable()));
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testAllocNotNull() {
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 11, 0, 0, 0);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, allocator.metric().chunkSize() + 1);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 1024);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 512);
        PooledByteBufAllocatorTest.testAllocNotNull(allocator, 1);
    }

    private static void testAllocNotNull(PooledByteBufAllocator allocator, int capacity) {
        ByteBuf buffer = allocator.heapBuffer(capacity);
        Assert.assertNotNull((Object)buffer.alloc());
        Assert.assertTrue((boolean)buffer.release());
        Assert.assertNotNull((Object)buffer.alloc());
    }

    @Test
    public void testFreePoolChunk() {
        int chunkSize = 0x1000000;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 0, 8192, 11, 0, 0, 0);
        ByteBuf buffer = allocator.heapBuffer(chunkSize);
        List arenas = allocator.metric().heapArenas();
        Assert.assertEquals((long)1L, (long)arenas.size());
        List lists = ((PoolArenaMetric)arenas.get(0)).chunkLists();
        Assert.assertEquals((long)6L, (long)lists.size());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(0)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(1)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(2)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(3)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(4)).iterator().hasNext());
        Assert.assertTrue((boolean)((PoolChunkListMetric)lists.get(5)).iterator().hasNext());
        Assert.assertTrue((boolean)buffer.release());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(0)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(1)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(2)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(3)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(4)).iterator().hasNext());
        Assert.assertFalse((boolean)((PoolChunkListMetric)lists.get(5)).iterator().hasNext());
    }

    @Test
    public void testCollapse() {
        int pageSize = 8192;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 11, 0, 0, 0);
        ByteBuf b1 = allocator.buffer(pageSize * 4);
        ByteBuf b2 = allocator.buffer(pageSize * 5);
        ByteBuf b3 = allocator.buffer(pageSize * 6);
        b2.release();
        b3.release();
        ByteBuf b4 = allocator.buffer(pageSize * 10);
        PooledByteBuf b = PooledByteBufAllocatorTest.unwrapIfNeeded(b4);
        Assert.assertEquals((long)4L, (long)PoolChunk.runOffset((long)b.handle));
        Assert.assertEquals((long)10L, (long)PoolChunk.runPages((long)b.handle));
        b1.release();
        b4.release();
        ByteBuf b5 = allocator.buffer(pageSize * 20);
        b = PooledByteBufAllocatorTest.unwrapIfNeeded(b5);
        Assert.assertEquals((long)0L, (long)PoolChunk.runOffset((long)b.handle));
        Assert.assertEquals((long)20L, (long)PoolChunk.runPages((long)b.handle));
        b5.release();
    }

    @Test
    public void testAllocateSmallOffset() {
        PooledByteBuf unwrapedBuf;
        ByteBuf buf;
        int i;
        int pageSize = 8192;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 11, 0, 0, 0);
        int size = pageSize * 5;
        ByteBuf[] bufs = new ByteBuf[10];
        for (i = 0; i < 10; ++i) {
            bufs[i] = allocator.buffer(size);
        }
        for (i = 0; i < 5; ++i) {
            bufs[i].release();
        }
        for (i = 0; i < 5; ++i) {
            buf = allocator.buffer(size);
            unwrapedBuf = PooledByteBufAllocatorTest.unwrapIfNeeded(buf);
            Assert.assertEquals((long)PoolChunk.runOffset((long)unwrapedBuf.handle), (long)(i * 5));
            bufs[i] = buf;
        }
        for (i = 9; i >= 5; --i) {
            bufs[i].release();
        }
        for (i = 5; i < 10; ++i) {
            buf = allocator.buffer(size);
            unwrapedBuf = PooledByteBufAllocatorTest.unwrapIfNeeded(buf);
            Assert.assertEquals((long)PoolChunk.runOffset((long)unwrapedBuf.handle), (long)(i * 5));
            bufs[i] = buf;
        }
        for (i = 0; i < 10; ++i) {
            bufs[i].release();
        }
    }

    @Test(timeout=4000L)
    public void testThreadCacheDestroyedByThreadCleaner() throws InterruptedException {
        PooledByteBufAllocatorTest.testThreadCacheDestroyed(false);
    }

    @Test(timeout=4000L)
    public void testThreadCacheDestroyedAfterExitRun() throws InterruptedException {
        PooledByteBufAllocatorTest.testThreadCacheDestroyed(true);
    }

    private static void testThreadCacheDestroyed(boolean useRunnable) throws InterruptedException {
        int numArenas = 11;
        final PooledByteBufAllocator allocator = new PooledByteBufAllocator(numArenas, numArenas, 8192, 1);
        final AtomicBoolean threadCachesCreated = new AtomicBoolean(true);
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                ByteBuf buf = allocator.newHeapBuffer(1024, 1024);
                for (int i = 0; i < buf.capacity(); ++i) {
                    buf.writeByte(0);
                }
                if (allocator.metric().numThreadLocalCaches() == 0) {
                    threadCachesCreated.set(false);
                }
                buf.release();
            }
        };
        for (int i = 0; i < numArenas; ++i) {
            FastThreadLocalThread thread;
            if (useRunnable) {
                thread = new FastThreadLocalThread(task);
                Assert.assertTrue((boolean)thread.willCleanupFastThreadLocals());
            } else {
                thread = new FastThreadLocalThread(){

                    public void run() {
                        task.run();
                    }
                };
                Assert.assertFalse((boolean)thread.willCleanupFastThreadLocals());
            }
            thread.start();
            thread.join();
        }
        while (allocator.metric().numThreadLocalCaches() > 0) {
            System.gc();
            System.runFinalization();
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(100L));
        }
        Assert.assertTrue((boolean)threadCachesCreated.get());
    }

    @Test(timeout=3000L)
    public void testNumThreadCachesWithNoDirectArenas() throws InterruptedException {
        int numHeapArenas = 1;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(numHeapArenas, 0, 8192, 1);
        ThreadCache tcache0 = PooledByteBufAllocatorTest.createNewThreadCache(allocator);
        Assert.assertEquals((long)1L, (long)allocator.metric().numThreadLocalCaches());
        ThreadCache tcache1 = PooledByteBufAllocatorTest.createNewThreadCache(allocator);
        Assert.assertEquals((long)2L, (long)allocator.metric().numThreadLocalCaches());
        tcache0.destroy();
        Assert.assertEquals((long)1L, (long)allocator.metric().numThreadLocalCaches());
        tcache1.destroy();
        Assert.assertEquals((long)0L, (long)allocator.metric().numThreadLocalCaches());
    }

    @Test(timeout=3000L)
    public void testThreadCacheToArenaMappings() throws InterruptedException {
        int numArenas = 2;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(numArenas, numArenas, 8192, 1);
        ThreadCache tcache0 = PooledByteBufAllocatorTest.createNewThreadCache(allocator);
        ThreadCache tcache1 = PooledByteBufAllocatorTest.createNewThreadCache(allocator);
        Assert.assertEquals((long)2L, (long)allocator.metric().numThreadLocalCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        tcache1.destroy();
        Assert.assertEquals((long)1L, (long)allocator.metric().numThreadLocalCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
        ThreadCache tcache2 = PooledByteBufAllocatorTest.createNewThreadCache(allocator);
        Assert.assertEquals((long)2L, (long)allocator.metric().numThreadLocalCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
        tcache0.destroy();
        Assert.assertEquals((long)1L, (long)allocator.metric().numThreadLocalCaches());
        tcache2.destroy();
        Assert.assertEquals((long)0L, (long)allocator.metric().numThreadLocalCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().heapArenas().get(1)).numThreadCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numThreadCaches());
        Assert.assertEquals((long)0L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(1)).numThreadCaches());
    }

    private static ThreadCache createNewThreadCache(final PooledByteBufAllocator allocator) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch cacheLatch = new CountDownLatch(1);
        FastThreadLocalThread t = new FastThreadLocalThread(new Runnable(){

            @Override
            public void run() {
                ByteBuf buf = allocator.newHeapBuffer(1024, 1024);
                cacheLatch.countDown();
                buf.writeZero(buf.capacity());
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                buf.release();
                FastThreadLocal.removeAll();
            }
        });
        t.start();
        cacheLatch.await();
        return new ThreadCache((Thread)t){
            final /* synthetic */ Thread val$t;
            {
                this.val$t = thread;
            }

            @Override
            public void destroy() throws InterruptedException {
                latch.countDown();
                this.val$t.join();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentUsage() throws Throwable {
        long runningTime = TimeUnit.MILLISECONDS.toNanos(SystemPropertyUtil.getLong((String)"io.netty.buffer.PooledByteBufAllocatorTest.testConcurrentUsageTime", (long)15000L));
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, 8192, 11, 0, 0, 0);
        ArrayList<AllocationThread> threads = new ArrayList<AllocationThread>();
        try {
            for (int i = 0; i < 512; ++i) {
                AllocationThread thread = new AllocationThread((ByteBufAllocator)allocator);
                thread.start();
                threads.add(thread);
            }
            long start = System.nanoTime();
            while (!PooledByteBufAllocatorTest.isExpired(start, runningTime)) {
                PooledByteBufAllocatorTest.checkForErrors(threads);
                Thread.sleep(100L);
            }
        }
        finally {
            for (AllocationThread t : threads) {
                t.markAsFinished();
            }
            for (AllocationThread t : threads) {
                t.joinAndCheckForError();
            }
        }
    }

    private static boolean isExpired(long start, long expireTime) {
        return System.nanoTime() - start > expireTime;
    }

    private static void checkForErrors(List<AllocationThread> threads) throws Throwable {
        for (AllocationThread t : threads) {
            if (!t.isFinished()) continue;
            t.checkForError();
        }
    }

    private static <T> PooledByteBuf<T> unwrapIfNeeded(ByteBuf buf) {
        return (PooledByteBuf)(buf instanceof PooledByteBuf ? buf : buf.unwrap());
    }

    @Test
    public void testCacheWorksForNormalAllocations() {
        int maxCachedBufferCapacity = PooledByteBufAllocator.DEFAULT_MAX_CACHED_BUFFER_CAPACITY;
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(true, 1, 1, PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), 128, 128, true);
        ByteBuf buffer = allocator.directBuffer(maxCachedBufferCapacity);
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity);
        Assert.assertEquals((long)1L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity + 1);
        Assert.assertEquals((long)2L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
        buffer = allocator.directBuffer(maxCachedBufferCapacity + 1);
        Assert.assertEquals((long)3L, (long)((PoolArenaMetric)allocator.metric().directArenas().get(0)).numNormalAllocations());
        buffer.release();
    }

    @Test
    public void testNormalPoolSubpageRelease() {
        int elemSize = 8192;
        int length = 1024;
        ByteBuf[] byteBufs = new ByteBuf[length];
        PooledByteBufAllocator allocator = new PooledByteBufAllocator(false, 32, 32, 8192, 11, 256, 64, false, 0);
        for (int i = 0; i < length; ++i) {
            byteBufs[i] = allocator.heapBuffer(elemSize, elemSize);
        }
        PoolChunk chunk = PooledByteBufAllocatorTest.unwrapIfNeeded((ByteBuf)byteBufs[0]).chunk;
        int beforeFreeBytes = chunk.freeBytes();
        for (int i = 0; i < length; ++i) {
            byteBufs[i].release();
        }
        int afterFreeBytes = chunk.freeBytes();
        Assert.assertTrue((beforeFreeBytes < afterFreeBytes ? 1 : 0) != 0);
    }

    private static final class AllocationThread
    extends Thread {
        private static final int[] ALLOCATION_SIZES = new int[16384];
        private final Queue<ByteBuf> buffers = new ConcurrentLinkedQueue<ByteBuf>();
        private final ByteBufAllocator allocator;
        private final AtomicReference<Object> finish = new AtomicReference();

        AllocationThread(ByteBufAllocator allocator) {
            this.allocator = allocator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int idx = 0;
                while (this.finish.get() == null) {
                    for (int i = 0; i < 10; ++i) {
                        int len = ALLOCATION_SIZES[Math.abs(idx++ % ALLOCATION_SIZES.length)];
                        ByteBuf buf = this.allocator.directBuffer(len, Integer.MAX_VALUE);
                        Assert.assertEquals((long)len, (long)buf.writableBytes());
                        while (buf.isWritable()) {
                            buf.writeByte(i);
                        }
                        this.buffers.offer(buf);
                    }
                    this.releaseBuffersAndCheckContent();
                }
            }
            catch (Throwable cause) {
                this.finish.set(cause);
            }
            finally {
                this.releaseBuffersAndCheckContent();
            }
        }

        private void releaseBuffersAndCheckContent() {
            int i = 0;
            while (!this.buffers.isEmpty()) {
                ByteBuf buf = this.buffers.poll();
                while (buf.isReadable()) {
                    Assert.assertEquals((long)i, (long)buf.readByte());
                }
                buf.release();
                ++i;
            }
        }

        boolean isFinished() {
            return this.finish.get() != null;
        }

        void markAsFinished() {
            this.finish.compareAndSet(null, Boolean.TRUE);
        }

        void joinAndCheckForError() throws Throwable {
            try {
                this.join();
            }
            finally {
                this.releaseBuffersAndCheckContent();
            }
            this.checkForError();
        }

        void checkForError() throws Throwable {
            Object obj = this.finish.get();
            if (obj instanceof Throwable) {
                throw (Throwable)obj;
            }
        }

        static {
            for (int i = 0; i < ALLOCATION_SIZES.length; ++i) {
                AllocationThread.ALLOCATION_SIZES[i] = i;
            }
        }
    }

    private static interface ThreadCache {
        public void destroy() throws InterruptedException;
    }
}

