/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.ByteBufAllocatorTest;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.util.internal.PlatformDependent;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractByteBufAllocatorTest<T extends AbstractByteBufAllocator>
extends ByteBufAllocatorTest {
    protected abstract T newAllocator(boolean var1);

    protected abstract T newUnpooledAllocator();

    @Override
    protected boolean isDirectExpected(boolean preferDirect) {
        return preferDirect && PlatformDependent.hasUnsafe();
    }

    @Override
    protected final int defaultMaxCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected final int defaultMaxComponents() {
        return 16;
    }

    @Test
    public void testCalculateNewCapacity() {
        this.testCalculateNewCapacity(true);
        this.testCalculateNewCapacity(false);
    }

    private void testCalculateNewCapacity(boolean preferDirect) {
        T allocator = this.newAllocator(preferDirect);
        Assert.assertEquals((long)8L, (long)allocator.calculateNewCapacity(1, 8));
        Assert.assertEquals((long)7L, (long)allocator.calculateNewCapacity(1, 7));
        Assert.assertEquals((long)64L, (long)allocator.calculateNewCapacity(1, 129));
        Assert.assertEquals((long)0x400000L, (long)allocator.calculateNewCapacity(0x400000, 0x400001));
        Assert.assertEquals((long)0x800000L, (long)allocator.calculateNewCapacity(0x400001, 0x1000000));
        try {
            allocator.calculateNewCapacity(8, 7);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            allocator.calculateNewCapacity(-1, 8);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        T allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeDirectByteBuf.class : UnpooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeHeapByteBuf.class : UnpooledHeapByteBuf.class);
        heapBuffer.release();
    }

    protected static void assertInstanceOf(ByteBuf buffer, Class<? extends ByteBuf> clazz) {
        Assert.assertTrue((boolean)clazz.isInstance(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer));
    }

    @Test
    public void testUsedDirectMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        Assert.assertEquals((long)0L, (long)metric.usedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assert.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assert.assertEquals((String)buffer.toString(), (long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.release();
        Assert.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedDirectMemory());
    }

    @Test
    public void testUsedHeapMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        Assert.assertEquals((long)0L, (long)metric.usedHeapMemory());
        ByteBuf buffer = allocator.heapBuffer(1024, 4096);
        int capacity = buffer.capacity();
        Assert.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        Assert.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.release();
        Assert.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedHeapMemory());
    }

    protected long expectedUsedMemory(T allocator, int capacity) {
        return capacity;
    }

    protected long expectedUsedMemoryAfterRelease(T allocator, int capacity) {
        return 0L;
    }
}

