/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessor;
import io.netty.buffer.search.SearchProcessorFactory;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchProcessorTest {
    @Parameterized.Parameter
    public Algorithm algorithm;

    @Parameterized.Parameters(name="{0} algorithm")
    public static Object[] algorithms() {
        return Algorithm.values();
    }

    @Test
    public void testSearch() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abc\u263a", (Charset)CharsetUtil.UTF_8);
        Assert.assertEquals((long)0L, (long)haystack.forEachByte((ByteProcessor)this.factory("a").newSearchProcessor()));
        Assert.assertEquals((long)1L, (long)haystack.forEachByte((ByteProcessor)this.factory("ab").newSearchProcessor()));
        Assert.assertEquals((long)2L, (long)haystack.forEachByte((ByteProcessor)this.factory("abc").newSearchProcessor()));
        Assert.assertEquals((long)5L, (long)haystack.forEachByte((ByteProcessor)this.factory("abc\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("abc\u263a\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("abc\u263ax").newSearchProcessor()));
        Assert.assertEquals((long)1L, (long)haystack.forEachByte((ByteProcessor)this.factory("b").newSearchProcessor()));
        Assert.assertEquals((long)2L, (long)haystack.forEachByte((ByteProcessor)this.factory("bc").newSearchProcessor()));
        Assert.assertEquals((long)5L, (long)haystack.forEachByte((ByteProcessor)this.factory("bc\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("bc\u263a\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("bc\u263ax").newSearchProcessor()));
        Assert.assertEquals((long)2L, (long)haystack.forEachByte((ByteProcessor)this.factory("c").newSearchProcessor()));
        Assert.assertEquals((long)5L, (long)haystack.forEachByte((ByteProcessor)this.factory("c\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("c\u263a\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("c\u263ax").newSearchProcessor()));
        Assert.assertEquals((long)5L, (long)haystack.forEachByte((ByteProcessor)this.factory("\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("\u263a\u263a").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("\u263ax").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("z").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("aa").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("ba").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("abcd").newSearchProcessor()));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory("abcde").newSearchProcessor()));
        haystack.release();
    }

    @Test
    public void testRepeating() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abcababc", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        SearchProcessor processor = this.factory("ab").newSearchProcessor();
        Assert.assertEquals((long)1L, (long)haystack.forEachByte((ByteProcessor)processor));
        Assert.assertEquals((long)4L, (long)haystack.forEachByte(2, length - 2, (ByteProcessor)processor));
        Assert.assertEquals((long)6L, (long)haystack.forEachByte(5, length - 5, (ByteProcessor)processor));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte(7, length - 7, (ByteProcessor)processor));
        haystack.release();
    }

    @Test
    public void testOverlapping() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"ababab", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        SearchProcessor processor = this.factory("bab").newSearchProcessor();
        Assert.assertEquals((long)3L, (long)haystack.forEachByte((ByteProcessor)processor));
        Assert.assertEquals((long)5L, (long)haystack.forEachByte(4, length - 4, (ByteProcessor)processor));
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte(6, length - 6, (ByteProcessor)processor));
        haystack.release();
    }

    @Test
    public void testLongInputs() {
        int haystackLen = 1024;
        int needleLen = 64;
        byte[] haystackBytes = new byte[1024];
        haystackBytes[1023] = 1;
        ByteBuf haystack = Unpooled.copiedBuffer((byte[])haystackBytes);
        byte[] needleBytes = new byte[64];
        Assert.assertEquals((long)63L, (long)haystack.forEachByte((ByteProcessor)this.factory(needleBytes).newSearchProcessor()));
        needleBytes[63] = 1;
        Assert.assertEquals((long)1023L, (long)haystack.forEachByte((ByteProcessor)this.factory(needleBytes).newSearchProcessor()));
        needleBytes[63] = 2;
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory(needleBytes).newSearchProcessor()));
        needleBytes[63] = 0;
        needleBytes[0] = 1;
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte((ByteProcessor)this.factory(needleBytes).newSearchProcessor()));
    }

    @Test
    public void testUniqueLen64Substrings() {
        byte[] haystackBytes = new byte[2080];
        int pos = 0;
        for (int i = 1; i <= 64; ++i) {
            for (int j = 0; j < i; ++j) {
                haystackBytes[pos++] = (byte)i;
            }
        }
        ByteBuf haystack = Unpooled.copiedBuffer((byte[])haystackBytes);
        for (int start = 0; start < haystackBytes.length - 64; ++start) {
            byte[] needle = Arrays.copyOfRange(haystackBytes, start, start + 64);
            Assert.assertEquals((long)(start + 63), (long)haystack.forEachByte((ByteProcessor)this.factory(needle).newSearchProcessor()));
        }
    }

    private SearchProcessorFactory factory(byte[] needle) {
        return this.algorithm.newFactory(needle);
    }

    private SearchProcessorFactory factory(String needle) {
        return this.factory(needle.getBytes(CharsetUtil.UTF_8));
    }

    private static enum Algorithm {
        KNUTH_MORRIS_PRATT{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newKmpSearchProcessorFactory((byte[])needle);
            }
        }
        ,
        BITAP{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newBitapSearchProcessorFactory((byte[])needle);
            }
        }
        ,
        AHO_CORASIC{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{needle});
            }
        };


        abstract SearchProcessorFactory newFactory(byte[] var1);
    }
}

