/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;

public class UnreleaseableByteBufTest {
    @Test
    public void testCantRelease() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copyInt((int)1));
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertFalse((boolean)buf.release());
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertFalse((boolean)buf.release());
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        buf.retain(5);
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        buf.retain();
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertTrue((boolean)buf.unwrap().release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    @Test
    public void testWrappedReadOnly() {
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)1).asReadOnly());
        Assert.assertSame((Object)buf, (Object)buf.asReadOnly());
        Assert.assertTrue((boolean)buf.unwrap().release());
    }
}

