/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.LongPriorityQueue;
import io.netty.util.internal.ThreadLocalRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ListIterator;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

class LongPriorityQueueTest {
    LongPriorityQueueTest() {
    }

    @Test
    public void mustThrowWhenAddingNoValue() {
        final LongPriorityQueue pq = new LongPriorityQueue();
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                pq.offer(-1L);
            }
        });
    }

    @Test
    public void mustReturnValuesInOrder() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(5, 30);
        ArrayList<Long> values = new ArrayList<Long>();
        for (int i = 0; i < initialValues; ++i) {
            values.add(tlr.nextLong(0L, Long.MAX_VALUE));
        }
        LongPriorityQueue pq = new LongPriorityQueue();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        for (Long value : values) {
            pq.offer(value.longValue());
        }
        Collections.sort(values);
        int valuesToRemove = initialValues / 2;
        ListIterator itr = values.listIterator();
        for (int i = 0; i < valuesToRemove; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)itr.hasNext());
            Assertions.assertThat((long)pq.poll()).isEqualTo(itr.next());
            itr.remove();
        }
        int moreValues = tlr.nextInt(5, 30);
        for (int i = 0; i < moreValues; ++i) {
            long value = tlr.nextLong(0L, Long.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        Collections.sort(values);
        itr = values.listIterator();
        while (itr.hasNext()) {
            Assertions.assertThat((long)pq.poll()).isEqualTo(itr.next());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((long)pq.poll()).isEqualTo(-1L);
    }

    @Test
    public void internalRemoveOfAllElements() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(5, 30);
        ArrayList<Long> values = new ArrayList<Long>();
        LongPriorityQueue pq = new LongPriorityQueue();
        for (int i = 0; i < initialValues; ++i) {
            long value = tlr.nextLong(0L, Long.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        for (Long value : values) {
            pq.remove(value.longValue());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((long)pq.poll()).isEqualTo(-1L);
    }

    @Test
    public void internalRemoveMustPreserveOrder() {
        ThreadLocalRandom tlr = ThreadLocalRandom.current();
        int initialValues = tlr.nextInt(1, 30);
        ArrayList<Long> values = new ArrayList<Long>();
        LongPriorityQueue pq = new LongPriorityQueue();
        for (int i = 0; i < initialValues; ++i) {
            long value = tlr.nextLong(0L, Long.MAX_VALUE);
            pq.offer(value);
            values.add(value);
        }
        long toRemove = (Long)values.get(values.size() / 2);
        values.remove(toRemove);
        pq.remove(toRemove);
        Collections.sort(values);
        for (Long value : values) {
            Assertions.assertThat((long)pq.poll()).isEqualTo((Object)value);
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((long)pq.poll()).isEqualTo(-1L);
    }

    @Test
    public void mustSupportDuplicateValues() {
        LongPriorityQueue pq = new LongPriorityQueue();
        pq.offer(10L);
        pq.offer(5L);
        pq.offer(6L);
        pq.offer(5L);
        pq.offer(10L);
        pq.offer(10L);
        pq.offer(6L);
        pq.remove(10L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(5L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(5L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(5L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(5L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(5L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(6L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(6L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(6L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(6L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(6L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(10L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(10L);
        Assertions.assertThat((long)pq.poll()).isEqualTo(10L);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pq.isEmpty());
        Assertions.assertThat((long)pq.poll()).isEqualTo(-1L);
        Assertions.assertThat((long)pq.peek()).isEqualTo(-1L);
    }
}

