/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class ByteProcessorTest {
    @Test
    public void testForward() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"abc\r\n\ndef\r\rghi\n\njkl\u0000\u0000mno  \t\tx", (Charset)CharsetUtil.ISO_8859_1);
        int length = buf.readableBytes();
        Assert.assertEquals((long)3L, (long)buf.forEachByte(0, length, ByteProcessor.FIND_CRLF));
        Assert.assertEquals((long)6L, (long)buf.forEachByte(3, length - 3, ByteProcessor.FIND_NON_CRLF));
        Assert.assertEquals((long)9L, (long)buf.forEachByte(6, length - 6, ByteProcessor.FIND_CR));
        Assert.assertEquals((long)11L, (long)buf.forEachByte(9, length - 9, ByteProcessor.FIND_NON_CR));
        Assert.assertEquals((long)14L, (long)buf.forEachByte(11, length - 11, ByteProcessor.FIND_LF));
        Assert.assertEquals((long)16L, (long)buf.forEachByte(14, length - 14, ByteProcessor.FIND_NON_LF));
        Assert.assertEquals((long)19L, (long)buf.forEachByte(16, length - 16, ByteProcessor.FIND_NUL));
        Assert.assertEquals((long)21L, (long)buf.forEachByte(19, length - 19, ByteProcessor.FIND_NON_NUL));
        Assert.assertEquals((long)24L, (long)buf.forEachByte(19, length - 19, ByteProcessor.FIND_ASCII_SPACE));
        Assert.assertEquals((long)24L, (long)buf.forEachByte(21, length - 21, ByteProcessor.FIND_LINEAR_WHITESPACE));
        Assert.assertEquals((long)28L, (long)buf.forEachByte(24, length - 24, ByteProcessor.FIND_NON_LINEAR_WHITESPACE));
        Assert.assertEquals((long)-1L, (long)buf.forEachByte(28, length - 28, ByteProcessor.FIND_LINEAR_WHITESPACE));
        buf.release();
    }

    @Test
    public void testBackward() {
        ByteBuf buf = Unpooled.copiedBuffer((CharSequence)"abc\r\n\ndef\r\rghi\n\njkl\u0000\u0000mno  \t\tx", (Charset)CharsetUtil.ISO_8859_1);
        int length = buf.readableBytes();
        Assert.assertEquals((long)27L, (long)buf.forEachByteDesc(0, length, ByteProcessor.FIND_LINEAR_WHITESPACE));
        Assert.assertEquals((long)25L, (long)buf.forEachByteDesc(0, length, ByteProcessor.FIND_ASCII_SPACE));
        Assert.assertEquals((long)23L, (long)buf.forEachByteDesc(0, 28, ByteProcessor.FIND_NON_LINEAR_WHITESPACE));
        Assert.assertEquals((long)20L, (long)buf.forEachByteDesc(0, 24, ByteProcessor.FIND_NUL));
        Assert.assertEquals((long)18L, (long)buf.forEachByteDesc(0, 21, ByteProcessor.FIND_NON_NUL));
        Assert.assertEquals((long)15L, (long)buf.forEachByteDesc(0, 19, ByteProcessor.FIND_LF));
        Assert.assertEquals((long)13L, (long)buf.forEachByteDesc(0, 16, ByteProcessor.FIND_NON_LF));
        Assert.assertEquals((long)10L, (long)buf.forEachByteDesc(0, 14, ByteProcessor.FIND_CR));
        Assert.assertEquals((long)8L, (long)buf.forEachByteDesc(0, 11, ByteProcessor.FIND_NON_CR));
        Assert.assertEquals((long)5L, (long)buf.forEachByteDesc(0, 9, ByteProcessor.FIND_CRLF));
        Assert.assertEquals((long)2L, (long)buf.forEachByteDesc(0, 6, ByteProcessor.FIND_NON_CRLF));
        Assert.assertEquals((long)-1L, (long)buf.forEachByteDesc(0, 3, ByteProcessor.FIND_CRLF));
        buf.release();
    }
}

