/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.buffer.UnpooledDirectByteBuf;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Test;

public class BigEndianDirectByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = this.newDirectBuffer(length, maxCapacity);
        Assert.assertSame((Object)ByteOrder.BIG_ENDIAN, (Object)buffer.order());
        Assert.assertEquals((long)0L, (long)buffer.writerIndex());
        return buffer;
    }

    protected ByteBuf newDirectBuffer(int length, int maxCapacity) {
        return new UnpooledDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, length, maxCapacity);
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assert.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }
}

