/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBuf;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractPooledByteBufTest
extends AbstractByteBufTest {
    protected abstract ByteBuf alloc(int var1, int var2);

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf buffer = this.alloc(length, maxCapacity);
        Assert.assertEquals((long)0L, (long)buffer.writerIndex());
        Assert.assertEquals((long)0L, (long)buffer.readerIndex());
        buffer.resetReaderIndex();
        buffer.resetWriterIndex();
        Assert.assertEquals((long)0L, (long)buffer.writerIndex());
        Assert.assertEquals((long)0L, (long)buffer.readerIndex());
        return buffer;
    }

    @Test
    public void ensureWritableWithEnoughSpaceShouldNotThrow() {
        ByteBuf buf = this.newBuffer(1, 10);
        buf.ensureWritable(3);
        MatcherAssert.assertThat((Object)buf.writableBytes(), (Matcher)Matchers.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(3))));
        buf.release();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void ensureWritableWithNotEnoughSpaceShouldThrow() {
        ByteBuf buf = this.newBuffer(1, 10);
        try {
            buf.ensureWritable(11);
            Assert.fail();
        }
        finally {
            buf.release();
        }
    }

    @Override
    @Test
    public void testMaxFastWritableBytes() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        Assert.assertEquals((long)50L, (long)buffer.writableBytes());
        Assert.assertEquals((long)150L, (long)buffer.capacity());
        Assert.assertEquals((long)500L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)400L, (long)buffer.maxWritableBytes());
        int chunkSize = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).maxLength;
        Assert.assertTrue((chunkSize >= 150 ? 1 : 0) != 0);
        int remainingInAlloc = Math.min(chunkSize - 100, 400);
        Assert.assertEquals((long)remainingInAlloc, (long)buffer.maxFastWritableBytes());
        long handleBefore = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle;
        buffer.writeBytes(new byte[remainingInAlloc]);
        Assert.assertEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        Assert.assertEquals((long)0L, (long)buffer.maxFastWritableBytes());
        buffer.writeByte(7);
        Assert.assertNotEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        buffer.capacity(500);
        Assert.assertEquals((long)(500 - buffer.writerIndex()), (long)buffer.maxFastWritableBytes());
        buffer.release();
    }

    private static PooledByteBuf<?> pooledByteBuf(ByteBuf buffer) {
        while (!(buffer instanceof PooledByteBuf)) {
            buffer = buffer.unwrap();
        }
        return (PooledByteBuf)buffer;
    }

    @Test
    public void testEnsureWritableDoesntGrowTooMuch() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        Assert.assertEquals((long)50L, (long)buffer.writableBytes());
        int fastWritable = buffer.maxFastWritableBytes();
        Assert.assertTrue((fastWritable > 50 ? 1 : 0) != 0);
        long handleBefore = AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle;
        buffer.ensureWritable(fastWritable);
        Assert.assertEquals((long)handleBefore, (long)AbstractPooledByteBufTest.pooledByteBuf((ByteBuf)buffer).handle);
        Assert.assertEquals((long)(100 + fastWritable), (long)buffer.capacity());
        Assert.assertEquals((long)buffer.writableBytes(), (long)buffer.maxFastWritableBytes());
        buffer.release();
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assert.assertTrue((boolean)buf.isContiguous());
        buf.release();
    }
}

