/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AdvancedLeakAwareByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.NoopResourceLeakTracker;
import io.netty.buffer.SimpleLeakAwareByteBuf;
import io.netty.buffer.SimpleLeakAwareByteBufTest;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.ResourceLeakTracker;
import org.junit.Assert;
import org.junit.Test;

public class AdvancedLeakAwareByteBufTest
extends SimpleLeakAwareByteBufTest {
    @Override
    protected Class<? extends ByteBuf> leakClass() {
        return AdvancedLeakAwareByteBuf.class;
    }

    @Override
    protected SimpleLeakAwareByteBuf wrap(ByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new AdvancedLeakAwareByteBuf(buffer, tracker);
    }

    @Test
    public void testAddComponentWithLeakAwareByteBuf() {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])"hello world".getBytes(CharsetUtil.US_ASCII)).slice(6, 5);
        SimpleLeakAwareByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponent(true, (ByteBuf)leakAwareBuf);
        byte[] result = new byte[5];
        ByteBuf bb = composite.component(0);
        System.out.println(bb);
        bb.readBytes(result);
        Assert.assertArrayEquals((byte[])"world".getBytes(CharsetUtil.US_ASCII), (byte[])result);
        composite.release();
    }
}

