/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer.search;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AhoCorasicSearchProcessorFactory;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.junit.Assert;
import org.junit.Test;

public class MultiSearchProcessorTest {
    @Test
    public void testSearchForMultiple() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"one two three one", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        AhoCorasicSearchProcessorFactory.Processor processor = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("one"), MultiSearchProcessorTest.bytes("two"), MultiSearchProcessorTest.bytes("three")}).newSearchProcessor();
        Assert.assertEquals((long)-1L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)2L, (long)haystack.forEachByte((ByteProcessor)processor));
        Assert.assertEquals((long)0L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)6L, (long)haystack.forEachByte(3, length - 3, (ByteProcessor)processor));
        Assert.assertEquals((long)1L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)12L, (long)haystack.forEachByte(7, length - 7, (ByteProcessor)processor));
        Assert.assertEquals((long)2L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)16L, (long)haystack.forEachByte(13, length - 13, (ByteProcessor)processor));
        Assert.assertEquals((long)0L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)-1L, (long)haystack.forEachByte(17, length - 17, (ByteProcessor)processor));
        haystack.release();
    }

    @Test
    public void testSearchForMultipleOverlapping() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"abcd", (Charset)CharsetUtil.UTF_8);
        int length = haystack.readableBytes();
        AhoCorasicSearchProcessorFactory.Processor processor = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("ab"), MultiSearchProcessorTest.bytes("bc"), MultiSearchProcessorTest.bytes("cd")}).newSearchProcessor();
        Assert.assertEquals((long)1L, (long)haystack.forEachByte((ByteProcessor)processor));
        Assert.assertEquals((long)0L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)2L, (long)haystack.forEachByte(2, length - 2, (ByteProcessor)processor));
        Assert.assertEquals((long)1L, (long)processor.getFoundNeedleId());
        Assert.assertEquals((long)3L, (long)haystack.forEachByte(3, length - 3, (ByteProcessor)processor));
        Assert.assertEquals((long)2L, (long)processor.getFoundNeedleId());
        haystack.release();
    }

    @Test
    public void findLongerNeedleInCaseOfSuffixMatch() {
        ByteBuf haystack = Unpooled.copiedBuffer((CharSequence)"xabcx", (Charset)CharsetUtil.UTF_8);
        AhoCorasicSearchProcessorFactory.Processor processor1 = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("abc"), MultiSearchProcessorTest.bytes("bc")}).newSearchProcessor();
        Assert.assertEquals((long)3L, (long)haystack.forEachByte((ByteProcessor)processor1));
        Assert.assertEquals((long)0L, (long)processor1.getFoundNeedleId());
        AhoCorasicSearchProcessorFactory.Processor processor2 = AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{MultiSearchProcessorTest.bytes("bc"), MultiSearchProcessorTest.bytes("abc")}).newSearchProcessor();
        Assert.assertEquals((long)3L, (long)haystack.forEachByte((ByteProcessor)processor2));
        Assert.assertEquals((long)1L, (long)processor2.getFoundNeedleId());
        haystack.release();
    }

    private static byte[] bytes(String s) {
        return s.getBytes(CharsetUtil.UTF_8);
    }
}

