/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import io.netty.util.CharsetUtil;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractByteBufTest {
    private static final int CAPACITY = 4096;
    private static final int BLOCK_SIZE = 128;
    private static final int JAVA_BYTEBUFFER_CONSISTENCY_ITERATIONS = 100;
    private long seed;
    private Random random;
    private ByteBuf buffer;
    private static final CharBuffer EXTENDED_ASCII_CHARS;
    private static final CharBuffer ASCII_CHARS;

    protected final ByteBuf newBuffer(int capacity) {
        return this.newBuffer(capacity, Integer.MAX_VALUE);
    }

    protected abstract ByteBuf newBuffer(int var1, int var2);

    protected boolean discardReadBytesDoesNotMoveWritableBytes() {
        return true;
    }

    @Before
    public void init() {
        this.buffer = this.newBuffer(4096);
        this.seed = System.currentTimeMillis();
        this.random = new Random(this.seed);
    }

    @After
    public void dispose() {
        if (this.buffer != null) {
            Assert.assertThat((Object)this.buffer.release(), (Matcher)CoreMatchers.is((Object)true));
            Assert.assertThat((Object)this.buffer.refCnt(), (Matcher)CoreMatchers.is((Object)0));
            try {
                this.buffer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.buffer = null;
        }
    }

    @Test
    public void comparableInterfaceNotViolated() {
        Assume.assumeFalse((boolean)this.buffer.isReadOnly());
        this.buffer.writerIndex(this.buffer.readerIndex());
        Assume.assumeTrue((this.buffer.writableBytes() >= 4 ? 1 : 0) != 0);
        this.buffer.writeLong(0L);
        ByteBuf buffer2 = this.newBuffer(4096);
        Assume.assumeFalse((boolean)buffer2.isReadOnly());
        buffer2.writerIndex(buffer2.readerIndex());
        buffer2.writeLong(0xF0000000L);
        Assert.assertTrue((this.buffer.compareTo(buffer2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((buffer2.compareTo(this.buffer) > 0 ? 1 : 0) != 0);
        buffer2.release();
    }

    @Test
    public void initialState() {
        Assert.assertEquals((long)4096L, (long)this.buffer.capacity());
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void readerIndexBoundaryCheck1() {
        try {
            this.buffer.writerIndex(0);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.fail();
        }
        this.buffer.readerIndex(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void readerIndexBoundaryCheck2() {
        try {
            this.buffer.writerIndex(this.buffer.capacity());
        }
        catch (IndexOutOfBoundsException e) {
            Assert.fail();
        }
        this.buffer.readerIndex(this.buffer.capacity() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void readerIndexBoundaryCheck3() {
        try {
            this.buffer.writerIndex(2048);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.fail();
        }
        this.buffer.readerIndex(6144);
    }

    @Test
    public void readerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.capacity());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void writerIndexBoundaryCheck1() {
        this.buffer.writerIndex(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void writerIndexBoundaryCheck2() {
        try {
            this.buffer.writerIndex(4096);
            this.buffer.readerIndex(4096);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.fail();
        }
        this.buffer.writerIndex(this.buffer.capacity() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void writerIndexBoundaryCheck3() {
        try {
            this.buffer.writerIndex(4096);
            this.buffer.readerIndex(2048);
        }
        catch (IndexOutOfBoundsException e) {
            Assert.fail();
        }
        this.buffer.writerIndex(1024);
    }

    @Test
    public void writerIndexBoundaryCheck4() {
        this.buffer.writerIndex(0);
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(4096);
        this.buffer.writeBytes(ByteBuffer.wrap(EmptyArrays.EMPTY_BYTES));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getBooleanBoundaryCheck1() {
        this.buffer.getBoolean(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getBooleanBoundaryCheck2() {
        this.buffer.getBoolean(this.buffer.capacity());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getByteBoundaryCheck1() {
        this.buffer.getByte(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getByteBoundaryCheck2() {
        this.buffer.getByte(this.buffer.capacity());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getShortBoundaryCheck1() {
        this.buffer.getShort(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getShortBoundaryCheck2() {
        this.buffer.getShort(this.buffer.capacity() - 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getMediumBoundaryCheck1() {
        this.buffer.getMedium(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getMediumBoundaryCheck2() {
        this.buffer.getMedium(this.buffer.capacity() - 2);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getIntBoundaryCheck1() {
        this.buffer.getInt(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getIntBoundaryCheck2() {
        this.buffer.getInt(this.buffer.capacity() - 3);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getLongBoundaryCheck1() {
        this.buffer.getLong(-1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getLongBoundaryCheck2() {
        this.buffer.getLong(this.buffer.capacity() - 7);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getByteArrayBoundaryCheck1() {
        this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getByteArrayBoundaryCheck2() {
        this.buffer.getBytes(-1, EmptyArrays.EMPTY_BYTES, 0, 0);
    }

    @Test
    public void getByteArrayBoundaryCheck3() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        try {
            this.buffer.getBytes(0, dst, -1, 4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)dst[0]);
        Assert.assertEquals((long)0L, (long)dst[1]);
        Assert.assertEquals((long)0L, (long)dst[2]);
        Assert.assertEquals((long)0L, (long)dst[3]);
    }

    @Test
    public void getByteArrayBoundaryCheck4() {
        byte[] dst = new byte[4];
        this.buffer.setInt(0, 16909060);
        try {
            this.buffer.getBytes(0, dst, 1, 4);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)dst[0]);
        Assert.assertEquals((long)0L, (long)dst[1]);
        Assert.assertEquals((long)0L, (long)dst[2]);
        Assert.assertEquals((long)0L, (long)dst[3]);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getByteBufferBoundaryCheck() {
        this.buffer.getBytes(-1, ByteBuffer.allocate(0));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void copyBoundaryCheck1() {
        this.buffer.copy(-1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void copyBoundaryCheck2() {
        this.buffer.copy(0, this.buffer.capacity() + 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void copyBoundaryCheck3() {
        this.buffer.copy(this.buffer.capacity() + 1, 0);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void copyBoundaryCheck4() {
        this.buffer.copy(this.buffer.capacity(), 1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setIndexBoundaryCheck1() {
        this.buffer.setIndex(-1, 4096);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setIndexBoundaryCheck2() {
        this.buffer.setIndex(2048, 1024);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void setIndexBoundaryCheck3() {
        this.buffer.setIndex(0, 4097);
    }

    @Test
    public void getByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocate(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        Assert.assertEquals((long)3L, (long)dst.position());
        Assert.assertEquals((long)3L, (long)dst.limit());
        dst.clear();
        Assert.assertEquals((long)0L, (long)dst.get(0));
        Assert.assertEquals((long)2L, (long)dst.get(1));
        Assert.assertEquals((long)3L, (long)dst.get(2));
        Assert.assertEquals((long)0L, (long)dst.get(3));
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void getDirectByteBufferBoundaryCheck() {
        this.buffer.getBytes(-1, ByteBuffer.allocateDirect(0));
    }

    @Test
    public void getDirectByteBufferState() {
        ByteBuffer dst = ByteBuffer.allocateDirect(4);
        dst.position(1);
        dst.limit(3);
        this.buffer.setByte(0, 1);
        this.buffer.setByte(1, 2);
        this.buffer.setByte(2, 3);
        this.buffer.setByte(3, 4);
        this.buffer.getBytes(1, dst);
        Assert.assertEquals((long)3L, (long)dst.position());
        Assert.assertEquals((long)3L, (long)dst.limit());
        dst.clear();
        Assert.assertEquals((long)0L, (long)dst.get(0));
        Assert.assertEquals((long)2L, (long)dst.get(1));
        Assert.assertEquals((long)3L, (long)dst.get(2));
        Assert.assertEquals((long)0L, (long)dst.get(3));
    }

    @Test
    public void testRandomByteAccess() {
        byte value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assert.assertEquals((long)value, (long)this.buffer.getByte(i));
        }
    }

    @Test
    public void testRandomUnsignedByteAccess() {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt();
            this.buffer.setByte(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt() & 0xFF;
            Assert.assertEquals((long)value, (long)this.buffer.getUnsignedByte(i));
        }
    }

    @Test
    public void testRandomShortAccess() {
        this.testRandomShortAccess(true);
    }

    @Test
    public void testRandomShortLEAccess() {
        this.testRandomShortAccess(false);
    }

    private void testRandomShortAccess(boolean testBigEndian) {
        short value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, (int)value);
                continue;
            }
            this.buffer.setShortLE(i, (int)value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = (short)this.random.nextInt();
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getShort(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getShortLE(i));
        }
    }

    @Test
    public void testShortConsistentWithByteBuffer() {
        this.testShortConsistentWithByteBuffer(true, true);
        this.testShortConsistentWithByteBuffer(true, false);
        this.testShortConsistentWithByteBuffer(false, true);
        this.testShortConsistentWithByteBuffer(false, false);
    }

    private void testShortConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            short expected = (short)(this.random.nextInt() & 0xFFFF);
            javaBuffer.putShort(expected);
            int bufferIndex = this.buffer.capacity() - 2;
            if (testBigEndian) {
                this.buffer.setShort(bufferIndex, (int)expected);
            } else {
                this.buffer.setShortLE(bufferIndex, (int)expected);
            }
            javaBuffer.flip();
            short javaActual = javaBuffer.getShort();
            Assert.assertEquals((long)expected, (long)javaActual);
            Assert.assertEquals((long)javaActual, (long)(testBigEndian ? (long)this.buffer.getShort(bufferIndex) : (long)this.buffer.getShortLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomUnsignedShortAccess() {
        this.testRandomUnsignedShortAccess(true);
    }

    @Test
    public void testRandomUnsignedShortLEAccess() {
        this.testRandomUnsignedShortAccess(false);
    }

    private void testRandomUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setShort(i, value);
                continue;
            }
            this.buffer.setShortLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 1; i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getUnsignedShort(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getUnsignedShortLE(i));
        }
    }

    @Test
    public void testRandomMediumAccess() {
        this.testRandomMediumAccess(true);
    }

    @Test
    public void testRandomMediumLEAccess() {
        this.testRandomMediumAccess(false);
    }

    private void testRandomMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getMedium(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getMediumLE(i));
        }
    }

    @Test
    public void testRandomUnsignedMediumAccess() {
        this.testRandomUnsignedMediumAccess(true);
    }

    @Test
    public void testRandomUnsignedMediumLEAccess() {
        this.testRandomUnsignedMediumAccess(false);
    }

    private void testRandomUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setMedium(i, value);
                continue;
            }
            this.buffer.setMediumLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 2; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getUnsignedMedium(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getUnsignedMediumLE(i));
        }
    }

    @Test
    public void testMediumConsistentWithByteBuffer() {
        this.testMediumConsistentWithByteBuffer(true, true);
        this.testMediumConsistentWithByteBuffer(true, false);
        this.testMediumConsistentWithByteBuffer(false, true);
        this.testMediumConsistentWithByteBuffer(false, false);
    }

    private void testMediumConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt() & 0xFFFFFF;
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 3;
            if (testBigEndian) {
                this.buffer.setMedium(bufferIndex, expected);
            } else {
                this.buffer.setMediumLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            Assert.assertEquals((long)expected, (long)javaActual);
            Assert.assertEquals((long)javaActual, (long)(testBigEndian ? (long)this.buffer.getUnsignedMedium(bufferIndex) : (long)this.buffer.getUnsignedMediumLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomIntAccess() {
        this.testRandomIntAccess(true);
    }

    @Test
    public void testRandomIntLEAccess() {
        this.testRandomIntAccess(false);
    }

    private void testRandomIntAccess(boolean testBigEndian) {
        int value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            value = this.random.nextInt();
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getInt(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getIntLE(i));
        }
    }

    @Test
    public void testIntConsistentWithByteBuffer() {
        this.testIntConsistentWithByteBuffer(true, true);
        this.testIntConsistentWithByteBuffer(true, false);
        this.testIntConsistentWithByteBuffer(false, true);
        this.testIntConsistentWithByteBuffer(false, false);
    }

    private void testIntConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            int expected = this.random.nextInt();
            javaBuffer.putInt(expected);
            int bufferIndex = this.buffer.capacity() - 4;
            if (testBigEndian) {
                this.buffer.setInt(bufferIndex, expected);
            } else {
                this.buffer.setIntLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            int javaActual = javaBuffer.getInt();
            Assert.assertEquals((long)expected, (long)javaActual);
            Assert.assertEquals((long)javaActual, (long)(testBigEndian ? (long)this.buffer.getInt(bufferIndex) : (long)this.buffer.getIntLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomUnsignedIntAccess() {
        this.testRandomUnsignedIntAccess(true);
    }

    @Test
    public void testRandomUnsignedIntLEAccess() {
        this.testRandomUnsignedIntAccess(false);
    }

    private void testRandomUnsignedIntAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            int value = this.random.nextInt();
            if (testBigEndian) {
                this.buffer.setInt(i, value);
                continue;
            }
            this.buffer.setIntLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 3; i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getUnsignedInt(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getUnsignedIntLE(i));
        }
    }

    @Test
    public void testRandomLongAccess() {
        this.testRandomLongAccess(true);
    }

    @Test
    public void testRandomLongLEAccess() {
        this.testRandomLongAccess(false);
    }

    private void testRandomLongAccess(boolean testBigEndian) {
        long value;
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                this.buffer.setLong(i, value);
                continue;
            }
            this.buffer.setLongLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            value = this.random.nextLong();
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.getLong(i));
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.getLongLE(i));
        }
    }

    @Test
    public void testLongConsistentWithByteBuffer() {
        this.testLongConsistentWithByteBuffer(true, true);
        this.testLongConsistentWithByteBuffer(true, false);
        this.testLongConsistentWithByteBuffer(false, true);
        this.testLongConsistentWithByteBuffer(false, false);
    }

    private void testLongConsistentWithByteBuffer(boolean direct, boolean testBigEndian) {
        for (int i = 0; i < 100; ++i) {
            ByteBuffer javaBuffer;
            ByteBuffer byteBuffer = javaBuffer = direct ? ByteBuffer.allocateDirect(this.buffer.capacity()) : ByteBuffer.allocate(this.buffer.capacity());
            if (!testBigEndian) {
                javaBuffer = javaBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            long expected = this.random.nextLong();
            javaBuffer.putLong(expected);
            int bufferIndex = this.buffer.capacity() - 8;
            if (testBigEndian) {
                this.buffer.setLong(bufferIndex, expected);
            } else {
                this.buffer.setLongLE(bufferIndex, expected);
            }
            javaBuffer.flip();
            long javaActual = javaBuffer.getLong();
            Assert.assertEquals((long)expected, (long)javaActual);
            Assert.assertEquals((long)javaActual, (long)(testBigEndian ? this.buffer.getLong(bufferIndex) : this.buffer.getLongLE(bufferIndex)));
        }
    }

    @Test
    public void testRandomFloatAccess() {
        this.testRandomFloatAccess(true);
    }

    @Test
    public void testRandomFloatLEAccess() {
        this.testRandomFloatAccess(false);
    }

    private void testRandomFloatAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float value = this.random.nextFloat();
            if (testBigEndian) {
                this.buffer.setFloat(i, value);
                continue;
            }
            this.buffer.setFloatLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            float expected = this.random.nextFloat();
            float actual = testBigEndian ? this.buffer.getFloat(i) : this.buffer.getFloatLE(i);
            Assert.assertEquals((double)expected, (double)actual, (double)0.01);
        }
    }

    @Test
    public void testRandomDoubleAccess() {
        this.testRandomDoubleAccess(true);
    }

    @Test
    public void testRandomDoubleLEAccess() {
        this.testRandomDoubleAccess(false);
    }

    private void testRandomDoubleAccess(boolean testBigEndian) {
        int i;
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double value = this.random.nextDouble();
            if (testBigEndian) {
                this.buffer.setDouble(i, value);
                continue;
            }
            this.buffer.setDoubleLE(i, value);
        }
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() - 7; i += 8) {
            double expected = this.random.nextDouble();
            double actual = testBigEndian ? this.buffer.getDouble(i) : this.buffer.getDoubleLE(i);
            Assert.assertEquals((double)expected, (double)actual, (double)0.01);
        }
    }

    @Test
    public void testSetZero() {
        int i;
        int length;
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.setZero(i, length);
        }
        for (i = 0; i < this.buffer.capacity(); ++i) {
            Assert.assertEquals((long)0L, (long)this.buffer.getByte(i));
        }
    }

    @Test
    public void testSequentialByteAccess() {
        byte value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            this.buffer.writeByte((int)value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = (byte)this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            Assert.assertEquals((long)value, (long)this.buffer.readByte());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedByteAccess() {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            this.buffer.writeByte(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); ++i) {
            value = this.random.nextInt() & 0xFF;
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            Assert.assertEquals((long)value, (long)this.buffer.readUnsignedByte());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialShortAccess() {
        this.testSequentialShortAccess(true);
    }

    @Test
    public void testSequentialShortLEAccess() {
        this.testSequentialShortAccess(false);
    }

    private void testSequentialShortAccess(boolean testBigEndian) {
        short value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeShort((int)value);
                continue;
            }
            this.buffer.writeShortLE((int)value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = (short)this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readShort());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readShortLE());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedShortAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    @Test
    public void testSequentialUnsignedShortLEAccess() {
        this.testSequentialUnsignedShortAccess(true);
    }

    private void testSequentialUnsignedShortAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeShort(value);
                continue;
            }
            this.buffer.writeShortLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 2) {
            value = this.random.nextInt() & 0xFFFF;
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readUnsignedShort());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readUnsignedShortLE());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialMediumAccess() {
        this.testSequentialMediumAccess(true);
    }

    @Test
    public void testSequentialMediumLEAccess() {
        this.testSequentialMediumAccess(false);
    }

    private void testSequentialMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.writerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() % 3), (long)this.buffer.writableBytes());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() << 8 >> 8;
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readMedium());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readMediumLE());
        }
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.writerIndex());
        Assert.assertEquals((long)0L, (long)this.buffer.readableBytes());
        Assert.assertEquals((long)(this.buffer.capacity() % 3), (long)this.buffer.writableBytes());
    }

    @Test
    public void testSequentialUnsignedMediumAccess() {
        this.testSequentialUnsignedMediumAccess(true);
    }

    @Test
    public void testSequentialUnsignedMediumLEAccess() {
        this.testSequentialUnsignedMediumAccess(false);
    }

    private void testSequentialUnsignedMediumAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeMedium(value);
                continue;
            }
            this.buffer.writeMediumLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.writerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() % 3), (long)this.buffer.writableBytes());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity() / 3 * 3; i += 3) {
            value = this.random.nextInt() & 0xFFFFFF;
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readUnsignedMedium());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readUnsignedMediumLE());
        }
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() / 3 * 3), (long)this.buffer.writerIndex());
        Assert.assertEquals((long)0L, (long)this.buffer.readableBytes());
        Assert.assertEquals((long)(this.buffer.capacity() % 3), (long)this.buffer.writableBytes());
    }

    @Test
    public void testSequentialIntAccess() {
        this.testSequentialIntAccess(true);
    }

    @Test
    public void testSequentialIntLEAccess() {
        this.testSequentialIntAccess(false);
    }

    private void testSequentialIntAccess(boolean testBigEndian) {
        int value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readInt());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readIntLE());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialUnsignedIntAccess() {
        this.testSequentialUnsignedIntAccess(true);
    }

    @Test
    public void testSequentialUnsignedIntLEAccess() {
        this.testSequentialUnsignedIntAccess(false);
    }

    private void testSequentialUnsignedIntAccess(boolean testBigEndian) {
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            int value = this.random.nextInt();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeInt(value);
                continue;
            }
            this.buffer.writeIntLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 4) {
            long value = (long)this.random.nextInt() & 0xFFFFFFFFL;
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readUnsignedInt());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readUnsignedIntLE());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testSequentialLongAccess() {
        this.testSequentialLongAccess(true);
    }

    @Test
    public void testSequentialLongLEAccess() {
        this.testSequentialLongAccess(false);
    }

    private void testSequentialLongAccess(boolean testBigEndian) {
        long value;
        int i;
        this.buffer.writerIndex(0);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            Assert.assertTrue((boolean)this.buffer.isWritable());
            if (testBigEndian) {
                this.buffer.writeLong(value);
                continue;
            }
            this.buffer.writeLongLE(value);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isWritable());
        this.random.setSeed(this.seed);
        for (i = 0; i < this.buffer.capacity(); i += 8) {
            value = this.random.nextLong();
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertTrue((boolean)this.buffer.isReadable());
            if (testBigEndian) {
                Assert.assertEquals((long)value, (long)this.buffer.readLong());
                continue;
            }
            Assert.assertEquals((long)value, (long)this.buffer.readLongLE());
        }
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        Assert.assertFalse((boolean)this.buffer.isReadable());
        Assert.assertFalse((boolean)this.buffer.isWritable());
    }

    @Test
    public void testByteArrayTransfer() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue[j], (long)value[j]);
            }
        }
    }

    @Test
    public void testRandomByteArrayTransfer1() {
        byte[] value = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            this.buffer.getBytes(i, value);
            for (int j = 0; j < 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value[j]);
            }
        }
    }

    @Test
    public void testRandomByteArrayTransfer2() {
        byte[] value = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value[j]);
            }
        }
    }

    @Test
    public void testRandomHeapBufferTransfer1() {
        byte[] valueContent = new byte[128];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setIndex(0, 128);
            this.buffer.setBytes(i, value);
            Assert.assertEquals((long)128L, (long)value.readerIndex());
            Assert.assertEquals((long)128L, (long)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[128];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.clear();
            this.buffer.getBytes(i, value);
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)128L, (long)value.writerIndex());
            for (int j = 0; j < 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
        }
    }

    @Test
    public void testRandomHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
        }
    }

    @Test
    public void testRandomDirectBufferTransfer() {
        byte[] tmp = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            value.setBytes(0, tmp, 0, value.capacity());
            this.buffer.setBytes(i, value, this.random.nextInt(128), 128);
        }
        this.random.setSeed(this.seed);
        ByteBuf expectedValue = Unpooled.directBuffer((int)256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(tmp);
            expectedValue.setBytes(0, tmp, 0, expectedValue.capacity());
            int valueOffset = this.random.nextInt(128);
            this.buffer.getBytes(i, value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testRandomByteBufferTransfer() {
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.setBytes(i, value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.getBytes(i, value);
            Assert.assertEquals((long)(valueOffset + 128), (long)value.position());
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.get(j), (long)value.get(j));
            }
        }
    }

    @Test
    public void testSequentialByteArrayTransfer1() {
        byte[] value = new byte[128];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            this.buffer.readBytes(value);
            for (int j = 0; j < 128; ++j) {
                Assert.assertEquals((long)expectedValue[j], (long)value[j]);
            }
        }
    }

    @Test
    public void testSequentialByteArrayTransfer2() {
        byte[] value = new byte[256];
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            this.buffer.writeBytes(value, readerIndex, 128);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[256];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            int valueOffset = this.random.nextInt(128);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue[j], (long)value[j]);
            }
        }
    }

    @Test
    public void testSequentialHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)valueContent.length, (long)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)valueContent.length, (long)value.writerIndex());
        }
    }

    @Test
    public void testSequentialHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((byte[])valueContent);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(readerIndex);
            value.writerIndex(readerIndex + 128);
            this.buffer.writeBytes(value);
            Assert.assertEquals((long)(readerIndex + 128), (long)value.writerIndex());
            Assert.assertEquals((long)value.writerIndex(), (long)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)valueOffset, (long)value.readerIndex());
            Assert.assertEquals((long)(valueOffset + 128), (long)value.writerIndex());
        }
    }

    @Test
    public void testSequentialDirectBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)0L, (long)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)0L, (long)value.writerIndex());
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testSequentialDirectBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.directBuffer((int)256);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            Assert.assertEquals((long)(readerIndex + 128), (long)value.writerIndex());
            Assert.assertEquals((long)value.writerIndex(), (long)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)valueOffset, (long)value.readerIndex());
            Assert.assertEquals((long)(valueOffset + 128), (long)value.writerIndex());
        }
        value.release();
        expectedValue.release();
    }

    @Test
    public void testSequentialByteBufferBackedHeapBufferTransfer1() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value, this.random.nextInt(128), 128);
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)0L, (long)value.writerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            int valueOffset = this.random.nextInt(128);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            this.buffer.readBytes(value, valueOffset, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)0L, (long)value.readerIndex());
            Assert.assertEquals((long)0L, (long)value.writerIndex());
        }
    }

    @Test
    public void testSequentialByteBufferBackedHeapBufferTransfer2() {
        byte[] valueContent = new byte[256];
        ByteBuf value = Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocate(256));
        value.writerIndex(0);
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(valueContent);
            value.setBytes(0, valueContent);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            int readerIndex = this.random.nextInt(128);
            value.readerIndex(0);
            value.writerIndex(readerIndex + 128);
            value.readerIndex(readerIndex);
            this.buffer.writeBytes(value);
            Assert.assertEquals((long)(readerIndex + 128), (long)value.writerIndex());
            Assert.assertEquals((long)value.writerIndex(), (long)value.readerIndex());
        }
        this.random.setSeed(this.seed);
        byte[] expectedValueContent = new byte[256];
        ByteBuf expectedValue = Unpooled.wrappedBuffer((byte[])expectedValueContent);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValueContent);
            value.setBytes(0, valueContent);
            int valueOffset = this.random.nextInt(128);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            value.readerIndex(valueOffset);
            value.writerIndex(valueOffset);
            this.buffer.readBytes(value, 128);
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.getByte(j), (long)value.getByte(j));
            }
            Assert.assertEquals((long)valueOffset, (long)value.readerIndex());
            Assert.assertEquals((long)(valueOffset + 128), (long)value.writerIndex());
        }
    }

    @Test
    public void testSequentialByteBufferTransfer() {
        this.buffer.writerIndex(0);
        ByteBuffer value = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(value.array());
            value.clear().position(this.random.nextInt(128));
            value.limit(value.position() + 128);
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        ByteBuffer expectedValue = ByteBuffer.allocate(256);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue.array());
            int valueOffset = this.random.nextInt(128);
            value.clear().position(valueOffset).limit(valueOffset + 128);
            this.buffer.readBytes(value);
            Assert.assertEquals((long)(valueOffset + 128), (long)value.position());
            for (int j = valueOffset; j < valueOffset + 128; ++j) {
                Assert.assertEquals((long)expectedValue.get(j), (long)value.get(j));
            }
        }
    }

    @Test
    public void testSequentialCopiedBufferTransfer1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            ByteBuf actualValue = this.buffer.readBytes(128);
            Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])expectedValue), (Object)actualValue);
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            Assert.assertFalse((this.buffer.getByte(i) == actualValue.getByte(0) ? 1 : 0) != 0);
            actualValue.release();
        }
    }

    @Test
    public void testSequentialSlice1() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            byte[] value = new byte[128];
            this.random.nextBytes(value);
            Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes(value);
        }
        this.random.setSeed(this.seed);
        byte[] expectedValue = new byte[128];
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.random.nextBytes(expectedValue);
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            Assert.assertEquals((long)4096L, (long)this.buffer.writerIndex());
            ByteBuf actualValue = this.buffer.readSlice(128);
            Assert.assertEquals((Object)this.buffer.order(), (Object)actualValue.order());
            Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])expectedValue), (Object)actualValue);
            actualValue.setByte(0, (int)((byte)(actualValue.getByte(0) + 1)));
            Assert.assertEquals((long)this.buffer.getByte(i), (long)actualValue.getByte(0));
        }
    }

    @Test
    public void testWriteZero() {
        int i;
        int length;
        try {
            this.buffer.writeZero(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.buffer.clear();
        while (this.buffer.isWritable()) {
            this.buffer.writeByte(-1);
        }
        this.buffer.clear();
        for (i = 0; i < this.buffer.capacity(); i += length) {
            length = Math.min(this.buffer.capacity() - i, this.random.nextInt(32));
            this.buffer.writeZero(length);
        }
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.writerIndex());
        for (i = 0; i < this.buffer.capacity(); ++i) {
            Assert.assertEquals((long)0L, (long)this.buffer.getByte(i));
        }
    }

    @Test
    public void testDiscardReadBytes() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); i += 4) {
            this.buffer.writeInt(i);
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.readerIndex(1024);
        this.buffer.markReaderIndex();
        this.buffer.writerIndex(1365);
        this.buffer.markWriterIndex();
        this.buffer.readerIndex(0);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)2048L, (long)this.buffer.writerIndex());
        Assert.assertEquals((Object)copy.slice(0, 2048), (Object)this.buffer.slice(0, 2048));
        this.buffer.resetReaderIndex();
        Assert.assertEquals((long)1024L, (long)this.buffer.readerIndex());
        this.buffer.resetWriterIndex();
        Assert.assertEquals((long)1365L, (long)this.buffer.writerIndex());
        this.buffer.readerIndex(1);
        this.buffer.writerIndex(2048);
        this.buffer.discardReadBytes();
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)2047L, (long)this.buffer.writerIndex());
        Assert.assertEquals((Object)copy.slice(1, 2047), (Object)this.buffer.slice(0, 2047));
        if (this.discardReadBytesDoesNotMoveWritableBytes()) {
            Assert.assertFalse((boolean)copy.slice(2048, 2048).equals((Object)this.buffer.slice(2047, 2048)));
        } else {
            Assert.assertEquals((Object)copy.slice(2048, 2048), (Object)this.buffer.slice(2047, 2048));
        }
        this.buffer.resetReaderIndex();
        Assert.assertEquals((long)1023L, (long)this.buffer.readerIndex());
        this.buffer.resetWriterIndex();
        Assert.assertEquals((long)1364L, (long)this.buffer.writerIndex());
        copy.release();
    }

    @Test
    public void testDiscardReadBytes2() {
        this.buffer.writerIndex(0);
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            this.buffer.writeByte((int)((byte)i));
        }
        ByteBuf copy = Unpooled.copiedBuffer((ByteBuf)this.buffer);
        this.buffer.setIndex(2047, 4095);
        this.buffer.discardReadBytes();
        Assert.assertEquals((long)0L, (long)this.buffer.readerIndex());
        Assert.assertEquals((long)2048L, (long)this.buffer.writerIndex());
        for (int i = 0; i < 2048; ++i) {
            Assert.assertEquals((Object)copy.slice(2047 + i, 2048 - i), (Object)this.buffer.slice(i, 2048 - i));
        }
        copy.release();
    }

    @Test
    public void testStreamTransfer1() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            Assert.assertEquals((long)128L, (long)this.buffer.setBytes(i, (InputStream)in, 128));
            Assert.assertEquals((long)-1L, (long)this.buffer.setBytes(i, (InputStream)in, 0));
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            this.buffer.getBytes(i, (OutputStream)out, 128);
        }
        Assert.assertTrue((boolean)Arrays.equals(expected, out.toByteArray()));
    }

    @Test
    public void testStreamTransfer2() throws Exception {
        byte[] expected = new byte[this.buffer.capacity()];
        this.random.nextBytes(expected);
        this.buffer.clear();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            ByteArrayInputStream in = new ByteArrayInputStream(expected, i, 128);
            Assert.assertEquals((long)i, (long)this.buffer.writerIndex());
            this.buffer.writeBytes((InputStream)in, 128);
            Assert.assertEquals((long)(i + 128), (long)this.buffer.writerIndex());
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            Assert.assertEquals((long)i, (long)this.buffer.readerIndex());
            this.buffer.readBytes((OutputStream)out, 128);
            Assert.assertEquals((long)(i + 128), (long)this.buffer.readerIndex());
        }
        Assert.assertTrue((boolean)Arrays.equals(expected, out.toByteArray()));
    }

    @Test
    public void testCopy() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf copy = this.buffer.copy();
        Assert.assertEquals((long)0L, (long)copy.readerIndex());
        Assert.assertEquals((long)this.buffer.readableBytes(), (long)copy.writerIndex());
        Assert.assertEquals((long)this.buffer.readableBytes(), (long)copy.capacity());
        Assert.assertSame((Object)this.buffer.order(), (Object)copy.order());
        for (int i = 0; i < copy.capacity(); ++i) {
            Assert.assertEquals((long)this.buffer.getByte(i + 1365), (long)copy.getByte(i));
        }
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        Assert.assertTrue((this.buffer.getByte(1365) != copy.getByte(0) ? 1 : 0) != 0);
        copy.setByte(1, (int)((byte)(copy.getByte(1) + 1)));
        Assert.assertTrue((this.buffer.getByte(1366) != copy.getByte(1) ? 1 : 0) != 0);
        copy.release();
    }

    @Test
    public void testDuplicate() {
        for (int i = 0; i < this.buffer.capacity(); ++i) {
            byte value = (byte)this.random.nextInt();
            this.buffer.setByte(i, (int)value);
        }
        int readerIndex = 1365;
        int writerIndex = 2730;
        this.buffer.setIndex(1365, 2730);
        ByteBuf duplicate = this.buffer.duplicate();
        Assert.assertSame((Object)this.buffer.order(), (Object)duplicate.order());
        Assert.assertEquals((long)this.buffer.readableBytes(), (long)duplicate.readableBytes());
        Assert.assertEquals((long)0L, (long)this.buffer.compareTo(duplicate));
        this.buffer.setByte(1365, (int)((byte)(this.buffer.getByte(1365) + 1)));
        Assert.assertEquals((long)this.buffer.getByte(1365), (long)duplicate.getByte(duplicate.readerIndex()));
        duplicate.setByte(duplicate.readerIndex(), (int)((byte)(duplicate.getByte(duplicate.readerIndex()) + 1)));
        Assert.assertEquals((long)this.buffer.getByte(1365), (long)duplicate.getByte(duplicate.readerIndex()));
    }

    @Test
    public void testSliceEndianness() throws Exception {
        Assert.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(0, this.buffer.capacity()).order());
        Assert.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(0, this.buffer.capacity() - 1).order());
        Assert.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(1, this.buffer.capacity() - 1).order());
        Assert.assertEquals((Object)this.buffer.order(), (Object)this.buffer.slice(1, this.buffer.capacity() - 2).order());
    }

    @Test
    public void testSliceIndex() throws Exception {
        Assert.assertEquals((long)0L, (long)this.buffer.slice(0, this.buffer.capacity()).readerIndex());
        Assert.assertEquals((long)0L, (long)this.buffer.slice(0, this.buffer.capacity() - 1).readerIndex());
        Assert.assertEquals((long)0L, (long)this.buffer.slice(1, this.buffer.capacity() - 1).readerIndex());
        Assert.assertEquals((long)0L, (long)this.buffer.slice(1, this.buffer.capacity() - 2).readerIndex());
        Assert.assertEquals((long)this.buffer.capacity(), (long)this.buffer.slice(0, this.buffer.capacity()).writerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() - 1), (long)this.buffer.slice(0, this.buffer.capacity() - 1).writerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() - 1), (long)this.buffer.slice(1, this.buffer.capacity() - 1).writerIndex());
        Assert.assertEquals((long)(this.buffer.capacity() - 2), (long)this.buffer.slice(1, this.buffer.capacity() - 2).writerIndex());
    }

    @Test
    public void testRetainedSliceIndex() throws Exception {
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        Assert.assertEquals((long)0L, (long)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        Assert.assertEquals((long)0L, (long)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        Assert.assertEquals((long)0L, (long)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        Assert.assertEquals((long)0L, (long)retainedSlice.readerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity());
        Assert.assertEquals((long)this.buffer.capacity(), (long)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, this.buffer.capacity() - 1);
        Assert.assertEquals((long)(this.buffer.capacity() - 1), (long)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 1);
        Assert.assertEquals((long)(this.buffer.capacity() - 1), (long)retainedSlice.writerIndex());
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(1, this.buffer.capacity() - 2);
        Assert.assertEquals((long)(this.buffer.capacity() - 2), (long)retainedSlice.writerIndex());
        retainedSlice.release();
    }

    @Test
    public void testEquals() {
        Assert.assertFalse((boolean)this.buffer.equals(null));
        Assert.assertFalse((boolean)this.buffer.equals(new Object()));
        byte[] value = new byte[32];
        this.buffer.setIndex(0, value.length);
        this.random.nextBytes(value);
        this.buffer.setBytes(0, value);
        Assert.assertEquals((Object)this.buffer, (Object)Unpooled.wrappedBuffer((byte[])value));
        Assert.assertEquals((Object)this.buffer, (Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN));
        value[0] = (byte)(value[0] + 1);
        Assert.assertFalse((boolean)this.buffer.equals((Object)Unpooled.wrappedBuffer((byte[])value)));
        Assert.assertFalse((boolean)this.buffer.equals((Object)Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)));
    }

    @Test
    public void testCompareTo() {
        try {
            this.buffer.compareTo(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        byte[] value = new byte[32];
        this.random.nextBytes(value);
        if (value[0] == 0) {
            value[0] = (byte)(value[0] + 1);
        } else if (value[0] == -1) {
            value[0] = (byte)(value[0] - 1);
        }
        this.buffer.setIndex(0, value.length);
        this.buffer.setBytes(0, value);
        Assert.assertEquals((long)0L, (long)this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)));
        Assert.assertEquals((long)0L, (long)this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)));
        value[0] = (byte)(value[0] + 1);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        value[0] = (byte)(value[0] - 2);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) > 0 ? 1 : 0) != 0);
        value[0] = (byte)(value[0] + 1);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.compareTo(Unpooled.wrappedBuffer((byte[])value, (int)0, (int)31).order(Unpooled.LITTLE_ENDIAN)) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.slice(0, 31).compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.buffer.slice(0, 31).compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        ByteBuf retainedSlice = this.buffer.retainedSlice(0, 31);
        Assert.assertTrue((retainedSlice.compareTo(Unpooled.wrappedBuffer((byte[])value)) < 0 ? 1 : 0) != 0);
        retainedSlice.release();
        retainedSlice = this.buffer.retainedSlice(0, 31);
        Assert.assertTrue((retainedSlice.compareTo(Unpooled.wrappedBuffer((byte[])value).order(Unpooled.LITTLE_ENDIAN)) < 0 ? 1 : 0) != 0);
        retainedSlice.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompareTo2() {
        byte[] bytes = new byte[]{1, 2, 3, 4};
        byte[] bytesReversed = new byte[]{4, 3, 2, 1};
        ByteBuf buf1 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf2 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.LITTLE_ENDIAN);
        ByteBuf buf3 = this.newBuffer(4).clear().writeBytes(bytes).order(ByteOrder.BIG_ENDIAN);
        ByteBuf buf4 = this.newBuffer(4).clear().writeBytes(bytesReversed).order(ByteOrder.BIG_ENDIAN);
        try {
            Assert.assertEquals((long)buf1.compareTo(buf2), (long)buf3.compareTo(buf4));
            Assert.assertEquals((long)buf2.compareTo(buf1), (long)buf4.compareTo(buf3));
            Assert.assertEquals((long)buf1.compareTo(buf3), (long)buf2.compareTo(buf4));
            Assert.assertEquals((long)buf3.compareTo(buf1), (long)buf4.compareTo(buf2));
        }
        finally {
            buf1.release();
            buf2.release();
            buf3.release();
            buf4.release();
        }
    }

    @Test
    public void testToString() {
        ByteBuf copied = Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.ISO_8859_1);
        this.buffer.clear();
        this.buffer.writeBytes(copied);
        Assert.assertEquals((Object)"Hello, World!", (Object)this.buffer.toString(CharsetUtil.ISO_8859_1));
        copied.release();
    }

    @Test(timeout=10000L)
    public void testToStringMultipleThreads() throws Throwable {
        this.buffer.clear();
        this.buffer.writeBytes("Hello, World!".getBytes(CharsetUtil.ISO_8859_1));
        final AtomicInteger counter = new AtomicInteger(30000);
        final AtomicReference errorRef = new AtomicReference();
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (errorRef.get() == null && counter.decrementAndGet() > 0) {
                            Assert.assertEquals((Object)"Hello, World!", (Object)AbstractByteBufTest.this.buffer.toString(CharsetUtil.ISO_8859_1));
                        }
                    }
                    catch (Throwable cause) {
                        errorRef.compareAndSet(null, cause);
                    }
                }
            });
            threads.add(thread);
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Throwable error = (Throwable)errorRef.get();
        if (error != null) {
            throw error;
        }
    }

    @Test
    public void testIndexOf() {
        this.buffer.clear();
        this.buffer.setZero(0, this.buffer.capacity());
        this.buffer.writeByte(1);
        this.buffer.writeByte(2);
        this.buffer.writeByte(3);
        this.buffer.writeByte(2);
        this.buffer.writeByte(1);
        Assert.assertEquals((long)-1L, (long)this.buffer.indexOf(1, 4, (byte)1));
        Assert.assertEquals((long)-1L, (long)this.buffer.indexOf(4, 1, (byte)1));
        Assert.assertEquals((long)1L, (long)this.buffer.indexOf(1, 4, (byte)2));
        Assert.assertEquals((long)3L, (long)this.buffer.indexOf(4, 1, (byte)2));
        try {
            this.buffer.indexOf(0, this.buffer.capacity() + 1, (byte)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            this.buffer.indexOf(this.buffer.capacity(), -1, (byte)0);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)4L, (long)this.buffer.indexOf(this.buffer.capacity() + 1, 0, (byte)1));
        Assert.assertEquals((long)0L, (long)this.buffer.indexOf(-1, this.buffer.capacity(), (byte)1));
    }

    @Test
    public void testIndexOfReleaseBuffer() {
        ByteBuf buffer = this.releasedBuffer();
        if (buffer.capacity() != 0) {
            try {
                buffer.indexOf(0, 1, (byte)1);
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {}
        } else {
            Assert.assertEquals((long)-1L, (long)buffer.indexOf(0, 1, (byte)1));
        }
    }

    @Test
    public void testNioBuffer1() {
        Assume.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value), this.buffer.nioBuffer());
    }

    @Test
    public void testToByteBuffer2() {
        Assume.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        byte[] value = new byte[this.buffer.capacity()];
        this.random.nextBytes(value);
        this.buffer.clear();
        this.buffer.writeBytes(value);
        for (int i = 0; i < this.buffer.capacity() - 128 + 1; i += 128) {
            AbstractByteBufTest.assertRemainingEquals(ByteBuffer.wrap(value, i, 128), this.buffer.nioBuffer(i, 128));
        }
    }

    private static void assertRemainingEquals(ByteBuffer expected, ByteBuffer actual) {
        int remaining = expected.remaining();
        int remaining2 = actual.remaining();
        Assert.assertEquals((long)remaining, (long)remaining2);
        byte[] array1 = new byte[remaining];
        byte[] array2 = new byte[remaining2];
        expected.get(array1);
        actual.get(array2);
        Assert.assertArrayEquals((byte[])array1, (byte[])array2);
    }

    @Test
    public void testToByteBuffer3() {
        Assume.assumeTrue((this.buffer.nioBufferCount() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.buffer.order(), (Object)this.buffer.nioBuffer().order());
    }

    @Test
    public void testSkipBytes1() {
        this.buffer.setIndex(1024, 2048);
        this.buffer.skipBytes(1024);
        Assert.assertEquals((long)2048L, (long)this.buffer.readerIndex());
        try {
            this.buffer.skipBytes(1025);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        Assert.assertEquals((long)2048L, (long)this.buffer.readerIndex());
    }

    @Test
    public void testHashCode() {
        ByteBuf elemA = Unpooled.buffer((int)15);
        ByteBuf elemB = Unpooled.directBuffer((int)15);
        elemA.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 1, 2, 3, 4, 5});
        elemB.writeBytes(new byte[]{6, 7, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 9});
        HashSet<ByteBuf> set = new HashSet<ByteBuf>();
        set.add(elemA);
        set.add(elemB);
        Assert.assertEquals((long)2L, (long)set.size());
        ByteBuf elemACopy = elemA.copy();
        Assert.assertTrue((boolean)set.contains(elemACopy));
        ByteBuf elemBCopy = elemB.copy();
        Assert.assertTrue((boolean)set.contains(elemBCopy));
        this.buffer.clear();
        this.buffer.writeBytes(elemA.duplicate());
        Assert.assertTrue((boolean)set.remove(this.buffer));
        Assert.assertFalse((boolean)set.contains(elemA));
        Assert.assertEquals((long)1L, (long)set.size());
        this.buffer.clear();
        this.buffer.writeBytes(elemB.duplicate());
        Assert.assertTrue((boolean)set.remove(this.buffer));
        Assert.assertFalse((boolean)set.contains(elemB));
        Assert.assertEquals((long)0L, (long)set.size());
        elemA.release();
        elemB.release();
        elemACopy.release();
        elemBCopy.release();
    }

    @Test
    public void testDiscardAllReadBytes() {
        this.buffer.writerIndex(this.buffer.capacity());
        this.buffer.readerIndex(this.buffer.writerIndex());
        this.buffer.discardReadBytes();
    }

    @Test
    public void testForEachByte() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        this.buffer.setIndex(1024, 3072);
        Assert.assertThat((Object)this.buffer.forEachByte(new ByteProcessor(){
            int i = 1024;

            public boolean process(byte value) throws Exception {
                Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)((byte)(this.i + 1))));
                lastIndex.set(this.i);
                ++this.i;
                return true;
            }
        }), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)lastIndex.get(), (Matcher)CoreMatchers.is((Object)3071));
    }

    @Test
    public void testForEachByteAbort() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        int stop = 2048;
        Assert.assertThat((Object)this.buffer.forEachByte(1365, 1365, new ByteProcessor(){
            int i = 1365;

            public boolean process(byte value) throws Exception {
                Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)((byte)(this.i + 1))));
                if (this.i == 2048) {
                    return false;
                }
                ++this.i;
                return true;
            }
        }), (Matcher)CoreMatchers.is((Object)2048));
    }

    @Test
    public void testForEachByteDesc() {
        this.buffer.clear();
        for (int i = 0; i < 4096; ++i) {
            this.buffer.writeByte(i + 1);
        }
        final AtomicInteger lastIndex = new AtomicInteger();
        Assert.assertThat((Object)this.buffer.forEachByteDesc(1024, 2048, new ByteProcessor(){
            int i = 3071;

            public boolean process(byte value) throws Exception {
                Assert.assertThat((Object)value, (Matcher)CoreMatchers.is((Object)((byte)(this.i + 1))));
                lastIndex.set(this.i);
                --this.i;
                return true;
            }
        }), (Matcher)CoreMatchers.is((Object)-1));
        Assert.assertThat((Object)lastIndex.get(), (Matcher)CoreMatchers.is((Object)1024));
    }

    @Test
    public void testInternalNioBuffer() {
        this.testInternalNioBuffer(128);
        this.testInternalNioBuffer(1024);
        this.testInternalNioBuffer(4096);
        this.testInternalNioBuffer(65536);
        this.testInternalNioBuffer(0x2000000);
        this.testInternalNioBuffer(0x4000000);
    }

    private void testInternalNioBuffer(int a) {
        ByteBuf buffer = this.newBuffer(2);
        ByteBuffer buf = buffer.internalNioBuffer(buffer.readerIndex(), 1);
        Assert.assertEquals((long)1L, (long)buf.remaining());
        byte[] data = new byte[a];
        PlatformDependent.threadLocalRandom().nextBytes(data);
        buffer.writeBytes(data);
        buf = buffer.internalNioBuffer(buffer.readerIndex(), a);
        Assert.assertEquals((long)a, (long)buf.remaining());
        for (int i = 0; i < a; ++i) {
            Assert.assertEquals((long)data[i], (long)buf.get());
        }
        Assert.assertFalse((boolean)buf.hasRemaining());
        buffer.release();
    }

    @Test
    public void testDuplicateReadGatheringByteChannelMultipleThreads() throws Exception {
        this.testReadGatheringByteChannelMultipleThreads(false);
    }

    @Test
    public void testSliceReadGatheringByteChannelMultipleThreads() throws Exception {
        this.testReadGatheringByteChannelMultipleThreads(true);
    }

    private void testReadGatheringByteChannelMultipleThreads(final boolean slice) throws Exception {
        final byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        final ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        TestGatheringByteChannel channel = new TestGatheringByteChannel();
                        while (buf.isReadable()) {
                            try {
                                buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        Assert.assertArrayEquals((byte[])bytes, (byte[])channel.writtenBytes());
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
        buffer.release();
    }

    @Test
    public void testDuplicateReadOutputStreamMultipleThreads() throws Exception {
        this.testReadOutputStreamMultipleThreads(false);
    }

    @Test
    public void testSliceReadOutputStreamMultipleThreads() throws Exception {
        this.testReadOutputStreamMultipleThreads(true);
    }

    private void testReadOutputStreamMultipleThreads(final boolean slice) throws Exception {
        final byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        final ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        while (buf.isReadable()) {
                            try {
                                buf.readBytes((OutputStream)out, buf.readableBytes());
                            }
                            catch (IOException e) {
                                return;
                            }
                        }
                        Assert.assertArrayEquals((byte[])bytes, (byte[])out.toByteArray());
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
        buffer.release();
    }

    @Test
    public void testDuplicateBytesInArrayMultipleThreads() throws Exception {
        this.testBytesInArrayMultipleThreads(false);
    }

    @Test
    public void testSliceBytesInArrayMultipleThreads() throws Exception {
        this.testBytesInArrayMultipleThreads(true);
    }

    private void testBytesInArrayMultipleThreads(final boolean slice) throws Exception {
        final byte[] bytes = new byte[8];
        this.random.nextBytes(bytes);
        final ByteBuf buffer = this.newBuffer(8);
        buffer.writeBytes(bytes);
        final AtomicReference cause = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(60000);
        final CyclicBarrier barrier = new CyclicBarrier(11);
        for (int i = 0; i < 10; ++i) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (cause.get() == null && latch.getCount() > 0L) {
                        ByteBuf buf = slice ? buffer.slice() : buffer.duplicate();
                        byte[] array = new byte[8];
                        buf.readBytes(array);
                        Assert.assertArrayEquals((byte[])bytes, (byte[])array);
                        Arrays.fill(array, (byte)0);
                        buf.getBytes(0, array);
                        Assert.assertArrayEquals((byte[])bytes, (byte[])array);
                        latch.countDown();
                    }
                    try {
                        barrier.await();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }).start();
        }
        latch.await(10L, TimeUnit.SECONDS);
        barrier.await(5L, TimeUnit.SECONDS);
        Assert.assertNull(cause.get());
        buffer.release();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void readByteThrowsIndexOutOfBoundsException() {
        ByteBuf buffer = this.newBuffer(8);
        try {
            buffer.writeByte(0);
            Assert.assertEquals((long)0L, (long)buffer.readByte());
            buffer.readByte();
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testNioBufferExposeOnlyRegion() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] data = new byte[8];
        this.random.nextBytes(data);
        buffer.writeBytes(data);
        ByteBuffer nioBuf = buffer.nioBuffer(1, data.length - 2);
        Assert.assertEquals((long)0L, (long)nioBuf.position());
        Assert.assertEquals((long)6L, (long)nioBuf.remaining());
        int i = 1;
        while (nioBuf.hasRemaining()) {
            Assert.assertEquals((long)data[i], (long)nioBuf.get());
            ++i;
        }
        buffer.release();
    }

    @Test
    public void ensureWritableWithForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(true);
    }

    @Test
    public void ensureWritableWithOutForceDoesNotThrow() {
        this.ensureWritableDoesNotThrow(false);
    }

    private void ensureWritableDoesNotThrow(boolean force) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writerIndex(buffer.capacity());
        buffer.ensureWritable(8, force);
        buffer.release();
    }

    @Test
    public void testLittleEndianWithExpand() {
        ByteBuf buffer = this.newBuffer(0).order(Unpooled.LITTLE_ENDIAN);
        buffer.writeInt(305419896);
        Assert.assertEquals((Object)"78563412", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
        buffer.release();
    }

    private ByteBuf releasedBuffer() {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        Assert.assertTrue((boolean)buffer.release());
        return buffer;
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testDiscardReadBytesAfterRelease() {
        this.releasedBuffer().discardReadBytes();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testDiscardSomeReadBytesAfterRelease() {
        this.releasedBuffer().discardSomeReadBytes();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testEnsureWritableAfterRelease() {
        this.releasedBuffer().ensureWritable(16);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBooleanAfterRelease() {
        this.releasedBuffer().getBoolean(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetByteAfterRelease() {
        this.releasedBuffer().getByte(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedByteAfterRelease() {
        this.releasedBuffer().getUnsignedByte(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetShortAfterRelease() {
        this.releasedBuffer().getShort(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetShortLEAfterRelease() {
        this.releasedBuffer().getShortLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedShortAfterRelease() {
        this.releasedBuffer().getUnsignedShort(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedShortLEAfterRelease() {
        this.releasedBuffer().getUnsignedShortLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetMediumAfterRelease() {
        this.releasedBuffer().getMedium(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetMediumLEAfterRelease() {
        this.releasedBuffer().getMediumLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedMediumAfterRelease() {
        this.releasedBuffer().getUnsignedMedium(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetIntAfterRelease() {
        this.releasedBuffer().getInt(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetIntLEAfterRelease() {
        this.releasedBuffer().getIntLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedIntAfterRelease() {
        this.releasedBuffer().getUnsignedInt(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetUnsignedIntLEAfterRelease() {
        this.releasedBuffer().getUnsignedIntLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetLongAfterRelease() {
        this.releasedBuffer().getLong(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetLongLEAfterRelease() {
        this.releasedBuffer().getLongLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetCharAfterRelease() {
        this.releasedBuffer().getChar(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetFloatAfterRelease() {
        this.releasedBuffer().getFloat(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetFloatLEAfterRelease() {
        this.releasedBuffer().getFloatLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetDoubleAfterRelease() {
        this.releasedBuffer().getDouble(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetDoubleLEAfterRelease() {
        this.releasedBuffer().getDoubleLE(0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().getBytes(0, buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            this.releasedBuffer().getBytes(0, buffer, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            this.releasedBuffer().getBytes(0, buffer, 0, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease4() {
        this.releasedBuffer().getBytes(0, new byte[8]);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease5() {
        this.releasedBuffer().getBytes(0, new byte[8], 0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease6() {
        this.releasedBuffer().getBytes(0, ByteBuffer.allocate(8));
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease7() throws IOException {
        this.releasedBuffer().getBytes(0, (OutputStream)new ByteArrayOutputStream(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testGetBytesAfterRelease8() throws IOException {
        this.releasedBuffer().getBytes(0, (GatheringByteChannel)new DevNullGatheringByteChannel(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBooleanAfterRelease() {
        this.releasedBuffer().setBoolean(0, true);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetByteAfterRelease() {
        this.releasedBuffer().setByte(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetShortAfterRelease() {
        this.releasedBuffer().setShort(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetShortLEAfterRelease() {
        this.releasedBuffer().setShortLE(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetMediumAfterRelease() {
        this.releasedBuffer().setMedium(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetMediumLEAfterRelease() {
        this.releasedBuffer().setMediumLE(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetIntAfterRelease() {
        this.releasedBuffer().setInt(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetIntLEAfterRelease() {
        this.releasedBuffer().setIntLE(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetLongAfterRelease() {
        this.releasedBuffer().setLong(0, 1L);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetLongLEAfterRelease() {
        this.releasedBuffer().setLongLE(0, 1L);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetCharAfterRelease() {
        this.releasedBuffer().setChar(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetFloatAfterRelease() {
        this.releasedBuffer().setFloat(0, 1.0f);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetDoubleAfterRelease() {
        this.releasedBuffer().setDouble(0, 1.0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            this.releasedBuffer().setBytes(0, buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            this.releasedBuffer().setBytes(0, buffer, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            this.releasedBuffer().setBytes(0, buffer, 0, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetUsAsciiCharSequenceAfterRelease() {
        this.testSetCharSequenceAfterRelease0(CharsetUtil.US_ASCII);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetIso88591CharSequenceAfterRelease() {
        this.testSetCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetUtf8CharSequenceAfterRelease() {
        this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_8);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetUtf16CharSequenceAfterRelease() {
        this.testSetCharSequenceAfterRelease0(CharsetUtil.UTF_16);
    }

    private void testSetCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().setCharSequence(0, (CharSequence)"x", charset);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease4() {
        this.releasedBuffer().setBytes(0, new byte[8]);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease5() {
        this.releasedBuffer().setBytes(0, new byte[8], 0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease6() {
        this.releasedBuffer().setBytes(0, ByteBuffer.allocate(8));
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease7() throws IOException {
        this.releasedBuffer().setBytes(0, (InputStream)new ByteArrayInputStream(new byte[8]), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetBytesAfterRelease8() throws IOException {
        this.releasedBuffer().setBytes(0, (ScatteringByteChannel)new TestScatteringByteChannel(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSetZeroAfterRelease() {
        this.releasedBuffer().setZero(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBooleanAfterRelease() {
        this.releasedBuffer().readBoolean();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadByteAfterRelease() {
        this.releasedBuffer().readByte();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedByteAfterRelease() {
        this.releasedBuffer().readUnsignedByte();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadShortAfterRelease() {
        this.releasedBuffer().readShort();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadShortLEAfterRelease() {
        this.releasedBuffer().readShortLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedShortAfterRelease() {
        this.releasedBuffer().readUnsignedShort();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedShortLEAfterRelease() {
        this.releasedBuffer().readUnsignedShortLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadMediumAfterRelease() {
        this.releasedBuffer().readMedium();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadMediumLEAfterRelease() {
        this.releasedBuffer().readMediumLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedMediumAfterRelease() {
        this.releasedBuffer().readUnsignedMedium();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedMediumLEAfterRelease() {
        this.releasedBuffer().readUnsignedMediumLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadIntAfterRelease() {
        this.releasedBuffer().readInt();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadIntLEAfterRelease() {
        this.releasedBuffer().readIntLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedIntAfterRelease() {
        this.releasedBuffer().readUnsignedInt();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadUnsignedIntLEAfterRelease() {
        this.releasedBuffer().readUnsignedIntLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadLongAfterRelease() {
        this.releasedBuffer().readLong();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadLongLEAfterRelease() {
        this.releasedBuffer().readLongLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadCharAfterRelease() {
        this.releasedBuffer().readChar();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadFloatAfterRelease() {
        this.releasedBuffer().readFloat();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadFloatLEAfterRelease() {
        this.releasedBuffer().readFloatLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadDoubleAfterRelease() {
        this.releasedBuffer().readDouble();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadDoubleLEAfterRelease() {
        this.releasedBuffer().readDoubleLE();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease() {
        this.releasedBuffer().readBytes(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().readBytes(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().readBytes(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease4() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().readBytes(buffer, 0, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease5() {
        this.releasedBuffer().readBytes(new byte[8]);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease6() {
        this.releasedBuffer().readBytes(new byte[8], 0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease7() {
        this.releasedBuffer().readBytes(ByteBuffer.allocate(8));
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease8() throws IOException {
        this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease9() throws IOException {
        this.releasedBuffer().readBytes((OutputStream)new ByteArrayOutputStream(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testReadBytesAfterRelease10() throws IOException {
        this.releasedBuffer().readBytes((GatheringByteChannel)new DevNullGatheringByteChannel(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBooleanAfterRelease() {
        this.releasedBuffer().writeBoolean(true);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteByteAfterRelease() {
        this.releasedBuffer().writeByte(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteShortAfterRelease() {
        this.releasedBuffer().writeShort(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteShortLEAfterRelease() {
        this.releasedBuffer().writeShortLE(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteMediumAfterRelease() {
        this.releasedBuffer().writeMedium(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteMediumLEAfterRelease() {
        this.releasedBuffer().writeMediumLE(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteIntAfterRelease() {
        this.releasedBuffer().writeInt(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteIntLEAfterRelease() {
        this.releasedBuffer().writeIntLE(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteLongAfterRelease() {
        this.releasedBuffer().writeLong(1L);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteLongLEAfterRelease() {
        this.releasedBuffer().writeLongLE(1L);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteCharAfterRelease() {
        this.releasedBuffer().writeChar(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteFloatAfterRelease() {
        this.releasedBuffer().writeFloat(1.0f);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteFloatLEAfterRelease() {
        this.releasedBuffer().writeFloatLE(1.0f);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteDoubleAfterRelease() {
        this.releasedBuffer().writeDouble(1.0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteDoubleLEAfterRelease() {
        this.releasedBuffer().writeDoubleLE(1.0);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().writeBytes(buffer);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease2() {
        ByteBuf buffer = Unpooled.copiedBuffer((byte[])new byte[8]);
        try {
            this.releasedBuffer().writeBytes(buffer, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease3() {
        ByteBuf buffer = Unpooled.buffer((int)8);
        try {
            this.releasedBuffer().writeBytes(buffer, 0, 1);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease4() {
        this.releasedBuffer().writeBytes(new byte[8]);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease5() {
        this.releasedBuffer().writeBytes(new byte[8], 0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease6() {
        this.releasedBuffer().writeBytes(ByteBuffer.allocate(8));
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease7() throws IOException {
        this.releasedBuffer().writeBytes((InputStream)new ByteArrayInputStream(new byte[8]), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteBytesAfterRelease8() throws IOException {
        this.releasedBuffer().writeBytes((ScatteringByteChannel)new TestScatteringByteChannel(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteZeroAfterRelease() throws IOException {
        this.releasedBuffer().writeZero(1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteUsAsciiCharSequenceAfterRelease() {
        this.testWriteCharSequenceAfterRelease0(CharsetUtil.US_ASCII);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteIso88591CharSequenceAfterRelease() {
        this.testWriteCharSequenceAfterRelease0(CharsetUtil.ISO_8859_1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteUtf8CharSequenceAfterRelease() {
        this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_8);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testWriteUtf16CharSequenceAfterRelease() {
        this.testWriteCharSequenceAfterRelease0(CharsetUtil.UTF_16);
    }

    private void testWriteCharSequenceAfterRelease0(Charset charset) {
        this.releasedBuffer().writeCharSequence((CharSequence)"x", charset);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testForEachByteAfterRelease() {
        this.releasedBuffer().forEachByte((ByteProcessor)new TestByteProcessor());
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testForEachByteAfterRelease1() {
        this.releasedBuffer().forEachByte(0, 1, (ByteProcessor)new TestByteProcessor());
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testForEachByteDescAfterRelease() {
        this.releasedBuffer().forEachByteDesc((ByteProcessor)new TestByteProcessor());
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testForEachByteDescAfterRelease1() {
        this.releasedBuffer().forEachByteDesc(0, 1, (ByteProcessor)new TestByteProcessor());
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testCopyAfterRelease() {
        this.releasedBuffer().copy();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testCopyAfterRelease1() {
        this.releasedBuffer().copy();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testNioBufferAfterRelease() {
        this.releasedBuffer().nioBuffer();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testNioBufferAfterRelease1() {
        this.releasedBuffer().nioBuffer(0, 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testInternalNioBufferAfterRelease() {
        ByteBuf releasedBuffer = this.releasedBuffer();
        releasedBuffer.internalNioBuffer(releasedBuffer.readerIndex(), 1);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testNioBuffersAfterRelease() {
        this.releasedBuffer().nioBuffers();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testNioBuffersAfterRelease2() {
        this.releasedBuffer().nioBuffers(0, 1);
    }

    @Test
    public void testArrayAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasArray()) {
            try {
                buf.array();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testMemoryAddressAfterRelease() {
        ByteBuf buf = this.releasedBuffer();
        if (buf.hasMemoryAddress()) {
            try {
                buf.memoryAddress();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSliceAfterRelease() {
        this.releasedBuffer().slice();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testSliceAfterRelease2() {
        this.releasedBuffer().slice(0, 1);
    }

    private static void assertSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                Assert.assertEquals((long)0L, (long)buf.refCnt());
                buf.slice();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainedSliceAfterRelease() {
        this.releasedBuffer().retainedSlice();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainedSliceAfterRelease2() {
        this.releasedBuffer().retainedSlice(0, 1);
    }

    private static void assertRetainedSliceFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                Assert.assertEquals((long)0L, (long)buf.refCnt());
                buf.retainedSlice();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedSliceRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedSliceAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertRetainedSliceFailAfterRelease(buf, buf2, buf3);
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testDuplicateAfterRelease() {
        this.releasedBuffer().duplicate();
    }

    @Test(expected=IllegalReferenceCountException.class)
    public void testRetainedDuplicateAfterRelease() {
        this.releasedBuffer().retainedDuplicate();
    }

    private static void assertDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                Assert.assertEquals((long)0L, (long)buf.refCnt());
                buf.duplicate();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testDuplicateAfterReleaseRetainedSliceDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        ByteBuf buf3 = buf2.duplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    @Test
    public void testDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testDuplicateAfterReleaseRetainedDuplicateSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        ByteBuf buf3 = buf2.slice(0, 1);
        AbstractByteBufTest.assertDuplicateFailAfterRelease(buf, buf2, buf3);
    }

    private static void assertRetainedDuplicateFailAfterRelease(ByteBuf ... bufs) {
        for (ByteBuf buf : bufs) {
            if (buf.refCnt() <= 0) continue;
            buf.release();
        }
        for (ByteBuf buf : bufs) {
            try {
                Assert.assertEquals((long)0L, (long)buf.refCnt());
                buf.retainedDuplicate();
                Assert.fail();
            }
            catch (IllegalReferenceCountException illegalReferenceCountException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRetainedDuplicateAfterReleaseRetainedDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedDuplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedDuplicateAfterReleaseDuplicate() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.duplicate();
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testRetainedDuplicateAfterReleaseRetainedSlice() {
        ByteBuf buf = this.newBuffer(1);
        ByteBuf buf2 = buf.retainedSlice(0, 1);
        AbstractByteBufTest.assertRetainedDuplicateFailAfterRelease(buf, buf2);
    }

    @Test
    public void testSliceRelease() {
        ByteBuf buf = this.newBuffer(8);
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertTrue((boolean)buf.slice().release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadSliceOutOfBounds() {
        this.testReadSliceOutOfBounds(false);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testReadRetainedSliceOutOfBounds() {
        this.testReadSliceOutOfBounds(true);
    }

    private void testReadSliceOutOfBounds(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(100);
        try {
            buf.writeZero(50);
            if (retainedSlice) {
                buf.readRetainedSlice(51);
            } else {
                buf.readSlice(51);
            }
            Assert.fail();
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testWriteUsAsciiCharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.US_ASCII);
    }

    @Test
    public void testWriteUtf8CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_8);
    }

    @Test
    public void testWriteIso88591CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testWriteUtf16CharSequenceExpand() {
        this.testWriteCharSequenceExpand(CharsetUtil.UTF_16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testWriteCharSequenceExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            int writerIndex = buf.capacity() - 1;
            buf.writerIndex(writerIndex);
            int written = buf.writeCharSequence((CharSequence)"AB", charset);
            Assert.assertEquals((long)writerIndex, (long)(buf.writerIndex() - written));
        }
        finally {
            buf.release();
        }
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetUsAsciiCharSequenceNoExpand() {
        this.testSetCharSequenceNoExpand(CharsetUtil.US_ASCII);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetUtf8CharSequenceNoExpand() {
        this.testSetCharSequenceNoExpand(CharsetUtil.UTF_8);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetIso88591CharSequenceNoExpand() {
        this.testSetCharSequenceNoExpand(CharsetUtil.ISO_8859_1);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSetUtf16CharSequenceNoExpand() {
        this.testSetCharSequenceNoExpand(CharsetUtil.UTF_16);
    }

    private void testSetCharSequenceNoExpand(Charset charset) {
        ByteBuf buf = this.newBuffer(1);
        try {
            buf.setCharSequence(0, (CharSequence)"AB", charset);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testSetUsAsciiCharSequence() {
        this.testSetGetCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    public void testSetUtf8CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    public void testSetIso88591CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testSetUtf16CharSequence() {
        this.testSetGetCharSequence(CharsetUtil.UTF_16);
    }

    private void testSetGetCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        int bytes = buf.setCharSequence(1, (CharSequence)sequence, charset);
        Assert.assertEquals((Object)sequence, (Object)CharBuffer.wrap(buf.getCharSequence(1, bytes, charset)));
        buf.release();
    }

    @Test
    public void testWriteReadUsAsciiCharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.US_ASCII);
    }

    @Test
    public void testWriteReadUtf8CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_8);
    }

    @Test
    public void testWriteReadIso88591CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.ISO_8859_1);
    }

    @Test
    public void testWriteReadUtf16CharSequence() {
        this.testWriteReadCharSequence(CharsetUtil.UTF_16);
    }

    private void testWriteReadCharSequence(Charset charset) {
        ByteBuf buf = this.newBuffer(1024);
        CharBuffer sequence = CharsetUtil.US_ASCII.equals(charset) ? ASCII_CHARS : EXTENDED_ASCII_CHARS;
        buf.writerIndex(1);
        int bytes = buf.writeCharSequence((CharSequence)sequence, charset);
        buf.readerIndex(1);
        Assert.assertEquals((Object)sequence, (Object)CharBuffer.wrap(buf.readCharSequence(bytes, charset)));
        buf.release();
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRetainedSliceIndexOutOfBounds() {
        this.testSliceOutOfBounds(true, true, true);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testRetainedSliceLengthOutOfBounds() {
        this.testSliceOutOfBounds(true, true, false);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMixedSliceAIndexOutOfBounds() {
        this.testSliceOutOfBounds(true, false, true);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMixedSliceALengthOutOfBounds() {
        this.testSliceOutOfBounds(true, false, false);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMixedSliceBIndexOutOfBounds() {
        this.testSliceOutOfBounds(false, true, true);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testMixedSliceBLengthOutOfBounds() {
        this.testSliceOutOfBounds(false, true, false);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceIndexOutOfBounds() {
        this.testSliceOutOfBounds(false, false, true);
    }

    @Test(expected=IndexOutOfBoundsException.class)
    public void testSliceLengthOutOfBounds() {
        this.testSliceOutOfBounds(false, false, false);
    }

    @Test
    public void testRetainedSliceAndRetainedDuplicateContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected4 = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{4, 5, 6, 7});
        expected4.writeBytes(new byte[]{5, 6, 7});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        Assert.assertEquals((long)0L, (long)slice1.compareTo(expected1));
        Assert.assertEquals((long)0L, (long)slice1.compareTo(buf.slice(buf.readerIndex() + 1, 6)));
        buf.release();
        slice1.readByte();
        ByteBuf dup1 = slice1.retainedDuplicate();
        Assert.assertEquals((long)0L, (long)dup1.compareTo(expected2));
        Assert.assertEquals((long)0L, (long)dup1.compareTo(slice1.duplicate()));
        dup1.readByte();
        ByteBuf dup2 = dup1.duplicate();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(expected3));
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex(), 3);
        Assert.assertEquals((long)0L, (long)slice2.compareTo(expected4));
        Assert.assertEquals((long)0L, (long)slice2.compareTo(dup2.slice(dup2.readerIndex(), 3)));
        Assert.assertTrue((boolean)expected1.release());
        Assert.assertTrue((boolean)expected2.release());
        Assert.assertTrue((boolean)expected3.release());
        Assert.assertTrue((boolean)expected4.release());
        slice2.release();
        dup2.release();
        Assert.assertEquals((long)slice2.refCnt(), (long)dup2.refCnt());
        Assert.assertEquals((long)dup2.refCnt(), (long)dup1.refCnt());
        Assert.assertTrue((boolean)slice1.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)0L, (long)dup2.refCnt());
    }

    @Test
    public void testRetainedDuplicateAndRetainedSliceContentIsExpected() {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(5).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(4).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6, 7});
        expected3.writeBytes(new byte[]{5, 6, 7});
        ByteBuf dup1 = buf.retainedDuplicate();
        Assert.assertEquals((long)0L, (long)dup1.compareTo(buf));
        Assert.assertEquals((long)0L, (long)dup1.compareTo(buf.slice()));
        buf.release();
        dup1.readByte();
        ByteBuf slice1 = dup1.retainedSlice(dup1.readerIndex(), 6);
        Assert.assertEquals((long)0L, (long)slice1.compareTo(expected1));
        Assert.assertEquals((long)0L, (long)slice1.compareTo(slice1.duplicate()));
        slice1.readByte();
        ByteBuf dup2 = slice1.duplicate();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(slice1));
        dup2.readByte();
        ByteBuf slice2 = dup2.retainedSlice(dup2.readerIndex() + 1, 3);
        Assert.assertEquals((long)0L, (long)slice2.compareTo(expected3));
        Assert.assertEquals((long)0L, (long)slice2.compareTo(dup2.slice(dup2.readerIndex() + 1, 3)));
        Assert.assertTrue((boolean)expected1.release());
        Assert.assertTrue((boolean)expected2.release());
        Assert.assertTrue((boolean)expected3.release());
        slice2.release();
        slice1.release();
        Assert.assertEquals((long)slice2.refCnt(), (long)dup2.refCnt());
        Assert.assertEquals((long)dup2.refCnt(), (long)slice1.refCnt());
        Assert.assertTrue((boolean)dup1.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)0L, (long)dup2.refCnt());
    }

    @Test
    public void testRetainedSliceContents() {
        this.testSliceContents(true);
    }

    @Test
    public void testMultipleLevelRetainedSlice1() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, true);
    }

    @Test
    public void testMultipleLevelRetainedSlice2() {
        this.testMultipleLevelRetainedSliceWithNonRetained(true, false);
    }

    @Test
    public void testMultipleLevelRetainedSlice3() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, true);
    }

    @Test
    public void testMultipleLevelRetainedSlice4() {
        this.testMultipleLevelRetainedSliceWithNonRetained(false, false);
    }

    @Test
    public void testRetainedSliceReleaseOriginal1() {
        this.testSliceReleaseOriginal(true, true);
    }

    @Test
    public void testRetainedSliceReleaseOriginal2() {
        this.testSliceReleaseOriginal(true, false);
    }

    @Test
    public void testRetainedSliceReleaseOriginal3() {
        this.testSliceReleaseOriginal(false, true);
    }

    @Test
    public void testRetainedSliceReleaseOriginal4() {
        this.testSliceReleaseOriginal(false, false);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal1() {
        this.testDuplicateReleaseOriginal(true, true);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal2() {
        this.testDuplicateReleaseOriginal(true, false);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal3() {
        this.testDuplicateReleaseOriginal(false, true);
    }

    @Test
    public void testRetainedDuplicateReleaseOriginal4() {
        this.testDuplicateReleaseOriginal(false, false);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal1() {
        this.testMultipleRetainedSliceReleaseOriginal(true, true);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal2() {
        this.testMultipleRetainedSliceReleaseOriginal(true, false);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal3() {
        this.testMultipleRetainedSliceReleaseOriginal(false, true);
    }

    @Test
    public void testMultipleRetainedSliceReleaseOriginal4() {
        this.testMultipleRetainedSliceReleaseOriginal(false, false);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal1() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, true);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal2() {
        this.testMultipleRetainedDuplicateReleaseOriginal(true, false);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal3() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, true);
    }

    @Test
    public void testMultipleRetainedDuplicateReleaseOriginal4() {
        this.testMultipleRetainedDuplicateReleaseOriginal(false, false);
    }

    @Test
    public void testSliceContents() {
        this.testSliceContents(false);
    }

    @Test
    public void testRetainedDuplicateContents() {
        this.testDuplicateContents(true);
    }

    @Test
    public void testDuplicateContents() {
        this.testDuplicateContents(false);
    }

    @Test
    public void testDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(false);
    }

    @Test
    public void testRetainedDuplicateCapacityChange() {
        this.testDuplicateCapacityChange(true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSliceCapacityChange() {
        this.testSliceCapacityChange(false);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRetainedSliceCapacityChange() {
        this.testSliceCapacityChange(true);
    }

    @Test
    public void testRetainedSliceUnreleasable1() {
        this.testRetainedSliceUnreleasable(true, true);
    }

    @Test
    public void testRetainedSliceUnreleasable2() {
        this.testRetainedSliceUnreleasable(true, false);
    }

    @Test
    public void testRetainedSliceUnreleasable3() {
        this.testRetainedSliceUnreleasable(false, true);
    }

    @Test
    public void testRetainedSliceUnreleasable4() {
        this.testRetainedSliceUnreleasable(false, false);
    }

    @Test
    public void testReadRetainedSliceUnreleasable1() {
        this.testReadRetainedSliceUnreleasable(true, true);
    }

    @Test
    public void testReadRetainedSliceUnreleasable2() {
        this.testReadRetainedSliceUnreleasable(true, false);
    }

    @Test
    public void testReadRetainedSliceUnreleasable3() {
        this.testReadRetainedSliceUnreleasable(false, true);
    }

    @Test
    public void testReadRetainedSliceUnreleasable4() {
        this.testReadRetainedSliceUnreleasable(false, false);
    }

    @Test
    public void testRetainedDuplicateUnreleasable1() {
        this.testRetainedDuplicateUnreleasable(true, true);
    }

    @Test
    public void testRetainedDuplicateUnreleasable2() {
        this.testRetainedDuplicateUnreleasable(true, false);
    }

    @Test
    public void testRetainedDuplicateUnreleasable3() {
        this.testRetainedDuplicateUnreleasable(false, true);
    }

    @Test
    public void testRetainedDuplicateUnreleasable4() {
        this.testRetainedDuplicateUnreleasable(false, false);
    }

    private void testRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.retainedSlice() : buf2.slice().retain();
        Assert.assertFalse((boolean)buf3.release());
        Assert.assertFalse((boolean)buf2.release());
        buf1.release();
        Assert.assertTrue((boolean)buf.release());
        Assert.assertEquals((long)0L, (long)buf1.refCnt());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    private void testReadRetainedSliceUnreleasable(boolean initRetainedSlice, boolean finalRetainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedSlice ? buf.retainedSlice() : buf.slice().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedSlice ? buf2.readRetainedSlice(buf2.readableBytes()) : buf2.readSlice(buf2.readableBytes()).retain();
        Assert.assertFalse((boolean)buf3.release());
        Assert.assertFalse((boolean)buf2.release());
        buf1.release();
        Assert.assertTrue((boolean)buf.release());
        Assert.assertEquals((long)0L, (long)buf1.refCnt());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    private void testRetainedDuplicateUnreleasable(boolean initRetainedDuplicate, boolean finalRetainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf buf1 = initRetainedDuplicate ? buf.retainedDuplicate() : buf.duplicate().retain();
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)buf1);
        ByteBuf buf3 = finalRetainedDuplicate ? buf2.retainedDuplicate() : buf2.duplicate().retain();
        Assert.assertFalse((boolean)buf3.release());
        Assert.assertFalse((boolean)buf2.release());
        buf1.release();
        Assert.assertTrue((boolean)buf.release());
        Assert.assertEquals((long)0L, (long)buf1.refCnt());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateCapacityChange(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            dup.capacity(10);
            Assert.assertEquals((long)buf.capacity(), (long)dup.capacity());
            dup.capacity(5);
            Assert.assertEquals((long)buf.capacity(), (long)dup.capacity());
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceCapacityChange(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 3) : buf.slice(buf.readerIndex() + 1, 3);
        try {
            slice.capacity(10);
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceOutOfBounds(boolean initRetainedSlice, boolean finalRetainedSlice, boolean indexOutOfBounds) {
        ByteBuf buf = this.newBuffer(8);
        ByteBuf slice = initRetainedSlice ? buf.retainedSlice(buf.readerIndex() + 1, 2) : buf.slice(buf.readerIndex() + 1, 2);
        try {
            int length;
            Assert.assertEquals((long)2L, (long)slice.capacity());
            Assert.assertEquals((long)2L, (long)slice.maxCapacity());
            int index = indexOutOfBounds ? 3 : 0;
            int n = length = indexOutOfBounds ? 0 : 3;
            if (finalRetainedSlice) {
                slice.retainedSlice(index, length);
            } else {
                slice.slice(index, length);
            }
        }
        finally {
            if (initRetainedSlice) {
                slice.release();
            }
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSliceContents(boolean retainedSlice) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(3).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(new byte[]{4, 5, 6});
        ByteBuf slice = retainedSlice ? buf.retainedSlice(buf.readerIndex() + 3, 3) : buf.slice(buf.readerIndex() + 3, 3);
        try {
            Assert.assertEquals((long)0L, (long)slice.compareTo(expected));
            Assert.assertEquals((long)0L, (long)slice.compareTo(slice.duplicate()));
            ByteBuf b = slice.retainedDuplicate();
            Assert.assertEquals((long)0L, (long)slice.compareTo(b));
            b.release();
            Assert.assertEquals((long)0L, (long)slice.compareTo(slice.slice(0, slice.capacity())));
        }
        finally {
            if (retainedSlice) {
                slice.release();
            }
            buf.release();
            expected.release();
        }
    }

    private void testSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        Assert.assertEquals((long)0L, (long)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        Assert.assertEquals((long)0L, (long)slice2.compareTo(expected2));
        Assert.assertTrue((boolean)expected1.release());
        Assert.assertTrue((boolean)expected2.release());
        slice2.release();
        Assert.assertTrue((boolean)slice1.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
    }

    private void testMultipleLevelRetainedSliceWithNonRetained(boolean doSlice1, boolean doSlice2) {
        ByteBuf slice4;
        ByteBuf slice3;
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(6).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(4).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected4SliceSlice = this.newBuffer(1).resetWriterIndex();
        ByteBuf expected4DupSlice = this.newBuffer(1).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{2, 3, 4, 5, 6, 7});
        expected2.writeBytes(new byte[]{3, 4, 5, 6});
        expected3.writeBytes(new byte[]{4, 5});
        expected4SliceSlice.writeBytes(new byte[]{5});
        expected4DupSlice.writeBytes(new byte[]{4});
        ByteBuf slice1 = buf.retainedSlice(buf.readerIndex() + 1, 6);
        Assert.assertEquals((long)0L, (long)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = slice1.retainedSlice(slice1.readerIndex() + 1, 4);
        Assert.assertEquals((long)0L, (long)slice2.compareTo(expected2));
        Assert.assertEquals((long)0L, (long)slice2.compareTo(slice2.duplicate()));
        Assert.assertEquals((long)0L, (long)slice2.compareTo(slice2.slice()));
        ByteBuf tmpBuf = slice2.retainedDuplicate();
        Assert.assertEquals((long)0L, (long)slice2.compareTo(tmpBuf));
        tmpBuf.release();
        tmpBuf = slice2.retainedSlice();
        Assert.assertEquals((long)0L, (long)slice2.compareTo(tmpBuf));
        tmpBuf.release();
        ByteBuf byteBuf = slice3 = doSlice1 ? slice2.slice(slice2.readerIndex() + 1, 2) : slice2.duplicate();
        if (doSlice1) {
            Assert.assertEquals((long)0L, (long)slice3.compareTo(expected3));
        } else {
            Assert.assertEquals((long)0L, (long)slice3.compareTo(expected2));
        }
        ByteBuf byteBuf2 = slice4 = doSlice2 ? slice3.slice(slice3.readerIndex() + 1, 1) : slice3.duplicate();
        if (doSlice1 && doSlice2) {
            Assert.assertEquals((long)0L, (long)slice4.compareTo(expected4SliceSlice));
        } else if (doSlice2) {
            Assert.assertEquals((long)0L, (long)slice4.compareTo(expected4DupSlice));
        } else {
            Assert.assertEquals((long)0L, (long)slice3.compareTo(slice4));
        }
        Assert.assertTrue((boolean)expected1.release());
        Assert.assertTrue((boolean)expected2.release());
        Assert.assertTrue((boolean)expected3.release());
        Assert.assertTrue((boolean)expected4SliceSlice.release());
        Assert.assertTrue((boolean)expected4DupSlice.release());
        slice4.release();
        Assert.assertEquals((long)slice3.refCnt(), (long)slice2.refCnt());
        Assert.assertEquals((long)slice3.refCnt(), (long)slice4.refCnt());
        Assert.assertTrue((boolean)slice1.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
        Assert.assertEquals((long)0L, (long)slice3.refCnt());
    }

    private void testDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        Assert.assertEquals((long)0L, (long)dup1.compareTo(expected));
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(expected));
        Assert.assertTrue((boolean)expected.release());
        dup2.release();
        Assert.assertTrue((boolean)dup1.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)0L, (long)dup2.refCnt());
    }

    private void testMultipleRetainedSliceReleaseOriginal(boolean retainedSlice1, boolean retainedSlice2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected1 = this.newBuffer(3).resetWriterIndex();
        ByteBuf expected2 = this.newBuffer(2).resetWriterIndex();
        ByteBuf expected3 = this.newBuffer(2).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected1.writeBytes(new byte[]{6, 7, 8});
        expected2.writeBytes(new byte[]{7, 8});
        expected3.writeBytes(new byte[]{6, 7});
        ByteBuf slice1 = retainedSlice1 ? buf.retainedSlice(buf.readerIndex() + 5, 3) : buf.slice(buf.readerIndex() + 5, 3).retain();
        Assert.assertEquals((long)0L, (long)slice1.compareTo(expected1));
        buf.release();
        ByteBuf slice2 = retainedSlice2 ? slice1.retainedSlice(slice1.readerIndex() + 1, 2) : slice1.slice(slice1.readerIndex() + 1, 2).retain();
        Assert.assertEquals((long)0L, (long)slice2.compareTo(expected2));
        slice2.release();
        ByteBuf slice3 = slice1.retainedSlice(slice1.readerIndex(), 2);
        Assert.assertEquals((long)0L, (long)slice3.compareTo(expected3));
        slice3.release();
        Assert.assertTrue((boolean)slice1.release());
        Assert.assertTrue((boolean)expected1.release());
        Assert.assertTrue((boolean)expected2.release());
        Assert.assertTrue((boolean)expected3.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)slice1.refCnt());
        Assert.assertEquals((long)0L, (long)slice2.refCnt());
        Assert.assertEquals((long)0L, (long)slice3.refCnt());
    }

    private void testMultipleRetainedDuplicateReleaseOriginal(boolean retainedDuplicate1, boolean retainedDuplicate2) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        ByteBuf expected = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        expected.writeBytes(buf, buf.readerIndex(), buf.readableBytes());
        ByteBuf dup1 = retainedDuplicate1 ? buf.retainedDuplicate() : buf.duplicate().retain();
        Assert.assertEquals((long)0L, (long)dup1.compareTo(expected));
        buf.release();
        ByteBuf dup2 = retainedDuplicate2 ? dup1.retainedDuplicate() : dup1.duplicate().retain();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(expected));
        Assert.assertEquals((long)0L, (long)dup2.compareTo(dup2.duplicate()));
        Assert.assertEquals((long)0L, (long)dup2.compareTo(dup2.slice()));
        ByteBuf tmpBuf = dup2.retainedDuplicate();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(tmpBuf));
        tmpBuf.release();
        tmpBuf = dup2.retainedSlice();
        Assert.assertEquals((long)0L, (long)dup2.compareTo(tmpBuf));
        tmpBuf.release();
        dup2.release();
        ByteBuf dup3 = dup1.retainedDuplicate();
        Assert.assertEquals((long)0L, (long)dup3.compareTo(expected));
        dup3.release();
        Assert.assertTrue((boolean)dup1.release());
        Assert.assertTrue((boolean)expected.release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)dup1.refCnt());
        Assert.assertEquals((long)0L, (long)dup2.refCnt());
        Assert.assertEquals((long)0L, (long)dup3.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDuplicateContents(boolean retainedDuplicate) {
        ByteBuf buf = this.newBuffer(8).resetWriterIndex();
        buf.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8});
        ByteBuf dup = retainedDuplicate ? buf.retainedDuplicate() : buf.duplicate();
        try {
            Assert.assertEquals((long)0L, (long)dup.compareTo(buf));
            Assert.assertEquals((long)0L, (long)dup.compareTo(dup.duplicate()));
            ByteBuf b = dup.retainedDuplicate();
            Assert.assertEquals((long)0L, (long)dup.compareTo(b));
            b.release();
            Assert.assertEquals((long)0L, (long)dup.compareTo(dup.slice(dup.readerIndex(), dup.readableBytes())));
        }
        finally {
            if (retainedDuplicate) {
                dup.release();
            }
            buf.release();
        }
    }

    @Test
    public void testDuplicateRelease() {
        ByteBuf buf = this.newBuffer(8);
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertTrue((boolean)buf.duplicate().release());
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    @Test
    public void testRefCnt() throws Exception {
        this.testRefCnt0(false);
    }

    @Test
    public void testRefCnt2() throws Exception {
        this.testRefCnt0(true);
    }

    @Test
    public void testEmptyNioBuffers() throws Exception {
        ByteBuf buffer = this.newBuffer(8);
        buffer.clear();
        Assert.assertFalse((boolean)buffer.isReadable());
        ByteBuffer[] nioBuffers = buffer.nioBuffers();
        Assert.assertEquals((long)1L, (long)nioBuffers.length);
        Assert.assertFalse((boolean)nioBuffers[0].hasRemaining());
        buffer.release();
    }

    @Test
    public void testGetReadOnlyDirectDst() {
        this.testGetReadOnlyDst(true);
    }

    @Test
    public void testGetReadOnlyHeapDst() {
        this.testGetReadOnlyDst(false);
    }

    private void testGetReadOnlyDst(boolean direct) {
        byte[] bytes = new byte[]{97, 98, 99, 100};
        ByteBuf buffer = this.newBuffer(bytes.length);
        buffer.writeBytes(bytes);
        ByteBuffer dst = direct ? ByteBuffer.allocateDirect(bytes.length) : ByteBuffer.allocate(bytes.length);
        ByteBuffer readOnlyDst = dst.asReadOnlyBuffer();
        try {
            buffer.getBytes(0, readOnlyDst);
            Assert.fail();
        }
        catch (ReadOnlyBufferException readOnlyBufferException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)readOnlyDst.position());
        buffer.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadBytesAndWriteBytesWithFileChannel() throws IOException {
        File file = File.createTempFile("file-channel", ".tmp");
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            Assert.assertEquals((long)len, (long)buffer.readBytes(channel, 10L, len));
            Assert.assertEquals((long)(oldReaderIndex + len), (long)buffer.readerIndex());
            Assert.assertEquals((long)channelPosition, (long)channel.position());
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            Assert.assertEquals((long)len, (long)buffer2.writeBytes(channel, 10L, len));
            Assert.assertEquals((long)channelPosition, (long)channel.position());
            Assert.assertEquals((long)(oldWriterIndex + len), (long)buffer2.writerIndex());
            Assert.assertEquals((long)97L, (long)buffer2.getByte(0));
            Assert.assertEquals((long)98L, (long)buffer2.getByte(1));
            Assert.assertEquals((long)99L, (long)buffer2.getByte(2));
            Assert.assertEquals((long)100L, (long)buffer2.getByte(3));
            buffer.release();
            buffer2.release();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetBytesAndSetBytesWithFileChannel() throws IOException {
        File file = File.createTempFile("file-channel", ".tmp");
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            FileChannel channel = randomAccessFile.getChannel();
            long channelPosition = channel.position();
            byte[] bytes = new byte[]{97, 98, 99, 100};
            int len = bytes.length;
            ByteBuf buffer = this.newBuffer(len);
            buffer.resetReaderIndex();
            buffer.resetWriterIndex();
            buffer.writeBytes(bytes);
            int oldReaderIndex = buffer.readerIndex();
            Assert.assertEquals((long)len, (long)buffer.getBytes(oldReaderIndex, channel, 10L, len));
            Assert.assertEquals((long)oldReaderIndex, (long)buffer.readerIndex());
            Assert.assertEquals((long)channelPosition, (long)channel.position());
            ByteBuf buffer2 = this.newBuffer(len);
            buffer2.resetReaderIndex();
            buffer2.resetWriterIndex();
            int oldWriterIndex = buffer2.writerIndex();
            Assert.assertEquals((long)buffer2.setBytes(oldWriterIndex, channel, 10L, len), (long)len);
            Assert.assertEquals((long)channelPosition, (long)channel.position());
            Assert.assertEquals((long)oldWriterIndex, (long)buffer2.writerIndex());
            Assert.assertEquals((long)97L, (long)buffer2.getByte(oldWriterIndex));
            Assert.assertEquals((long)98L, (long)buffer2.getByte(oldWriterIndex + 1));
            Assert.assertEquals((long)99L, (long)buffer2.getByte(oldWriterIndex + 2));
            Assert.assertEquals((long)100L, (long)buffer2.getByte(oldWriterIndex + 3));
            buffer.release();
            buffer2.release();
        }
        finally {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            file.delete();
        }
    }

    @Test
    public void testReadBytes() {
        ByteBuf buffer = this.newBuffer(8);
        byte[] bytes = new byte[8];
        buffer.writeBytes(bytes);
        ByteBuf buffer2 = buffer.readBytes(4);
        Assert.assertSame((Object)buffer.alloc(), (Object)buffer2.alloc());
        Assert.assertEquals((long)4L, (long)buffer.readerIndex());
        Assert.assertTrue((boolean)buffer.release());
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
        Assert.assertTrue((boolean)buffer2.release());
        Assert.assertEquals((long)0L, (long)buffer2.refCnt());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForEachByteDesc2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByteDesc(new ByteProcessor(){
                private int index;
                {
                    this.index = bytes.length - 1;
                }

                public boolean process(byte value) throws Exception {
                    bytes[this.index--] = value;
                    return true;
                }
            });
            Assert.assertEquals((long)-1L, (long)i);
            Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testForEachByte2() {
        byte[] expected = new byte[]{1, 2, 3, 4};
        ByteBuf buf = this.newBuffer(expected.length);
        try {
            buf.writeBytes(expected);
            final byte[] bytes = new byte[expected.length];
            int i = buf.forEachByte(new ByteProcessor(){
                private int index;

                public boolean process(byte value) throws Exception {
                    bytes[this.index++] = value;
                    return true;
                }
            });
            Assert.assertEquals((long)-1L, (long)i);
            Assert.assertArrayEquals((byte[])expected, (byte[])bytes);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IndexOutOfBoundsException.class)
    public void testGetBytesByteBuffer() {
        byte[] bytes = new byte[]{97, 98, 99, 100, 101, 102, 103};
        ByteBuffer nioBuffer = ByteBuffer.allocate(bytes.length + 1);
        ByteBuf buffer = this.newBuffer(bytes.length);
        try {
            buffer.writeBytes(bytes);
            buffer.getBytes(buffer.readerIndex(), nioBuffer);
        }
        finally {
            buffer.release();
        }
    }

    private void testRefCnt0(final boolean parameter) throws Exception {
        for (int i = 0; i < 10; ++i) {
            final CountDownLatch latch = new CountDownLatch(1);
            final CountDownLatch innerLatch = new CountDownLatch(1);
            final ByteBuf buffer = this.newBuffer(4);
            Assert.assertEquals((long)1L, (long)buffer.refCnt());
            final AtomicInteger cnt = new AtomicInteger(Integer.MAX_VALUE);
            Thread t1 = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean released = parameter ? buffer.release(buffer.refCnt()) : buffer.release();
                    Assert.assertTrue((boolean)released);
                    Thread t2 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            cnt.set(buffer.refCnt());
                            latch.countDown();
                        }
                    });
                    t2.start();
                    try {
                        innerLatch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            t1.start();
            latch.await();
            Assert.assertEquals((long)0L, (long)cnt.get());
            innerLatch.countDown();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCapacityEnforceMaxCapacity() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)3L, (long)buffer.capacity());
        try {
            buffer.capacity(14);
        }
        finally {
            buffer.release();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCapacityNegative() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)3L, (long)buffer.capacity());
        try {
            buffer.capacity(-1);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCapacityDecrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)3L, (long)buffer.capacity());
        try {
            buffer.capacity(2);
            Assert.assertEquals((long)2L, (long)buffer.capacity());
            Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCapacityIncrease() {
        ByteBuf buffer = this.newBuffer(3, 13);
        Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)3L, (long)buffer.capacity());
        try {
            buffer.capacity(4);
            Assert.assertEquals((long)4L, (long)buffer.capacity());
            Assert.assertEquals((long)13L, (long)buffer.maxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IndexOutOfBoundsException.class)
    public void testReaderIndexLargerThanWriterIndex() {
        String content1 = "hello";
        String content2 = "world";
        int length = content1.length() + content2.length();
        ByteBuf buffer = this.newBuffer(length);
        buffer.setIndex(0, 0);
        buffer.writeCharSequence((CharSequence)content1, CharsetUtil.US_ASCII);
        buffer.markWriterIndex();
        buffer.skipBytes(content1.length());
        buffer.writeCharSequence((CharSequence)content2, CharsetUtil.US_ASCII);
        buffer.skipBytes(content2.length());
        Assert.assertTrue((buffer.readerIndex() <= buffer.writerIndex() ? 1 : 0) != 0);
        try {
            buffer.resetWriterIndex();
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testMaxFastWritableBytes() {
        ByteBuf buffer = this.newBuffer(150, 500).writerIndex(100);
        Assert.assertEquals((long)50L, (long)buffer.writableBytes());
        Assert.assertEquals((long)150L, (long)buffer.capacity());
        Assert.assertEquals((long)500L, (long)buffer.maxCapacity());
        Assert.assertEquals((long)400L, (long)buffer.maxWritableBytes());
        Assert.assertEquals((long)50L, (long)buffer.maxFastWritableBytes());
        buffer.release();
    }

    @Test
    public void testEnsureWritableIntegerOverflow() {
        ByteBuf buffer = this.newBuffer(4096);
        buffer.writerIndex(buffer.readerIndex());
        buffer.writeByte(1);
        try {
            buffer.ensureWritable(Integer.MAX_VALUE);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        finally {
            buffer.release();
        }
    }

    static {
        char[] chars = new char[256];
        for (int c = 0; c < chars.length; c = (int)((char)(c + 1))) {
            chars[c] = c;
        }
        EXTENDED_ASCII_CHARS = CharBuffer.wrap(chars);
        ASCII_CHARS = CharBuffer.wrap(chars, 0, 128);
    }

    private static final class TestByteProcessor
    implements ByteProcessor {
        private TestByteProcessor() {
        }

        public boolean process(byte value) throws Exception {
            return true;
        }
    }

    private static final class TestScatteringByteChannel
    implements ScatteringByteChannel {
        private TestScatteringByteChannel() {
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long read(ByteBuffer[] dsts) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(ByteBuffer dst) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DevNullGatheringByteChannel
    implements GatheringByteChannel {
        private DevNullGatheringByteChannel() {
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOpen() {
            return false;
        }

        @Override
        public void close() {
            throw new UnsupportedOperationException();
        }
    }

    static final class TestGatheringByteChannel
    implements GatheringByteChannel {
        private final ByteArrayOutputStream out = new ByteArrayOutputStream();
        private final WritableByteChannel channel = Channels.newChannel(this.out);
        private final int limit;

        TestGatheringByteChannel(int limit) {
            this.limit = limit;
        }

        TestGatheringByteChannel() {
            this(Integer.MAX_VALUE);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            long written = 0L;
            while (offset < length && (written += (long)this.write(srcs[offset])) < (long)this.limit) {
                ++offset;
            }
            return written;
        }

        @Override
        public long write(ByteBuffer[] srcs) throws IOException {
            return this.write(srcs, 0, srcs.length);
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            int oldLimit = src.limit();
            if (this.limit < src.remaining()) {
                src.limit(src.position() + this.limit);
            }
            int w = this.channel.write(src);
            src.limit(oldLimit);
            return w;
        }

        @Override
        public boolean isOpen() {
            return this.channel.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }

        public byte[] writtenBytes() {
            return this.out.toByteArray();
        }
    }
}

