/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.SwappedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.WrappedByteBuf;
import io.netty.buffer.WrappedCompositeByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class ByteBufUtilTest {
    private static int[][] INVALID_RANGES = new int[][]{{-1, 5}, {5, 30}, {10, 5}};

    @Test
    public void decodeRandomHexBytesWithEvenLength() {
        ByteBufUtilTest.decodeRandomHexBytes(256);
    }

    @Test
    public void decodeRandomHexBytesWithOddLength() {
        ByteBufUtilTest.decodeRandomHexBytes(257);
    }

    private static void decodeRandomHexBytes(int len) {
        byte[] b = new byte[len];
        Random rand = new Random();
        rand.nextBytes(b);
        String hexDump = ByteBufUtil.hexDump((byte[])b);
        for (int i = 0; i <= len; ++i) {
            byte[] b2 = Arrays.copyOfRange(b, i, b.length);
            byte[] decodedBytes = ByteBufUtil.decodeHexDump((CharSequence)hexDump, (int)(i * 2), (int)((len - i) * 2));
            Assert.assertArrayEquals((byte[])b2, (byte[])decodedBytes);
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void decodeHexDumpWithOddLength() {
        ByteBufUtil.decodeHexDump((CharSequence)"abc");
    }

    @Test(expected=IllegalArgumentException.class)
    public void decodeHexDumpWithInvalidChar() {
        ByteBufUtil.decodeHexDump((CharSequence)"fg");
    }

    @Test
    public void equalsBufferSubsections() {
        byte[] b1 = new byte[128];
        byte[] b2 = new byte[256];
        Random rand = new Random();
        rand.nextBytes(b1);
        rand.nextBytes(b2);
        int iB1 = b1.length / 2;
        int iB2 = iB1 + b1.length;
        int length = b1.length - iB1;
        System.arraycopy(b1, iB1, b2, iB2, length);
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)Unpooled.wrappedBuffer((byte[])b1), (int)iB1, (ByteBuf)Unpooled.wrappedBuffer((byte[])b2), (int)iB2, (int)length));
    }

    private static int random(Random r, int min, int max) {
        return r.nextInt(max - min + 1) + min;
    }

    @Test
    public void notEqualsBufferSubsections() {
        int diffIndex;
        byte[] b1 = new byte[50];
        byte[] b2 = new byte[256];
        Random rand = new Random();
        rand.nextBytes(b1);
        rand.nextBytes(b2);
        int iB1 = b1.length / 2;
        int iB2 = iB1 + b1.length;
        int length = b1.length - iB1;
        System.arraycopy(b1, iB1, b2, iB2, length);
        int n = diffIndex = ByteBufUtilTest.random(rand, iB1, iB1 + length - 1);
        b1[n] = (byte)(b1[n] + 1);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)Unpooled.wrappedBuffer((byte[])b1), (int)iB1, (ByteBuf)Unpooled.wrappedBuffer((byte[])b2), (int)iB2, (int)length));
    }

    @Test
    public void notEqualsBufferOverflow() {
        byte[] b1 = new byte[8];
        byte[] b2 = new byte[16];
        Random rand = new Random();
        rand.nextBytes(b1);
        rand.nextBytes(b2);
        int iB1 = b1.length / 2;
        int iB2 = iB1 + b1.length;
        int length = b1.length - iB1;
        System.arraycopy(b1, iB1, b2, iB2, length - 1);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)Unpooled.wrappedBuffer((byte[])b1), (int)iB1, (ByteBuf)Unpooled.wrappedBuffer((byte[])b2), (int)iB2, (int)(Math.max(b1.length, b2.length) * 2)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void notEqualsBufferUnderflow() {
        byte[] b1 = new byte[8];
        byte[] b2 = new byte[16];
        Random rand = new Random();
        rand.nextBytes(b1);
        rand.nextBytes(b2);
        int iB1 = b1.length / 2;
        int iB2 = iB1 + b1.length;
        int length = b1.length - iB1;
        System.arraycopy(b1, iB1, b2, iB2, length - 1);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)Unpooled.wrappedBuffer((byte[])b1), (int)iB1, (ByteBuf)Unpooled.wrappedBuffer((byte[])b2), (int)iB2, (int)-1));
    }

    @Test
    public void writeShortBE() {
        int expected = 4660;
        ByteBuf buf = Unpooled.buffer((int)2).order(ByteOrder.BIG_ENDIAN);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)expected);
        Assert.assertEquals((long)expected, (long)buf.readShort());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapShort((short)((short)expected)), (long)buf.readShortLE());
        buf.release();
        buf = Unpooled.buffer((int)2).order(ByteOrder.LITTLE_ENDIAN);
        ByteBufUtil.writeShortBE((ByteBuf)buf, (int)expected);
        Assert.assertEquals((long)((short)expected), (long)buf.readShortLE());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapShort((short)((short)expected)), (long)buf.readShort());
        buf.release();
    }

    @Test
    public void setShortBE() {
        int shortValue = 4660;
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])new byte[2]).order(ByteOrder.BIG_ENDIAN);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)0, (int)shortValue);
        Assert.assertEquals((long)shortValue, (long)buf.readShort());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapShort((short)((short)shortValue)), (long)buf.readShortLE());
        buf.release();
        buf = Unpooled.wrappedBuffer((byte[])new byte[2]).order(ByteOrder.LITTLE_ENDIAN);
        ByteBufUtil.setShortBE((ByteBuf)buf, (int)0, (int)shortValue);
        Assert.assertEquals((long)((short)shortValue), (long)buf.readShortLE());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapShort((short)((short)shortValue)), (long)buf.readShort());
        buf.release();
    }

    @Test
    public void writeMediumBE() {
        int mediumValue = 1193046;
        ByteBuf buf = Unpooled.buffer((int)4).order(ByteOrder.BIG_ENDIAN);
        ByteBufUtil.writeMediumBE((ByteBuf)buf, (int)mediumValue);
        Assert.assertEquals((long)mediumValue, (long)buf.readMedium());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapMedium((int)mediumValue), (long)buf.readMediumLE());
        buf.release();
        buf = Unpooled.buffer((int)4).order(ByteOrder.LITTLE_ENDIAN);
        ByteBufUtil.writeMediumBE((ByteBuf)buf, (int)mediumValue);
        Assert.assertEquals((long)mediumValue, (long)buf.readMediumLE());
        buf.resetReaderIndex();
        Assert.assertEquals((long)ByteBufUtil.swapMedium((int)mediumValue), (long)buf.readMedium());
        buf.release();
    }

    @Test
    public void testWriteUsAscii() {
        String usAscii = "NettyRocks";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.US_ASCII));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUsAsciiSwapped() {
        String usAscii = "NettyRocks";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.US_ASCII));
        SwappedByteBuf buf2 = new SwappedByteBuf(Unpooled.buffer((int)16));
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUsAsciiWrapped() {
        String usAscii = "NettyRocks";
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)16));
        ByteBufUtilTest.assertWrapped(buf);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.US_ASCII));
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)16));
        ByteBufUtilTest.assertWrapped(buf2);
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.unwrap().release();
        buf2.unwrap().release();
    }

    @Test
    public void testWriteUsAsciiComposite() {
        String usAscii = "NettyRocks";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.US_ASCII));
        CompositeByteBuf buf2 = Unpooled.compositeBuffer().addComponent(Unpooled.buffer((int)8)).addComponent(Unpooled.buffer((int)24));
        buf2.writeByte(1);
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2.skipBytes(1));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUsAsciiCompositeWrapped() {
        String usAscii = "NettyRocks";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.US_ASCII));
        WrappedCompositeByteBuf buf2 = new WrappedCompositeByteBuf(Unpooled.compositeBuffer().addComponent(Unpooled.buffer((int)8)).addComponent(Unpooled.buffer((int)24)));
        buf2.writeByte(1);
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2.skipBytes(1));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8() {
        String usAscii = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8Composite() {
        String utf8 = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(utf8.getBytes(CharsetUtil.UTF_8));
        CompositeByteBuf buf2 = Unpooled.compositeBuffer().addComponent(Unpooled.buffer((int)8)).addComponent(Unpooled.buffer((int)24));
        buf2.writeByte(1);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)utf8);
        Assert.assertEquals((Object)buf, (Object)buf2.skipBytes(1));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8CompositeWrapped() {
        String utf8 = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(utf8.getBytes(CharsetUtil.UTF_8));
        WrappedCompositeByteBuf buf2 = new WrappedCompositeByteBuf(Unpooled.compositeBuffer().addComponent(Unpooled.buffer((int)8)).addComponent(Unpooled.buffer((int)24)));
        buf2.writeByte(1);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)utf8);
        Assert.assertEquals((Object)buf, (Object)buf2.skipBytes(1));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8Surrogates() {
        String surrogateString = new StringBuilder(2).append('a').append('\ud800').append('\udc00').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidOnlyTrailingSurrogate() {
        String surrogateString = new StringBuilder(2).append('a').append('\udc00').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidOnlyLeadingSurrogate() {
        String surrogateString = new StringBuilder(2).append('a').append('\ud800').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidSurrogatesSwitched() {
        String surrogateString = new StringBuilder(2).append('a').append('\udc00').append('\ud800').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidTwoLeadingSurrogates() {
        String surrogateString = new StringBuilder(2).append('a').append('\ud800').append('\ud800').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidTwoTrailingSurrogates() {
        String surrogateString = new StringBuilder(2).append('a').append('\udc00').append('\udc00').append('b').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidEndOnLeadingSurrogate() {
        String surrogateString = new StringBuilder(2).append('\ud800').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8InvalidEndOnTrailingSurrogate() {
        String surrogateString = new StringBuilder(2).append('\udc00').toString();
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(surrogateString.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)surrogateString);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)ByteBufUtil.utf8Bytes((CharSequence)surrogateString));
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUsAsciiString() {
        AsciiString usAscii = new AsciiString((CharSequence)"NettyRocks");
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.toString().getBytes(CharsetUtil.US_ASCII));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeAscii((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8Wrapped() {
        String usAscii = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)16));
        ByteBufUtilTest.assertWrapped(buf);
        buf.writeBytes(usAscii.getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.buffer((int)16));
        ByteBufUtilTest.assertWrapped(buf2);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)usAscii);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    private static void assertWrapped(ByteBuf buf) {
        Assert.assertTrue((boolean)(buf instanceof WrappedByteBuf));
    }

    @Test
    public void testWriteUtf8Subsequence() {
        String usAscii = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.substring(5, 18).getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)usAscii, (int)5, (int)18);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testWriteUtf8SubsequenceSplitSurrogate() {
        String usAscii = "\ud800\udc00";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.substring(0, 1).getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        ByteBufUtil.writeUtf8((ByteBuf)buf2, (CharSequence)usAscii, (int)0, (int)1);
        Assert.assertEquals((Object)buf, (Object)buf2);
        buf.release();
        buf2.release();
    }

    @Test
    public void testReserveAndWriteUtf8Subsequence() {
        String usAscii = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBuf buf = Unpooled.buffer((int)16);
        buf.writeBytes(usAscii.substring(5, 18).getBytes(CharsetUtil.UTF_8));
        ByteBuf buf2 = Unpooled.buffer((int)16);
        int count = ByteBufUtil.reserveAndWriteUtf8((ByteBuf)buf2, (CharSequence)usAscii, (int)5, (int)18, (int)16);
        Assert.assertEquals((Object)buf, (Object)buf2);
        Assert.assertEquals((long)buf.readableBytes(), (long)count);
        buf.release();
        buf2.release();
    }

    @Test
    public void testUtf8BytesSubsequence() {
        String usAscii = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        Assert.assertEquals((long)usAscii.substring(5, 18).getBytes(CharsetUtil.UTF_8).length, (long)ByteBufUtil.utf8Bytes((CharSequence)usAscii, (int)5, (int)18));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testInvalidSubsequences(TestMethod method) {
        for (int[] range : INVALID_RANGES) {
            ByteBuf buf = Unpooled.buffer((int)16);
            try {
                method.invoke(buf, "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152", range[0], range[1]);
                Assert.fail((String)("Did not throw IndexOutOfBoundsException for range (" + range[0] + ", " + range[1] + ")"));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
            finally {
                Assert.assertFalse((boolean)buf.isReadable());
                buf.release();
            }
        }
    }

    @Test
    public void testWriteUtf8InvalidSubsequences() {
        this.testInvalidSubsequences(new TestMethod(){

            @Override
            public int invoke(Object ... args) {
                return ByteBufUtil.writeUtf8((ByteBuf)((ByteBuf)args[0]), (CharSequence)((String)args[1]), (int)((Integer)args[2]), (int)((Integer)args[3]));
            }
        });
    }

    @Test
    public void testReserveAndWriteUtf8InvalidSubsequences() {
        this.testInvalidSubsequences(new TestMethod(){

            @Override
            public int invoke(Object ... args) {
                return ByteBufUtil.reserveAndWriteUtf8((ByteBuf)((ByteBuf)args[0]), (CharSequence)((String)args[1]), (int)((Integer)args[2]), (int)((Integer)args[3]), (int)32);
            }
        });
    }

    @Test
    public void testUtf8BytesInvalidSubsequences() {
        this.testInvalidSubsequences(new TestMethod(){

            @Override
            public int invoke(Object ... args) {
                return ByteBufUtil.utf8Bytes((CharSequence)((String)args[1]), (int)((Integer)args[2]), (int)((Integer)args[3]));
            }
        });
    }

    @Test
    public void testDecodeUsAscii() {
        ByteBufUtilTest.testDecodeString("This is a test", CharsetUtil.US_ASCII);
    }

    @Test
    public void testDecodeUtf8() {
        ByteBufUtilTest.testDecodeString("Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152", CharsetUtil.UTF_8);
    }

    private static void testDecodeString(String text, Charset charset) {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)text, (Charset)charset);
        Assert.assertEquals((Object)text, (Object)ByteBufUtil.decodeString((ByteBuf)buffer, (int)0, (int)buffer.readableBytes(), (Charset)charset));
        buffer.release();
    }

    @Test
    public void testToStringDoesNotThrowIndexOutOfBounds() {
        CompositeByteBuf buffer = Unpooled.compositeBuffer();
        try {
            byte[] bytes = "1234".getBytes(CharsetUtil.UTF_8);
            buffer.addComponent(Unpooled.buffer((int)bytes.length).writeBytes(bytes));
            buffer.addComponent(Unpooled.buffer((int)bytes.length).writeBytes(bytes));
            Assert.assertEquals((Object)"1234", (Object)buffer.toString(bytes.length, bytes.length, CharsetUtil.UTF_8));
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testIsTextWithUtf8() {
        byte[][] invalidUtf8Bytes;
        byte[][] validUtf8Bytes;
        for (byte[] bytes : validUtf8Bytes = new byte[][]{"netty".getBytes(CharsetUtil.UTF_8), {36}, {-62, -94}, {-30, -126, -84}, {-16, -112, -115, -120}, {36, -62, -94, -30, -126, -84, -16, -112, -115, -120}}) {
            ByteBufUtilTest.assertIsText(bytes, true, CharsetUtil.UTF_8);
        }
        for (byte[] bytes : invalidUtf8Bytes = new byte[][]{{-128}, {-16, -126, -126, -84}, {-62}, {-30, -126}, {-16, -112, -115}, {-62, -64}, {-30, -126, -64}, {-16, -112, -115, -64}, {-63, -128}, {-32, -128, -128}, {-19, -81, -128}}) {
            ByteBufUtilTest.assertIsText(bytes, false, CharsetUtil.UTF_8);
        }
    }

    @Test
    public void testIsTextWithoutOptimization() {
        byte[] validBytes = new byte[]{1, -40, 55, -36};
        byte[] invalidBytes = new byte[]{1, -40};
        ByteBufUtilTest.assertIsText(validBytes, true, CharsetUtil.UTF_16LE);
        ByteBufUtilTest.assertIsText(invalidBytes, false, CharsetUtil.UTF_16LE);
    }

    @Test
    public void testIsTextWithAscii() {
        byte[] validBytes = new byte[]{0, 1, 55, 127};
        byte[] invalidBytes = new byte[]{-128, -1};
        ByteBufUtilTest.assertIsText(validBytes, true, CharsetUtil.US_ASCII);
        ByteBufUtilTest.assertIsText(invalidBytes, false, CharsetUtil.US_ASCII);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsTextWithInvalidIndexAndLength() {
        ByteBuf buffer = Unpooled.buffer();
        try {
            int[][] invalidIndexLengthPairs;
            int[][] validIndexLengthPairs;
            buffer.writeBytes(new byte[4]);
            for (int[] pair : validIndexLengthPairs = new int[][]{{4, 0}, {0, 4}, {1, 3}}) {
                Assert.assertTrue((boolean)ByteBufUtil.isText((ByteBuf)buffer, (int)pair[0], (int)pair[1], (Charset)CharsetUtil.US_ASCII));
            }
            for (int[] pair : invalidIndexLengthPairs = new int[][]{{4, 1}, {-1, 2}, {3, -1}, {3, -2}, {5, 0}, {1, 5}}) {
                try {
                    ByteBufUtil.isText((ByteBuf)buffer, (int)pair[0], (int)pair[1], (Charset)CharsetUtil.US_ASCII);
                    Assert.fail((String)"Expected IndexOutOfBoundsException");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testUtf8Bytes() {
        String s = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152";
        ByteBufUtilTest.checkUtf8Bytes("Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152");
    }

    @Test
    public void testUtf8BytesWithSurrogates() {
        String s = "a\ud800\udc00b";
        ByteBufUtilTest.checkUtf8Bytes("a\ud800\udc00b");
    }

    @Test
    public void testUtf8BytesWithNonSurrogates3Bytes() {
        String s = "a\ue000b";
        ByteBufUtilTest.checkUtf8Bytes("a\ue000b");
    }

    @Test
    public void testUtf8BytesWithNonSurrogatesNonAscii() {
        int nonAscii = 129;
        String s = "a\u0081b";
        ByteBufUtilTest.checkUtf8Bytes("a\u0081b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkUtf8Bytes(CharSequence charSequence) {
        ByteBuf buf = Unpooled.buffer((int)ByteBufUtil.utf8MaxBytes((CharSequence)charSequence));
        try {
            int writtenBytes = ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)charSequence);
            int utf8Bytes = ByteBufUtil.utf8Bytes((CharSequence)charSequence);
            Assert.assertEquals((long)writtenBytes, (long)utf8Bytes);
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertIsText(byte[] bytes, boolean expected, Charset charset) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            buffer.writeBytes(bytes);
            Assert.assertEquals((Object)expected, (Object)ByteBufUtil.isText((ByteBuf)buffer, (Charset)charset));
        }
        finally {
            buffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsTextMultiThreaded() throws Throwable {
        final ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Hello, World!", (Charset)CharsetUtil.ISO_8859_1);
        try {
            final AtomicInteger counter = new AtomicInteger(60000);
            final AtomicReference errorRef = new AtomicReference();
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (int i = 0; i < 10; ++i) {
                Thread thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            while (errorRef.get() == null && counter.decrementAndGet() > 0) {
                                Assert.assertTrue((boolean)ByteBufUtil.isText((ByteBuf)buffer, (Charset)CharsetUtil.ISO_8859_1));
                            }
                        }
                        catch (Throwable cause) {
                            errorRef.compareAndSet(null, cause);
                        }
                    }
                });
                threads.add(thread);
            }
            for (Thread thread : threads) {
                thread.start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
            Throwable error = (Throwable)errorRef.get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testGetBytesHeap() {
        ByteBuf buf = Unpooled.buffer((int)4);
        try {
            Assume.assumeTrue((boolean)buf.hasArray());
            ByteBufUtilTest.checkGetBytes(buf);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetBytesDirect() {
        ByteBuf buf = Unpooled.directBuffer((int)4);
        try {
            Assume.assumeFalse((boolean)buf.hasArray());
            ByteBufUtilTest.checkGetBytes(buf);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetBytesHeapWithNonZeroArrayOffset() {
        ByteBuf buf = Unpooled.buffer((int)5);
        try {
            buf.setByte(0, 5);
            ByteBuf slice = buf.slice(1, 4);
            slice.writerIndex(0);
            Assume.assumeTrue((boolean)slice.hasArray());
            Assume.assumeThat((Object)slice.arrayOffset(), (Matcher)Matchers.is((Object)1));
            Assume.assumeThat((Object)slice.array().length, (Matcher)Matchers.is((Object)buf.capacity()));
            ByteBufUtilTest.checkGetBytes(slice);
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testGetBytesHeapWithArrayLengthGreaterThanCapacity() {
        ByteBuf buf = Unpooled.buffer((int)5);
        try {
            buf.setByte(4, 5);
            ByteBuf slice = buf.slice(0, 4);
            slice.writerIndex(0);
            Assume.assumeTrue((boolean)slice.hasArray());
            Assume.assumeThat((Object)slice.arrayOffset(), (Matcher)Matchers.is((Object)0));
            Assume.assumeThat((Object)slice.array().length, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(slice.capacity())));
            ByteBufUtilTest.checkGetBytes(slice);
        }
        finally {
            buf.release();
        }
    }

    private static void checkGetBytes(ByteBuf buf) {
        buf.writeInt(16909060);
        byte[] expected = new byte[]{1, 2, 3, 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf));
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)0, (int)buf.readableBytes(), (boolean)false));
        expected = new byte[]{1, 2, 3};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)0, (int)3));
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)0, (int)3, (boolean)false));
        expected = new byte[]{2, 3, 4};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)1, (int)3));
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)1, (int)3, (boolean)false));
        expected = new byte[]{2, 3};
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)1, (int)2));
        Assert.assertArrayEquals((byte[])expected, (byte[])ByteBufUtil.getBytes((ByteBuf)buf, (int)1, (int)2, (boolean)false));
    }

    static interface TestMethod {
        public int invoke(Object ... var1);
    }
}

