/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBufTest;
import io.netty.buffer.AbstractDerivedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class AbstractCompositeByteBufTest
extends AbstractByteBufTest {
    private static final ByteBufAllocator ALLOC = UnpooledByteBufAllocator.DEFAULT;
    private final ByteOrder order;

    protected AbstractCompositeByteBufTest(ByteOrder order) {
        this.order = (ByteOrder)ObjectUtil.checkNotNull((Object)order, (String)"order");
    }

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        Assume.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>();
        for (int i = 0; i < length + 45; i += 45) {
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[1]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[2]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[3]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[4]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[5]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[6]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[7]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[8]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[9]));
            buffers.add(Unpooled.EMPTY_BUFFER);
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0])).order(this.order);
        buffer.capacity(length);
        Assert.assertEquals((long)length, (long)buffer.capacity());
        Assert.assertEquals((long)length, (long)buffer.readableBytes());
        Assert.assertFalse((boolean)buffer.isWritable());
        buffer.writerIndex(0);
        return buffer;
    }

    @Override
    protected boolean discardReadBytesDoesNotMoveWritableBytes() {
        return false;
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assert.assertFalse((boolean)buf.isContiguous());
        buf.release();
    }

    @Test
    public void testComponentAtOffset() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}});
        Assert.assertEquals((long)5L, (long)buf.componentAtOffset(2).capacity());
        for (int index = 0; index < buf.capacity(); index = (int)((byte)(index + 1))) {
            int n = index;
            ByteBuf _buf = buf.componentAtOffset(n);
            Assert.assertNotNull((Object)_buf);
            Assert.assertTrue((_buf.capacity() > 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)_buf.getByte(0));
            Assert.assertNotNull((Object)_buf.getByte(_buf.readableBytes() - 1));
        }
        buf.release();
    }

    @Test
    public void testToComponentIndex() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}, {10, 9, 8, 7, 6, 5, 33}});
        Assert.assertEquals((long)0L, (long)buf.toComponentIndex(4));
        Assert.assertEquals((long)1L, (long)buf.toComponentIndex(5));
        Assert.assertEquals((long)2L, (long)buf.toComponentIndex(15));
        for (int index = 0; index < buf.capacity(); index = (int)((byte)(index + 1))) {
            int n = index;
            int cindex = buf.toComponentIndex(n);
            Assert.assertTrue((cindex >= 0 && cindex < buf.numComponents() ? 1 : 0) != 0);
        }
        buf.release();
    }

    @Test
    public void testToByteIndex() {
        CompositeByteBuf buf = (CompositeByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 5}, {4, 5, 6, 7, 8, 9, 26}, {10, 9, 8, 7, 6, 5, 33}});
        Assert.assertEquals((long)0L, (long)buf.toByteIndex(0));
        Assert.assertEquals((long)5L, (long)buf.toByteIndex(1));
        Assert.assertEquals((long)12L, (long)buf.toByteIndex(2));
        buf.release();
    }

    @Test
    public void testDiscardReadBytes3() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (int)0, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, (int)5, (int)5).order(this.order)});
        a.skipBytes(6);
        a.markReaderIndex();
        b.skipBytes(6);
        b.markReaderIndex();
        Assert.assertEquals((long)a.readerIndex(), (long)b.readerIndex());
        a.readerIndex(a.readerIndex() - 1);
        b.readerIndex(b.readerIndex() - 1);
        Assert.assertEquals((long)a.readerIndex(), (long)b.readerIndex());
        a.writerIndex(a.writerIndex() - 1);
        a.markWriterIndex();
        b.writerIndex(b.writerIndex() - 1);
        b.markWriterIndex();
        Assert.assertEquals((long)a.writerIndex(), (long)b.writerIndex());
        a.writerIndex(a.writerIndex() + 1);
        b.writerIndex(b.writerIndex() + 1);
        Assert.assertEquals((long)a.writerIndex(), (long)b.writerIndex());
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.discardReadBytes();
        b.discardReadBytes();
        Assert.assertEquals((long)a.readerIndex(), (long)b.readerIndex());
        Assert.assertEquals((long)a.writerIndex(), (long)b.writerIndex());
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.resetReaderIndex();
        b.resetReaderIndex();
        Assert.assertEquals((long)a.readerIndex(), (long)b.readerIndex());
        a.resetWriterIndex();
        b.resetWriterIndex();
        Assert.assertEquals((long)a.writerIndex(), (long)b.writerIndex());
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
    }

    @Test
    public void testAutoConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)2);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        Assert.assertEquals((long)2L, (long)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        Assert.assertTrue((boolean)buf.hasArray());
        Assert.assertNotNull((Object)buf.array());
        Assert.assertEquals((long)0L, (long)buf.arrayOffset());
        buf.release();
    }

    @Test
    public void testCompositeToSingleBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)3);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}));
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4}));
        Assert.assertEquals((long)2L, (long)buf.numComponents());
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{5, 6}));
        Assert.assertEquals((long)3L, (long)buf.numComponents());
        ByteBuffer nioBuffer = buf.nioBuffer(0, 6);
        byte[] bytes = nioBuffer.array();
        Assert.assertEquals((long)6L, (long)bytes.length);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2, 3, 4, 5, 6}, (byte[])bytes);
        buf.release();
    }

    @Test
    public void testFullConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        buf.consolidate();
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        Assert.assertTrue((boolean)buf.hasArray());
        Assert.assertNotNull((Object)buf.array());
        Assert.assertEquals((long)0L, (long)buf.arrayOffset());
        buf.release();
    }

    @Test
    public void testRangedConsolidation() {
        CompositeByteBuf buf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{2, 3}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}));
        buf.consolidate(1, 2);
        Assert.assertEquals((long)3L, (long)buf.numComponents());
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1}), (Object)buf.component(0));
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{2, 3, 4, 5, 6}), (Object)buf.component(1));
        Assert.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}), (Object)buf.component(2));
        buf.release();
    }

    @Test
    public void testCompositeWrappedBuffer() {
        ByteBuf header = Unpooled.buffer((int)12).order(this.order);
        ByteBuf payload = Unpooled.buffer((int)512).order(this.order);
        header.writeBytes(new byte[12]);
        payload.writeBytes(new byte[512]);
        ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, payload});
        Assert.assertEquals((long)12L, (long)header.readableBytes());
        Assert.assertEquals((long)512L, (long)payload.readableBytes());
        Assert.assertEquals((long)524L, (long)buffer.readableBytes());
        Assert.assertEquals((long)2L, (long)buffer.nioBufferCount());
        buffer.release();
    }

    @Test
    public void testSeveralBuffersEquals() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order)});
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order)});
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)1, (int)2).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)3, (int)1).order(this.order)});
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{4}).order(this.order)});
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)1, (int)2).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)3, (int)1).order(this.order)});
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}).order(this.order)});
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)1, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)6, (int)5).order(this.order)});
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 6}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 5, 9, 10}).order(this.order)});
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)1, (int)5).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)6, (int)5).order(this.order)});
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
    }

    @Test
    public void testWrappedBuffer() {
        ByteBuf a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)ByteBuffer.allocateDirect(16)));
        Assert.assertEquals((long)16L, (long)a.capacity());
        a.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3}}).order(this.order));
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, {2}, {3}}).order(this.order));
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order)});
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order), Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order)});
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3})).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1, 2, 3})}));
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
        a = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order));
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(new byte[]{1}), ByteBuffer.wrap(new byte[]{2}), ByteBuffer.wrap(new byte[]{3})}));
        Assert.assertEquals((Object)a, (Object)b);
        a.release();
        b.release();
    }

    @Test
    public void testWrittenBuffersEquals() {
        ByteBuf a = Unpooled.wrappedBuffer((byte[])new byte[]{1}).order(this.order);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, new byte[1]})).order(this.order);
        ByteBuf c = Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1}, new byte[2]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{2}).order(this.order);
        b.writerIndex(b.writerIndex() - 2);
        b.writeBytes(c);
        c.release();
        c = Unpooled.wrappedBuffer((byte[])new byte[]{3}).order(this.order);
        b.writeBytes(c);
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)1, (int)3)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4}, (int)3, (int)1).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2}, new byte[1]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{4}).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)1, (int)3)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 4, 5}, (int)3, (int)1).order(this.order);
        b.writerIndex(b.writerIndex() - 1);
        b.writeBytes(c);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3}, new byte[7]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{4, 5, 6}).order(this.order);
        b.writerIndex(b.writerIndex() - 7);
        b.writeBytes(c);
        c.release();
        c = Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 9, 10}).order(this.order);
        b.writeBytes(c);
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)1, (int)10)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, (int)6, (int)5).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assert.assertTrue((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2, 3, 4, 6}, new byte[5]})).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{7, 8, 5, 9, 10}).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
        a = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).order(this.order);
        b = Unpooled.wrappedBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)1, (int)10)).order(this.order);
        c = Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2, 3, 4, 6, 7, 8, 5, 9, 10, 11}, (int)6, (int)5).order(this.order);
        b.writerIndex(b.writerIndex() - 5);
        b.writeBytes(c);
        Assert.assertFalse((boolean)ByteBufUtil.equals((ByteBuf)a, (ByteBuf)b));
        a.release();
        b.release();
        c.release();
    }

    @Test
    public void testEmptyBuffer() {
        ByteBuf b = Unpooled.wrappedBuffer((byte[][])new byte[][]{{1, 2}, {3, 4}});
        b.readBytes(new byte[4]);
        b.readBytes(EmptyArrays.EMPTY_BYTES);
        b.release();
    }

    @Test
    public void testReadWithEmptyCompositeBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        int n = 65;
        for (int i = 0; i < n; ++i) {
            buf.writeByte(1);
            Assert.assertEquals((long)1L, (long)buf.readByte());
        }
        buf.release();
    }

    @Test
    public void testComponentMustBeDuplicate() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.buffer((int)4, (int)6).setIndex(1, 3));
        Assert.assertThat((Object)buf.component(0), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(AbstractDerivedByteBuf.class)));
        Assert.assertThat((Object)buf.component(0).capacity(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)buf.component(0).maxCapacity(), (Matcher)CoreMatchers.is((Object)6));
        Assert.assertThat((Object)buf.component(0).readableBytes(), (Matcher)CoreMatchers.is((Object)2));
        buf.release();
    }

    @Test
    public void testReferenceCounts1() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        buf.addComponents(new ByteBuf[]{c1, c2, c3});
        Assert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)buf.component(0).refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)buf.component(1).refCnt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)buf.component(2).refCnt(), (Matcher)CoreMatchers.is((Object)3));
        c3.release(2);
        c2.release();
        buf.release();
    }

    @Test
    public void testReferenceCounts2() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf bufA = Unpooled.compositeBuffer();
        bufA.addComponents(new ByteBuf[]{c1, c2, c3}).writerIndex(3);
        CompositeByteBuf bufB = Unpooled.compositeBuffer();
        bufB.addComponents((Iterable)bufA);
        Assert.assertThat((Object)bufA.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        bufB.release();
        Assert.assertThat((Object)bufB.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)bufA.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)0));
        Assert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        c3.release(2);
        c2.release();
    }

    @Test
    public void testReferenceCounts3() {
        ByteBuf c1 = Unpooled.buffer().writeByte(1);
        ByteBuf c2 = Unpooled.buffer().writeByte(2).retain();
        ByteBuf c3 = Unpooled.buffer().writeByte(3).retain(2);
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertThat((Object)buf.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        ArrayList components = new ArrayList();
        Collections.addAll(components, c1, c2, c3);
        buf.addComponents(components);
        Assert.assertThat((Object)c1.refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)c2.refCnt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)c3.refCnt(), (Matcher)CoreMatchers.is((Object)3));
        Assert.assertThat((Object)buf.component(0).refCnt(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)buf.component(1).refCnt(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)buf.component(2).refCnt(), (Matcher)CoreMatchers.is((Object)3));
        c3.release(2);
        c2.release();
        buf.release();
    }

    @Test
    public void testNestedLayout() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.compositeBuffer().addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2})).addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{3, 4})).slice(1, 2));
        ByteBuffer[] nioBuffers = buf.nioBuffers(0, 2);
        Assert.assertThat((Object)nioBuffers.length, (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)nioBuffers[0].remaining(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)nioBuffers[0].get(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)nioBuffers[1].remaining(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)nioBuffers[1].get(), (Matcher)CoreMatchers.is((Object)3));
        buf.release();
    }

    @Test
    public void testRemoveLastComponent() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        buf.removeComponent(0);
        Assert.assertEquals((long)0L, (long)buf.numComponents());
        buf.release();
    }

    @Test
    public void testCopyEmpty() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertEquals((long)0L, (long)buf.numComponents());
        ByteBuf copy = buf.copy();
        Assert.assertEquals((long)0L, (long)copy.readableBytes());
        buf.release();
        copy.release();
    }

    @Test
    public void testDuplicateEmpty() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertEquals((long)0L, (long)buf.numComponents());
        Assert.assertEquals((long)0L, (long)buf.duplicate().readableBytes());
        buf.release();
    }

    @Test
    public void testRemoveLastComponentWithOthersLeft() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        Assert.assertEquals((long)2L, (long)buf.numComponents());
        buf.removeComponent(1);
        Assert.assertEquals((long)1L, (long)buf.numComponents());
        buf.release();
    }

    @Test
    public void testRemoveComponents() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        for (int i = 0; i < 10; ++i) {
            buf.addComponent(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2}));
        }
        Assert.assertEquals((long)10L, (long)buf.numComponents());
        Assert.assertEquals((long)20L, (long)buf.capacity());
        buf.removeComponents(4, 3);
        Assert.assertEquals((long)7L, (long)buf.numComponents());
        Assert.assertEquals((long)14L, (long)buf.capacity());
        buf.release();
    }

    @Test
    public void testGatheringWritesHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order));
    }

    @Test
    public void testGatheringWritesDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesMixes() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesHeapPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesDirectPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order));
    }

    @Test
    public void testGatheringWritesMixesPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWrites(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order));
    }

    private static void testGatheringWrites(ByteBuf buf1, ByteBuf buf2) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(buf1.writeBytes(new byte[]{1, 2}));
        buf.addComponent(buf2.writeBytes(new byte[]{1, 2}));
        buf.writerIndex(3);
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        Assert.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testGatheringWritesPartialHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialMixes() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialHeapSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.buffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialDirectSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.directBuffer().order(this.order), Unpooled.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialMixesSlice() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(Unpooled.buffer().order(this.order), Unpooled.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialHeapPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialDirectPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialMixesPooled() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), false);
    }

    @Test
    public void testGatheringWritesPartialHeapPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialDirectPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), true);
    }

    @Test
    public void testGatheringWritesPartialMixesPooledSliced() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesPartial(PooledByteBufAllocator.DEFAULT.heapBuffer().order(this.order), PooledByteBufAllocator.DEFAULT.directBuffer().order(this.order), true);
    }

    private static void testGatheringWritesPartial(ByteBuf buf1, ByteBuf buf2, boolean slice) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf1.writeBytes(new byte[]{1, 2, 3, 4});
        buf2.writeBytes(new byte[]{1, 2, 3, 4});
        if (slice) {
            buf1 = buf1.readerIndex(1).slice();
            buf2 = buf2.writerIndex(3).slice();
            buf.addComponent(buf1);
            buf.addComponent(buf2);
            buf.writerIndex(6);
        } else {
            buf.addComponent(buf1);
            buf.addComponent(buf2);
            buf.writerIndex(7);
            buf.readerIndex(1);
        }
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel(1);
        while (buf.isReadable()) {
            buf.readBytes((GatheringByteChannel)channel, buf.readableBytes());
        }
        byte[] data = new byte[6];
        if (slice) {
            buf.getBytes(0, data);
        } else {
            buf.getBytes(1, data);
        }
        Assert.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Test
    public void testGatheringWritesSingleHeap() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.buffer().order(this.order));
    }

    @Test
    public void testGatheringWritesSingleDirect() throws Exception {
        AbstractCompositeByteBufTest.testGatheringWritesSingleBuf(Unpooled.directBuffer().order(this.order));
    }

    private static void testGatheringWritesSingleBuf(ByteBuf buf1) throws Exception {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        buf.addComponent(buf1.writeBytes(new byte[]{1, 2, 3, 4}));
        buf.writerIndex(3);
        buf.readerIndex(1);
        AbstractByteBufTest.TestGatheringByteChannel channel = new AbstractByteBufTest.TestGatheringByteChannel();
        buf.readBytes((GatheringByteChannel)channel, 2);
        byte[] data = new byte[2];
        buf.getBytes(1, data);
        Assert.assertArrayEquals((byte[])data, (byte[])channel.writtenBytes());
        buf.release();
    }

    @Override
    @Test
    public void testInternalNioBuffer() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertEquals((long)0L, (long)buf.internalNioBuffer(0, 0).remaining());
        ByteBuf concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer);
        Assert.assertSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
        buf = Unpooled.compositeBuffer();
        concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer.slice());
        Assert.assertNotSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
        buf = Unpooled.compositeBuffer();
        concreteBuffer = Unpooled.directBuffer().writeByte(1);
        buf.addComponent(concreteBuffer.duplicate());
        Assert.assertNotSame((Object)concreteBuffer.internalNioBuffer(0, 1), (Object)buf.internalNioBuffer(0, 1));
        buf.release();
    }

    @Test
    public void testisDirectMultipleBufs() {
        CompositeByteBuf buf = Unpooled.compositeBuffer();
        Assert.assertFalse((boolean)buf.isDirect());
        buf.addComponent(Unpooled.directBuffer().writeByte(1));
        Assert.assertTrue((boolean)buf.isDirect());
        buf.addComponent(Unpooled.directBuffer().writeByte(1));
        Assert.assertTrue((boolean)buf.isDirect());
        buf.addComponent(Unpooled.buffer().writeByte(1));
        Assert.assertFalse((boolean)buf.isDirect());
        buf.release();
    }

    @Test
    public void testDiscardSomeReadBytes() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        int len = 32;
        for (int i = 0; i < len; i += 4) {
            ByteBuf buf = Unpooled.buffer().writeInt(i);
            cbuf.capacity(cbuf.writerIndex()).addComponent(buf).writerIndex(i + 4);
        }
        cbuf.writeByte(1);
        byte[] me = new byte[len];
        cbuf.readBytes(me);
        cbuf.readByte();
        cbuf.discardSomeReadBytes();
        cbuf.release();
    }

    @Test
    public void testAddEmptyBufferRelease() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf = Unpooled.buffer();
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        cbuf.addComponent(buf);
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        cbuf.release();
        Assert.assertEquals((long)0L, (long)buf.refCnt());
    }

    @Test
    public void testAddEmptyBuffersRelease() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf = Unpooled.buffer();
        ByteBuf buf2 = Unpooled.buffer().writeInt(1);
        ByteBuf buf3 = Unpooled.buffer();
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertEquals((long)1L, (long)buf2.refCnt());
        Assert.assertEquals((long)1L, (long)buf3.refCnt());
        cbuf.addComponents(new ByteBuf[]{buf, buf2, buf3});
        Assert.assertEquals((long)1L, (long)buf.refCnt());
        Assert.assertEquals((long)1L, (long)buf2.refCnt());
        Assert.assertEquals((long)1L, (long)buf3.refCnt());
        cbuf.release();
        Assert.assertEquals((long)0L, (long)buf.refCnt());
        Assert.assertEquals((long)0L, (long)buf2.refCnt());
        Assert.assertEquals((long)0L, (long)buf3.refCnt());
    }

    @Test
    public void testAddEmptyBufferInMiddle() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf1 = Unpooled.buffer().writeByte(1);
        cbuf.addComponent(true, buf1);
        cbuf.addComponent(true, Unpooled.EMPTY_BUFFER);
        ByteBuf buf3 = Unpooled.buffer().writeByte(2);
        cbuf.addComponent(true, buf3);
        Assert.assertEquals((long)2L, (long)cbuf.readableBytes());
        Assert.assertEquals((long)1L, (long)cbuf.readByte());
        Assert.assertEquals((long)2L, (long)cbuf.readByte());
        Assert.assertSame((Object)Unpooled.EMPTY_BUFFER, (Object)cbuf.internalComponent(1));
        Assert.assertNotSame((Object)Unpooled.EMPTY_BUFFER, (Object)cbuf.internalComponentAtOffset(1));
        cbuf.release();
    }

    @Test
    public void testInsertEmptyBufferInMiddle() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ByteBuf buf1 = Unpooled.buffer().writeByte(1);
        cbuf.addComponent(true, buf1);
        ByteBuf buf2 = Unpooled.buffer().writeByte(2);
        cbuf.addComponent(true, buf2);
        cbuf.addComponent(true, 1, Unpooled.EMPTY_BUFFER);
        Assert.assertEquals((long)2L, (long)cbuf.readableBytes());
        Assert.assertEquals((long)1L, (long)cbuf.readByte());
        Assert.assertEquals((long)2L, (long)cbuf.readByte());
        Assert.assertEquals((long)2L, (long)cbuf.capacity());
        Assert.assertEquals((long)3L, (long)cbuf.numComponents());
        byte[] dest = new byte[2];
        cbuf.getBytes(0, dest);
        Assert.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])dest);
        cbuf.release();
    }

    @Test
    public void testAddFlattenedComponents() {
        ByteBuf b1 = Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3});
        CompositeByteBuf newComposite = Unpooled.compositeBuffer().addComponent(true, b1).addFlattenedComponents(true, b1.retain()).addFlattenedComponents(true, Unpooled.EMPTY_BUFFER);
        Assert.assertEquals((long)2L, (long)newComposite.numComponents());
        Assert.assertEquals((long)6L, (long)newComposite.capacity());
        Assert.assertEquals((long)6L, (long)newComposite.writerIndex());
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer().writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readRetainedSlice(2);
        ByteBuf s2 = s1.retainedSlice(0, 2);
        ByteBuf s3 = buffer.slice(0, 2).retain();
        ByteBuf s4 = s2.retainedSlice(0, 2);
        buffer.release();
        CompositeByteBuf compositeToAdd = Unpooled.compositeBuffer().addComponent(s1).addComponent(Unpooled.EMPTY_BUFFER).addComponents(new ByteBuf[]{s2, s3, s4});
        compositeToAdd.setIndex(1, 5);
        Assert.assertEquals((long)1L, (long)compositeToAdd.refCnt());
        Assert.assertEquals((long)1L, (long)s4.refCnt());
        ByteBuf compositeCopy = compositeToAdd.copy();
        newComposite.addFlattenedComponents(true, (ByteBuf)compositeToAdd);
        ByteBufUtil.equals((ByteBuf)compositeCopy, (int)0, (ByteBuf)newComposite, (int)6, (int)compositeCopy.readableBytes());
        Assert.assertEquals((long)5L, (long)newComposite.numComponents());
        Assert.assertEquals((long)10L, (long)newComposite.capacity());
        Assert.assertEquals((long)10L, (long)newComposite.writerIndex());
        Assert.assertEquals((long)0L, (long)compositeToAdd.refCnt());
        Assert.assertEquals((long)0L, (long)s4.refCnt());
        Assert.assertEquals((long)1L, (long)newComposite.refCnt());
        newComposite.release();
        Assert.assertEquals((long)0L, (long)newComposite.refCnt());
        Assert.assertEquals((long)0L, (long)s1.refCnt());
        Assert.assertEquals((long)0L, (long)s2.refCnt());
        Assert.assertEquals((long)0L, (long)s3.refCnt());
        Assert.assertEquals((long)0L, (long)b1.refCnt());
    }

    @Test
    public void testIterator() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Iterator it = cbuf.iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertSame((Object)Unpooled.EMPTY_BUFFER, it.next());
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertSame((Object)Unpooled.EMPTY_BUFFER, it.next());
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        cbuf.release();
    }

    @Test
    public void testEmptyIterator() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        Iterator it = cbuf.iterator();
        Assert.assertFalse((boolean)it.hasNext());
        try {
            it.next();
            Assert.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        cbuf.release();
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testIteratorConcurrentModificationAdd() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Iterator it = cbuf.iterator();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Assert.assertTrue((boolean)it.hasNext());
        try {
            it.next();
        }
        finally {
            cbuf.release();
        }
    }

    @Test(expected=ConcurrentModificationException.class)
    public void testIteratorConcurrentModificationRemove() {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        cbuf.addComponent(Unpooled.EMPTY_BUFFER);
        Iterator it = cbuf.iterator();
        cbuf.removeComponent(0);
        Assert.assertTrue((boolean)it.hasNext());
        try {
            it.next();
        }
        finally {
            cbuf.release();
        }
    }

    @Test
    public void testReleasesItsComponents() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readSlice(2).retain();
        ByteBuf s2 = s1.readSlice(2).retain();
        ByteBuf s3 = s2.readSlice(2).retain();
        ByteBuf s4 = s3.readSlice(2).retain();
        ByteBuf composite = PooledByteBufAllocator.DEFAULT.compositeBuffer().addComponent(s1).addComponents(new ByteBuf[]{s2, s3, s4}).order(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)1L, (long)composite.refCnt());
        Assert.assertEquals((long)5L, (long)buffer.refCnt());
        ReferenceCountUtil.release((Object)composite);
        Assert.assertEquals((long)0L, (long)composite.refCnt());
        Assert.assertEquals((long)1L, (long)buffer.refCnt());
        ReferenceCountUtil.release((Object)buffer);
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testReleasesItsComponents2() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeBytes(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10});
        ByteBuf s1 = buffer.readRetainedSlice(2);
        ByteBuf s2 = s1.readRetainedSlice(2);
        ByteBuf s3 = s2.readRetainedSlice(2);
        ByteBuf s4 = s3.readRetainedSlice(2);
        ByteBuf composite = Unpooled.compositeBuffer().addComponent(s1).addComponents(new ByteBuf[]{s2, s3, s4}).order(ByteOrder.LITTLE_ENDIAN);
        Assert.assertEquals((long)1L, (long)composite.refCnt());
        Assert.assertEquals((long)2L, (long)buffer.refCnt());
        composite.release();
        Assert.assertEquals((long)0L, (long)composite.refCnt());
        Assert.assertEquals((long)1L, (long)buffer.refCnt());
        buffer.release();
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testReleasesOnShrink() {
        ByteBuf b1 = Unpooled.buffer((int)2).writeShort(1);
        ByteBuf b2 = Unpooled.buffer((int)2).writeShort(2);
        CompositeByteBuf composite = Unpooled.compositeBuffer().addComponents(new ByteBuf[]{b1, b2});
        Assert.assertEquals((long)4L, (long)composite.capacity());
        composite.capacity(2);
        Assert.assertEquals((long)2L, (long)composite.capacity());
        composite.release();
        Assert.assertEquals((long)0L, (long)composite.refCnt());
        Assert.assertEquals((long)0L, (long)b1.refCnt());
        Assert.assertEquals((long)0L, (long)b2.refCnt());
    }

    @Test
    public void testReleasesOnShrink2() {
        ByteBuf buffer = PooledByteBufAllocator.DEFAULT.buffer();
        buffer.writeShort(1).writeShort(2);
        ByteBuf b1 = buffer.readRetainedSlice(2);
        ByteBuf b2 = b1.retainedSlice(b1.readerIndex(), 2);
        CompositeByteBuf composite = Unpooled.compositeBuffer().addComponents(new ByteBuf[]{b1, b2});
        Assert.assertEquals((long)4L, (long)composite.capacity());
        composite.capacity(2);
        Assert.assertEquals((long)2L, (long)composite.capacity());
        composite.release();
        Assert.assertEquals((long)0L, (long)composite.refCnt());
        Assert.assertEquals((long)0L, (long)b1.refCnt());
        Assert.assertEquals((long)0L, (long)b2.refCnt());
        buffer.release();
        Assert.assertEquals((long)0L, (long)buffer.refCnt());
    }

    @Test
    public void testAllocatorIsSameWhenCopy() {
        this.testAllocatorIsSameWhenCopy(false);
    }

    @Test
    public void testAllocatorIsSameWhenCopyUsingIndexAndLength() {
        this.testAllocatorIsSameWhenCopy(true);
    }

    private void testAllocatorIsSameWhenCopy(boolean withIndexAndLength) {
        ByteBuf buffer = this.newBuffer(8);
        buffer.writeZero(4);
        ByteBuf copy = withIndexAndLength ? buffer.copy(0, 4) : buffer.copy();
        Assert.assertEquals((Object)buffer, (Object)copy);
        Assert.assertEquals((Object)buffer.isDirect(), (Object)copy.isDirect());
        Assert.assertSame((Object)buffer.alloc(), (Object)copy.alloc());
        buffer.release();
        copy.release();
    }

    @Test
    public void testDecomposeMultiple() {
        AbstractCompositeByteBufTest.testDecompose(150, 500, 3);
    }

    @Test
    public void testDecomposeOne() {
        AbstractCompositeByteBufTest.testDecompose(310, 50, 1);
    }

    @Test
    public void testDecomposeNone() {
        AbstractCompositeByteBufTest.testDecompose(310, 0, 0);
    }

    private static void testDecompose(int offset, int length, int expectedListSize) {
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponents(true, new ByteBuf[]{buf.retainedSlice(100, 200), buf.retainedSlice(300, 400), buf.retainedSlice(700, 100)});
        ByteBuf slice = composite.slice(offset, length);
        List bufferList = composite.decompose(offset, length);
        Assert.assertEquals((long)expectedListSize, (long)bufferList.size());
        ByteBuf wrapped = Unpooled.wrappedBuffer((ByteBuf[])bufferList.toArray(new ByteBuf[0]));
        Assert.assertEquals((Object)slice, (Object)wrapped);
        composite.release();
        buf.release();
        for (ByteBuf buffer : bufferList) {
            Assert.assertEquals((long)0L, (long)buffer.refCnt());
        }
    }

    @Test
    public void testComponentsLessThanLowerBound() {
        try {
            new CompositeByteBuf(ALLOC, true, 0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)"maxNumComponents: 0 (expected: >= 1)", (Object)e.getMessage());
        }
    }

    @Test
    public void testComponentsEqualToLowerBound() {
        AbstractCompositeByteBufTest.assertCompositeBufCreated(1);
    }

    @Test
    public void testComponentsGreaterThanLowerBound() {
        AbstractCompositeByteBufTest.assertCompositeBufCreated(5);
    }

    private static void assertCompositeBufCreated(int expectedMaxComponents) {
        CompositeByteBuf buf = new CompositeByteBuf(ALLOC, true, expectedMaxComponents);
        Assert.assertEquals((long)expectedMaxComponents, (long)buf.maxNumComponents());
        Assert.assertTrue((boolean)buf.release());
    }

    @Test
    public void testDiscardSomeReadBytesCorrectlyUpdatesLastAccessed() {
        AbstractCompositeByteBufTest.testDiscardCorrectlyUpdatesLastAccessed(true);
    }

    @Test
    public void testDiscardReadBytesCorrectlyUpdatesLastAccessed() {
        AbstractCompositeByteBufTest.testDiscardCorrectlyUpdatesLastAccessed(false);
    }

    private static void testDiscardCorrectlyUpdatesLastAccessed(boolean discardSome) {
        CompositeByteBuf cbuf = Unpooled.compositeBuffer();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(4);
        for (int i = 0; i < 4; ++i) {
            ByteBuf buf = Unpooled.buffer().writeInt(i);
            cbuf.addComponent(true, buf);
            buffers.add(buf);
        }
        cbuf.skipBytes(2);
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assert.assertEquals((long)4L, (long)cbuf.numComponents());
        cbuf.skipBytes(3);
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assert.assertEquals((long)3L, (long)cbuf.numComponents());
        cbuf.skipBytes(3);
        Assert.assertEquals((long)2L, (long)cbuf.readInt());
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assert.assertEquals((long)1L, (long)cbuf.numComponents());
        Assert.assertEquals((long)3L, (long)cbuf.readInt());
        if (discardSome) {
            cbuf.discardSomeReadBytes();
        } else {
            cbuf.discardReadBytes();
        }
        Assert.assertEquals((long)0L, (long)cbuf.numComponents());
        for (ByteBuf buffer : buffers) {
            Assert.assertEquals((long)0L, (long)buffer.refCnt());
        }
        Assert.assertTrue((boolean)cbuf.release());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testOverflowWhileAddingComponent() {
        int capacity = 0x100000;
        ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                ByteBuf duplicate = buffer.duplicate();
                compositeByteBuf.addComponent(duplicate);
                duplicate.retain();
            }
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testOverflowWhileAddingComponentsViaVarargs() {
        int capacity = 0x100000;
        ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                ByteBuf duplicate = buffer.duplicate();
                compositeByteBuf.addComponents(new ByteBuf[]{duplicate});
                duplicate.retain();
            }
        }
        finally {
            compositeByteBuf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IllegalArgumentException.class)
    public void testOverflowWhileAddingComponentsViaIterable() {
        int capacity = 0x100000;
        ByteBuf buffer = Unpooled.buffer((int)capacity).writeZero(capacity);
        CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer((int)Integer.MAX_VALUE);
        try {
            for (int i = 0; i >= 0; i += buffer.readableBytes()) {
                ByteBuf duplicate = buffer.duplicate();
                compositeByteBuf.addComponents(Collections.singletonList(duplicate));
                duplicate.retain();
            }
        }
        finally {
            compositeByteBuf.release();
        }
    }
}

