/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import org.junit.Assert;
import org.junit.Test;

public class DefaultByteBufHolderTest {
    @Test
    public void testToString() {
        DefaultByteBufHolder holder = new DefaultByteBufHolder(Unpooled.buffer());
        Assert.assertEquals((long)1L, (long)holder.refCnt());
        Assert.assertNotNull((Object)holder.toString());
        Assert.assertTrue((boolean)holder.release());
        Assert.assertNotNull((Object)holder.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        DefaultByteBufHolder holder = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER);
        ByteBufHolder copy = holder.copy();
        try {
            Assert.assertEquals((Object)holder, (Object)copy);
            Assert.assertEquals((long)holder.hashCode(), (long)copy.hashCode());
        }
        finally {
            holder.release();
            copy.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentClassesAreNotEqual() {
        DefaultByteBufHolder dflt = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER);
        OtherByteBufHolder other = new OtherByteBufHolder(Unpooled.EMPTY_BUFFER, 123);
        DefaultByteBufHolder constant1 = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER){};
        DefaultByteBufHolder constant2 = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER){};
        try {
            Assert.assertFalse((boolean)dflt.equals((Object)other));
            Assert.assertFalse((boolean)dflt.equals(constant1));
            Assert.assertFalse((boolean)constant1.equals(dflt));
            Assert.assertFalse((boolean)constant1.equals((Object)other));
            Assert.assertFalse((boolean)constant1.equals(constant2));
        }
        finally {
            dflt.release();
            other.release();
            constant1.release();
            constant2.release();
        }
    }

    private static class OtherByteBufHolder
    extends DefaultByteBufHolder {
        private final int extraField;

        OtherByteBufHolder(ByteBuf data, int extraField) {
            super(data);
            this.extraField = extraField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OtherByteBufHolder that = (OtherByteBufHolder)((Object)o);
            return this.extraField == that.extraField;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.extraField;
            return result;
        }
    }
}

