/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.HeapByteBuf;
import io.netty.util.internal.DetectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class DefaultCompositeByteBuf
extends AbstractByteBuf
implements CompositeByteBuf {
    private final List<Component> components = new ArrayList<Component>();
    private final int maxNumComponents;
    private final ByteBuf.Unsafe unsafe = new CompositeUnsafe();
    private Component lastAccessed;
    private int lastAccessedId;

    public DefaultCompositeByteBuf(int maxNumComponents) {
        super(ByteOrder.BIG_ENDIAN, Integer.MAX_VALUE);
        this.maxNumComponents = maxNumComponents;
    }

    public DefaultCompositeByteBuf(int maxNumComponents, ByteBuf ... buffers) {
        super(ByteOrder.BIG_ENDIAN, Integer.MAX_VALUE);
        if (maxNumComponents < 2) {
            throw new IllegalArgumentException("maxNumComponents: " + maxNumComponents + " (expected: >= 2)");
        }
        this.maxNumComponents = maxNumComponents;
        this.addComponents(0, buffers);
        this.setIndex(0, this.capacity());
    }

    public DefaultCompositeByteBuf(int maxNumComponents, Iterable<ByteBuf> buffers) {
        super(ByteOrder.BIG_ENDIAN, Integer.MAX_VALUE);
        if (maxNumComponents < 2) {
            throw new IllegalArgumentException("maxNumComponents: " + maxNumComponents + " (expected: >= 2)");
        }
        this.maxNumComponents = maxNumComponents;
        this.addComponents(0, buffers);
        this.setIndex(0, this.capacity());
    }

    @Override
    public void addComponent(ByteBuf buffer) {
        this.addComponent(this.components.size(), buffer);
    }

    @Override
    public void addComponents(ByteBuf ... buffers) {
        this.addComponents(this.components.size(), buffers);
    }

    @Override
    public void addComponents(Iterable<ByteBuf> buffers) {
        this.addComponents(this.components.size(), buffers);
    }

    @Override
    public void addComponent(int cIndex, ByteBuf buffer) {
        this.checkComponentIndex(cIndex);
        if (buffer == null) {
            throw new NullPointerException("buffer");
        }
        if (buffer instanceof Iterable) {
            Iterable composite = (Iterable)((Object)buffer);
            this.addComponents(cIndex, composite);
            return;
        }
        int readableBytes = buffer.readableBytes();
        if (readableBytes == 0) {
            return;
        }
        int numComponents = this.components.size();
        if (numComponents >= this.maxNumComponents) {
            int capacity = this.components.get((int)(numComponents - 1)).endOffset + readableBytes;
            ByteBuf consolidated = buffer.unsafe().newBuffer(capacity);
            for (int i = 0; i < numComponents; ++i) {
                ByteBuf b = this.components.get((int)i).buf;
                consolidated.writeBytes(b);
                b.unsafe().release();
            }
            consolidated.writeBytes(buffer, buffer.readerIndex(), readableBytes);
            Component c = new Component(consolidated);
            c.endOffset = c.length;
            this.components.clear();
            this.components.add(c);
            return;
        }
        Component c = new Component(buffer.order(ByteOrder.BIG_ENDIAN).slice());
        if (cIndex == this.components.size()) {
            this.components.add(c);
            if (cIndex == 0) {
                c.endOffset = readableBytes;
            } else {
                Component prev = this.components.get(cIndex - 1);
                c.offset = prev.endOffset;
                c.endOffset = c.offset + readableBytes;
            }
        } else {
            this.components.add(cIndex, c);
            this.updateComponentOffsets(cIndex);
        }
    }

    @Override
    public void addComponents(int cIndex, ByteBuf ... buffers) {
        this.checkComponentIndex(cIndex);
        if (buffers == null) {
            throw new NullPointerException("buffers");
        }
        ByteBuf lastBuf = null;
        int cnt = 0;
        int readableBytes = 0;
        for (ByteBuf b : buffers) {
            if (b == null) break;
            lastBuf = b;
            ++cnt;
            readableBytes += b.readableBytes();
        }
        if (readableBytes == 0) {
            return;
        }
        int numComponents = this.components.size();
        if (numComponents + cnt > this.maxNumComponents) {
            ByteBuf consolidated;
            if (numComponents != 0) {
                int capacity = this.components.get((int)(numComponents - 1)).endOffset + readableBytes;
                consolidated = lastBuf.unsafe().newBuffer(capacity);
                for (int i = 0; i < cIndex; ++i) {
                    ByteBuf b = this.components.get((int)i).buf;
                    consolidated.writeBytes(b);
                    b.unsafe().release();
                }
                for (ByteBuf b : buffers) {
                    if (b == null) break;
                    consolidated.writeBytes(b, b.readerIndex(), b.readableBytes());
                }
                for (int i = cIndex; i < numComponents; ++i) {
                    ByteBuf b = this.components.get((int)i).buf;
                    consolidated.writeBytes(b);
                    b.unsafe().release();
                }
            } else {
                consolidated = lastBuf.unsafe().newBuffer(readableBytes);
                for (ByteBuf b : buffers) {
                    if (b == null) break;
                    consolidated.writeBytes(b, b.readerIndex(), b.readableBytes());
                }
            }
            Component c = new Component(consolidated);
            c.endOffset = c.length;
            this.components.clear();
            this.components.add(c);
            this.updateComponentOffsets(0);
            return;
        }
        for (ByteBuf b : buffers) {
            if (b == null) break;
            if (!b.readable()) continue;
            this.addComponent(cIndex++, b);
        }
    }

    @Override
    public void addComponents(int cIndex, Iterable<ByteBuf> buffers) {
        if (buffers == null) {
            throw new NullPointerException("buffers");
        }
        if (buffers instanceof DefaultCompositeByteBuf) {
            List<Component> list = ((DefaultCompositeByteBuf)buffers).components;
            ByteBuf[] array = new ByteBuf[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = list.get((int)i).buf;
            }
            this.addComponents(cIndex, array);
            return;
        }
        if (buffers instanceof List) {
            List list = (List)buffers;
            ByteBuf[] array = new ByteBuf[list.size()];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (ByteBuf)list.get(i);
            }
            this.addComponents(cIndex, array);
            return;
        }
        if (buffers instanceof Collection) {
            Collection col = (Collection)buffers;
            ByteBuf[] array = new ByteBuf[col.size()];
            int i = 0;
            for (ByteBuf b : col) {
                array[i++] = b;
            }
            this.addComponents(cIndex, array);
            return;
        }
        ArrayList<ByteBuf> list = new ArrayList<ByteBuf>();
        for (ByteBuf b : buffers) {
            list.add(b);
        }
        this.addComponents(cIndex, list.toArray(new ByteBuf[list.size()]));
    }

    private void checkComponentIndex(int cIndex) {
        if (cIndex < 0 || cIndex > this.components.size()) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d (expected: >= 0 && <= numComponents(%d))", cIndex, this.components.size()));
        }
    }

    private void checkComponentIndex(int cIndex, int numComponents) {
        if (cIndex < 0 || cIndex + numComponents > this.components.size()) {
            throw new IndexOutOfBoundsException(String.format("cIndex: %d, numComponents: %d (expected: cIndex >= 0 && cIndex + numComponents <= totalNumComponents(%d))", cIndex, numComponents, this.components.size()));
        }
    }

    private void updateComponentOffsets(int cIndex) {
        Component c;
        this.lastAccessed = c = this.components.get(cIndex);
        this.lastAccessedId = cIndex;
        if (cIndex == 0) {
            c.offset = 0;
            c.endOffset = c.length;
            ++cIndex;
        }
        for (int i = cIndex; i < this.components.size(); ++i) {
            Component prev = this.components.get(i - 1);
            Component cur = this.components.get(i);
            cur.offset = prev.endOffset;
            cur.endOffset = cur.offset + cur.length;
        }
    }

    @Override
    public void removeComponent(int cIndex) {
        this.checkComponentIndex(cIndex);
        this.components.remove(cIndex);
        this.updateComponentOffsets(cIndex);
    }

    @Override
    public void removeComponents(int cIndex, int numComponents) {
        this.checkComponentIndex(cIndex, numComponents);
        this.components.subList(cIndex, cIndex + numComponents).clear();
        this.updateComponentOffsets(cIndex);
    }

    @Override
    public Iterator<ByteBuf> iterator() {
        ArrayList<ByteBuf> list = new ArrayList<ByteBuf>(this.components.size());
        for (Component c : this.components) {
            list.add(c.buf);
        }
        return list.iterator();
    }

    @Override
    public List<ByteBuf> decompose(int offset, int length) {
        int readableBytes;
        if (length == 0) {
            return Collections.emptyList();
        }
        if (offset + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to decompose - Need " + (offset + length) + ", capacity is " + this.capacity());
        }
        int componentId = this.toComponentIndex(offset);
        ArrayList<ByteBuf> slice = new ArrayList<ByteBuf>(this.components.size());
        Component firstC = this.components.get(componentId);
        ByteBuf first = firstC.buf.duplicate();
        first.readerIndex(offset - firstC.offset);
        ByteBuf buf = first;
        int bytesToSlice = length;
        do {
            if (bytesToSlice <= (readableBytes = buf.readableBytes())) {
                buf.writerIndex(buf.readerIndex() + bytesToSlice);
                slice.add(buf);
                break;
            }
            slice.add(buf);
            buf = this.components.get((int)(++componentId)).buf.duplicate();
        } while ((bytesToSlice -= readableBytes) > 0);
        for (int i = 0; i < slice.size(); ++i) {
            slice.set(i, ((ByteBuf)slice.get(i)).slice());
        }
        return slice;
    }

    @Override
    public boolean isDirect() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.isDirect();
        }
        return false;
    }

    @Override
    public boolean hasArray() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.hasArray();
        }
        return false;
    }

    @Override
    public byte[] array() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.array();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int arrayOffset() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.arrayOffset();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int capacity() {
        if (this.components.isEmpty()) {
            return 0;
        }
        return this.components.get((int)(this.components.size() - 1)).endOffset;
    }

    @Override
    public void capacity(int newCapacity) {
        if (newCapacity < 0 || newCapacity > this.maxCapacity()) {
            throw new IllegalArgumentException("newCapacity: " + newCapacity);
        }
        int oldCapacity = this.capacity();
        if (newCapacity > oldCapacity) {
            ByteBuf padding;
            int paddingLength = newCapacity - oldCapacity;
            if (this.components.isEmpty()) {
                padding = new HeapByteBuf(paddingLength, paddingLength);
            } else {
                Component last = this.components.get(this.components.size() - 1);
                padding = last.buf.unsafe().newBuffer(paddingLength);
            }
            padding.setIndex(0, paddingLength);
            this.addComponent(padding);
        } else if (newCapacity < oldCapacity) {
            int bytesToTrim = oldCapacity - newCapacity;
            ListIterator<Component> i = this.components.listIterator(this.components.size());
            while (i.hasPrevious()) {
                Component c = i.previous();
                if (bytesToTrim >= c.length) {
                    bytesToTrim -= c.length;
                    i.remove();
                    continue;
                }
                Component newC = new Component(c.buf.slice(0, c.length - bytesToTrim));
                newC.offset = c.offset;
                newC.endOffset = newC.offset + newC.length;
                c.buf.unsafe().release();
                i.set(newC);
                break;
            }
            if (this.readerIndex() > newCapacity) {
                this.setIndex(newCapacity, newCapacity);
            } else if (this.writerIndex() > newCapacity) {
                this.writerIndex(newCapacity);
            }
        }
    }

    @Override
    public int numComponents() {
        return this.components.size();
    }

    @Override
    public int maxNumComponents() {
        return this.maxNumComponents;
    }

    @Override
    public int toComponentIndex(int offset) {
        if (offset < 0 || offset >= this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("offset: %d (expected: >= 0 && < capacity(%d))", offset, this.capacity()));
        }
        Component c = this.lastAccessed;
        if (c == null) {
            this.lastAccessed = c = this.components.get(0);
        }
        if (offset >= c.offset) {
            if (offset < c.endOffset) {
                return this.lastAccessedId;
            }
            for (int i = this.lastAccessedId + 1; i < this.components.size(); ++i) {
                c = this.components.get(i);
                if (offset >= c.endOffset) continue;
                this.lastAccessedId = i;
                this.lastAccessed = c;
                return i;
            }
        } else {
            for (int i = this.lastAccessedId - 1; i >= 0; --i) {
                c = this.components.get(i);
                if (offset < c.offset) continue;
                this.lastAccessedId = i;
                this.lastAccessed = c;
                return i;
            }
        }
        throw new IllegalStateException("should not reach here - concurrent modification?");
    }

    @Override
    public int toByteIndex(int cIndex) {
        this.checkComponentIndex(cIndex);
        return this.components.get((int)cIndex).offset;
    }

    @Override
    public byte getByte(int index) {
        Component c = this.findComponent(index);
        return c.buf.getByte(index - c.offset);
    }

    @Override
    public short getShort(int index) {
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset) {
            return c.buf.getShort(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (short)((this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF);
        }
        return (short)(this.getByte(index) & 0xFF | (this.getByte(index + 1) & 0xFF) << 8);
    }

    @Override
    public int getUnsignedMedium(int index) {
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset) {
            return c.buf.getUnsignedMedium(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 8 | this.getByte(index + 2) & 0xFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getByte(index + 2) & 0xFF) << 16;
    }

    @Override
    public int getInt(int index) {
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset) {
            return c.buf.getInt(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return (this.getShort(index) & 0xFFFF) << 16 | this.getShort(index + 2) & 0xFFFF;
        }
        return this.getShort(index) & 0xFFFF | (this.getShort(index + 2) & 0xFFFF) << 16;
    }

    @Override
    public long getLong(int index) {
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset) {
            return c.buf.getLong(index - c.offset);
        }
        if (this.order() == ByteOrder.BIG_ENDIAN) {
            return ((long)this.getInt(index) & 0xFFFFFFFFL) << 32 | (long)this.getInt(index + 4) & 0xFFFFFFFFL;
        }
        return (long)this.getInt(index) & 0xFFFFFFFFL | ((long)this.getInt(index + 4) & 0xFFFFFFFFL) << 32;
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        if (index > this.capacity() - length || dstIndex > dst.length - length) {
            throw new IndexOutOfBoundsException("Too many bytes to read - Needs " + (index + length) + ", maximum is " + this.capacity() + " or " + dst.length);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.toComponentIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int index, ByteBuffer dst) {
        int limit = dst.limit();
        int length = dst.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.toComponentIndex(index);
        try {
            while (length > 0) {
                Component c = this.components.get(i);
                ByteBuf s = c.buf;
                int adjustment = c.offset;
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                dst.limit(dst.position() + localLength);
                s.getBytes(index - adjustment, dst);
                index += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            dst.limit(limit);
        }
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        if (index > this.capacity() - length || dstIndex > dst.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - Needs " + (index + length) + " or " + (dstIndex + length) + ", maximum is " + this.capacity() + " or " + dst.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.toComponentIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        if (DetectionUtil.javaVersion() < 7) {
            return out.write(this.copiedNioBuffer(index, length));
        }
        long writtenBytes = out.write(this.nioBuffers(index, length));
        if (writtenBytes > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)writtenBytes;
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be read - needs " + (index + length) + ", maximum of " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        if (length == 0) {
            return;
        }
        int i = this.toComponentIndex(index);
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, out, localLength);
            index += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public void setByte(int index, int value) {
        Component c = this.findComponent(index);
        c.buf.setByte(index - c.offset, value);
    }

    @Override
    public void setShort(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 2 <= c.endOffset) {
            c.buf.setShort(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setByte(index, (byte)(value >>> 8));
            this.setByte(index + 1, (byte)value);
        } else {
            this.setByte(index, (byte)value);
            this.setByte(index + 1, (byte)(value >>> 8));
        }
    }

    @Override
    public void setMedium(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 3 <= c.endOffset) {
            c.buf.setMedium(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >> 8));
            this.setByte(index + 2, (byte)value);
        } else {
            this.setShort(index, (short)value);
            this.setByte(index + 2, (byte)(value >>> 16));
        }
    }

    @Override
    public void setInt(int index, int value) {
        Component c = this.findComponent(index);
        if (index + 4 <= c.endOffset) {
            c.buf.setInt(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setShort(index, (short)(value >>> 16));
            this.setShort(index + 2, (short)value);
        } else {
            this.setShort(index, (short)value);
            this.setShort(index + 2, (short)(value >>> 16));
        }
    }

    @Override
    public void setLong(int index, long value) {
        Component c = this.findComponent(index);
        if (index + 8 <= c.endOffset) {
            c.buf.setLong(index - c.offset, value);
        } else if (this.order() == ByteOrder.BIG_ENDIAN) {
            this.setInt(index, (int)(value >>> 32));
            this.setInt(index + 4, (int)value);
        } else {
            this.setInt(index, (int)value);
            this.setInt(index + 4, (int)(value >>> 32));
        }
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        int componentId = this.toComponentIndex(index);
        if (index > this.capacity() - length || srcIndex > src.length - length) {
            throw new IndexOutOfBoundsException("Too many bytes to read - needs " + (index + length) + " or " + (srcIndex + length) + ", maximum is " + this.capacity() + " or " + src.length);
        }
        int i = componentId;
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int index, ByteBuffer src) {
        int componentId = this.toComponentIndex(index);
        int limit = src.limit();
        int length = src.remaining();
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        try {
            while (length > 0) {
                Component c = this.components.get(i);
                ByteBuf s = c.buf;
                int adjustment = c.offset;
                int localLength = Math.min(length, s.capacity() - (index - adjustment));
                src.limit(src.position() + localLength);
                s.setBytes(index - adjustment, src);
                index += localLength;
                length -= localLength;
                ++i;
            }
        }
        finally {
            src.limit(limit);
        }
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        int componentId = this.toComponentIndex(index);
        if (index > this.capacity() - length || srcIndex > src.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to be written - Needs " + (index + length) + " or " + (srcIndex + length) + ", maximum is " + this.capacity() + " or " + src.capacity());
        }
        int i = componentId;
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.setBytes(index - adjustment, src, srcIndex, localLength);
            index += localLength;
            srcIndex += localLength;
            length -= localLength;
            ++i;
        }
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        int componentId = this.toComponentIndex(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        int readBytes = 0;
        do {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            int localReadBytes = s.setBytes(index - adjustment, in, localLength);
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        int componentId = this.toComponentIndex(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to write - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        int i = componentId;
        int readBytes = 0;
        do {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            int localReadBytes = s.setBytes(index - adjustment, in, localLength);
            if (localReadBytes == 0) break;
            if (localReadBytes < 0) {
                if (readBytes != 0) break;
                return -1;
            }
            if (localReadBytes == localLength) {
                index += localLength;
                length -= localLength;
                readBytes += localLength;
                ++i;
                continue;
            }
            index += localReadBytes;
            length -= localReadBytes;
            readBytes += localReadBytes;
        } while (length > 0);
        return readBytes;
    }

    @Override
    public ByteBuf copy(int index, int length) {
        int componentId = this.toComponentIndex(index);
        if (index > this.capacity() - length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Needs " + (index + length) + ", maximum is " + this.capacity());
        }
        ByteBuf dst = this.unsafe().newBuffer(length);
        this.copyTo(index, length, componentId, dst);
        return dst;
    }

    private void copyTo(int index, int length, int componentId, ByteBuf dst) {
        int dstIndex = 0;
        int i = componentId;
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            s.getBytes(index - adjustment, dst, dstIndex, localLength);
            index += localLength;
            dstIndex += localLength;
            length -= localLength;
            ++i;
        }
        dst.writerIndex(dst.capacity());
    }

    @Override
    public ByteBuf component(int cIndex) {
        this.checkComponentIndex(cIndex);
        return this.components.get((int)cIndex).buf;
    }

    @Override
    public ByteBuf componentAtOffset(int offset) {
        return this.findComponent((int)offset).buf;
    }

    private Component findComponent(int offset) {
        if (offset < 0 || offset >= this.capacity()) {
            throw new IndexOutOfBoundsException(String.format("offset: %d (expected: >= 0 && < capacity(%d))", offset, this.capacity()));
        }
        Component c = this.lastAccessed;
        if (c == null) {
            this.lastAccessed = c = this.components.get(0);
        }
        if (offset >= c.offset) {
            if (offset < c.endOffset) {
                return c;
            }
            for (int i = this.lastAccessedId + 1; i < this.components.size(); ++i) {
                c = this.components.get(i);
                if (offset >= c.endOffset) continue;
                this.lastAccessedId = i;
                this.lastAccessed = c;
                return c;
            }
        } else {
            for (int i = this.lastAccessedId - 1; i >= 0; --i) {
                c = this.components.get(i);
                if (offset < c.offset) continue;
                this.lastAccessedId = i;
                this.lastAccessed = c;
                return c;
            }
        }
        throw new IllegalStateException("should not reach here - concurrent modification?");
    }

    @Override
    public boolean hasNioBuffer() {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.hasNioBuffer();
        }
        return false;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        if (this.components.size() == 1) {
            return this.components.get((int)0).buf.nioBuffer(index, length);
        }
        throw new UnsupportedOperationException();
    }

    private ByteBuffer copiedNioBuffer(int index, int length) {
        if (this.components.size() == 1) {
            return DefaultCompositeByteBuf.toNioBuffer(this.components.get((int)0).buf, index, length);
        }
        ByteBuffer[] buffers = this.nioBuffers(index, length);
        ByteBuffer merged = ByteBuffer.allocate(length).order(this.order());
        for (ByteBuffer b : buffers) {
            merged.put(b);
        }
        merged.flip();
        return merged;
    }

    @Override
    public boolean hasNioBuffers() {
        return true;
    }

    @Override
    public ByteBuffer[] nioBuffers(int index, int length) {
        if (index + length > this.capacity()) {
            throw new IndexOutOfBoundsException("Too many bytes to convert - Needs" + (index + length) + ", maximum is " + this.capacity());
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index must be >= 0");
        }
        if (length == 0) {
            return new ByteBuffer[0];
        }
        int componentId = this.toComponentIndex(index);
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.components.size());
        int i = componentId;
        while (length > 0) {
            Component c = this.components.get(i);
            ByteBuf s = c.buf;
            int adjustment = c.offset;
            int localLength = Math.min(length, s.capacity() - (index - adjustment));
            buffers.add(DefaultCompositeByteBuf.toNioBuffer(s, index - adjustment, localLength));
            index += localLength;
            length -= localLength;
            ++i;
        }
        return buffers.toArray(new ByteBuffer[buffers.size()]);
    }

    private static ByteBuffer toNioBuffer(ByteBuf buf, int index, int length) {
        if (buf.hasNioBuffer()) {
            return buf.nioBuffer(index, length);
        }
        return buf.copy(index, length).nioBuffer(0, length);
    }

    @Override
    public void consolidate() {
        int numComponents = this.numComponents();
        if (numComponents <= 1) {
            return;
        }
        Component last = this.components.get(numComponents - 1);
        int capacity = last.endOffset;
        ByteBuf consolidated = last.buf.unsafe().newBuffer(capacity);
        for (int i = 0; i < numComponents; ++i) {
            ByteBuf b = this.components.get((int)i).buf;
            consolidated.writeBytes(b);
            b.unsafe().release();
        }
        this.components.clear();
        this.components.add(new Component(consolidated));
        this.updateComponentOffsets(0);
    }

    @Override
    public void consolidate(int cIndex, int numComponents) {
        this.checkComponentIndex(cIndex, numComponents);
        if (numComponents <= 1) {
            return;
        }
        int endCIndex = cIndex + numComponents;
        Component last = this.components.get(endCIndex - 1);
        int capacity = last.endOffset - this.components.get((int)cIndex).offset;
        ByteBuf consolidated = last.buf.unsafe().newBuffer(capacity);
        for (int i = cIndex; i < endCIndex; ++i) {
            ByteBuf b = this.components.get((int)i).buf;
            consolidated.writeBytes(b);
            b.unsafe().release();
        }
        this.components.subList(cIndex + 1, endCIndex).clear();
        this.components.set(cIndex, new Component(consolidated));
        this.updateComponentOffsets(cIndex);
    }

    @Override
    public void discardReadComponents() {
        int readerIndex = this.readerIndex();
        if (readerIndex == 0) {
            return;
        }
        int writerIndex = this.writerIndex();
        if (readerIndex == writerIndex && writerIndex == this.capacity()) {
            for (Component c : this.components) {
                c.buf.unsafe().release();
            }
            this.components.clear();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return;
        }
        int firstComponentId = this.toComponentIndex(readerIndex);
        for (int i = 0; i < firstComponentId; ++i) {
            this.components.get((int)i).buf.unsafe().release();
        }
        this.components.subList(0, firstComponentId).clear();
        Component first = this.components.get(0);
        this.updateComponentOffsets(0);
        this.setIndex(readerIndex - first.offset, writerIndex - first.offset);
        this.adjustMarkers(first.offset);
    }

    @Override
    public void discardReadBytes() {
        int readerIndex = this.readerIndex();
        if (readerIndex == 0) {
            return;
        }
        int writerIndex = this.writerIndex();
        if (readerIndex == writerIndex && writerIndex == this.capacity()) {
            for (Component c : this.components) {
                c.buf.unsafe().release();
            }
            this.components.clear();
            this.setIndex(0, 0);
            this.adjustMarkers(readerIndex);
            return;
        }
        int firstComponentId = this.toComponentIndex(readerIndex);
        for (int i = 0; i < firstComponentId; ++i) {
            this.components.get((int)i).buf.unsafe().release();
        }
        this.components.subList(0, firstComponentId).clear();
        Component c = this.components.get(0);
        int adjustment = readerIndex - c.offset;
        if (adjustment == c.length) {
            this.components.remove(0);
        } else {
            Component newC = new Component(c.buf.slice(adjustment, c.length - adjustment));
            c.buf.unsafe().release();
            this.components.set(0, newC);
        }
        this.updateComponentOffsets(0);
        this.setIndex(0, writerIndex - readerIndex);
        this.adjustMarkers(readerIndex);
    }

    @Override
    public String toString() {
        String result = super.toString();
        result = result.substring(0, result.length() - 1);
        return result + ", components=" + this.components.size() + ")";
    }

    @Override
    public ByteBuf.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    private final class CompositeUnsafe
    implements ByteBuf.Unsafe {
        private CompositeUnsafe() {
        }

        @Override
        public ByteBuffer nioBuffer() {
            if (DefaultCompositeByteBuf.this.components.size() == 1) {
                return ((Component)((DefaultCompositeByteBuf)DefaultCompositeByteBuf.this).components.get((int)0)).buf.unsafe().nioBuffer();
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public ByteBuffer[] nioBuffers() {
            ByteBuffer[] nioBuffers = new ByteBuffer[DefaultCompositeByteBuf.this.components.size()];
            int index = 0;
            for (Component component : DefaultCompositeByteBuf.this.components) {
                nioBuffers[index++] = component.buf.unsafe().nioBuffer();
            }
            return nioBuffers;
        }

        @Override
        public ByteBuf newBuffer(int initialCapacity) {
            DefaultCompositeByteBuf buf = new DefaultCompositeByteBuf(DefaultCompositeByteBuf.this.maxNumComponents);
            buf.addComponent(new HeapByteBuf(new byte[initialCapacity], initialCapacity));
            return buf;
        }

        @Override
        public void discardSomeReadBytes() {
            DefaultCompositeByteBuf.this.discardReadComponents();
        }

        @Override
        public void acquire() {
            if (DefaultCompositeByteBuf.this.refCnt <= 0) {
                throw new IllegalStateException();
            }
            ++DefaultCompositeByteBuf.this.refCnt;
        }

        @Override
        public void release() {
            if (DefaultCompositeByteBuf.this.refCnt <= 0) {
                throw new IllegalStateException();
            }
            --DefaultCompositeByteBuf.this.refCnt;
            if (DefaultCompositeByteBuf.this.refCnt == 0) {
                for (Component c : DefaultCompositeByteBuf.this.components) {
                    c.buf.unsafe().release();
                }
                DefaultCompositeByteBuf.this.components.clear();
                DefaultCompositeByteBuf.this.lastAccessed = null;
            }
        }
    }

    private static final class Component {
        final ByteBuf buf;
        final int length;
        int offset;
        int endOffset;

        Component(ByteBuf buf) {
            this.buf = buf;
            this.length = buf.readableBytes();
        }
    }
}

