/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import io.netty.buffer.HeapByteBufFactory;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.TruncatedByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;

public class HeapByteBuf
extends AbstractByteBuf {
    protected final byte[] array;
    protected final ByteBuffer nioBuf;

    public HeapByteBuf(int length) {
        this(new byte[length], 0, 0);
    }

    public HeapByteBuf(byte[] array) {
        this(array, 0, array.length);
    }

    protected HeapByteBuf(byte[] array, int readerIndex, int writerIndex) {
        super(ByteOrder.BIG_ENDIAN);
        if (array == null) {
            throw new NullPointerException("array");
        }
        this.array = array;
        this.setIndex(readerIndex, writerIndex);
        this.nioBuf = ByteBuffer.wrap(array);
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public int capacity() {
        return this.array.length;
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.array;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public byte getByte(int index) {
        return this.array[index];
    }

    @Override
    public void getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        if (dst instanceof HeapByteBuf) {
            this.getBytes(index, ((HeapByteBuf)dst).array, dstIndex, length);
        } else {
            dst.setBytes(dstIndex, this.array, index, length);
        }
    }

    @Override
    public void getBytes(int index, byte[] dst, int dstIndex, int length) {
        System.arraycopy(this.array, index, dst, dstIndex, length);
    }

    @Override
    public void getBytes(int index, ByteBuffer dst) {
        dst.put(this.array, index, Math.min(this.capacity() - index, dst.remaining()));
    }

    @Override
    public void getBytes(int index, OutputStream out, int length) throws IOException {
        out.write(this.array, index, length);
    }

    @Override
    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return out.write((ByteBuffer)this.nioBuf.clear().position(index).limit(index + length));
    }

    @Override
    public void setByte(int index, int value) {
        this.array[index] = (byte)value;
    }

    @Override
    public void setBytes(int index, ByteBuf src, int srcIndex, int length) {
        if (src instanceof HeapByteBuf) {
            this.setBytes(index, ((HeapByteBuf)src).array, srcIndex, length);
        } else {
            src.getBytes(srcIndex, this.array, index, length);
        }
    }

    @Override
    public void setBytes(int index, byte[] src, int srcIndex, int length) {
        System.arraycopy(src, srcIndex, this.array, index, length);
    }

    @Override
    public void setBytes(int index, ByteBuffer src) {
        src.get(this.array, index, src.remaining());
    }

    @Override
    public int setBytes(int index, InputStream in, int length) throws IOException {
        return in.read(this.array, index, length);
    }

    @Override
    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        try {
            return in.read((ByteBuffer)this.nioBuf.clear().position(index).limit(index + length));
        }
        catch (ClosedChannelException e) {
            return -1;
        }
    }

    @Override
    public ByteBuf slice(int index, int length) {
        if (index == 0) {
            if (length == 0) {
                return Unpooled.EMPTY_BUFFER;
            }
            if (length == this.array.length) {
                ByteBuf slice = this.duplicate();
                slice.setIndex(0, length);
                return slice;
            }
            return new TruncatedByteBuf(this, length);
        }
        if (length == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        return new SlicedByteBuf(this, index, length);
    }

    @Override
    public boolean hasNioBuffer() {
        return true;
    }

    @Override
    public ByteBuffer nioBuffer(int index, int length) {
        return ByteBuffer.wrap(this.array, index, length).order(this.order());
    }

    @Override
    public ByteBufFactory factory() {
        return HeapByteBufFactory.getInstance(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public short getShort(int index) {
        return (short)(this.array[index] << 8 | this.array[index + 1] & 0xFF);
    }

    @Override
    public int getUnsignedMedium(int index) {
        return (this.array[index] & 0xFF) << 16 | (this.array[index + 1] & 0xFF) << 8 | (this.array[index + 2] & 0xFF) << 0;
    }

    @Override
    public int getInt(int index) {
        return (this.array[index] & 0xFF) << 24 | (this.array[index + 1] & 0xFF) << 16 | (this.array[index + 2] & 0xFF) << 8 | (this.array[index + 3] & 0xFF) << 0;
    }

    @Override
    public long getLong(int index) {
        return ((long)this.array[index] & 0xFFL) << 56 | ((long)this.array[index + 1] & 0xFFL) << 48 | ((long)this.array[index + 2] & 0xFFL) << 40 | ((long)this.array[index + 3] & 0xFFL) << 32 | ((long)this.array[index + 4] & 0xFFL) << 24 | ((long)this.array[index + 5] & 0xFFL) << 16 | ((long)this.array[index + 6] & 0xFFL) << 8 | ((long)this.array[index + 7] & 0xFFL) << 0;
    }

    @Override
    public void setShort(int index, int value) {
        this.array[index] = (byte)(value >>> 8);
        this.array[index + 1] = (byte)(value >>> 0);
    }

    @Override
    public void setMedium(int index, int value) {
        this.array[index] = (byte)(value >>> 16);
        this.array[index + 1] = (byte)(value >>> 8);
        this.array[index + 2] = (byte)(value >>> 0);
    }

    @Override
    public void setInt(int index, int value) {
        this.array[index] = (byte)(value >>> 24);
        this.array[index + 1] = (byte)(value >>> 16);
        this.array[index + 2] = (byte)(value >>> 8);
        this.array[index + 3] = (byte)(value >>> 0);
    }

    @Override
    public void setLong(int index, long value) {
        this.array[index] = (byte)(value >>> 56);
        this.array[index + 1] = (byte)(value >>> 48);
        this.array[index + 2] = (byte)(value >>> 40);
        this.array[index + 3] = (byte)(value >>> 32);
        this.array[index + 4] = (byte)(value >>> 24);
        this.array[index + 5] = (byte)(value >>> 16);
        this.array[index + 6] = (byte)(value >>> 8);
        this.array[index + 7] = (byte)(value >>> 0);
    }

    @Override
    public ByteBuf duplicate() {
        return new HeapByteBuf(this.array, this.readerIndex(), this.writerIndex());
    }

    @Override
    public ByteBuf copy(int index, int length) {
        if (index < 0 || length < 0 || index + length > this.array.length) {
            throw new IndexOutOfBoundsException("Too many bytes to copy - Need " + (index + length) + ", maximum is " + this.array.length);
        }
        byte[] copiedArray = new byte[length];
        System.arraycopy(this.array, index, copiedArray, 0, length);
        return new HeapByteBuf(copiedArray);
    }
}

