/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufFactory;
import java.nio.ByteOrder;

public abstract class AbstractByteBufFactory
implements ByteBufFactory {
    private final ByteOrder defaultOrder;

    protected AbstractByteBufFactory() {
        this(ByteOrder.BIG_ENDIAN);
    }

    protected AbstractByteBufFactory(ByteOrder defaultOrder) {
        if (defaultOrder == null) {
            throw new NullPointerException("defaultOrder");
        }
        this.defaultOrder = defaultOrder;
    }

    @Override
    public ByteBuf getBuffer(int capacity) {
        return this.getBuffer(this.getDefaultOrder(), capacity);
    }

    @Override
    public ByteBuf getBuffer(byte[] array, int offset, int length) {
        return this.getBuffer(this.getDefaultOrder(), array, offset, length);
    }

    @Override
    public ByteOrder getDefaultOrder() {
        return this.defaultOrder;
    }
}

